function StiMobileDesigner(parameters) {
    var jsObject = this;
    this.defaultParameters = {};
    this.options = parameters;
    this.options.buttons = {};
    this.options.controls = {};
    this.options.panels = {};
    this.options.menus = {};
    this.options.forms = {};
    this.options.radioButtons = {};
    this.options.callbackFunctions = {};
    this.options.openDialogs = {};
    this.options.properties = {};
    this.options.propertiesGroups = {};
    this.options.dataBasesTreeOpeningArray = {};
    this.options.dataBasesTreeOpeningArrayTemp = {};
    this.options.paintPanelPadding = 15;
    this.options.rulerSize = 14;
    this.options.previewPageNumber = 0;
    this.options.previewCountPages = 0;
    this.options.commands = [];
    this.options.abortedCommands = {};
    this.options.touchZoom = {};
    this.options.startZoom = 0;
    this.options.oldDeltaPos = 0;
    this.options.timeUpdateCache = 60000;
    this.options.uploadBlockSize = 10000000;
    this.options.modifyRestrictions = true;
    this.options.mobileDesigner = document.getElementById(parameters.mobileDesignerId);
    this.options.mainPanel = document.getElementById(jsObject.options.mobileDesigner.id + "_MainPanel");
    this.options.head = document.getElementsByTagName("head")[0];
    this.options.isTouchDevice = parameters.interfaceType == "Auto" ? this.IsTouchDevice() : (parameters.interfaceType == "Touch" || parameters.interfaceType == "Mobile");
    this.options.canOpenFiles = window.File && window.FileReader && window.FileList && window.Blob;
    this.options.menuAnimDuration = parameters.showAnimation ? 150 : 0;
    this.options.formAnimDuration = parameters.showAnimation ? 200 : 0;
    this.options.xOffset = parameters.focusingX ? 0 : 0.5;
    this.options.yOffset = parameters.focusingY ? 0 : 0.5;
    this.options.touchMovingMinOffset = 15;
    this.options.containers = {};
    this.options.droppedContainers = [];
    this.options.designerIsFocused = true;
    this.options.fontSizes = this.GetFontSizes();
    this.options.monthesCollection = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
    this.options.themeColors = { Blue: "#19478a", Carmine: "#912c2f", Green: "#0b6433", Orange: "#b73a1c", Purple: "#8653a5", Teal: "#23645c", Violet: "#6d3069" };
    this.options.favouriteCultures = ["en-US", "en-GB", "zh-CN", "nb-NO", "el-GR", "fr-FR", "de-DE", "it-IT", "ko-KR", "pt-BR", "pt-PT", "es-ES", "ja-JP", "ar-SA"];
    this.options.propertyControlWidth = this.options.propertiesGridWidth - this.options.propertiesGridLabelWidth - 35;
    this.options.propertyNumbersControlWidth = Math.max(this.options.propertyControlWidth - 100, 40);
    this.options.showPanelPropertiesAndDictionary = this.options.showDictionary || this.options.showPropertiesGrid || this.options.showReportTree;
    if (!this.options.requestTimeout) this.options.requestTimeout = 20;
    if (this.options.fullScreenMode) this.options.mobileDesigner.style.zIndex = "10000";
    this.options.helpLanguage = this.IsRusCulture(this.options.cultureName) ? "ru" : "en";
    this.options.designerSpecification = "Developer";
    this.options.osWin11 = this.checkWin11();
    this.options.controlsHeight = this.options.isTouchDevice ? 28 : 23;
    this.options.controlsButtonsWidth = this.options.isTouchDevice ? 22 : 18;
    this.options.propertyControlsHeight = this.options.isTouchDevice ? 25 : 22;
    this.options.updateCacheCounter = 0;
    this.options.restoreCacheTime = 2;
    this.options.ribbonClassicHeight = 92;
    this.options.ribbonSingleLineHeight = 32;
    this.options.maxRecentFontsCount = 3;

    var setupToolboxCookie = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerSetupToolbox");
    var setupToolbox = setupToolboxCookie ? JSON.parse(setupToolboxCookie) : null;
    this.options.showToolbox = setupToolbox ? setupToolbox.showToolbox : true;
    this.options.showInsertTab = setupToolbox ? setupToolbox.showInsertTab : true;
    this.options.publishUrl = "https://publish.stimulsoft.com/";
    this.options.formsDesignerUrl = "https://designer-forms.stimulsoft.com/";

    this.options.newReportDictionary = this.options.newReportDictionary && this.options.newReportDictionary != "Auto" ? this.options.newReportDictionary : (StiMobileDesigner.GetCookie("StimulsoftMobileDesignerNewReportDictionary") || "DictionaryMerge");
    this.options.chartEditorType = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerChartEditorType") || "Simple";
    this.options.compilationAccess = this.options.jsMode || this.options.isAngular ? "Allow" : (StiMobileDesigner.GetCookie("StimulsoftMobileDesignerCompilationAccess") || this.options.defaultCompilationAccess || "Allow");
    this.options.ribbonType = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerRibbonType") || this.options.defaultRibbonType || "Classic";
    this.options.eventsAccess = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerEventsAccess") || this.options.eventsAccess || "Allow";
    this.options.defaultSaveFormat = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerDefaultSaveFormat") || "mrt";
    
    var showRulers = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerShowRulers");
    this.options.showRulers = showRulers != null ? showRulers.toLowerCase() == "true" : true;

    var showTextQuality = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerShowTextQuality");
    this.options.showTextQuality = showTextQuality != null ? showTextQuality.toLowerCase() == "true" : false;

    var showDictionaryFind = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerShowDictionaryFind");
    this.options.showDictionaryFind = showDictionaryFind != null ? showDictionaryFind.toLowerCase() == "true" : true;

    var showPropertiesFind = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerShowPropertiesFind");
    this.options.showPropertiesFind = showPropertiesFind != null ? showPropertiesFind.toLowerCase() == "true" : true;

    var showPropertiesComponents = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerShowPropertiesComponents");
    this.options.showPropertiesComponents = showPropertiesComponents != null ? showPropertiesComponents.toLowerCase() == "true" : true;

    var storeUserName = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerStoreUserNameInReportAuthor");
    this.options.storeUserNameInReportAuthor = storeUserName != null ? storeUserName.toLowerCase() == "true" : true;

    var showStimulAI = StiMobileDesigner.GetCookie("StimulsoftMobileDesignershowStimulAI");
    this.options.showStimulAI = !this.options.cloudMode ? false : showStimulAI != null ? showStimulAI.toLowerCase() == "true" : true;

    var dictSettings = StiMobileDesigner.GetCookie("StiMobileDesignerDictionarySettings");
    if (dictSettings) {
        dictSettings = JSON.parse(dictSettings);
        this.options.dictionarySorting = dictSettings.sort || "noSorting";
    }

    this.options.blocklyNotSupported = this.GetNavigatorName() == "MSIE" || (this.options.jsMode && !this.options.blocklyAssemblyLoaded);
    this.options.defaultScriptMode = this.options.blocklyNotSupported ? "Code" : (StiMobileDesigner.GetCookie("StimulsoftMobileDesignerDefaultScriptMode") || "Auto");
    this.options.customThemeAccent = this.options.cloudMode ? StiMobileDesigner.GetCookie("StimulsoftCustomThemeAccent") : this.options.customThemeAccentColor;
    this.proxy = parameters.proxy;

    if (this.options.cloudMode) {
        this.getNetworkData(function () { });
    }

    this.CheckOAuthParameters();
    this.LoadThemeSettings();
    this.ResetInsertTabComponentsCookies();

    if (parameters.loc) {
        var loc = typeof parameters.loc == 'string' ? JSON.parse(parameters.loc) : parameters.loc;
        this.loc = loc.Localization || loc;
        delete this.options.loc;
    }

    this.options.dayOfWeekCollection = [
        this.loc.A_WebViewer.AbbreviatedDayMonday,
        this.loc.A_WebViewer.AbbreviatedDayTuesday,
        this.loc.A_WebViewer.AbbreviatedDayWednesday,
        this.loc.A_WebViewer.AbbreviatedDayThursday,
        this.loc.A_WebViewer.AbbreviatedDayFriday,
        this.loc.A_WebViewer.AbbreviatedDaySaturday,
        this.loc.A_WebViewer.AbbreviatedDaySunday
    ];

    var startDay = this.options.datePickerFirstDayOfWeek == "Auto" ? this.GetFirstDayOfWeek() : this.options.datePickerFirstDayOfWeek;
    if (startDay == "Sunday") {
        this.options.dayOfWeekCollection.splice(6, 1);
        this.options.dayOfWeekCollection.splice(0, 0, this.loc.A_WebViewer.AbbreviatedDaySunday);
    }

    if (this.options.theme == "Auto") {
        this.ApplyAutoTheme();
    }

    if (!this.options.jsMode) {
        var processImage = this.options.processImage || this.InitializeProcessImage();
        // Show progress only for non-Blazor, because in Blazor the loading progress is in StiComponentLoader class
        if (typeof StiComponentLoader == 'undefined') processImage.show();

        // Load designer styles
        var stylesUrl = this.options.stylesUrl;
        if (this.options.customThemeAccent) {
            stylesUrl += "&stiweb_customaccent=" + this.options.customThemeAccent.replace("#", "");
        }
        this.LoadStyle(stylesUrl);

        //Start update cache timer
        if (this.options.allowAutoUpdateCache) {
            this.options.timerUpdateCache = setTimeout(function () {
                jsObject.SendCommandUpdateCache();
            }, this.options.timeUpdateCache);
        }
    }

    if (this.options.serverMode && this.options.cloudParameters) {
        this.SetWindowIcon(this.options.cloudParameters.favIcon);
    }

    this.options.imagesScalingFactor = this.GetImagesScalingFactor();

    if (this.options.images) {
        this.InitializeDesignerControls();
    }
    else {
        this.GetImagesCollection();
    }
}

StiMobileDesigner.setImageSource = function (image, options, name, transform) {
    if (image != null) {
        if (image.tagName == "IMG")
            image.src = options.images[name];
        else if (image.tagName == "image")
            image.href.baseVal = options.images[name];
        else if (image.tagName == "DIV")
            image.style.backgroundImage = "url(" + options.images[name] + ")";
    }
}

StiMobileDesigner.checkImageSource = function (options, name) {
    return options.images[name] != null;
}

StiMobileDesigner.getImageSource = function (options, name) {
    return options.images[name];
}

StiMobileDesigner.prototype.InitializeDesignerControls = function (callback) {
    var jsObject = this;

    if (jsObject.options.plansLimits) {
        jsObject.options.plansLimits = JSON.parse(jsObject.options.plansLimits);
    }

    if ((jsObject.options.cloudMode || jsObject.options.serverMode) && this.options.cloudParameters) {
        if (jsObject.options.cloudParameters.isTouchDevice != null) {
            jsObject.options.isTouchDevice = jsObject.options.cloudParameters.isTouchDevice == "true";
        }

        var title = jsObject.loc.FormDesigner.title;
        if (jsObject.options.cloudParameters.reportName) title = jsObject.options.cloudParameters.reportName + " - " + title;
        jsObject.SetWindowTitle(title);

        if (jsObject.options.cloudMode) {
            jsObject.UpdateResourcesLimits();
        }

        var requestChangesCookie = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerRequestChangesWhenSaving");
        jsObject.options.requestChangesWhenSaving = requestChangesCookie == null || requestChangesCookie == "true";
    }

    jsObject.AddCustomOpenTypeFontsCss();

    // Data Tree
    jsObject.options.dataTree = jsObject.DataTree();
    jsObject.options.mobileDesigner.jsObject = jsObject;

    jsObject.CreateMetaTag();
    jsObject.InitializeDesigner();
    jsObject.InitializeToolBar();
    jsObject.InitializeWorkPanel();
    jsObject.InitializeHomePanel();
    jsObject.InitializeStatusPanel();
    jsObject.InitializeInfoPanel();
    jsObject.InitializePropertiesPanel();
    jsObject.InitializePagesPanel();
    jsObject.InitializePaintPanel();
    jsObject.InitializeRulers();
    jsObject.InitializeToolbox();
    jsObject.InitializeToolTip();
    if (jsObject.options.jsMode) jsObject.InitializePreviewPanel();
    if (jsObject.options.cloudMode) jsObject.InitializeLoginControls();
    if (jsObject.options.showToolbar === false) jsObject.options.toolBar.changeVisibleState(false);
    jsObject.UpdateDesignerSpecification();
    jsObject.UpdateDesignerControlsBySpecification();
    jsObject.showTrLog();

    jsObject.SetEnabledAllControls(false);

    jsObject.addEvent(document, 'mousemove', function (event) {
        jsObject.DocumentMouseMove(event);
    });

    jsObject.addEvent(document, 'touchmove', function (event) {
        jsObject.DocumentTouchMove(event);
    });

    jsObject.addEvent(document, 'touchend', function (event) {
        jsObject.isTouchEndFlag = true;
        clearTimeout(jsObject.isTouchEndTimer);

        jsObject.DocumentTouchEnd(event);

        jsObject.isTouchEndTimer = setTimeout(function () {
            jsObject.isTouchEndFlag = false;
        }, 1000);
    });

    jsObject.addEvent(document, 'mouseup', function (event) {
        if (jsObject.isTouchEndTimer) return;
        jsObject.DocumentMouseUp(event);
    });

    //Load Report
    if (jsObject.options.jsMode) {
        jsObject.CloseReport();

        //append stimulsoft font
        if (jsObject.options.stimulsoftFontContent) {
            jsObject.AddCustomFontsCss(jsObject.GetCustomFontsCssText(jsObject.options.stimulsoftFontContent, "Stimulsoft"));
        }

        if (jsObject.options.buttons.resizeDesigner && jsObject.options.maximizeAfterCreating) {
            jsObject.options.buttons.resizeDesigner.action();
        }

        if (jsObject.options.standaloneJsMode) {
            var designerLoading = document.getElementById("stiDesignerLoading");
            if (designerLoading) designerLoading.parentElement.removeChild(designerLoading);
        }

        jsObject.startDesignerTimer = setTimeout(function () {
            var startScreen = jsObject.options.startScreen;

            if (!startScreen || startScreen == "NotAssigned") {
                var designerOptionsJs = StiMobileDesigner.GetCookie("StimulsoftMobileDesignerOptions");
                if (designerOptionsJs) startScreen = JSON.parse(StiBase64.decode(designerOptionsJs)).startScreen;
                if (startScreen) jsObject.options.startScreen = startScreen;
            }

            if (startScreen == "BlankReport") {
                jsObject.ActionNewReport();
            }
            else if (startScreen == "BlankDashboard" && jsObject.options.dashboardAssemblyLoaded) {
                jsObject.ActionNewDashboard();
            }
            else {
                var fileMenu = jsObject.options.menus.fileMenu || jsObject.InitializeFileMenu();
                fileMenu.changeVisibleState(true);
                fileMenu.items.newReport.action();
            }
        }, 500);
    }
    else {
        var processImage = this.options.processImage || this.InitializeProcessImage();
        processImage.show();

        if (document.readyState == 'complete') {
            jsObject.BuildDesignerComplete();
        }
        else {
            jsObject.addEvent(window, 'load', function () { jsObject.BuildDesignerComplete(); });
        }
    }

    if (jsObject.onready) jsObject.onready();

    if (this.onreadyasync) this.onreadyasync(callback);
    else if (callback) callback();
}

StiMobileDesigner.prototype.mergeOptions = function (fromObject, toObject) {
    for (var value in fromObject) {
        if (toObject[value] === undefined || toObject[value] == null || typeof toObject[value] !== "object" || (typeof Array == "function" && Array.isArray(toObject[value])))
            toObject[value] = fromObject[value];
        else
            this.mergeOptions(fromObject[value], toObject[value]);
    }
}

StiMobileDesigner.prototype.BuildDesignerComplete = function () {
    var jsObject = this;

    var params = {
        defaultUnit: this.options.defaultUnit,
        zoom: this.options.zoom,
        designerOptions: StiMobileDesigner.GetCookie("StimulsoftMobileDesignerOptions")
    };

    if (this.options.serverMode) {
        params.sessionKey = this.options.cloudParameters.sessionKey;
        params.reportTemplateItemKey = this.options.cloudParameters.reportTemplateItemKey;
        params.attachedItems = this.options.cloudParameters.attachedItems || [];
        params.resourceItems = this.options.cloudParameters.resourceItems || [];
    }

    if ((this.options.serverMode || this.options.cloudMode) && this.options.cloudParameters) {
        var startDemoFormsDesigner = jsObject.GetParameterFromUrl("open") == "blankform";

        if (this.options.cloudParameters.isForm || startDemoFormsDesigner) {
            var whitePanel = jsObject.options.panels.mainWhitePanel || jsObject.InitializeWhitePanel("mainWhitePanel", jsObject.options.mainPanel);
            whitePanel.show();

            if (startDemoFormsDesigner) {
                params.startParameters = {
                    action: "blankFormButton"
                }
            }
        }
        if (this.options.cloudParameters.startParameters) {
            params.startParameters = JSON.parse(StiBase64.decode(this.options.cloudParameters.startParameters));
        }
    }

    if (params.startParameters && (params.startParameters.action || params.startParameters.wizard)) {
        if (params.startParameters.action) {
            this.ExecuteAction(params.startParameters.action);
        }
        else {
            jsObject.StartWizardForm2(params.startParameters.wizard, params.startParameters.template);
        }
    }
    else if (params.startParameters && params.startParameters.resourceName) {
        jsObject.SendCommandOpenWizardReport(params.startParameters.resourceName);
    }
    else {
        this.SendCommandToDesignerServer("GetReportForDesigner", params, function (answer) {
            if (answer.formContent) {
                jsObject.InitializeFormsDesignerFrame(function (frame) {
                    if (jsObject.options.cloudParameters && (jsObject.options.cloudParameters.reportTemplateItemKey || jsObject.options.cloudParameters.demomode)) {
                        frame.openForm(jsObject.options.cloudParameters ? (jsObject.options.cloudParameters.reportName || "Form") : "Form", answer.formContent);
                    }
                    else {
                        frame.createForm();
                    }
                });
            }
            else {
                if (answer.reportObject) {
                    jsObject.LoadReport(jsObject.ParseReport(answer.reportObject));

                    if (jsObject.options.setZoomToPageWidth) {
                        jsObject.SetZoomBy("Width");
                    }
                    else if (jsObject.options.setZoomToPageHeight) {
                        jsObject.SetZoomBy("Height");
                    }
                }

                if ((jsObject.options.serverMode || jsObject.options.cloudMode) && params.startParameters && params.startParameters.useDemoData) {
                    jsObject.autoCreateDataComponent();
                }

                if ((jsObject.options.cloudParameters && jsObject.options.cloudParameters.thenOpenWizard) ||
                    jsObject.options.runWizardAfterLoad ||
                    jsObject.options.runSpecificWizardAfterLoad ||
                    !answer.reportObject ||
                    (jsObject.options.wizardTypeRunningAfterLoad && jsObject.options.wizardTypeRunningAfterLoad != "None")) {
                    var wizardType = jsObject.options.runSpecificWizardAfterLoad || jsObject.options.wizardTypeRunningAfterLoad;
                    if (wizardType && wizardType != "None") {
                        jsObject.RunWizard(wizardType.toString());
                    }
                    else {
                        var fileMenu = jsObject.options.menus.fileMenu || jsObject.InitializeFileMenu();
                        fileMenu.changeVisibleState(true);
                    }
                }
            }

            // Update images array
            setTimeout(function () {
                // Show progress only for WebAssembly, because it takes some time
                if (jsObject.options.processImage && typeof jsObject.options.frameworkType == 'string' && jsObject.options.frameworkType.indexOf('Wasm') > 0)
                    jsObject.options.processImage.show();

                // Timer is needed for WebAssembly to show progress
                setTimeout(function () {
                    jsObject.GetImagesCollection(true);
                }, 50);
            }, 5000);

            // Load all scripts
            jsObject.LoadScript(jsObject.options.scriptsUrl + "AllNotLoadedScripts");
        });
    }

    //append stimulsoft font
    if (this.options.stimulsoftFontContent) {
        this.AddCustomFontsCss(this.GetCustomFontsCssText(this.options.stimulsoftFontContent, "Stimulsoft"));
    }
}

StiMobileDesigner.prototype.GetImagesCollection = function (secondRequest) {
    var jsObject = this;

    var params = {
        action: "Resource",
        imagesScalingFactor: jsObject.options.imagesScalingFactor,
        useCompression: jsObject.options.useCompression,
        iconSet: jsObject.options.iconSet || "Auto"
    }
    if (jsObject.options.imagesUrl) {
        params.resourcesUrl = "imagesUrl";
    }
    if (secondRequest) {
        params.secondRequest = true;
    }
    var url = jsObject.options.imagesUrl + "images";
    for (var key in params) {
        if (key != "action")
            url += "&stiweb_" + key.toLowerCase() + "=" + params[key];
    }

    this.PostAjax(url, params, function (data) {
        if (jsObject.options.processImage) jsObject.options.processImage.hide();
        if (data) {
            if (jsObject.options.useCompression) data = StiGZipHelper.unpack(data);
            data = JSON.parse(data);
            if (data.images) {
                if (!secondRequest) {
                    if (jsObject.options.imagesUrl) {
                        for (var key in data.images) {
                            if (data.images[key].indexOf("imagesUrl") == 0) {
                                data.images[key] = data.images[key].replace("imagesUrl", jsObject.options.imagesUrl);
                            }
                        }
                    }
                    jsObject.options.images = data.images;
                    jsObject.InitializeDesignerControls();
                }
                else {
                    for (var imageName in data.images) {
                        jsObject.options.images[imageName] = data.images[imageName];
                    }
                }
            }
        }
    }, "GET");
}

StiMobileDesigner.prototype.LoadThemeSettings = function () {

}

StiMobileDesigner.prototype.isTouchEndFlag = null;
StiMobileDesigner.prototype.isTouchEndTimer = null;
StiMobileDesigner.prototype.startDesignerTimer = null;
