﻿
StiMobileDesigner.prototype.InitializeWorkPanel = function () {
    var jsObject = this;
    var workPanel = document.createElement("div");
    workPanel.className = "stiDesignerWorkPanel";
    workPanel.jsObject = this;
    this.options.workPanel = workPanel;
    this.options.mainPanel.appendChild(workPanel);
    workPanel.currentPanel = null;
    workPanel.visibleState = true;

    var ribbonTypeButton = this.StandartSmallButton("ribbonTypeButton", null, null, "Toolbar.ArrowDown.png", null, null);
    ribbonTypeButton.style.position = "absolute";
    ribbonTypeButton.style.bottom = ribbonTypeButton.style.right = "1px";
    workPanel.appendChild(ribbonTypeButton);
    if (this.options.showToolbar === false) ribbonTypeButton.style.display = "none";

    var ribbonTypeMenu = this.VerticalMenu("ribbonTypeMenu", ribbonTypeButton, "Down", this.GetRibbonTypeItems(), null, null, { width: 12, height: 12 }, null, true);

    ribbonTypeButton.action = function () {
        ribbonTypeMenu.changeVisibleState(!ribbonTypeMenu.visible);
    }

    ribbonTypeMenu.onshow = function () {
        var isClassic = jsObject.options.ribbonType == "Classic";
        this.items.Classic.setSelected(isClassic);
        this.items.SingleLine.setSelected(!isClassic);
        this.items.Classic.image.style.visibility = isClassic ? "visible" : "hidden";
        this.items.SingleLine.image.style.visibility = !isClassic ? "visible" : "hidden";
    }

    ribbonTypeMenu.action = function (menuItem) {
        this.changeVisibleState(false);
        jsObject.options.ribbonType = menuItem.key;
        StiMobileDesigner.SetCookie("StimulsoftMobileDesignerRibbonType", menuItem.key);
        workPanel.changeByRibbonType();
    }

    workPanel.changeByRibbonType = function () {
        jsObject.options.homePanel.changeByRibbonType();
        if (jsObject.options.insertPanel)
            jsObject.options.insertPanel.changeByRibbonType();
        if (jsObject.options.reportPanel)
            jsObject.options.reportPanel.changeByRibbonType();
        if (jsObject.options.pagePanel)
            jsObject.options.pagePanel.changeByRibbonType();
        if (jsObject.options.layoutPanel)
            jsObject.options.layoutPanel.changeByRibbonType();
        if (jsObject.options.previewPanel)
            jsObject.options.previewPanel.changeByRibbonType();
        if (jsObject.options.report) {
            jsObject.options.report.stylesCache = null;
            jsObject.options.homePanel.updateControls();
        }
        this.layoutOtherPanels();
        if (jsObject.options.toolbox)
            jsObject.options.toolbox.resize();
    }

    workPanel.layoutOtherPanels = function () {
        var toolBar = jsObject.options.toolBar;
        var paintPanel = jsObject.options.paintPanel;
        var pagesPanel = jsObject.options.pagesPanel;
        var toolbox = jsObject.options.toolbox;
        var propertiesPanel = jsObject.options.propertiesPanel;
        var infoPanel = jsObject.options.infoPanel;
        paintPanel.style.top = toolBar.offsetHeight + pagesPanel.offsetHeight + infoPanel.offsetHeight + this.offsetHeight + "px";
        pagesPanel.style.top = toolBar.offsetHeight + infoPanel.offsetHeight + this.offsetHeight + "px";
        propertiesPanel.style.top = toolBar.offsetHeight + infoPanel.offsetHeight + this.offsetHeight + "px";
        if (toolbox) toolbox.style.top = toolBar.offsetHeight + infoPanel.offsetHeight + this.offsetHeight + "px";
        propertiesPanel.showButtonsPanel.style.top = (toolBar.offsetHeight + workPanel.offsetHeight + infoPanel.offsetHeight + 40) + "px";
    }

    workPanel.changeVisibleState = function (state) {
        this.style.display = state ? "" : "none";
        this.layoutOtherPanels();
        if (state) this.visibleState = true;
    }

    workPanel.showPanel = function (panel) {
        if (this.currentPanel != null && this.currentPanel != panel) {
            this.currentPanel.style.display = "none";
            this.currentPanel.onhide();
        }
        this.currentPanel = panel;
        panel.style.display = "";
        if (this.jsObject.options.paintPanel)
            this.jsObject.options.paintPanel.style.top = this.jsObject.options.toolBar.offsetHeight + this.jsObject.options.pagesPanel.offsetHeight + this.offsetHeight + "px";
        panel.onshow();
    }
}

StiMobileDesigner.prototype.ChildWorkPanel = function (name) {
    var jsObject = this;
    var childPanel = document.createElement("div");
    childPanel.className = "stiChildWorkPanel stiWorkPanelScrollContainer";

    childPanel.setHeightByRibbonType = function () {
        childPanel.style.height = ((jsObject.options.ribbonType == "Classic" ? jsObject.options.ribbonClassicHeight : jsObject.options.ribbonSingleLineHeight) + (jsObject.options.isTouchDevice ? 5 : 0)) + "px";
    }

    childPanel.setHeightByRibbonType();

    childPanel.jsObject = this;
    this.options[name] = childPanel;
    this.options.workPanel.appendChild(childPanel);
    childPanel.style.marginRight = this.options.isTouchDevice ? "31px" : "23px";

    childPanel.onshow = function () { };
    childPanel.onhide = function () { };

    return childPanel;
}

StiMobileDesigner.prototype.DesignPanelInnerTable = function () {
    var table = this.CreateHTMLTable();

    table.addCell = function (control) {
        var cell = document.createElement("td");
        cell.style.verticalAlign = "top";
        this.tr[0].appendChild(cell);
        if (control) cell.appendChild(control);

        return cell;
    }

    return table;
}