﻿
StiMobileDesigner.prototype.SignaturePropertiesGroup = function () {
    var jsObject = this;
    var group = this.PropertiesGroup("signaturePropertiesGroup", this.loc.Components.StiSignature);
    group.style.display = "none";
    group.innerGroups = {};

    var groupNames = [
        ["draw", this.loc.PropertyEnum.StiSignatureTypeDraw, "main", 1],
        ["image", this.loc.PropertyCategory.ImageCategory, "main", 1],
        ["text", this.loc.PropertyCategory.TextCategory, "main", 1]
    ]

    for (var i = 0; i < groupNames.length; i++) {
        var innerGroup = this.PropertiesGroup(null, groupNames[i][1], null, groupNames[i][3]);
        group.innerGroups[groupNames[i][0]] = innerGroup;
        innerGroup.parentGroup = groupNames[i][2] == "main" ? group : group.innerGroups[groupNames[i][2]];
    }

    var props = [
        ["allowCleanSignature", this.loc.PropertyMain.AllowCleanSignature, this.CheckBox("allowCleanSignature"), "main"],
        ["signatureMode", this.loc.PropertyMain.Mode, this.PropertyDropDownList("signatureMode", this.options.propertyControlWidth, this.GetSignatureModeItems(), true), "main"],
        ["drawDrawAspectRatio", this.loc.PropertyMain.AspectRatio, this.CheckBox("drawDrawAspectRatio"), "draw"],
        ["drawDrawHorAlignment", this.loc.PropertyMain.HorAlignment, this.PropertyDropDownList("drawDrawHorAlignment", this.options.propertyControlWidth, this.GetHorizontalAlignmentItems(true), true), "draw"],
        ["drawDrawVertAlignment", this.loc.PropertyMain.VertAlignment, this.PropertyDropDownList("drawDrawVertAlignment", this.options.propertyControlWidth, this.GetVerticalAlignmentItems(true), true), "draw"],
        ["drawDrawStretch", this.loc.PropertyMain.Stretch, this.CheckBox("drawDrawStretch"), "draw"],
        ["drawImageAspectRatio", this.loc.PropertyMain.AspectRatio, this.CheckBox("drawImageAspectRatio"), "image"],
        ["drawImageHorAlignment", this.loc.PropertyMain.HorAlignment, this.PropertyDropDownList("drawImageHorAlignment", this.options.propertyControlWidth, this.GetHorizontalAlignmentItems(true), true), "image"],
        ["drawImageVertAlignment", this.loc.PropertyMain.VertAlignment, this.PropertyDropDownList("drawImageVertAlignment", this.options.propertyControlWidth, this.GetVerticalAlignmentItems(true), true), "image"],
        ["drawImageStretch", this.loc.PropertyMain.Stretch, this.CheckBox("drawImageStretch"), "image"],
        ["drawText", this.loc.PropertyMain.Text, this.PropertyTextBox("drawText", this.options.propertyControlWidth), "text"],
        ["drawTextFont", this.loc.PropertyMain.Font, this.PropertyFontControl("drawTextFont", null, true), "text"],
        ["drawTextColor", this.loc.PropertyMain.Color, this.PropertyColorControl("drawTextColor", null, this.options.propertyControlWidth), "text"],
        ["drawTextHorAlignment", this.loc.PropertyMain.HorAlignment, this.PropertyDropDownList("drawTextHorAlignment", this.options.propertyControlWidth, this.GetHorizontalAlignmentItems(true), true), "text"]
    ]

    for (var i = 0; i < props.length; i++) {
        var control = props[i][2];
        control.propertyName = props[i][0];
        var currentGroup = props[i][3] == "main" ? group : group.innerGroups[props[i][3]];
        currentGroup.container.appendChild(this.Property(props[i].length > 4 ? props[i][4] : props[i][0], props[i][1], control, null, currentGroup.nestingLevel));

        control.action = function () {
            var value = jsObject.GetControlValue(this);
            if (this.propertyName == "drawText") {
                value = StiBase64.encode(value);
            }
            jsObject.ApplyPropertyValue([this.propertyName], [value]);
        }
    }

    for (var i = 0; i < groupNames.length; i++) {
        group.innerGroups[groupNames[i][0]].parentGroup.container.appendChild(group.innerGroups[groupNames[i][0]]);
    }

    return group;
}