﻿
StiMobileDesigner.prototype.PagesButton = function (page) {
    var jsObject = this;
    var name = page.properties.name;
    var pageIcon = page.properties.pageIcon;
    var alias = StiBase64.decode(page.properties.aliasName);
    var captionText = (!alias || name == alias) ? name : name + " [" + alias + "]";
    var image = "SmallComponents." + (page.isDashboard ? "StiDashboard.png" : "StiPage.png");

    if (this.options.useAliases && this.options.showOnlyAliasForPages && alias) {
        captionText = alias;
    }

    var button = this.TabButton(null, null, captionText, image, captionText);
    button.key = name;

    if (pageIcon) {
        button.image.src = pageIcon;
    }

    button.action = function () {
        var pages = jsObject.options.pagesPanel.pagesContainer.pages;
        for (var i = 0; i < pages.length; i++) {
            if (this != pages[i]) {
                pages[i].setSelected(false);
            }
        }
        this.setSelected(true);

        if (jsObject.options.currentPage != jsObject.options.report.pages[this.key]) {
            jsObject.options.paintPanel.showPage(jsObject.options.report.pages[this.key]);
        }
    }

    //Override
    button.setSelected = function (state) {
        if (!state) this.setEditMode(false);
        this.isSelected = state;
        this.className = state ? this.selectedClass : (this.isEnabled ? (this.isOver ? this.overClass : this.defaultClass) : this.disabledClass);
        this.footer.className = state ? "stiDesignerStandartTabFooter" : "";
    }

    button.onmousedown = function (event) {
        if (this.isTouchStartFlag) return;
        if (!event || event.button != 2) {
            var pageButtonInDrag = jsObject.options.pageButtonInDrag = jsObject.PageButtonForDragDrop(captionText, image);
            pageButtonInDrag.beginingOffset = 0;
            pageButtonInDrag.ownerPage = this.ownerPage;
        }
    }

    button.onmouseup = function (event) {
        if (this.isTouchEndFlag || jsObject.options.isTouchClick) return;

        if (jsObject.options.pageButtonInDrag) {
            var fromIndex = jsObject.options.pageButtonInDrag.ownerPage.properties.pageIndex;
            var toIndex = this.ownerPage.properties.pageIndex;

            if (fromIndex != toIndex) {
                jsObject.SendCommandPageMoveToIndex(fromIndex, toIndex);
            }
        }
        else if (event.button == 2) {
            event.stopPropagation();
            this.action();
            var pageMenu = jsObject.options.menus.pageContextMenu || jsObject.InitializePageContextMenu();
            var point = jsObject.FindMousePosOnMainPanel(event);
            pageMenu.pageButton = this;
            pageMenu.show(point.xPixels + 3, point.yPixels + 3, "Down", "Right");
        }
        return false;
    }

    var contextTimer = null;
    button.ontouchstart = function (event) {
        jsObject.options.fingerIsMoved = false;
        jsObject.options.buttonPressed = this;
        var this_ = this;
        contextTimer = setTimeout(function () {
            if (jsObject.options.fingerIsMoved) return;
            this_.action();
            var pageMenu = jsObject.options.menus.pageContextMenu || jsObject.InitializePageContextMenu();
            var point = jsObject.FindMousePosOnMainPanel(event);
            pageMenu.pageButton = this_;
            pageMenu.show(point.xPixels - 2, point.yPixels - 2, "Up");
        }, 1000);
    }

    button.ontouchend = function (event) {
        var this_ = this;
        this.isTouchEndFlag = true;
        clearTimeout(this.isTouchEndTimer);
        clearTimeout(contextTimer);
        if (!this.isEnabled || jsObject.options.fingerIsMoved) return;
        this.action();
        this.isTouchEndTimer = setTimeout(function () {
            this_.isTouchEndFlag = false;
        }, 1000);
    }

    button.oncontextmenu = function (event) {
        return false;
    }

    var editTextBox = this.TextBox(null, 70);
    button.innerTable.addCell(editTextBox);
    editTextBox.style.display = "none";
    editTextBox.style.margin = "0px 4px 1px 4px";
    editTextBox.style.height = "18px";
    editTextBox.style.border = "0px";

    editTextBox.onblur = function () {
        this.isOver = false;
        this.setSelected(false);
        jsObject.options.controlsIsFocused = false;
        if (!this.readOnly && (this.oldValue != this.value || this.keyEnterPressed)) this.action();
        this.keyEnterPressed = false;
        button.setEditMode(false);
    }

    editTextBox.action = function () {
        jsObject.SendCommandRenameComponent(button.ownerPage, this.value);
    }

    button.setEditMode = function (state) {
        editTextBox.style.display = state ? "" : "none";
        this.caption.style.display = !state ? "" : "none";
        if (state) {
            editTextBox.value = this.captionText;
            editTextBox.focus();
        }
    }

    button.ondblclick = function () {
        jsObject.InitializeRenamePageForm(function (form) {
            form.show();
        });
    }

    return button;
}

StiMobileDesigner.prototype.PageButtonForDragDrop = function (caption, image) {
    var jsObject = this;
    var button = this.StandartSmallButton(null, null, caption, image);
    this.options.mainPanel.appendChild(button);

    button.style.position = "absolute";
    button.style.display = "none";
    button.style.zIndex = "300";
    button.className = "stiDesignerTreeItemForDragDrop stiDesignerTreeItemForDragDrop" + (this.options.isTouchDevice ? "_Touch" : "_Mouse");
    if (button.caption) button.caption.style.padding = "6px 5px 6px 5px";

    button.ondblclick = null;
    button.ontouchstart = null;
    button.onmousedown = null;
    button.ontouchend = null;
    button.onmouseup = null;
    button.onmousemove = null;
    button.ontouchmove = null;

    button.move = function (event, offsetX, offsetY) {
        button.style.display = "";
        var clientX = event.touches ? event.touches[0].pageX : event.clientX;
        var clientY = event.touches ? event.touches[0].pageY : event.clientY;

        var designerOffsetX = jsObject.FindPosX(jsObject.options.mainPanel);
        var designerOffsetY = jsObject.FindPosY(jsObject.options.mainPanel);
        clientX -= designerOffsetX;
        clientY -= designerOffsetY;

        if (offsetX) clientX += offsetX;
        if (offsetY) clientY += offsetY;

        this.style.left = clientX + "px";
        this.style.top = (clientY + 20) + "px";
    }

    return button;
}
