﻿
StiMobileDesigner.prototype.InitializePagePanelSingleLine = function (pagePanel) {
    var jsObject = this;

    var mainTable = pagePanel.mainTableSingleLine = this.CreateHTMLTable();
    mainTable.style.display = jsObject.options.ribbonType == "SingleLine" ? "" : "none";
    mainTable.style.height = (jsObject.options.ribbonSingleLineHeight - 2) + "px";
    mainTable.addCell(this.PagePanelSingleLinePageSetupBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());

    var pageSingleLineViewBlock = this.PagePanelSingleLineViewBlock();
    mainTable.addCell(pageSingleLineViewBlock);

    mainTable.addCell(this.PagePanelSingleLineViewOptionsBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());
    pagePanel.appendChild(mainTable);

    pagePanel.updateSingleLineControls = function () {
        var buttons = jsObject.options.buttons;
        var designerOptions = jsObject.options.report ? jsObject.options.report.info : null;
        var currentPage = jsObject.options.currentPage;

        var buttonNames = ["pagePanelShowGridSingle", "pagePanelAlignToGridSingle", "pagePanelShowHeadersSingle", "pagePanelGridModeSingle", "marginsPageSingle", "orientationPageSingle", "pageSizeSingle", "columnsPageSingle", "watermarkPageSingle"];

        for (var i = 0; i < buttonNames.length; i++) {
            var button = buttons[buttonNames[i]];
            if (button) {
                var isEnabled = designerOptions;
                if (currentPage && currentPage.isDashboard && ["marginsPageSingle", "orientationPageSingle", "pageSizeSingle", "columnsPageSingle", "pagePanelShowHeadersSingle"].indexOf(buttonNames[i]) >= 0) {
                    isEnabled = false;
                }
                button.setEnabled(isEnabled);
            }
        }

        if (designerOptions) {
            buttons.pagePanelShowGridSingle.setSelected(designerOptions.showGrid);
            buttons.pagePanelAlignToGridSingle.setSelected(designerOptions.alignToGrid);
            buttons.pagePanelShowHeadersSingle.setSelected(designerOptions.showHeaders);
            StiMobileDesigner.setImageSource(buttons.pagePanelGridModeSingle.image, jsObject.options, "ViewOptions.Grid" + designerOptions.gridMode + ".png");
        }

        if (currentPage && currentPage.isDashboard) {
            buttons.pageViewDesktopSingle.setSelected(currentPage.properties.dashboardViewMode == "Desktop");
            buttons.pageViewMobileSingle.setSelected(currentPage.properties.dashboardViewMode == "Mobile");
            buttons.pageViewComponentsButtonSingle.setEnabled(currentPage.properties.dashboardViewMode == "Mobile");
            buttons.pageViewRemoveMobileSingle.style.display = buttons.pageViewComponentsButtonSingle.style.display = pageSingleLineViewBlock.mobileSep.style.display = currentPage.properties.mobileViewModePresent ? "" : "none";
        }
        pageSingleLineViewBlock.style.display = currentPage && currentPage.isDashboard ? "" : "none";
    }
}

//Page Setup
StiMobileDesigner.prototype.PagePanelSingleLinePageSetupBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    //Margins
    var marginsButton = this.SingleLineRibbonButton("marginsPageSingle", null, this.loc.FormPageSetup.Margins, "Layout.Margins.png", [this.loc.HelpDesigner.Margins, this.GetHelpLink("page")], "Down");
    marginsButton.style.margin = "0 2px 0 2px";
    table.addCell(marginsButton);

    var marginsMenu = this.MarginsMenu("marginsMenuSingle", marginsButton);

    marginsButton.action = function () {
        marginsMenu.changeVisibleState(!marginsMenu.visible);
    }

    //Orientation
    var orientationButton = this.SingleLineRibbonButton("orientationPageSingle", null, this.loc.FormPageSetup.Orientation, "Layout.Orientation.png", [this.loc.HelpDesigner.Orientation, this.GetHelpLink("page")], "Down");
    orientationButton.style.margin = "0 2px 0 2px";
    table.addCell(orientationButton);

    var orientationMenu = this.OrientationMenu("orientationMenuSingle", orientationButton);

    orientationButton.action = function () {
        orientationMenu.changeVisibleState(!orientationMenu.visible);
    }

    //PageSize
    var pageSizeButton = this.SingleLineRibbonButton("pageSizeSingle", null, this.loc.PropertyMain.Size, "Layout.Size.png", [this.loc.HelpDesigner.PageSize, this.GetHelpLink("page")], "Down");
    pageSizeButton.style.margin = "0 2px 0 2px";
    table.addCell(pageSizeButton);

    var pageSizeMenu = this.PageSizeMenu("pageSizeMenuSingle", pageSizeButton);

    pageSizeButton.action = function () {
        pageSizeMenu.changeVisibleState(!pageSizeMenu.visible);
    }

    //Columns
    var columnsButton = this.SingleLineRibbonButton("columnsPageSingle", null, this.loc.FormPageSetup.Columns, "Layout.Columns.png", [this.loc.HelpDesigner.Columns, this.GetHelpLink("page")], "Down");
    columnsButton.style.margin = "0 2px 0 2px";
    table.addCell(columnsButton);

    var columnsMenu = this.ColumnsMenu("columnsMenuSingle", columnsButton);

    columnsButton.action = function () {
        columnsMenu.changeVisibleState(!columnsMenu.visible);
    }

    //Watermark
    var watermarkButton = this.SingleLineRibbonButton("watermarkPageSingle", null, this.loc.PropertyMain.Watermark, "Styles.StiWatermarkStyle.png", [this.loc.PropertyMain.Watermark, this.GetHelpLink("page")]);
    watermarkButton.style.margin = "0 2px 0 2px";
    table.addCell(watermarkButton);

    watermarkButton.action = function () {
        jsObject.options.buttons.watermarkPage.action();
    }

    return table;
}

//View
StiMobileDesigner.prototype.PagePanelSingleLineViewBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    var buttons = [
        [this.SingleLineRibbonButton("pageViewDesktopSingle", null, null, "PageViewMode.ViewDesktop.png", [this.loc.Dashboard.ViewModeDesktop, this.GetHelpLink("page")]), "pageViewDesktop"],
        [this.SingleLineRibbonButton("pageViewMobileSingle", null, null, "PageViewMode.ViewMobile.png", [this.loc.Dashboard.ViewModeMobile, this.GetHelpLink("page")]), "pageViewMobile"],
        [this.SingleLineRibbonButton("pageViewRemoveMobileSingle", null, null, "PageViewMode.RemoveMobileSurface.png", [this.loc.Dashboard.RemoveMobileSurface, this.GetHelpLink("page")]), "pageViewRemoveMobile"],
        [this.SingleLineRibbonButton("pageViewComponentsButtonSingle", null, null, "PageViewMode.Components.png", [this.loc.Report.Components, this.GetHelpLink("page")]), "pageViewComponentsButton"]
    ]

    for (var i = 0; i < buttons.length; i++) {
        var button = buttons[i][0];
        button.cloneName = buttons[i][1];
        button.style.margin = "0 2px 0 2px";
        table.addCell(button);

        if (button.cloneName == "pageViewMobile") {
            table.mobileSep = jsObject.RibbonPanelSingleLineSeparator();
            table.addCell(table.mobileSep);
        }

        button.action = function () {
            if (this.cloneName == "pageViewComponentsButton") {
                this.setSelected(!this.isSelected);
            }
            var cloneButton = jsObject.options.buttons[this.cloneName];
            if (cloneButton) cloneButton.action();
        }
    }

    table.addCell(this.RibbonPanelSingleLineSeparator());

    return table;
}


//View Options
StiMobileDesigner.prototype.PagePanelSingleLineViewOptionsBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    //ShowGrid
    var showGridButton = this.SingleLineRibbonButton("pagePanelShowGridSingle", null, this.loc.MainMenu.menuViewShowGrid, "ViewOptions.ShowGrid.png", [this.loc.HelpDesigner.menuViewShowGrid, this.GetHelpLink("viewOptions")], null);
    showGridButton.propertyName = "showGrid";
    showGridButton.style.margin = "0 2px 0 2px";
    table.addCell(showGridButton);

    //Show Headers
    var showHeadersButton = this.SingleLineRibbonButton("pagePanelShowHeadersSingle", null, this.loc.MainMenu.menuViewShowHeaders, "ViewOptions.ShowHeaders.png", [this.loc.HelpDesigner.menuViewShowHeaders, this.GetHelpLink("viewOptions")], null);
    showHeadersButton.propertyName = "showHeaders";
    showHeadersButton.style.margin = "0 2px 0 2px";
    table.addCell(showHeadersButton);

    //AlignToGrid
    var alignToGridButton = this.SingleLineRibbonButton("pagePanelAlignToGridSingle", null, this.loc.MainMenu.menuViewAlignToGrid, "ViewOptions.AlignToGrid.png", [this.loc.HelpDesigner.menuViewAlignToGrid, this.GetHelpLink("viewOptions")], null);
    alignToGridButton.propertyName = "alignToGrid";
    alignToGridButton.style.margin = "0 2px 0 2px";
    table.addCell(alignToGridButton);

    //GridMode
    var gridModeButton = this.SingleLineRibbonButton("pagePanelGridModeSingle", null, this.loc.FormOptions.GridMode, "ViewOptions.GridDots.png", [this.loc.HelpDesigner.GridMode, this.GetHelpLink("viewOptions")], "Down");
    gridModeButton.style.margin = "0 2px 0 2px";
    table.addCell(gridModeButton);

    var gridModeMenu = this.GridModeMenu("gridModeMenuSingle", gridModeButton);
    gridModeButton.action = function () { gridModeMenu.changeVisibleState(!gridModeMenu.visible); };

    var changeViewOption = function (button) {
        if (!jsObject.options.report) return;
        var designerOptions = jsObject.options.report.info;
        button.setSelected(!button.isSelected);
        designerOptions[button.propertyName] = button.isSelected;
        jsObject.SendCommandApplyDesignerOptions(designerOptions);
    }

    showGridButton.action = function () { changeViewOption(this); }
    showHeadersButton.action = function () { changeViewOption(this); }
    alignToGridButton.action = function () { changeViewOption(this); }

    return table;
}