﻿
StiMobileDesigner.prototype.MarginsMenu = function (name, parentButton) {
    var jsObject = this;
    var menu = this.VerticalMenu(name || "marginsMenu", parentButton || this.options.buttons.marginsPage, "Down", this.GetPageMarginsItems(), "stiDesignerMenuMiddleItem");

    menu.constMargins = this.GetConstMargins();

    menu.action = function (menuItem) {
        var mInUnit = this.constMargins[jsObject.options.report.properties.reportUnit][menuItem.key];
        jsObject.options.currentPage.properties.unitMargins = mInUnit + "!" + mInUnit + "!" + mInUnit + "!" + mInUnit;
        menuItem.setSelected(true);
        this.changeVisibleState(false);
        jsObject.SendCommandSendProperties(jsObject.options.currentPage, ["unitMargins"]);
    }

    menu.onshow = function () {
        var text = function (options, num) {
            var unit = options.report.properties.reportUnit;
            var leftWord = jsObject.loc.PropertyEnum.StiBorderSidesLeft;
            var topWord = jsObject.loc.PropertyEnum.StiBorderSidesTop;
            var rightWord = jsObject.loc.PropertyEnum.StiBorderSidesRight;
            var bottomWord = jsObject.loc.PropertyEnum.StiBorderSidesBottom;

            return "<nobr>" + leftWord + ": " + num + unit + ", " + topWord + ": " + num + unit + ", " +
                rightWord + ": " + num + unit + ", " + bottomWord + ": " + num + unit + "</nobr>"
        }
        var options = jsObject.options;

        for (var itemName in this.items) {
            var locName = itemName.charAt(0).toUpperCase() + itemName.substr(1);
            var headText = jsObject.loc.FormDesigner[locName];
            this.items[itemName].caption.innerHTML = "<b>" + headText +
                "</b><br>" + text(options, this.constMargins[options.report.properties.reportUnit][itemName]);
        }

        for (var marginName in this.constMargins[jsObject.options.report.properties.reportUnit]) {
            var constValue = this.constMargins[jsObject.options.report.properties.reportUnit][marginName];
            this.items[marginName].setSelected(constValue + "!" + constValue + "!" + constValue + "!" + constValue == jsObject.options.currentPage.properties.unitMargins);
        }
    }

    return menu;
}