﻿
StiMobileDesigner.prototype.DataSourcesSubMenu = function (name, parentButton, parentMenu) {
    var jsObject = this;
    var dataSourcesItems = [];
    var dataSources = jsObject.GetDataSourcesFromDictionary(jsObject.options.report.dictionary);
    var dataSourcesMenu = parentMenu ? jsObject.InitializeSubMenu(name, [], parentButton, parentMenu) : jsObject.VerticalMenu(name, parentButton, "Down", [], null, null, null, null, true);

    if (dataSources.length > 0) {
        for (var i = 0; i < dataSources.length; i++) {
            dataSourcesItems.push(jsObject.Item("dataSource_" + dataSources[i].correctName, dataSources[i].name, "DataSource.png", dataSources[i].name, null, true));
        }
        dataSourcesMenu.addItems(dataSourcesItems);

        for (var i = 0; i < dataSources.length; i++) {
            var columns = dataSources[i].columns;
            var columnsItems = [];

            for (var k = 0; k < columns.length; k++) {
                columnsItems.push(jsObject.Item("column_" + columns[k].name, columns[k].name, columns[k].typeIcon + ".png", { corrected: dataSources[i].correctName + "." + columns[k].correctName, original: dataSources[i].name + "." + columns[k].name }));
            }

            var columnsMenu = jsObject.InitializeSubMenu(name + "_" + dataSources[i], columnsItems, dataSourcesMenu.items["dataSource_" + dataSources[i].correctName], dataSourcesMenu);

            columnsMenu.action = function (menuItem) {
                dataSourcesMenu.action(menuItem);

                dataSourcesMenu.changeVisibleState(false);
                if (parentMenu) parentMenu.changeVisibleState(false);
            }
        }
    }

    return dataSourcesMenu;
}