﻿
StiMobileDesigner.prototype.InitializeLayoutPanelSingleLine = function (layoutPanel) {
    var jsObject = this;

    var mainTable = layoutPanel.mainTableSingleLine = this.CreateHTMLTable();
    mainTable.style.display = jsObject.options.ribbonType == "SingleLine" ? "" : "none";
    mainTable.style.height = (jsObject.options.ribbonSingleLineHeight - 2) + "px";
    mainTable.addCell(this.LayoutPanelSingleLineArrangeBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());
    mainTable.addCell(this.LayoutPanelSingleLineDesignBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());
    layoutPanel.appendChild(mainTable);

    layoutPanel.updateSingleLineControls = function () {
        var currentObject = jsObject.options.selectedObject || jsObject.GetCommonObject(this.jsObject.options.selectedObjects);

        var enableArrangeButtons = currentObject && currentObject.typeComponent != "StiPage" && currentObject.typeComponent != "StiReport";
        var arrangeButtons = ["alignToGridSingle", "alignLayoutSingle", "bringToFrontSingle", "sendToBackSingle", "moveForwardSingle", "moveBackwardSingle", "layoutSizeSingle", "linkSingle", "lockSingle"]

        for (var i = 0; i < arrangeButtons.length; i++) {
            var button = jsObject.options.buttons[arrangeButtons[i]];
            if (button) button.setEnabled(enableArrangeButtons);
        }

        if (currentObject) {
            jsObject.options.buttons.lockSingle.setSelected(currentObject.properties.locked === true);
            jsObject.options.buttons.linkSingle.setSelected(currentObject.properties.linked === true);
            jsObject.options.buttons.layoutSizeSingle.setEnabled(jsObject.options.selectedObjects && this.jsObject.options.selectedObjects.length > 0);
        }
    }
}

//Arrange
StiMobileDesigner.prototype.LayoutPanelSingleLineArrangeBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    var buttons = [
        [this.SingleLineRibbonButton("alignToGridSingle", null, this.loc.Toolbars.AlignToGrid, "ContextMenu.AlignToGrid.png", [this.loc.HelpDesigner.AlignToGrid, this.GetHelpLink("layout")]), "alignToGrid"],
        [this.SingleLineRibbonButton("alignLayoutSingle", null, this.loc.Toolbars.Align, "ContextMenu.AlignToGrid.png", [this.loc.HelpDesigner.Align, this.GetHelpLink("layout")], "Down"), "alignLayout"],
        [this.SingleLineRibbonButton("bringToFrontSingle", null, this.loc.Toolbars.BringToFront, "ContextMenu.BringToFront.png", [this.loc.HelpDesigner.BringToFront, this.GetHelpLink("layout")]), "bringToFront"],
        [this.SingleLineRibbonButton("sendToBackSingle", null, this.loc.Toolbars.SendToBack, "ContextMenu.SendToBack.png", [this.loc.HelpDesigner.SendToBack, this.GetHelpLink("layout")]), "sendToBack"],
        [this.SingleLineRibbonButton("moveForwardSingle", null, this.loc.Toolbars.MoveForward, "ContextMenu.MoveForward.png", [this.loc.HelpDesigner.MoveForward, this.GetHelpLink("layout")]), "moveForward"],
        [this.SingleLineRibbonButton("moveBackwardSingle", null, this.loc.Toolbars.MoveBackward, "ContextMenu.MoveBackward.png", [this.loc.HelpDesigner.MoveBackward, this.GetHelpLink("layout")]), "moveBackward"],
    ]

    for (var i = 0; i < buttons.length; i++) {
        var button = buttons[i][0];
        button.cloneName = buttons[i][1];
        button.style.margin = "0 2px 0 2px";
        table.addCell(button);

        if (button.cloneName == "alignToGrid" || button.cloneName == "alignLayout") {
            table.addCell(jsObject.RibbonPanelSingleLineSeparator());
        }

        button.action = function () {
            var cloneButton = jsObject.options.buttons[this.cloneName];
            if (cloneButton) cloneButton.action();
        }
    }

    var alignMenu = this.LayoutAlignMenu("layoutAlignMenuSingle", jsObject.options.buttons.alignLayoutSingle);

    jsObject.options.buttons.alignLayoutSingle.action = function () {
        alignMenu.changeVisibleState(!alignMenu.visible);
    }

    return table;
}

//Design
StiMobileDesigner.prototype.LayoutPanelSingleLineDesignBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    var buttons = [
        [this.SingleLineRibbonButton("layoutSizeSingle", null, this.loc.PropertyMain.Size, "Layout.MakeSameSize.png", [this.loc.HelpDesigner.ComponentSize, this.GetHelpLink("layout")], "Down"), "layoutSize"],
        [this.SingleLineRibbonButton("lockSingle", null, this.loc.Toolbars.Lock, "Layout.Lock.png", [this.loc.HelpDesigner.Lock, this.GetHelpLink("layout")], null), "lock"],
        [this.SingleLineRibbonButton("linkSingle", null, this.loc.Toolbars.Link, "Layout.Link.png", [this.loc.HelpDesigner.Link, this.GetHelpLink("layout")], null), "link"],
    ]

    for (var i = 0; i < buttons.length; i++) {
        var button = buttons[i][0];
        button.cloneName = buttons[i][1];
        button.style.margin = "0 2px 0 2px";
        table.addCell(button);

        button.action = function () {
            var cloneButton = jsObject.options.buttons[this.cloneName];
            if (cloneButton) cloneButton.action();
        }
    }

    var layoutSizeMenu = jsObject.LayoutSizeMenu("layoutSizeMenuSingle", jsObject.options.buttons.layoutSizeSingle);

    jsObject.options.buttons.layoutSizeSingle.action = function () {
        layoutSizeMenu.changeVisibleState(!layoutSizeMenu.visible);
    }

    return table;
}