﻿
StiMobileDesigner.prototype.InitializeInsertPanelSingleLine = function (insertPanel) {
    var jsObject = this;

    insertPanel.singleLineButtons = {};

    var mainTable = insertPanel.mainTableSingleLine = this.CreateHTMLTable();
    mainTable.style.display = jsObject.options.ribbonType == "SingleLine" ? "" : "none";
    mainTable.style.height = (jsObject.options.ribbonSingleLineHeight - 2) + "px";
    mainTable.addCell(this.InsertPanelSingleInsertPagesBlock());

    if (!this.options.componentsIntoInsertTab) {
        mainTable.addCell(this.InsertPanelSingleGroupsComponentsBlock());
        var sep = jsObject.options.controls.singleGroupsComponentsSep = this.RibbonPanelSingleLineSeparator();
        mainTable.addCell(sep); 
    }

    var mainCompsBlock = insertPanel.mainCompsBlock = this.InsertPanelSingleMainComponentsBlock();
    mainTable.addCell(mainCompsBlock);
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());

    insertPanel.appendChild(mainTable);

    insertPanel.resetChooseSingleLine = function () {
        var buttons = jsObject.options.buttons;
        var names = ["insertBandsSingle", "insertCrossBandsSingle", "insertComponentsSingle", "insertBarCodesSingle", "insertShapesSingle", "insertSignaturesSingle", "insertChartsSingle",
            "insertMapsSingle", "insertGaugesSingle", "insertMapsElementsSingle", "insertFiltersElementsSingle"];

        for (var i = 0; i < names.length; i++) {
            if (buttons[names[i]]) buttons[names[i]].setSelected(false);
        }
    }

    insertPanel.updateSingleLine = function (components) {
        if (insertPanel.selCompsTableSingle) {
            mainCompsBlock.removeChild(insertPanel.selCompsTableSingle);
            insertPanel.singleLineButtons = {};
        }

        insertPanel.selCompsTableSingle = jsObject.CreateHTMLTable();
        mainCompsBlock.appendChild(insertPanel.selCompsTableSingle);

        var addComponentButtons = function (componentTypes) {
            var mapsMenuCreated = false;
            var filterMenuCreated = false;

            for (var i = 0; i < componentTypes.length; i++) {
                if (jsObject.options.visibilityComponents[componentTypes[i]] || jsObject.options.visibilityBands[componentTypes[i]] || jsObject.options.visibilityCrossBands[componentTypes[i]] ||
                    (jsObject.options.dashboardAssemblyLoaded && jsObject.options.visibilityDashboardElements[componentTypes[i]])) {
                    var isDashboardElement = jsObject.options.dashboardAssemblyLoaded && jsObject.options.visibilityDashboardElements[componentTypes[i]];
                    var text = isDashboardElement ? jsObject.loc.Components[componentTypes[i].replace("Element", "")] : jsObject.loc.Components[componentTypes[i]];
                    var image = (isDashboardElement ? "Dashboards.SmallComponents." : "SmallComponents.") + componentTypes[i] + ".png";
                    var tooltip = ["<b>" + text + "</b><br><br><table><tr><td style='vertical-align: top;'>" + (jsObject.loc.HelpComponents[componentTypes[i]] || "") + "</td></tr></table>", jsObject.GetHelpLink("insertcomponent")];
                    var button = jsObject.ComponentButton(componentTypes[i], null, image, null, tooltip, null, true, true);

                    if (isDashboardElement) {
                        if (componentTypes[i] == "StiShapeElement") {
                            button = jsObject.SingleLineRibbonButton("insertShapesElementsSingle", null, null, "SmallComponents.StiShape.png", tooltip, "Down");

                            var shapesMenu = jsObject.ShapesMenu("shapesElementsMenuSingle", button, true, true);

                            button.action = function () {
                                shapesMenu.changeVisibleState(!shapesMenu.visible);
                            }
                        }
                        else if (componentTypes[i] == "StiRegionMapElement" || componentTypes[i] == "StiOnlineMapElement") {
                            if (mapsMenuCreated) continue;

                            tooltip = ["<b>" + jsObject.loc.PropertyMain.Maps + "</b><br><br>" +
                                "<table><tr><td style='vertical-align: top;'>" + jsObject.loc.HelpComponents.StiMapCategory + "</td></tr></table>", jsObject.GetHelpLink("insertcomponent")];

                            button = jsObject.SingleLineRibbonButton("insertMapsElementsSingle", null, null, "SmallComponents.StiMap.png", tooltip, "Down");

                            var mapsMenu = jsObject.MapsElementsMenu("mapsElementsMenuSingle", button, false, componentTypes);
                            mapsMenuCreated = true;

                            button.action = function () {
                                mapsMenu.changeVisibleState(!mapsMenu.visible);
                            }
                        }
                        else if (jsObject.IsFilterElement(componentTypes[i])) {
                            if (filterMenuCreated) continue;

                            tooltip = ["<b>" + jsObject.loc.PropertyMain.Filters + "</b><br><br>" +
                                "<table><tr><td style='vertical-align: top;'>" + jsObject.loc.HelpComponents.StiFilterCategory + "</td></tr></table>", jsObject.GetHelpLink("insertcomponent")];

                            button = jsObject.SingleLineRibbonButton("insertFiltersElementsSingle", null, null, "Dashboards.SmallComponents.StiFilterElement.png", tooltip, "Down");

                            var filtersMenu = jsObject.FiltersElementsMenu("filtersElementsMenuSingle", button, false, componentTypes);
                            filterMenuCreated = true;

                            button.action = function () {
                                filtersMenu.changeVisibleState(!filtersMenu.visible);
                            }
                        }
                    }

                    button.isDashboardElement = isDashboardElement;
                    button.allwaysEnabled = false;
                    insertPanel.selCompsTableSingle.addCell(button);
                    insertPanel.singleLineButtons[componentTypes[i]] = button;
                    button.setEnabled(jsObject.options.report != null);
                }
            }
        }
        var componentTypes = jsObject.options.componentsIntoInsertTab || components || jsObject.GetComponentsIntoInsertTab();
        var addSetupButtonSeparator = false;

        if (jsObject.Is_array(componentTypes)) {
            addComponentButtons(componentTypes);
        }
        else {
            var addSep = false;
            for (var groupName in componentTypes) {
                if (componentTypes[groupName].items.length > 0) {
                    var componentsInGroup = componentTypes[groupName].items;
                    var visibleComponents = [];
                    for (var i = 0; i < componentsInGroup.length; i++) {
                        if (jsObject.options.visibilityComponents[componentsInGroup[i]] ||
                            jsObject.options.visibilityBands[componentsInGroup[i]] ||
                            jsObject.options.visibilityCrossBands[componentsInGroup[i]] ||
                            (jsObject.options.dashboardAssemblyLoaded && jsObject.options.visibilityDashboardElements[componentsInGroup[i]])) {
                            visibleComponents.push(componentsInGroup[i]);
                        }
                    }
                    if (visibleComponents.length > 0) {
                        if (addSep && groupName != "dashboards") {
                            insertPanel.singleLineButtons["separator" + groupName] = jsObject.RibbonPanelSingleLineSeparator();
                            insertPanel.selCompsTableSingle.addCell(insertPanel.singleLineButtons["separator" + groupName]);
                        }
                        addSep = true;
                        addSetupButtonSeparator = true;
                    }
                }
                addComponentButtons(componentTypes[groupName].items);
            }
        }

        if (jsObject.options.showSetupToolboxButton) {
            if (addSetupButtonSeparator) {
                insertPanel.setupButtonSeparatorSingle = insertPanel.selCompsTableSingle.addCell(jsObject.RibbonPanelSingleLineSeparator());
            }
            var setupToolboxButton = jsObject.SingleLineRibbonButton("insertPanelSetupToolboxSingle", null, jsObject.loc.FormDesigner.SetupToolbox, "Toolbox.SmallSetupToolbox.png", [jsObject.loc.FormDesigner.SetupToolbox, jsObject.GetHelpLink("insertcomponent")]);
            insertPanel.selCompsTableSingle.addCell(setupToolboxButton);

            setupToolboxButton.action = function () {
                jsObject.InitializeSetupToolboxForm(function (form) {
                    form.changeVisibleState(true);
                });
            }
        }

        var buttonNames = ["insertBandsSingle", "insertCrossBandsSingle", "insertComponentsSingle", "insertSignaturesSingle", "insertBarCodesSingle", "insertShapesSingle", "insertChartsSingle", "insertMapsSingle", "insertGaugesSingle",
            "insertPanelAddPageSingle", "insertPanelAddDashboardSingle"];

        for (var i = 0; i < buttonNames.length; i++) {
            var button = jsObject.options.buttons[buttonNames[i]];
            if (button) {
                if (!jsObject.options.componentsIntoInsertTab && componentTypes) {
                    var buttonCell = button.parentElement;
                    if (buttonNames[i] == "insertBandsSingle")
                        buttonCell.style.display = componentTypes["bands"] && componentTypes["bands"].categoryVisible && jsObject.IsVisibilityBands() ? "" : "none";
                    else if (buttonNames[i] == "insertCrossBandsSingle")
                        buttonCell.style.display = componentTypes["crossBands"] && componentTypes["crossBands"].categoryVisible && jsObject.IsVisibilityCrossBands() ? "" : "none";
                    else if (buttonNames[i] == "insertComponentsSingle")
                        buttonCell.style.display = componentTypes["components"] && componentTypes["components"].categoryVisible && jsObject.IsVisibilityComponents() ? "" : "none";
                    else if (buttonNames[i] == "insertSignaturesSingle")
                        buttonCell.style.display = componentTypes["signatures"] && componentTypes["signatures"].categoryVisible && jsObject.IsVisibilitySignatures() ? "" : "none";
                    else if (buttonNames[i] == "insertBarCodesSingle")
                        buttonCell.style.display = componentTypes["barcodes"] && componentTypes["barcodes"].categoryVisible && jsObject.options.visibilityComponents.StiBarCode ? "" : "none";
                    else if (buttonNames[i] == "insertShapesSingle")
                        buttonCell.style.display = componentTypes["shapes"] && componentTypes["shapes"].categoryVisible && jsObject.IsVisibilityShapes() ? "" : "none";
                    else if (buttonNames[i] == "insertChartsSingle")
                        buttonCell.style.display = componentTypes["charts"] && componentTypes["charts"].categoryVisible && jsObject.options.visibilityComponents.StiChart ? "" : "none";
                    else if (buttonNames[i] == "insertMapsSingle")
                        buttonCell.style.display = componentTypes["maps"] && componentTypes["maps"].categoryVisible && jsObject.options.visibilityComponents.StiMap ? "" : "none";
                    else if (buttonNames[i] == "insertGaugesSingle")
                        buttonCell.style.display = componentTypes["gauges"] && componentTypes["gauges"].categoryVisible && jsObject.options.visibilityComponents.StiGauge ? "" : "none";
                }
                if (button.style.display != "none") {
                    button.setEnabled(jsObject.options.report != null);
                }
            }
        }

        jsObject.options.buttons.insertPanelSingleAddPage.setEnabled(jsObject.options.report != null);

        if (jsObject.options.dashboardAssemblyLoaded) {
            jsObject.options.buttons.insertPanelSingleAddDashboard.setEnabled(jsObject.options.report != null);
        }

        insertPanel.setModeSingleLine(true);
    }

    insertPanel.setModeSingleLine = function (manually) {
        if (!jsObject.options.componentsIntoInsertTab) {
            jsObject.options.controls.singleGroupsComponentsBlock.style.display = jsObject.options.controls.singleGroupsComponentsSep.style.display = this.mode == "Page" ? "" : "none";
        }

        if (insertPanel.setupButtonSeparatorSingle)
            insertPanel.setupButtonSeparatorSingle.style.display = "none";

        for (var name in this.singleLineButtons) {
            var button = this.singleLineButtons[name];
            button.parentNode.style.display = (this.mode == "Dashboard" && button.isDashboardElement && name.indexOf("separator") < 0) || (this.mode == "Page" && !button.isDashboardElement) ? "" : "none";

            if (button.parentNode.style.display == "" && insertPanel.setupButtonSeparatorSingle) {
                insertPanel.setupButtonSeparatorSingle.style.display = "";
            }
        }
    }
}

//Pages
StiMobileDesigner.prototype.InsertPanelSingleInsertPagesBlock = function () {
    var table = this.CreateHTMLTable();
    var showSep = false;

    var pageButton = this.SingleLineRibbonButton("insertPanelSingleAddPage", null, this.loc.A_WebViewer.Page, "SmallComponents.StiPage.png", [this.loc.HelpDesigner.PageNew, this.GetHelpLink("insertcomponent")]);
    pageButton.style.margin = "0px 0px 0px 2px";

    if (this.options.showNewPageButton !== false) {
        table.addCell(pageButton);
        showSep = true;
    }

    if (this.options.dashboardAssemblyLoaded) {
        var dashboardButton = this.SingleLineRibbonButton("insertPanelSingleAddDashboard", null, this.loc.Components.StiDashboard, "SmallComponents.StiDashboard.png", [this.loc.Wizards.groupCreateNewDashboard, this.GetHelpLink("insertcomponent")]);
        dashboardButton.style.margin = "0px 0px 0px 2px";

        if (this.options.showNewDashboardButton !== false) {
            table.addCell(dashboardButton);
            showSep = true;
        }
    }

    if (showSep) {
        table.addCell(this.RibbonPanelSingleLineSeparator());
    }

    return table;
}

//Components
StiMobileDesigner.prototype.InsertPanelSingleGroupsComponentsBlock = function () {
    var jsObject = this;
    var table = jsObject.options.controls.singleGroupsComponentsBlock = this.CreateHTMLTable();

    //Groups
    if (!this.options.componentsIntoInsertTab) {
        table.addCell(this.SingleLineRibbonButton("insertBandsSingle", null, null, "Toolbox.Bands.png", [this.loc.Report.Bands, this.GetHelpLink("insertcomponent")], "Down"));
        this.BandsMenu("bandsMenuSingle", this.options.buttons.insertBandsSingle);

        table.addCell(this.SingleLineRibbonButton("insertCrossBandsSingle", null, null, "Toolbox.CrossBands.png", [this.loc.Report.CrossBands, this.GetHelpLink("insertcomponent")], "Down"));
        this.CrossBandsMenu("crossBandsMenuSingle", this.options.buttons.insertCrossBandsSingle);

        table.addCell(this.SingleLineRibbonButton("insertComponentsSingle", null, null, "Toolbox.Components.png", [this.loc.Report.Components, this.GetHelpLink("insertcomponent")], "Down"));
        this.ComponentsMenu("componentsMenuSingle", this.options.buttons.insertComponentsSingle);

        table.addCell(this.SingleLineRibbonButton("insertSignaturesSingle", null, null, "Toolbox.Signatures.png", [this.loc.Components.StiSignature, this.GetHelpLink("insertcomponent")], "Down"));
        this.SignaturesMenu("signaturesMenuSingle", this.options.buttons.insertSignaturesSingle);

        table.addCell(this.SingleLineRibbonButton("insertBarCodesSingle", null, null, "SmallComponents.StiBarCode.png", [this.loc.Components.StiBarCode, this.GetHelpLink("insertcomponent")], "Down"));
        this.BarCodesMenu("barCodesMenuSingle", this.options.buttons.insertBarCodesSingle);

        table.addCell(this.SingleLineRibbonButton("insertShapesSingle", null, null, "SmallComponents.StiShape.png", [this.loc.Report.Shapes, this.GetHelpLink("insertcomponent")], "Down"));
        this.ShapesMenu("shapesMenuSingle", this.options.buttons.insertShapesSingle);

        table.addCell(this.SingleLineRibbonButton("insertChartsSingle", null, null, "SmallComponents.StiChart.png", [this.loc.Components.StiChart, this.GetHelpLink("insertcomponent")], "Down"));
        this.ChartsMenu("chartsMenuSingle", this.options.buttons.insertChartsSingle);

        table.addCell(this.SingleLineRibbonButton("insertGaugesSingle", null, null, "SmallComponents.StiGauge.png", [this.loc.Components.StiGauge, this.GetHelpLink("insertcomponent")], "Down"));
        this.GaugesMenu("gaugesMenuSingle", this.options.buttons.insertGaugesSingle);

        var mapTooltip = ["<b>" + this.loc.Components.StiMap + "</b><br><br><table><tr><td style='vertical-align: top;'>" + jsObject.loc.HelpComponents.StiMap + "</td></tr></table>", this.GetHelpLink("insertcomponent")];
        var insertMapsButton = this.SingleLineRibbonButton("insertMapsSingle", null, null, "SmallComponents.StiMap.png", mapTooltip);
        insertMapsButton.name = "StiMap";
        table.addCell(insertMapsButton);

        this.AddDragEventsToComponentButton(insertMapsButton);

        insertMapsButton.action = function () {
            jsObject.InitializeMapCategoriesForm(function (form) {
                insertMapsButton.setSelected(true);
                form.show(jsObject.options.insertPanel);
            });
        }
    }

    return table;
}

StiMobileDesigner.prototype.InsertPanelSingleMainComponentsBlock = function () {
    var block = document.createElement("div");

    return block;
}