﻿
StiMobileDesigner.prototype.InitializeSubReportForm_ = function () {

    //SubReport Form
    var jsObject = this;
    var subReportForm = this.BaseForm("subReportForm", this.loc.Components.StiSubReport, 1, this.GetHelpLink("subreportform"));
    subReportForm.mode = "SubReportPage";

    //Main Table
    var mainTable = this.CreateHTMLTable();
    mainTable.className = "stiDesignerImageFormMainPanel";
    subReportForm.container.appendChild(mainTable);
    subReportForm.container.style.padding = "0px";

    //Buttons
    var buttonProps = [
        ["SubReportPage", "SubReportForm.SubReportPage.png", this.loc.Toolbars.TabPage],
        ["SubReportFile", "SubReportForm.SubReportFile.png", this.loc.MainMenu.menuFile.replace("&", "")],
        ["SubReportUrl", "SubReportForm.SubReportHyperlink.png", this.loc.PropertyMain.URL],
        ["SubReportParameters", "SubReportForm.SubReportParameters.png", this.loc.PropertyMain.Parameters]
    ];

    if (this.options.serverMode) {
        buttonProps.push(["SubReportServer", "SubReportForm.SubReportCloud.png", "Server"]);
    }

    //Add Panels && Buttons
    var buttonsPanel = mainTable.addCell();
    var panelsContainer = mainTable.addCell();
    buttonsPanel.style.verticalAlign = "top";
    buttonsPanel.style.paddingTop = "6px";
    subReportForm.mainButtons = {};
    subReportForm.panels = {};

    for (var i = 0; i < buttonProps.length; i++) {
        var panel = document.createElement("Div");
        panel.className = "stiDesignerEditFormPanel";
        panel.style.height = "480px";
        panel.style.width = "auto";
        panel.style.minWidth = "505px";
        if (i != 0) panel.style.display = "none";
        panelsContainer.appendChild(panel);
        subReportForm.panels[buttonProps[i][0]] = panel;

        var button = this.FormTabPanelButton(null, buttonProps[i][2], buttonProps[i][1], buttonProps[i][2], null, { width: 24, height: 24 }, 34);
        subReportForm.mainButtons[buttonProps[i][0]] = button;
        buttonsPanel.appendChild(button);

        button.panelName = buttonProps[i][0];
        button.action = function () {
            subReportForm.setMode(this.panelName);
        }

        //add marker
        var marker = document.createElement("div");
        marker.style.display = "none";
        marker.className = "stiUsingMarker";
        var markerInner = document.createElement("div");
        marker.appendChild(markerInner);
        button.style.position = "relative";
        button.appendChild(marker);
        button.marker = marker;
    }

    if (!jsObject.options.standaloneJsMode && jsObject.options.allowLoadingLocalResource === false) {
        subReportForm.mainButtons.SubReportFile.style.display = "none";
    }

    //Page
    var pageContainer = this.Container("pageContainer", 480, 422);
    pageContainer.className = "stiSimpleContainerWithBorder";
    pageContainer.style.margin = "12px";
    pageContainer.style.overflow = "auto";
    subReportForm.panels.SubReportPage.appendChild(pageContainer);

    //File Name
    var toolBarFileName = this.CreateHTMLTable();
    toolBarFileName.style.width = "100%";
    subReportForm.panels.SubReportFile.appendChild(toolBarFileName);

    var captionCell = toolBarFileName.addCell();
    captionCell.style.padding = "0 12px 0 15px";
    captionCell.innerHTML = this.loc.Cloud.labelFileName.replace(":", "");

    var fileNameTextBox = subReportForm.fileNameTextBox = this.TextBoxWithOpenDialog("subReportFormFileName", 340, ".mrt");
    if (!this.options.standaloneJsMode) fileNameTextBox.openButton.style.display = "none";
    fileNameTextBox.style.margin = "12px 14px 12px 0";
    toolBarFileName.addCell(fileNameTextBox).style.textAlign = "right";

    //Url
    var urlControl = subReportForm.urlControl = this.ExpressionControl("subReportFormUrl", 470, null, null, null, null, null, true, ["http://site.com/file.mrt", "{Expression}"], null, 50);
    urlControl.style.margin = "12px";
    urlControl.onlyExpression = false;
    subReportForm.panels.SubReportUrl.appendChild(urlControl);
    subReportForm.panels.SubReportUrl.style.overflow = "hidden";

    //Resources Gallery
    var resourcesGallery = this.ImageGallery(null, 490, 100, this.loc.PropertyMain.Resources, null, { width: 32, height: 32 });
    resourcesGallery.style.marginTop = "12px";
    subReportForm.panels.SubReportUrl.appendChild(resourcesGallery);

    resourcesGallery.changeVisibleState = function (state) {
        this.style.display = state ? "" : "none";
    }

    resourcesGallery.update = function () {
        this.clear();
        if (!this.jsObject.options.report) return;

        var types = ["Report", "ReportSnapshot"];
        var resources = this.jsObject.options.report.dictionary.resources;
        var resourceIdent = this.jsObject.options.resourceIdent;
        var urlResourceName = urlControl.textBox.value.indexOf(resourceIdent) == 0 ? urlControl.textBox.value.substring(resourceIdent.length) : null;

        for (var i = 0; i < resources.length; i++) {
            if (types.indexOf(resources[i].type) >= 0) {
                var itemObject = this.jsObject.CopyObject(resources[i]);
                itemObject.imageName = "Resources.BigResource" + resources[i].type;
                var item = this.addItem(itemObject);

                item.action = function () {
                    resourcesGallery.action(this);
                }

                item.select = function (state) {
                    if (state) {
                        var items = resourcesGallery.getItems();
                        for (var i = 0; i < items.length; i++) {
                            items[i].setSelected(false);
                        }
                        this.setSelected(true);
                    }
                    else {
                        this.setSelected(false);
                    }
                }

                if (itemObject.name == urlResourceName) {
                    item.select(true);
                }
            }
        };

        resourcesGallery.changeVisibleState(this.innerContainer.innerTable);
    }

    resourcesGallery.action = function (item) {
        item.select(true);
        urlControl.textBox.value = this.jsObject.options.resourceIdent + item.itemObject.name;
    }

    //Parameters
    var newParameter = this.FormButton(null, null, this.loc.FormDictionaryDesigner.DataParameterNew);
    newParameter.style.margin = "12px 12px 0 12px";
    newParameter.style.display = "inline-block";
    subReportForm.panels.SubReportParameters.appendChild(newParameter);

    var parametersTable = this.CreateHTMLTable();
    subReportForm.panels.SubReportParameters.appendChild(parametersTable);

    var paramsCont = this.DataContainer(160, 380, false, jsObject.loc.PropertyMain.NoElements);
    paramsCont.style.margin = "12px 12px 0 12px";
    paramsCont.className = "stiSimpleContainerWithBorder";
    paramsCont.style.overflow = "auto";
    parametersTable.addCell(paramsCont);

    paramsCont.onAction = function (actionName) {
        if (actionName == "select" && this.selectedItem && this.selectedItem.itemObject) {
            drillParamName.value = this.selectedItem.itemObject.name;
            drillParamValue.textArea.value = StiBase64.decode(this.selectedItem.itemObject.expression);
        }
        var countItems = paramsCont.getCountItems();
        drillParamName.setEnabled(countItems > 0);
        drillParamValue.setEnabled(countItems > 0);

        if (countItems == 0) {
            drillParamName.value = "";
            drillParamValue.textArea.value = "";
        }
        this.updateHintText();
    }

    paramsCont.updateItem = function () {
        if (this.selectedItem && this.selectedItem.itemObject) {
            this.selectedItem.itemObject.name = drillParamName.value;
            this.selectedItem.itemObject.expression = StiBase64.encode(drillParamValue.textArea.value);
            this.selectedItem.captionContainer.innerHTML = drillParamName.value;
        }
    }

    paramsCont.onmouseover = function () { }
    paramsCont.onmouseout = function () { }

    newParameter.action = function () {
        var countItems = paramsCont.getCountItems();
        if (countItems < 10) {
            var index = 1;
            var resultName = jsObject.loc.PropertyMain.Parameter;
            var nameIsFree = false;
            while (!nameIsFree) {
                var nameFinded = false;
                for (var i = 0; i < countItems; i++) {
                    var item = paramsCont.getItemByIndex(i);
                    if (item.itemObject.name.toLowerCase() == resultName.toLowerCase()) {
                        nameFinded = true;
                        break;
                    }
                }
                if (nameFinded) {
                    index++;
                    resultName = jsObject.loc.PropertyMain.Parameter + index;
                }
                else {
                    nameIsFree = true;
                }
            }
            var itemObject = {
                name: resultName,
                expression: ""
            }
            paramsCont.addItem(itemObject.name, false, itemObject).select();
        }
    }

    var paramControlsTable = this.CreateHTMLTable();
    parametersTable.addCell(paramControlsTable).style.verticalAlign = "top";
    paramControlsTable.addTextCell(this.loc.PropertyMain.Name).className = "stiDesignerCaptionControls";

    var drillParamName = this.TextBox(null, 200);
    drillParamName.action = function () { paramsCont.updateItem(); }
    paramControlsTable.addCell(drillParamName).style.padding = "8px 12px 4px 0";

    var expCell = paramControlsTable.addTextCellInNextRow(this.loc.PropertyMain.Expression);
    expCell.className = "stiDesignerCaptionControls";
    expCell.style.verticalAlign = "top";
    expCell.style.paddingTop = "8px";

    var drillParamValue = this.ExpressionTextArea(null, 200, 100, true, true, false, false, ["Variable", "Line"], null, 40, true);
    drillParamValue.action = function () { paramsCont.updateItem(); }
    paramControlsTable.addCellInLastRow(drillParamValue).style.padding = "4px 12px 8px 0";

    //Server
    if (this.options.serverMode) {
        subReportForm.cloudContainer = this.CloudContainer("subReportFormCloudContainer", ["SubReport"], null, 450);
        subReportForm.panels.SubReportServer.appendChild(subReportForm.cloudContainer);
        if (this.options.dictionaryTree.selectedItem) this.options.dictionaryTree.selectedItem.setSelected();
    }

    //Form Methods
    subReportForm.setMode = function (mode) {
        subReportForm.mode = mode;
        for (var panelName in subReportForm.panels) {
            subReportForm.panels[panelName].style.display = mode == panelName ? "" : "none";
            subReportForm.mainButtons[panelName].setSelected(mode == panelName);
        }
        if (mode == "SubReportUrl") {
            urlControl.textBox.focus();
            resourcesGallery.update();
        }
        if (mode == "SubReportFile") {
            fileNameTextBox.textBox.focus();
        }
    }

    subReportForm.onhide = function () {
        clearTimeout(this.markerTimer);
    }

    subReportForm.updateMarkers = function () {
        this.mainButtons["SubReportPage"].marker.style.display = pageContainer.selectedItem && pageContainer.selectedItem.itemObject.name != "NotAssigned" ? "" : "none";
        this.mainButtons["SubReportFile"].marker.style.display = fileNameTextBox.textBox.value ? "" : "none";
        this.mainButtons["SubReportUrl"].marker.style.display = urlControl.textBox.value ? "" : "none";
        this.mainButtons["SubReportParameters"].marker.style.display = paramsCont.getCountItems() > 0 ? "" : "none";
    }

    subReportForm.show = function () {
        var selectedObject = this.jsObject.options.selectedObject || this.jsObject.GetCommonObject(this.jsObject.options.selectedObjects);
        if (!selectedObject) return;

        subReportForm.changeVisibleState(true);
        subReportForm.setMode("SubReportPage");
        urlControl.textBox.value = "";
        fileNameTextBox.textBox.value = "";
        resourcesGallery.changeVisibleState(false);

        var subReportPage = selectedObject.properties["subReportPage"] != "StiEmptyValue" ? selectedObject.properties["subReportPage"] : "[Not Assigned]";
        var subReportUrl = selectedObject.properties["subReportUrl"] != null && selectedObject.properties["subReportUrl"] != "StiEmptyValue"
            ? StiBase64.decode(selectedObject.properties["subReportUrl"]) : null;

        //Get subreport pages
        pageContainer.clear();
        var items = this.jsObject.GetSubReportItems();
        for (var i = 0; i < items.length; i++) {
            var item = pageContainer.addItemAndNotAction(null, items[i], items[i].caption);
            if (i == 0) item.selected();
        }

        if (subReportUrl) {
            if (subReportUrl.indexOf("file://") == 0) {
                subReportForm.setMode("SubReportFile");
                fileNameTextBox.textBox.value = subReportUrl.replace("file://", "");
            }
            else if (subReportUrl.indexOf(this.jsObject.options.cloudServerUrl) == 0) {
                subReportForm.setMode("SubReportServer");
                var key = subReportUrl.replace(this.jsObject.options.cloudServerUrl, "");
                var item = this.jsObject.options.dictionaryTree.getCloudItemByKey("SubReport", key);
                if (item && subReportForm.cloudContainer) subReportForm.cloudContainer.addItem(item.itemObject);
            }
            else {
                urlControl.textBox.value = subReportUrl;
                subReportForm.setMode("SubReportUrl");
            }
        }
        else if (subReportPage != "[Not Assigned]") {
            for (var i = 0; i < pageContainer.items.length; i++) {
                if (pageContainer.items[i].itemObject.name == subReportPage) {
                    pageContainer.items[i].selected();
                    break;
                }
            }
        }

        //Fill Parameters
        var parameters = selectedObject.properties.subReportParameters;
        paramsCont.clear();

        for (var i = 0; i < parameters.length; i++) {
            var item = paramsCont.addItem(parameters[i].name, false, { name: parameters[i].name, expression: parameters[i].expression });
            if (i == 0) item.action();
        }

        this.updateMarkers();
        this.markerTimer = setInterval(function () {
            subReportForm.updateMarkers();
        }, 250);
    }

    subReportForm.action = function () {
        var selectedObjects = this.jsObject.options.selectedObjects || [this.jsObject.options.selectedObject];
        if (!selectedObjects) return;
        for (var i = 0; i < selectedObjects.length; i++) {
            var selectedObject = selectedObjects[i];

            switch (subReportForm.mode) {
                case "SubReportUrl":
                    {
                        selectedObject.properties.subReportUrl = StiBase64.encode(urlControl.textBox.value);
                        selectedObject.properties.subReportPage = "[Not Assigned]";
                        break;
                    }
                case "SubReportFile":
                    {
                        selectedObject.properties.subReportUrl = StiBase64.encode("file://" + fileNameTextBox.textBox.value);
                        selectedObject.properties.subReportPage = "[Not Assigned]";
                        break;
                    }
                case "SubReportPage":
                    {
                        selectedObject.properties.subReportPage = pageContainer.selectedItem ? pageContainer.selectedItem.itemObject.name : "[Not Assigned]";
                        selectedObject.properties.subReportUrl = "";
                        break;
                    }
                case "SubReportServer":
                    {
                        if (subReportForm.cloudContainer && subReportForm.cloudContainer.item && this.jsObject.options.cloudServerUrl)
                            selectedObject.properties.subReportUrl = StiBase64.encode(this.jsObject.options.cloudServerUrl + subReportForm.cloudContainer.item.itemObject.key);
                        break;
                    }
            }
        }

        var parameters = [];
        for (var i = 0; i < paramsCont.childNodes.length; i++) {
            if (paramsCont.childNodes[i].itemObject) {
                parameters.push(paramsCont.childNodes[i].itemObject);
            }
        }
        selectedObject.properties.subReportParameters = parameters;

        subReportForm.jsObject.SendCommandSendProperties(selectedObjects, ["subReportPage", "subReportUrl", "subReportParameters"]);
        this.changeVisibleState(false);
    }

    return subReportForm;
}