﻿
StiMobileDesigner.prototype.InitializePostgreSqlConnectionForm_ = function () {
    var jsObject = this;
    var form = this.BaseForm("postgreSqlConnectionForm", this.loc.Database.DatabasePostgreSQL, 4);
    form.controls = {}

    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "6px 0 6px 0";
    form.container.appendChild(innerTable);

    var controlProps = [
        ["server", "Server", this.TextBox(null, 250)],
        ["database", this.loc.QueryBuilder.Database, this.TextBox(null, 250)],
        ["port", this.loc.Cloud.Port, this.TextBoxPositiveIntValue(null, 250, 1, 65535)],
        ["userName", this.loc.Report.LabelUserName.replace(":", ""), this.TextBox(null, 250)],
        ["password", this.loc.Cloud.labelPassword.replace(":", ""), this.TextBox(null, 250)]
    ]

    for (var i = 0; i < controlProps.length; i++) {
        innerTable.addRow();
        innerTable.addTextCellInLastRow(controlProps[i][1]).className = "stiDesignerCaptionControlsBigIntervals";
        var control = controlProps[i][2];
        form.controls[controlProps[i][0]] = control;
        innerTable.addCellInLastRow(control).className = "stiDesignerControlCellsBigIntervals2";
    }

    form.controls.password.setAttribute("type", "password");

    form.getConnectionString = function () {
        var conStr = "Server=" + form.controls.server.value + ";Database=" + form.controls.database.value + ";User Id=" + form.controls.userName.value + ";Password=" + form.controls.password.value;
        if (form.controls.port.value != "") conStr += ";Port=" + form.controls.port.value;
        return conStr;
    }

    form.getConnectionStringKey = function (key, connectionString) {
        return jsObject.getConnectionStringKey(key, connectionString);
    }

    form.show = function (connection) {
        this.controls.server.value = form.getConnectionStringKey("Server", connection) || "";
        this.controls.database.value = form.getConnectionStringKey("Database", connection) || "";
        this.controls.port.value = form.getConnectionStringKey("Port", connection) || "";
        this.controls.userName.value = form.getConnectionStringKey("User Id", connection) || "";
        this.controls.password.value = form.getConnectionStringKey("Password", connection) || "";
        this.changeVisibleState(true);
    }

    form.action = function () {
        this.changeVisibleState(false);
    }

    return form;
}