﻿
StiMobileDesigner.prototype.InitializeMSAccessConnectionForm_ = function () {
    var jsObject = this;
    var form = this.BaseForm("msAccessConnectionForm", this.loc.Database.Database.replace("{0}", "MS Access"), 4);
    form.controls = {}

    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "6px 0 6px 0";
    form.container.appendChild(innerTable);

    var ace12ProviderName = "Microsoft.ACE.OLEDB.12.0";
    var jet4ProviderName = "Microsoft.Jet.OLEDB.4.0";

    var providerTable = this.CreateHTMLTable();
    var msOffice2007 = form.controls.msOffice2007 = this.RadioButton("msOffice2007", "oleDBAdapter", "MS Office 2007");
    var msOffice2003 = form.controls.msOffice2003 = this.RadioButton("msOffice2003", "oleDBAdapter", "MS Office 2000-2003");
    msOffice2007.style.margin = msOffice2003.style.margin = "6px 0 6px 0";

    providerTable.addCell(msOffice2007);
    providerTable.addCellInNextRow(msOffice2003);

    var controlProps = [
        ["providerTable", "OLEDB Adapter", providerTable],
        ["database", "Database Name (Data Path)", this.TextBox(null, 250)],
        ["userName", this.loc.Report.LabelUserName.replace(":", ""), this.TextBox(null, 250)],
        ["password", this.loc.Cloud.labelPassword.replace(":", ""), this.TextBox(null, 250)]
    ]

    for (var i = 0; i < controlProps.length; i++) {
        innerTable.addRow();
        innerTable.addTextCellInLastRow(controlProps[i][1]).className = "stiDesignerCaptionControlsBigIntervals";
        var control = controlProps[i][2];
        form.controls[controlProps[i][0]] = control;
        innerTable.addCellInLastRow(control).className = "stiDesignerControlCellsBigIntervals2";
    }

    form.controls.password.setAttribute("type", "password");

    form.getConnectionString = function () {
        return ("Provider=" + (this.controls.msOffice2007.isChecked ? ace12ProviderName : jet4ProviderName) + ";Data Source=" + form.controls.database.value + ";User ID=" + form.controls.userName.value + ";Password=" + form.controls.password.value);
    }

    form.getConnectionStringKey = function (key, connectionString) {
        return jsObject.getConnectionStringKey(key, connectionString);
    }

    form.show = function (connection) {
        var provider = form.getConnectionStringKey("Provider", connection) || "";
        this.controls.msOffice2007.setChecked(provider != jet4ProviderName);
        this.controls.msOffice2003.setChecked(provider == jet4ProviderName);
        this.controls.database.value = form.getConnectionStringKey("Data Source", connection) || "";
        this.controls.userName.value = form.getConnectionStringKey("User ID", connection) || "";
        this.controls.password.value = form.getConnectionStringKey("Password", connection) || "";
        this.changeVisibleState(true);
    }

    form.action = function () {
        this.changeVisibleState(false);
    }

    return form;
}