﻿
StiMobileDesigner.prototype.InitializeEventEditorForm_ = function () {
    var jsObject = this;
    var form = this.InitializeBaseExpressionEditorForm("eventEditor", this.loc.FormTitles.EventEditorForm, 3, this.GetHelpLink("expression"));
            
    var switchButton = this.FormButton(null, null, this.loc.Buttons.SwitchTo.replace("{0}", "Blockly"), null);
    switchButton.style.display = this.options.blocklyNotSupported ? "none" : "inline-block";
    switchButton.style.margin = "12px";

    switchButton.action = function () {
        var messageForm = jsObject.MessageFormForSwitchingEventMode();
        messageForm.changeVisibleState(true);

        messageForm.action = function (state) {
            if (state) {
                if (form.resultControl) {
                    var eventScript = form.expressionTextArea.value;
                    var resultTextBox = form.resultControl.textBox || form.resultControl;
                    resultTextBox.value = resultTextBox.hiddenValue = "";

                    var showBlocklyForm = function () {
                        jsObject.InitializeBlocklyEditorForm(function (blocklyForm) {
                            blocklyForm.resultControl = form.resultControl;
                            blocklyForm.show("", form.resultControl.eventName, null, eventScript);
                        });
                    }
                    if (!jsObject.options.blocklyInitialized && !jsObject.options.jsMode) {
                        jsObject.LoadScriptWithProcessImage(jsObject.options.scriptsUrl + "BlocklyScripts;" + (jsObject.options.cultureName || "en"), function () {
                            jsObject.options.blocklyInitialized = true;
                            showBlocklyForm();
                        });
                    }
                    else {
                        showBlocklyForm();
                    }
                }
                form.changeVisibleState(false);
            }
            else {
                messageForm.changeVisibleState(false);
            }
        }
    }

    //AI Converter
    var convertingPanel = document.createElement("div");
    convertingPanel.className = "stiSimpleContainerWithBorder";
    convertingPanel.style.margin = "12px";
    var convertingTable = this.CreateHTMLTable();
    convertingPanel.appendChild(convertingTable);
    convertingTable.style.width = "100%";    
    
    var textCell = convertingTable.addTextCell(this.loc.StimulAI.TryConvertScriptToBlockly.replace("{0}", "Blockly").replace("{1}", "C#"));
    textCell.className = "stiDataTransformHintBlock";
    textCell.style.padding = "12px";

    var tryStimulAIButton = this.FormButton(null, null, this.loc.StimulAI.Try, null);
    tryStimulAIButton.style.margin = "12px";
    tryStimulAIButton.style.display = "inline-block";
    convertingTable.addCell(tryStimulAIButton).style.width = "1px";
    form.container.appendChild(convertingPanel);

    tryStimulAIButton.action = function () {
        convertingPanel.style.display = "none";

        jsObject.InitializeStimulAIForm(function (stimulAIForm) {
            stimulAIForm.show(form, form.expressionTextArea, function () {
                stimulAIForm.sendButtonAction("ConvertBlocklyToEventScript");
            });
        });
    }

    var stimulAIButton = this.FormButton(null, null, this.loc.StimulAI.CheckWithStimulAI, null);    
    stimulAIButton.style.margin = "12px 0 12px 12px";

    stimulAIButton.action = function () {
        jsObject.InitializeStimulAIForm(function (stimulAIForm) {
            stimulAIForm.show(form, form.expressionTextArea, function () {
                stimulAIForm.sendButtonAction("CheckEventScript");
            });
        });
    }

    var footerTable = this.CreateHTMLTable();
    footerTable.style.width = "100%";

    var buttonsPanel = form.buttonsPanel;
    form.removeChild(buttonsPanel);
    form.appendChild(footerTable);

    footerTable.addCell(stimulAIButton).style.width = "1px";
    footerTable.addCell(switchButton).style.textAlign = "left";
    footerTable.addCell();
    footerTable.addCell(form.buttonOk).style.width = "1px";
    footerTable.addCell(form.buttonCancel).style.width = "1px";

    form.getDataForAI = function () {
        var params = {
            commandName: "eventScript",
            expression: StiBase64.encode(form.expressionTextArea.value)
        }
        if (form.blocklyXmlText) {
            params.blocklyXmlText = StiBase64.encode(form.blocklyXmlText);
        }
        return params;
    }

    form.show = function (blocklyXmlText) {
        this.blocklyXmlText = blocklyXmlText;
        convertingPanel.style.display = jsObject.options.showStimulAI && blocklyXmlText ? "" : "none";
        stimulAIButton.style.display = jsObject.options.showStimulAI ? "inline-block" : "none";
        this.changeVisibleState(true);
        jsObject.AddHintHelperToControl(form.expressionTextArea, 40, false, true, ["Variable = 0", "Variable = Expression"], jsObject.loc.Cloud.ForExample);
    }

    return form;
}