﻿
StiMobileDesigner.prototype.InitializeEditVariableForm_ = function () {

    //Edit Variable Form
    var editVariableForm = this.BaseForm("editVariableForm", this.loc.FormDictionaryDesigner.VariableNew, 2, this.GetHelpLink("variableEdit"));
    editVariableForm.variable = null;
    editVariableForm.mode = "Edit";
    editVariableForm.controls = {};
    var jsObject = this;

    var saveCopyButton = this.FormButton(null, null, this.loc.Buttons.SaveCopy, null);
    saveCopyButton.style.display = "inline-block";
    saveCopyButton.style.margin = "12px";

    saveCopyButton.action = function () {
        if (!editVariableForm.controls.name.checkExists(jsObject.GetVariablesFromDictionary(jsObject.options.report.dictionary), "name")) {
            if (editVariableForm.controls.name.value == editVariableForm.controls.alias.value) {
                editVariableForm.controls.alias.value += "Copy";
            }
            editVariableForm.controls.name.value += "Copy";

            var resultName = editVariableForm.controls.name.value;
            var i = 2;
            while (!editVariableForm.controls.name.checkExists(jsObject.GetVariablesFromDictionary(jsObject.options.report.dictionary), "name")) {
                editVariableForm.controls.name.value = editVariableForm.controls.alias.value = resultName + i;
                i++;
            }
        }

        editVariableForm.mode = "New";
        editVariableForm.action();
    }

    var footerTable = this.CreateHTMLTable();
    footerTable.style.width = "100%";
    var buttonsPanel = editVariableForm.buttonsPanel;
    editVariableForm.removeChild(buttonsPanel);
    editVariableForm.appendChild(footerTable);
    footerTable.addCell(saveCopyButton).style.textAlign = "left";
    footerTable.addCell();
    footerTable.addCell(editVariableForm.buttonOk).style.width = "1px";
    footerTable.addCell(editVariableForm.buttonCancel).style.width = "1px";

    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "5px 0 5px 0";
    editVariableForm.container.appendChild(innerTable);

    //Name, Alias, Description
    var textBoxes = [
        ["name", this.loc.PropertyMain.Name, 180],
        ["alias", this.loc.PropertyMain.Alias, 180],
        ["description", this.loc.PropertyMain.Description, 325]
    ]
    for (var i = 0; i < textBoxes.length; i++) {
        var text = innerTable.addCellInNextRow();
        text.className = "stiDesignerCaptionControlsBigIntervals";
        text.innerHTML = textBoxes[i][1];
        text.style.minWidth = "140px";
        editVariableForm.controls[textBoxes[i][0]] = this.TextBox("editVariableForm" + textBoxes[i][0], textBoxes[i][2]);
        innerTable.addCellInLastRow(editVariableForm.controls[textBoxes[i][0]]).className = "stiDesignerControlCellsBigIntervals2";
    }

    //Type
    var textType = innerTable.addCellInNextRow();
    textType.className = "stiDesignerCaptionControlsBigIntervals";
    textType.innerHTML = this.loc.PropertyMain.Type;
    var typeControlsTable = this.CreateHTMLTable();
    innerTable.addCellInLastRow(typeControlsTable).className = "stiDesignerControlCellsBigIntervals2";
    editVariableForm.controls.type = this.DropDownList("editVariableFormTypeControl", 185, null, this.GetVariableTypesItems(), true, true, null, null, { width: 16, height: 16 });

    //Override
    editVariableForm.controls.type.image.style.width = "16px";
    editVariableForm.controls.type.image.style.margin = "0 8px 0 8px";
    typeControlsTable.addCell(editVariableForm.controls.type).style.padding = "0 12px 0 0";
    editVariableForm.controls.basicType = this.DropDownList("editVariableFormBasicTypeControl", 129, null, this.GetVariableBasicTypesItems(), true);
    typeControlsTable.addCell(editVariableForm.controls.basicType).style.padding = "0 12px 0 0";
    var separator1 = this.Separator();
    innerTable.addCellInNextRow(separator1).setAttribute("colspan", "2");
    separator1.style.margin = "12px 0 12px 0";

    //InitBy && Values
    var controlProps = [
        ["initBy", this.loc.PropertyMain.InitBy, 180, "DropDownList", this.GetFilterFieldIsItems()],
        ["value", this.loc.PropertyMain.Value, 180, "TextAreaWithEditButton", this.options.isTouchDevice ? 28 : 24, false],
        ["valueFrom", this.loc.PropertyMain.RangeFrom, 325, "TextAreaWithEditButton", this.options.isTouchDevice ? 28 : 24, false],
        ["valueTo", this.loc.PropertyMain.RangeTo, 325, "TextAreaWithEditButton", this.options.isTouchDevice ? 28 : 24, false],
        ["expression", this.loc.PropertyEnum.StiFilterItemExpression, 325, "ExpressionTextArea", null, true],
        ["expressionFrom", this.loc.PropertyMain.RangeFrom, 325, "ExpressionTextArea", null, true],
        ["expressionTo", this.loc.PropertyMain.RangeTo, 325, "ExpressionTextArea", null, true],
        ["valueDateTime", this.loc.PropertyMain.Value, 180, "DateControlWithCheckBox", null],
        ["valueDateTimeFrom", this.loc.PropertyMain.RangeFrom, 180, "DateControlWithCheckBox", null],
        ["valueDateTimeTo", this.loc.PropertyMain.RangeTo, 180, "DateControlWithCheckBox", null],
        ["valueBool", this.loc.PropertyMain.Value, 180, "CheckBox", null],
        ["valueImage", this.loc.PropertyMain.Image, 328, "ImageControl", null],
        ["separatorInitBy"],
        ["readOnly", "", null, "CheckBox", this.loc.PropertyMain.ReadOnly],
        ["allowUseAsSqlParameter", "", null, "CheckBox", this.loc.PropertyMain.AllowUsingAsSqlParameter],
        ["requestFromUser", "", null, "CheckBox", this.loc.Report.ShowOnParametersPanel],
        ["rememberSelection", "", null, "CheckBox", this.loc.PropertyMain.RememberSelection],
        ["allowUserValues", "", null, "CheckBox", this.loc.PropertyMain.AllowUserValues],
        ["items", this.loc.PropertyMain.Items, 306, "ItemsControl", this.options.isTouchDevice ? 21 : 17, true],
        ["formatMask", this.loc.FormFormatEditor.FormatMask.replace(":", ""), 325, "TextBox", null],
        ["dateTimeFormat", this.loc.FormFormatEditor.DateTimeFormat, 180, "DropDownList", this.GetVariableDateTimeTypesItems()],
    ]

    for (var i = 0; i < controlProps.length; i++) {
        editVariableForm.controls[controlProps[i][0] + "Row"] = innerTable.addRow();

        if (controlProps[i][0].indexOf("separator") == 0) {
            var separator = this.Separator();
            innerTable.addCellInLastRow(separator).setAttribute("colspan", "2");
            separator.style.margin = "12px 0 12px 0";
        }
        else {
            var textControl = innerTable.addCellInLastRow();
            textControl.className = "stiDesignerCaptionControlsBigIntervals";
            textControl.innerHTML = controlProps[i][1];
            var control;
            if (controlProps[i][3] == "DropDownList") control = this.DropDownList("editVariableForm" + controlProps[i][0], controlProps[i][2], null, controlProps[i][4], true);
            else if (controlProps[i][3] == "ExpressionTextArea") control = this.ExpressionTextArea("editVariableForm" + controlProps[i][0], controlProps[i][2], this.options.isTouchDevice ? 28 : 24, true, controlProps[i][5], false, null, ["DataSource.Field + 1", "Variable1 + Variable2", "ParseDouble(Variable2)", "\"My Str\"", "123"], null, 40, true);
            else if (controlProps[i][3] == "DataControl") control = this.DataControl("editVariableForm" + controlProps[i][0], controlProps[i][2]);
            else if (controlProps[i][3] == "TextBox") control = this.TextBox("editVariableForm" + controlProps[i][0], controlProps[i][2]);
            else if (controlProps[i][3] == "DateControlWithCheckBox") control = this.DateControlWithCheckBox("editVariableForm" + controlProps[i][0], controlProps[i][2]);
            else if (controlProps[i][3] == "CheckBox") control = this.CheckBox("editVariableForm" + controlProps[i][0], controlProps[i][4]);
            else if (controlProps[i][3] == "TextAreaWithEditButton") control = this.TextAreaWithEditButton("editVariableForm" + controlProps[i][0], controlProps[i][2], controlProps[i][4], controlProps[i][5], true, true, ["123", "MyText", "True", "567f", "456.23d", "10.5M", "Test String", "A"], 40);
            else if (controlProps[i][3] == "ImageControl") control = this.ImageControl(null, controlProps[i][2], 80);
            else if (controlProps[i][3] == "ItemsControl") control = this.ExpressionTextArea(null, controlProps[i][2], controlProps[i][4], true);

            control.editVariableForm = editVariableForm;
            editVariableForm.controls[controlProps[i][0]] = control;
            var controlCell = innerTable.addCellInLastRow(control);
            controlCell.className = "stiDesignerControlCellsBigIntervals2"
            controlCell.style.lineHeight = "0";
            if (controlProps[i][3] == "CheckBox") controlCell.style.padding = "7px 12px 7px 0";
        }
    }

    var itemsControl = editVariableForm.controls.items;
    itemsControl.className = "stiDesignerTextArea stiDesignerTextAreaDefault";
    itemsControl.style.padding = "0";
    itemsControl.style.display = "inline-block";
    itemsControl.style.position = "relative";

    var itemsContainer = itemsControl.container = document.createElement("div");
    itemsContainer.style.margin = "4px 50px 4px 4px";
    itemsContainer.style.width = "274px";
    itemsContainer.style.height = "60px";
    itemsContainer.style.overflow = "hidden";

    var itemsParent = itemsControl.textArea.parentElement;
    itemsParent.removeChild(itemsControl.textArea);
    itemsParent.appendChild(itemsContainer);

    var itemsEditButton = itemsControl.button = itemsControl.textArea.insertButton;
    itemsEditButton.style.width = "auto";
    itemsEditButton.style.margin = "0";
    itemsEditButton.style.top = "4px";
    itemsEditButton.style.right = "4px";
    itemsEditButton.imageCell.innerHTML = jsObject.loc.MainMenu.menuEditEdit;
    itemsEditButton.imageCell.style.padding = "0 10px 0 10px";
    itemsEditButton.imageCell.style.fontSize = "inherit";
    itemsEditButton.style.height = "24px";

    itemsControl.showValues = function (valuesTable) {
        itemsContainer.innerHTML = "";
        itemsContainer.appendChild(valuesTable);
    }

    var initByTable = this.CreateHTMLTable();
    editVariableForm.controls.initBy.parentElement.appendChild(initByTable);
    initByTable.addCell(editVariableForm.controls.initBy);
    initByTable.addCell(editVariableForm.controls.readOnly);
    editVariableForm.controls.readOnly.style.marginLeft = "11px";
    editVariableForm.controls.readOnlyRow.style.display = "none";

    var valueNotAssign = editVariableForm.controls.valueNotAssign = this.CheckBox(null, this.loc.Report.NotAssigned);
    var valueTable = this.CreateHTMLTable();
    editVariableForm.controls.value.parentElement.appendChild(valueTable);
    valueTable.addCell(editVariableForm.controls.value);
    valueTable.addCell(valueNotAssign);
    valueNotAssign.style.marginLeft = "11px";

    valueNotAssign.action = function () {
        if (this.isChecked && editVariableForm.controls.basicType.key != "NullableValue") {
            editVariableForm.controls.basicType.setKey("NullableValue");
            editVariableForm.controls.basicType.action();
        }
        editVariableForm.controls.value.setEnabled(!this.isChecked);
    }

    var valueBoolNotAssign = editVariableForm.controls.valueBoolNotAssign = this.CheckBox(null, this.loc.Report.NotAssigned);
    var valueBoolTable = this.CreateHTMLTable();
    editVariableForm.controls.valueBool.parentElement.appendChild(valueBoolTable);
    valueBoolTable.addCell(editVariableForm.controls.valueBool);
    valueBoolTable.addCell(valueBoolNotAssign);
    valueBoolNotAssign.style.marginLeft = "11px";

    valueBoolNotAssign.action = function () {
        if (this.isChecked && editVariableForm.controls.basicType.key != "NullableValue") {
            editVariableForm.controls.basicType.setKey("NullableValue");
            editVariableForm.controls.basicType.action();
        }
        editVariableForm.controls.valueBool.setEnabled(!this.isChecked);
    }

    editVariableForm.controls.valueDateTime.checkBox.style.marginLeft = editVariableForm.controls.valueDateTimeFrom.checkBox.style.marginLeft = editVariableForm.controls.valueDateTimeTo.checkBox.style.marginLeft = "11px";

    editVariableForm.controls.value.textArea.setAttribute("placeholder", "123, MyText, True");
    editVariableForm.controls.valueFrom.textArea.setAttribute("placeholder", "123, MyText, True");
    editVariableForm.controls.valueTo.textArea.setAttribute("placeholder", "123, MyText, True");
    editVariableForm.controls.expression.textArea.setAttribute("placeholder", "DataSource.Field + 1, Variable1 + Variable2");
    editVariableForm.controls.expressionFrom.textArea.setAttribute("placeholder", "DataSource.Field + 1, Variable1 + Variable2");
    editVariableForm.controls.expressionTo.textArea.setAttribute("placeholder", "DataSource.Field + 1, Variable1 + Variable2");

    var formatMaskSamples = this.CreateHTMLTable();
    formatMaskSamples.style.fontSize = "10px";
    editVariableForm.controls.formatMask.parentElement.appendChild(formatMaskSamples);

    var samples = [
        ["Numeric", jsObject.loc.PropertyEnum.StiFilterDataTypeNumeric],
        ["ZipCode", jsObject.loc.Components.StiZipCode],
        ["SSN", "SSN"],
        ["Currency", jsObject.loc.FormFormatEditor.Currency]
    ]

    for (var i = 0; i < samples.length; i++) {
        var button = jsObject.SmallButton(null, null, samples[i][1], null, null, null, "stiDesignerSmallTextButton");
        button.key = samples[i][0];        
        if (i == 0) button.caption.style.padding = "0 10px 0 0";
        if (i != 0) formatMaskSamples.addTextCell(" | ");
        formatMaskSamples.addCell(button);

        button.action = function () {
            var formatMaskControl = editVariableForm.controls.formatMask;
            switch (this.key) {
                case "Numeric": formatMaskControl.value = "00000"; break;
                case "ZipCode": formatMaskControl.value = "00000-9999"; break;
                case "SSN": formatMaskControl.value = "000-00-0000"; break;
                case "Currency": formatMaskControl.value = "$999,999.00"; break;
            }
        }
    }

    editVariableForm.typeNotCompatibleWithNullableValue = function (type) {
        return type == "image";
    }

    editVariableForm.typeNotCompatibleWithList = function (type) {
        return (type == "sbyte" || type == "ushort" || type == "uint" || type == "ulong" || type == "object" || type == "image" || type == "byte[]" || type == "datetimeoffset" || type == "dateonly" || type == "timeonly");
    }

    editVariableForm.typeNotCompatibleWithRange = function (type) {
        return (this.typeNotCompatibleWithList(type) || type == "bool");
    }

    editVariableForm.typeAndBasicTypeConflicted = function () {
        var basicType = this.variable.basicType;
        var type = this.variable.type;

        if (basicType == "List" && this.typeNotCompatibleWithList(type) ||
            basicType == "Range" && this.typeNotCompatibleWithRange(type) ||
            basicType == "NullableValue" && this.typeNotCompatibleWithNullableValue(type))
            return true;

        return false;
    }

    editVariableForm.changeConflictedControls = function (currPropName, conflictedPropName, currentKey) {
        if (this.variable[currPropName] != currentKey && (currPropName == "type" || (currPropName == "basicType" && (this.variable[currPropName] == "Range" || currentKey == "Range")))) {
            this.clearItems();
        }

        this.variable[currPropName] = currentKey;

        if (this.typeAndBasicTypeConflicted()) {
            var key = conflictedPropName == "type" ? "string" : "Value";
            this.controls[conflictedPropName].setKey(key);
            this.variable[conflictedPropName] = key;
        }

        this.showControlsByType();
    }

    var controlNames = ["initBy", "readOnly", "requestFromUser", "allowUserValues"];
    for (var i = 0; i < controlNames.length; i++) {
        editVariableForm.controls[controlNames[i]].action = function () {
            editVariableForm.showControlsByType();
        }
    }

    editVariableForm.controls.items.button.action = function () {
        jsObject.InitializeVariableItemsForm(function (variableItemsForm) {
            variableItemsForm.show(editVariableForm);
        });
    }

    editVariableForm.controls.valueDateTime.checkBox.action = function () {
        this.parentControl.dateControl.setEnabled(!this.isChecked);
        if (this.isChecked) {
            editVariableForm.controls.basicType.setKey("NullableValue");
            editVariableForm.controls.basicType.action();
        }
    }

    editVariableForm.controls.type.action = function () {
        editVariableForm.changeConflictedControls("type", "basicType", this.key);
    }

    editVariableForm.controls.basicType.action = function () {
        editVariableForm.changeConflictedControls("basicType", "type", this.key);

        if (this.key == "Value") {
            editVariableForm.controls.valueNotAssign.setChecked(false);
            editVariableForm.controls.valueNotAssign.action();
            editVariableForm.controls.valueBoolNotAssign.setChecked(false);
            editVariableForm.controls.valueBoolNotAssign.action();
            editVariableForm.controls.valueDateTime.checkBox.setChecked(false);
            editVariableForm.controls.valueDateTime.checkBox.action();
        }
    }

    editVariableForm.updateDateTimeControls = function () {
        var controls = editVariableForm.controls;
        var dateTimeFormat = editVariableForm.controls.dateTimeFormat.key;
        controls.valueDateTime.dateTimeFormat = controls.valueDateTimeFrom.dateTimeFormat = controls.valueDateTimeTo.dateTimeFormat = dateTimeFormat;
        controls.valueDateTime.dateControl.shortFormat = controls.valueDateTimeFrom.dateControl.shortFormat = controls.valueDateTimeTo.dateControl.shortFormat = dateTimeFormat == "Date";
        controls.valueDateTime.setKey(editVariableForm.controls.valueDateTime.key);
        controls.valueDateTimeFrom.setKey(editVariableForm.controls.valueDateTimeFrom.key);
        controls.valueDateTimeTo.setKey(editVariableForm.controls.valueDateTimeTo.key);
    }

    editVariableForm.controls.dateTimeFormat.action = function () {
        editVariableForm.controls.items.showValues(this.getItemsValuesTable());
        editVariableForm.updateDateTimeControls();
    }

    editVariableForm.controls.name.action = function () {
        if (this.oldValue == editVariableForm.controls.alias.value) {
            editVariableForm.controls.alias.value = this.value;
        }
    }

    editVariableForm.clearItems = function () {
        this.variable.items = null;
        this.controls.items.showValues(this.getItemsValuesTable());
    }

    editVariableForm.showControlsByType = function () {
        var type = this.controls.type.key;
        var basicType = this.controls.basicType.key;
        var initBy = this.controls.initBy.key;
        var isValueBasicType = basicType != "Range" && basicType != "List";
        var showValues = this.variable.selection != "Nothing" && this.variable.selection != "First";
        var showInitBy = type != "image" && basicType != "List" && showValues;
        var arrayType = type == "byte[]" || type == "object" || type == "image";
        var isTextType = type == "text";
        var enabledRequestFromUserCheckBox = !this.controls.readOnly.isChecked && !arrayType;
        var showRequestFromUserControls = this.controls.requestFromUser.isChecked && enabledRequestFromUserCheckBox;

        if (!showInitBy) this.controls.readOnly.setChecked(false);
        if (!enabledRequestFromUserCheckBox) this.controls.requestFromUser.setChecked(false);

        this.controls.basicType.style.display = (type != "byte[]" && type != "object" && type != "image") ? "" : "none";
        this.controls.valueBoolRow.style.display = (type == "bool" && isValueBasicType && initBy == "Value" && showValues) ? "" : "none";
        this.controls.valueImageRow.style.display = (type == "image" && isValueBasicType && showValues) ? "" : "none";
        this.controls.valueRow.style.display = (type != "datetime" && type != "datetimeoffset" && type != "bool" && type != "image" && isValueBasicType && initBy == "Value" && showValues) ? "" : "none";
        this.controls.valueFromRow.style.display = (type != "datetime" && type != "datetimeoffset" && basicType == "Range" && initBy == "Value") ? "" : "none";
        this.controls.valueToRow.style.display = (type != "datetime" && type != "datetimeoffset" && basicType == "Range" && initBy == "Value") ? "" : "none";
        this.controls.expressionRow.style.display = (type != "image" && isValueBasicType && initBy == "Expression" && showValues) ? "" : "none";
        this.controls.expressionFromRow.style.display = (basicType == "Range" && initBy == "Expression") ? "" : "none";
        this.controls.expressionToRow.style.display = (basicType == "Range" && initBy == "Expression") ? "" : "none";
        this.controls.valueDateTimeRow.style.display = ((type == "datetime" || type == "datetimeoffset") && isValueBasicType && initBy == "Value") ? "" : "none";
        this.controls.valueDateTimeFromRow.style.display = (type == "datetime" && basicType == "Range" && initBy == "Value") ? "" : "none";
        this.controls.valueDateTimeToRow.style.display = (type == "datetime" && basicType == "Range" && initBy == "Value") ? "" : "none";
        this.controls.initByRow.style.display = showInitBy ? "" : "none";
        this.controls.separatorInitByRow.style.display = showInitBy ? "" : "none";
        this.controls.requestFromUser.setEnabled(enabledRequestFromUserCheckBox);
        this.controls.allowUserValuesRow.style.display = showRequestFromUserControls && !isTextType ? "" : "none";
        this.controls.rememberSelectionRow.style.display = showRequestFromUserControls && (basicType == "Range" || basicType == "Value") ? "" : "none";
        this.controls.requestFromUserRow.style.display = !arrayType ? "" : "none";
        this.controls.allowUseAsSqlParameterRow.style.display = !arrayType ? "" : "none";

        if (basicType == "Range" || basicType == "List") {
            editVariableForm.controls.allowUseAsSqlParameter.setChecked(false);
        }
        editVariableForm.controls.allowUseAsSqlParameter.setEnabled(basicType != "Range" && basicType != "List");

        this.controls.itemsRow.style.display = showRequestFromUserControls && !isTextType ? "" : "none";
        this.controls.formatMaskRow.style.display = (showRequestFromUserControls && type == "string") ? "" : "none";
        this.controls.dateTimeFormatRow.style.display = (showRequestFromUserControls && (type == "datetime" || type == "datetimeoffset")) ? "" : "none";

        var basicTypeItems = this.controls.basicType.menu.items;
        basicTypeItems.nullablevalue.style.display = this.typeNotCompatibleWithNullableValue(type) ? "none" : "";
        basicTypeItems.list.style.display = this.typeNotCompatibleWithList(type) ? "none" : "";
        basicTypeItems.range.style.display = this.typeNotCompatibleWithRange(type) ? "none" : "";

        if (basicType == "NullableValue" && basicTypeItems.nullablevalue.style.display == "none" ||
            basicType == "List" && basicTypeItems.list.style.display == "none" ||
            basicType == "Range" && basicTypeItems.range.style.display == "none") {
            this.controls.basicType.setKey("Value");
            this.controls.basicType.action();
        }

        this.correctHeight();
    }

    editVariableForm.resetControls = function () {
        for (var i = 0; i < controlProps.length; i++) {
            if (editVariableForm.controls[controlProps[i][0]]) {
                if (editVariableForm.controls[controlProps[i][0]].value != null)
                    editVariableForm.controls[controlProps[i][0]].value = ""
                else if (editVariableForm.controls[controlProps[i][0]].textBox != null)
                    editVariableForm.controls[controlProps[i][0]].textBox.value = "";
            }
        }
        this.controls.valueDateTime.setChecked(false);
        this.controls.valueDateTimeFrom.setChecked(false);
        this.controls.valueDateTimeTo.setChecked(false);
        this.controls.valueDateTime.setKey(new Date());
        this.controls.valueDateTimeFrom.setKey(new Date());
        this.controls.valueDateTimeTo.setKey(new Date());
        this.controls.expressionFrom.setValue("");
        this.controls.expression.setValue("");
        this.controls.expressionFrom.setValue("");
        this.controls.expressionTo.setValue("");
        this.controls.value.setValue("");
        this.controls.valueFrom.setValue("");
        this.controls.valueTo.setValue("");
    }

    editVariableForm.onshow = function () {
        this.resetControls();
        this.mode = "Edit";
        if (this.variable == null) {
            this.variable = jsObject.VariableObject();
            this.mode = "New";
        }
        saveCopyButton.style.visibility = this.mode == "Edit" ? "visible" : "hidden";
        this.editableDictionaryItem = this.mode == "Edit" && jsObject.options.dictionaryTree
            ? jsObject.options.dictionaryTree.selectedItem : null;
        var caption = jsObject.loc.FormDictionaryDesigner["Variable" + this.mode];
        this.caption.innerHTML = caption;
        this.controls.name.hideError();
        this.controls.name.focus();
        this.controls.name.value = this.variable.name;
        this.controls.alias.value = this.variable.alias;
        this.controls.description.value = StiBase64.decode(this.variable.description);
        this.controls.type.setKey(this.variable.type);
        this.controls.basicType.setKey(this.variable.allowNullableString ? "NullableValue" : this.variable.basicType);
        this.controls.initBy.setKey(this.variable.initBy);
        this.controls.readOnly.setChecked(this.variable.readOnly);
        this.controls.allowUseAsSqlParameter.setChecked(this.variable.allowUseAsSqlParameter);
        this.controls.requestFromUser.setChecked(this.variable.requestFromUser);
        this.controls.allowUserValues.setChecked(this.variable.allowUserValues);
        this.controls.rememberSelection.setChecked(this.variable.rememberSelection);
        this.controls.dateTimeFormat.setKey(this.variable.requestFromUser ? this.variable.dateTimeFormat : "DateAndTime");
        this.controls.formatMask.value = StiBase64.decode(this.variable.formatMask);
        this.controls.items.showValues(this.getItemsValuesTable());
        this.controls.valueImage.setImage(null);        

        switch (this.variable.basicType) {
            case "Value":
            case "NullableValue":
                {
                    if (this.variable.initBy == "Value") {
                        if (this.variable.type == "image") {
                            this.controls.valueImage.setImage(this.variable.value);
                        }
                        else {
                            var variableValue = this.variable.value != null ? StiBase64.decode(this.variable.value) : null;

                            if (this.variable.type == "bool") {
                                if (variableValue == null) {
                                    this.controls.valueBoolNotAssign.setChecked(true);
                                    this.controls.valueBool.setEnabled(false);
                                }
                                else {
                                    this.controls.valueBoolNotAssign.setChecked(false);
                                    this.controls.valueBool.setEnabled(true);
                                    this.controls.valueBool.setChecked(variableValue == "true" || variableValue == "True");
                                }
                            }
                            else {
                                if (this.variable.type == "datetime" || this.variable.type == "datetimeoffset") {
                                    if (variableValue == null) {
                                        this.controls.valueDateTime.setChecked(true);
                                    }
                                    else {
                                        if (this.variable.type == "datetimeoffset" && variableValue.indexOf("+") > 0)
                                            variableValue = variableValue.substring(0, variableValue.indexOf("+"));

                                        this.controls.valueDateTime.setKey(new Date(variableValue));
                                    }
                                }
                                else {
                                    if (variableValue == null) {
                                        this.controls.valueNotAssign.setChecked(true);
                                        this.controls.value.setEnabled(false);
                                        this.controls.value.setValue("");
                                    }
                                    else {
                                        this.controls.valueNotAssign.setChecked(false);
                                        this.controls.value.setEnabled(true);
                                        this.controls.value.setValue(variableValue);
                                    }
                                }
                            }
                        }
                    }
                    else {

                        this.variable.expression = StiBase64.decode(this.variable.expression);
                        this.controls.expression.setValue(this.variable.expression != null ? this.variable.expression : "");
                    }
                    break;
                }
            case "Range":
                {
                    if (this.variable.initBy == "Value") {
                        this.variable.valueFrom = StiBase64.decode(this.variable.valueFrom);
                        this.variable.valueTo = StiBase64.decode(this.variable.valueTo);
                        if (this.variable.type == "datetime") {
                            if (this.variable.valueFrom == "") this.controls.valueDateTimeFrom.setChecked(true);
                            else this.controls.valueDateTimeFrom.setKey(new Date(this.variable.valueFrom));
                            if (this.variable.valueTo == "") this.controls.valueDateTimeTo.setChecked(true);
                            else this.controls.valueDateTimeTo.setKey(new Date(this.variable.valueTo));
                        }
                        else {
                            this.controls.valueFrom.setValue(this.variable.valueFrom);
                            this.controls.valueTo.setValue(this.variable.valueTo);
                        }
                    }
                    else {
                        this.variable.expressionFrom = StiBase64.decode(this.variable.expressionFrom);
                        this.variable.expressionTo = StiBase64.decode(this.variable.expressionTo);
                        this.controls.expressionFrom.setValue(this.variable.expressionFrom);
                        this.controls.expressionTo.setValue(this.variable.expressionTo);
                    }
                    break;
                }
        }

        this.showControlsByType();
        this.updateDateTimeControls();

        var buttonWidth = this.controls.items.button.offsetWidth;
        if (buttonWidth) {
            this.controls.items.container.style.margin = "4px " + (buttonWidth + 10) + "px 4px 4px";
            this.controls.items.container.style.width = this.controls.items.container.style.minWidth = (325 - buttonWidth - 10) + "px";
        }
    }

    editVariableForm.action = function () {
        var variable = {};
        variable.mode = this.mode;

        if (!this.controls.name.checkNotEmpty(jsObject.loc.PropertyMain.Name)) return;
        if ((this.mode == "New" || this.controls.name.value != this.variable.name) &&
            !(this.controls.name.checkExists(jsObject.GetVariablesFromDictionary(jsObject.options.report.dictionary), "name") &&
                this.controls.name.checkExists(jsObject.GetDataSourcesFromDictionary(jsObject.options.report.dictionary), "name") &&
                this.controls.name.checkExists(jsObject.GetUserFunctionsFromDictionary(jsObject.options.report.dictionary), "name")))
            return;

        if (jsObject.options.variableReservedWords && jsObject.options.variableReservedWords.includes(this.controls.name.value.toLowerCase())) {
            this.controls.name.showError(jsObject.loc.Errors.NameExists.replace("{0}", this.controls.name.value));
            return;
        }

        if (this.mode == "Edit") variable.oldName = this.variable.name;
        var variableCategoryItem = jsObject.options.dictionaryTree.getCurrentVariableParent();
        variable.category = variableCategoryItem.itemObject.typeItem == "Category" ? variableCategoryItem.itemObject.name : "";
        variable.name = this.controls.name.value;
        variable.alias = this.controls.alias.value;
        variable.description = StiBase64.encode(this.controls.description.value);
        variable.type = this.controls.type.key;
        variable.basicType = this.controls.basicType.key;

        if (variable.basicType != "List") {
            variable.initBy = this.controls.initBy.key;
            if (variable.type == "image") {
                variable.value = this.controls.valueImage.src;
            }
            else if (variable.initBy == "Expression") {
                if (variable.basicType != "Range") variable.expression = StiBase64.encode(this.controls.expression.getValue());
                else {
                    variable.expressionFrom = StiBase64.encode(this.controls.expressionFrom.getValue());
                    variable.expressionTo = StiBase64.encode(this.controls.expressionTo.getValue());
                }
            }
            else {
                if (variable.basicType != "Range") {
                    variable.value = variable.type == "bool"
                        ? (this.controls.valueBool.isEnabled ? StiBase64.encode(this.controls.valueBool.isChecked ? "True" : "False") : null)
                        : ((variable.type == "datetime" || variable.type == "datetimeoffset")
                            ? (!this.controls.valueDateTime.isChecked ? StiBase64.encode(jsObject.DateToStringAmericanFormat(this.controls.valueDateTime.key)) : null)
                            : this.controls.value.isEnabled ? StiBase64.encode(this.controls.value.getValue()) : null);
                }
                else {
                    variable.valueFrom = variable.type == "datetime"
                        ? (!this.controls.valueDateTimeFrom.isChecked ? StiBase64.encode(jsObject.DateToStringAmericanFormat(this.controls.valueDateTimeFrom.key)) : null)
                        : StiBase64.encode(this.controls.valueFrom.getValue());
                    variable.valueTo = variable.type == "datetime"
                        ? (!this.controls.valueDateTimeTo.isChecked ? StiBase64.encode(jsObject.DateToStringAmericanFormat(this.controls.valueDateTimeTo.key)) : null)
                        : StiBase64.encode(this.controls.valueTo.getValue());
                }
            }
        }

        variable.readOnly = this.controls.readOnly.isChecked && variable.type != "image";
        variable.allowUseAsSqlParameter = this.controls.allowUseAsSqlParameter.isChecked && variable.type != "image";
        variable.allowNullableString = variable.basicType == "NullableValue" && variable.type == "string";
        variable.requestFromUser = this.controls.requestFromUser.isEnabled && this.controls.requestFromUser.isChecked && variable.type != "image";
        variable.allowUserValues = variable.requestFromUser ? this.controls.allowUserValues.isChecked : true;
        variable.rememberSelection = variable.requestFromUser ? this.controls.rememberSelection.isChecked : false;
        variable.dateTimeFormat = this.controls.dateTimeFormatRow.style.display == "" && variable.requestFromUser ? this.controls.dateTimeFormat.key : "DateAndTime";
        variable.formatMask = this.controls.formatMaskRow.style.display == "" ? StiBase64.encode(this.controls.formatMask.value) : "";
        variable.selection = this.variable.selection;
        variable.dataSource = this.variable.dataSource;
        variable.keys = this.variable.keys;
        variable.values = this.variable.values;
        variable.sortField = this.variable.sortField;
        variable.sortDirection = this.variable.sortDirection;
        variable.checkedColumn = this.variable.checkedColumn || "";
        variable.dependentValue = this.variable.dependentValue;
        variable.dependentVariable = this.variable.dependentVariable;
        variable.dependentColumn = this.variable.dependentColumn;
        variable.items = variable.dataSource == "Items" && this.variable.items ? this.variable.items : [];
        variable.checkedStates = this.variable.checkedStates || [];
        variable.filterExpression = this.variable.filterExpression;

        this.changeVisibleState(false);
        jsObject.SendCommandCreateOrEditVariable(variable);
    }

    editVariableForm.getItemsValuesTable = function () {
        var countLines = 0;
        var variable = editVariableForm.variable;
        var valuesTable = jsObject.CreateHTMLTable();
        valuesTable.style.lineHeight = "1.2";

        valuesTable.addTextCell = function (text) {
            var cell = valuesTable.addTextCellInLastRow(text);
            cell.style.whiteSpace = "nowrap";
            cell.style.paddingRight = "10px";

            return cell;
        }  

        if (variable.dataSource == "Items") {
            var resultStr = "";
            var items = variable.items;
            if (items == null) return valuesTable;
            for (var i = 0; i < items.length; i++) {
                if (i != 0) resultStr += (jsObject.options.listSeparator ? jsObject.options.listSeparator + " " : "; ");
                resultStr += this.getItemCaption(items[i]);
                valuesTable.addTextCell(resultStr);
            }
        }
        else {
            var sortBy = variable.sortDirection != "None"
                ? (" - " + jsObject.loc.Dashboard[variable.sortDirection == "Asc" ? "SortAZ" : "SortZA"])
                : "";

            if (variable.keys) {
                valuesTable.addRow();
                valuesTable.addTextCell(jsObject.loc.PropertyMain.Keys + ":");
                valuesTable.addTextCell(variable.keys + (variable.sortField == "Key" ? sortBy : ""));
                countLines++;
            }
            if (variable.values) {
                valuesTable.addRow();
                valuesTable.addTextCell(jsObject.loc.PropertyMain.Labels + ":");
                valuesTable.addTextCell(variable.values + (variable.sortField == "Label" ? sortBy : ""));
                countLines++;
            }
            if (variable.filterExpression) {
                valuesTable.addRow();
                valuesTable.addTextCell(jsObject.loc.PropertyMain.Filter + ":");
                valuesTable.addTextCell(StiBase64.decode(variable.filterExpression));
                countLines++;
            }

            var limitString = function (str, limit) {
                if (str.length > limit)
                    str = str.substring(0, limit);

                return str.toUpperCase();
            }

            var checkedColumn = this.variable.checkedColumn;
            if (checkedColumn) {
                var checkedColumnArray = checkedColumn.split(";");
                var dataSourceName = checkedColumnArray[0];
                var expression = checkedColumnArray.length > 1 ? checkedColumnArray[1] : "";
                var checkedResult = expression;

                if (dataSourceName) {
                    if (checkedResult) checkedResult += "; "
                    checkedResult += limitString(jsObject.loc.Components.StiDataBand, 4) + " - " + dataSourceName;
                }

                if (checkedResult) {
                    valuesTable.addRow();
                    valuesTable.addTextCell(jsObject.loc.PropertyEnum.StiCheckStateChecked + ":");
                    valuesTable.addTextCell(checkedResult);
                    countLines++;
                }
            }

            if (variable.dependentValue) {
                var varResult = "";

                if (variable.dependentVariable) {
                    varResult += limitString(jsObject.loc.PropertyMain.Variable, 3) + "-" + variable.dependentVariable;
                }
                if (variable.dependentColumn) {
                    if (varResult) varResult += "; "
                    varResult += limitString(jsObject.loc.PropertyMain.Column, 3) + "-" + variable.dependentColumn;
                }
                if (varResult) {
                    valuesTable.addRow();
                    valuesTable.addTextCell(jsObject.loc.PropertyMain.DependentValue + ":");
                    valuesTable.addTextCell(varResult);
                    countLines++;
                }
            }

            if (countLines > 0) {
                editVariableForm.controls.items.container.style.height = (25 + (countLines - 1) * 12) + "px";
            }
        }

        return valuesTable;
    }

    editVariableForm.getItemCaption = function (itemObject) {
        var itemCaption = StiBase64.decode(itemObject.value || "");
        if (itemCaption == "") {
            var key = itemObject.key != null ? StiBase64.decode(itemObject.key) : null;
            var keyTo = itemObject.keyTo != null ? StiBase64.decode(itemObject.keyTo) : null;
            itemCaption = key;
            var isDateTimeValue = this.variable.type == "datetime" && itemObject.type != "expression";
            if (isDateTimeValue) itemCaption = jsObject.DateAmericanFormatToLocalFormat(key, this.controls.dateTimeFormat.key);
            if (keyTo != null) {
                if (isDateTimeValue) itemCaption += " - " + jsObject.DateAmericanFormatToLocalFormat(keyTo, this.controls.dateTimeFormat.key);
                else itemCaption += " - " + keyTo;
            }
        }
        if (itemObject.type == "expression") itemCaption = "{" + itemCaption + "}";
        if (itemCaption == "") itemCaption = jsObject.loc.PropertyMain.Value;

        return itemCaption;
    }

    return editVariableForm;
}