﻿
StiMobileDesigner.prototype.InitializeEditElectronicSignatureForm_ = function () {
    var jsObject = this;
    var form = this.BaseForm("editElectronicSignature", this.loc.Components.StiSignature, 1, this.GetHelpLink("signature"));
    form.controls = {};

    var tabs = [];
    tabs.push({ name: "type", caption: this.loc.PropertyMain.Type });
    tabs.push({ name: "draw", caption: this.loc.PropertyEnum.StiSignatureTypeDraw });

    var tabbedPane = this.TabbedPane("editSignatureTabbedPane", tabs, "stiDesignerStandartTab");
    tabbedPane.style.margin = "12px";
    form.container.appendChild(tabbedPane);

    for (var i = 0; i < tabs.length; i++) {
        var tabsPanel = tabbedPane.tabsPanels[tabs[i].name];
        tabsPanel.style.width = "350px";
        tabsPanel.style.height = "220px";
    }

    tabbedPane.tabsPanels.type.appendChild(this.SignatureFormTypePanel(form));
    tabbedPane.tabsPanels.draw.appendChild(this.SignatureFormDrawPanel(form));

    // Save/Open Signature
    var saveButton = this.StandartSmallButton(null, null, null, "Signature.ExportSignature.png", this.loc.MainMenu.menuFileSave.replace("&", ""));
    var openButton = this.StandartSmallButton(null, null, null, "Signature.ImportSignature.png", this.loc.MainMenu.menuFileOpen.replace("&", ""), "Down");

    var tabsTable = tabbedPane.tabsPanel.firstChild;
    tabsTable.style.width = "100%";

    tabsTable.addCell();
    tabsTable.addCell(saveButton).style.width = "1px";
    tabsTable.addCell(openButton).style.width = "1px";

    var menuOpen = this.VerticalMenu("openSignatureMenu", openButton, "Down");

    menuOpen.onshow = function () {
        var signs = form.getSignaturesFromCookies();

        menuOpen.clear();

        for (var i = 0; i < signs.length; i++) {
            var item = jsObject.VerticalMenuItem(menuOpen, signs[i].key, signs[i].key, null, signs[i].key);
            item.style.height = "auto";
            item.style.width = "200px";
            item.style.margin = "2px 4px 2px 2px";
            item.innerTable.className = "stiSimpleContainerWithBorder";
            item.caption.innerHTML = "";
            item.caption.style.padding = "0 4px 0 4px";
            item.caption.appendChild(form.getSignatureVisualContent(signs[i]));
            menuOpen.innerContent.appendChild(item);
        }
    }

    menuOpen.action = function (menuItem) {
        var signs = form.getSignaturesFromCookies();
        for (var i = 0; i < signs.length; i++) {
            if (menuItem.key == signs[i].key) {
                form.fill(signs[i]);
                break;
            }
        }
        this.changeVisibleState(false);
    }

    saveButton.action = function () {
        var signs = form.getSignaturesFromCookies();

        var currSignature = form.getSignatureProps();
        currSignature.key = jsObject.generateKey();

        if (signs.length >= 5) signs.splice(0, 1);
        signs.push(currSignature);

        StiMobileDesigner.SetCookie("StimulsoftSignatures", StiBase64.encode(JSON.stringify(signs)));
        openButton.setEnabled(true);

        var messageForm = jsObject.options.forms.errorMessageForm || jsObject.InitializeErrorMessageForm();
        messageForm.show(jsObject.loc.Signature.SignatureSavedSuccessfully, "Info");
    }

    openButton.action = function () {
        menuOpen.changeVisibleState(!menuOpen.visible);
    }

    form.getCurrentSignatureMode = function () {
        return jsObject.UpperFirstChar(tabbedPane.selectedTab.panelName);
    }

    form.setCurrentSignatureMode = function (signatureMode) {
        tabbedPane.showTabPanel(jsObject.LowerFirstChar(signatureMode));
    }

    form.fill = function (properties) {
        var props = properties || this.currentComponent.properties;

        this.setCurrentSignatureMode(props.signatureMode);
        this.controls.fullName.value = props.typeFullName;
        this.controls.initials.value = props.typeInitials;
        this.controls.changeStyle.setStyleName(props.typeStyle);
        this.controls.sampleText.update();

        var drawContainer = this.controls.drawContainer;

        drawContainer.textProps = {
            text: props.drawText,
            font: props.drawTextFont,
            color: props.drawTextColor,
            horAlign: props.drawTextHorAlignment
        }

        drawContainer.imageProps = {
            image: props.drawImage,
            horAlignment: props.drawImageHorAlignment,
            vertAlignment: props.drawImageVertAlignment,
            stretch: props.drawImageStretch,
            aspectRatio: props.drawImageAspectRatio
        }

        drawContainer.update();
        drawContainer.setCanvasContent(props.drawCanvasContent);
        openButton.setEnabled(form.getSignaturesFromCookies().length > 0);
    }

    form.getSignaturesFromCookies = function () {
        var signs = [];
        var signsStr = StiMobileDesigner.GetCookie("StimulsoftSignatures");

        if (signsStr) {
            signs = JSON.parse(StiBase64.decode(signsStr));
        }

        return signs;
    }

    form.getSignatureVisualContent = function (props) {
        var content = document.createElement("div");
        content.style.height = "50px";
        content.style.textAlign = "center";
        content.style.overflow = "hidden";
        content.style.position = "relative";

        if (props.signatureMode == "Type") {
            content.setAttribute("style", "height: 50px; overflow: hidden; font-size: 16pt; display: flex; justify-content: center; align-items: center;");
            content.innerHTML = props.typeFullName + " " + props.typeInitials;

            for (var i = 0; i < form.signatureStyles.length; i++) {
                if (props.typeStyle == form.signatureStyles[i].styleName) {
                    content.style.fontFamily = form.signatureStyles[i].fontName;
                }
            }
        }
        else if (props.signatureMode == "Draw") {
            content.style.display = "flex";
            content.style.alignItems = "center";
            content.style.justifyContent = "center";

            if (props.drawImage) {
                var img = document.createElement("img");
                img.setAttribute("style", "height: 50px; position: absolute;");
                img.src = props.drawImage;
                content.appendChild(img);
            }
            if (props.drawText) {
                var font = jsObject.FontStrToObject(props.drawTextFont);
                var textCont = document.createElement("div");
                content.appendChild(textCont);

                textCont.innerText = StiBase64.decode(props.drawText);
                textCont.style.position = "absolute";
                textCont.style.fontFamily = font.name;
                textCont.style.fontSize = font.size + "px";
                textCont.style.fontWeight = font.bold == "1" ? "bold" : "normal";
                textCont.style.fontStyle = font.italic == "1" ? "italic" : "normal";
                textCont.style.textDecoration = font.underline == "1" ? "underline" : "";
                textCont.style.color = jsObject.GetHTMLColor(props.drawTextColor);
                textCont.style.justifyContent = textCont.style.textAlign = props.drawTextHorAlignment.toLowerCase();
            }
            if (props.drawCanvasContent) {
                var img = document.createElement("img");
                img.setAttribute("style", "height: 50px; position: absolute;");
                img.src = props.drawCanvasContent;
                content.appendChild(img);
            }
        }

        return content;
    }

    form.getSignatureProps = function () {
        var props = {};

        props.signatureMode = this.getCurrentSignatureMode();
        props.typeFullName = this.controls.fullName.value;
        props.typeInitials = this.controls.initials.value;
        props.typeStyle = this.controls.changeStyle.styleName;

        var imageProps = this.controls.drawContainer.imageProps;
        props.drawImage = imageProps.image;
        props.drawImageHorAlignment = imageProps.horAlignment;
        props.drawImageVertAlignment = imageProps.vertAlignment;
        props.drawImageStretch = imageProps.stretch;
        props.drawImageAspectRatio = imageProps.aspectRatio;

        var textProps = this.controls.drawContainer.textProps;
        props.drawText = textProps.text;
        props.drawTextFont = textProps.font;
        props.drawTextColor = textProps.color;
        props.drawTextHorAlignment = textProps.horAlign;
        props.drawCanvasContent = this.controls.drawContainer.getCanvasContent();

        return props;
    }

    form.show = function (component) {
        this.currentComponent = component;
        this.changeVisibleState(true);

        if (!this.signatureStyles) {
            jsObject.SendCommandToDesignerServer("GetStylesForSignature", {}, function (answer) {
                if (answer.styles) {
                    for (var i = 0; i < answer.styles.length; i++) {
                        var style = answer.styles[i];
                        if (style.fontContent) {
                            jsObject.AddCustomFontsCss(jsObject.GetCustomFontsCssText(style.fontContent, style.fontName));
                        }
                    }
                    form.signatureStyles = answer.styles;
                    form.fill();
                }
            });
        }
        else {
            form.fill();
        }
    }

    form.action = function () {
        this.changeVisibleState(false);
        var props = form.getSignatureProps();
        var propNames = ["signatureMode", "typeFullName", "typeInitials", "typeStyle", "drawImage", "drawImageHorAlignment", "drawImageVertAlignment", "drawImageStretch",
            "drawImageAspectRatio", "drawText", "drawTextFont", "drawTextColor", "drawTextHorAlignment", "drawCanvasContent"];

        for (var i = 0; i < propNames.length; i++) {
            this.currentComponent.properties[propNames[i]] = props[propNames[i]];
        }

        jsObject.SendCommandSendProperties(this.currentComponent, propNames);
    }

    return form;
}

StiMobileDesigner.prototype.SignatureFormTypePanel = function (form) {
    var jsObject = this;
    var table = this.CreateHTMLTable();
    table.style.width = "100%";

    //FullName
    var fullNameControl = this.TextBox(null, 220);
    form.addControlRow(table, this.loc.PropertyMain.FullName, "fullName", fullNameControl, "12px 12px 6px 12px", 30).style.textAlign = "right";

    //Initials
    var initialsControl = this.TextBox(null, 220);
    form.addControlRow(table, this.loc.PropertyMain.Initials, "initials", initialsControl, "6px 12px 6px 12px", 30).style.textAlign = "right";

    //ChangeStyle
    var changeStyleButton = this.SmallButton(null, null, this.loc.ChartRibbon.Style, null, null, "Down", "stiDesignerFormButton");
    changeStyleButton.style.display = "inline-block";
    form.addControlRow(table, " ", "changeStyle", changeStyleButton, "24px 12px 3px 12px", 50).style.textAlign = "right";

    changeStyleButton.setStyleName = function (styleName) {
        this.styleName = styleName;
    }

    var changeStyleMenu = this.VerticalMenu("editSignatureChangeStyle", changeStyleButton, "Down", [], "stiDesignerMenuMiddleItem");

    changeStyleButton.action = function () {
        changeStyleMenu.changeVisibleState(!changeStyleMenu.visible);
    }

    var getSignatureText = function () {
        return (fullNameControl.value || initialsControl.value ? fullNameControl.value + "  " + initialsControl.value : "FullName FN");
    }

    changeStyleMenu.onshow = function () {
        this.clear();

        var items = [];
        var styles = form.signatureStyles;

        if (styles) {
            for (var i = 0; i < styles.length; i++) {
                items.push(jsObject.Item("item" + i, getSignatureText(), null, styles[i]));
            }
        }

        this.addItems(items);

        for (var itemKey in this.items) {
            var item = this.items[itemKey];
            if (item.caption) {
                item.caption.style.fontSize = "16px";
                item.caption.style.fontFamily = item.key.fontName;
            }
            if (item.key.styleName == changeStyleButton.styleName) {
                item.setSelected(true);
            }
        }
    }

    //SampleText
    var sampleText = document.createElement("div");
    sampleText.className = "stiSimpleContainerWithBorder";
    sampleText.setAttribute("style", "height: 80px; width: 325px; overflow: hidden; font-size: 16pt; display: flex; justify-content: center; align-items: center;");
    form.addControlRow(table, null, "sampleText", sampleText, "0 12px 6px 12px");

    sampleText.update = function () {
        var styleName = changeStyleButton.styleName;
        for (var i = 0; i < form.signatureStyles.length; i++) {
            if (styleName == form.signatureStyles[i].styleName) {
                this.style.fontFamily = form.signatureStyles[i].fontName;
            }
        }
        this.innerText = getSignatureText();
    }

    changeStyleMenu.action = function (menuItem) {
        changeStyleButton.setStyleName(menuItem.key.styleName);
        sampleText.update();
        this.changeVisibleState(false);
    }

    fullNameControl.onchange = function () {
        sampleText.update();
    }

    initialsControl.onchange = function () {
        sampleText.update();
    }

    return table;
}

StiMobileDesigner.prototype.SignatureFormDrawPanel = function (form) {
    var jsObject = this;
    var panel = document.createElement("div");
    panel.setAttribute("style", "height: 100%;");

    var toolBar = this.CreateHTMLTable();
    toolBar.style.margin = "6px 0 6px 12px";
    toolBar.style.display = "inline-block";
    panel.appendChild(toolBar);

    //Use Brush
    var useBrush = form.controls.useBrush = this.ColorControlWithImage("signatureFormUseBrush", "BorderColor.png");
    useBrush.setKey("0,0,0");
    useBrush.style.marginRight = "4px";
    var cell = useBrush.button.innerTable.insertCell(1);
    cell.innerText = this.loc.Signature.UseBrush;
    cell.style.padding = "0 2px 0 2px";
    toolBar.addCell(useBrush);

    //Insert Text
    var insertText = this.StandartSmallButton(null, null, null, "Signature.StiSignatureText.png", this.loc.Signature.InsertText);
    insertText.style.marginRight = "4px";
    toolBar.addCell(insertText);

    //Insert Image
    var insertImage = this.StandartSmallButton(null, null, null, "SmallComponents.StiImage.png", this.loc.Signature.InsertImage);
    insertImage.style.marginRight = "4px";
    toolBar.addCell(insertImage);

    //Clear
    var clear = this.StandartSmallButton(null, null, null, "ClearAllFormatting.png", this.loc.Gui.monthcalendar_clearbutton);
    clear.style.marginRight = "4px";
    toolBar.addCell(clear);

    clear.action = function () {
        drawContainer.imageProps.image = "";
        drawContainer.textProps.text = "";
        drawContainer.update();
        drawContainer.clearCanvasContent();
    }

    //DrawContainer
    var drawContainer = this.SignatureFormDrawContainer(form);
    panel.appendChild(drawContainer);

    insertImage.action = function () {
        jsObject.InitializeSignatureImageForm(function (imageForm) {
            imageForm.show(drawContainer.imageProps);

            imageForm.action = function () {
                drawContainer.imageProps = {
                    image: imageForm.imageSrcContainer.src,
                    horAlignment: imageForm.horAlignLeft.isSelected ? "Left" : (imageForm.horAlignCenter.isSelected ? "Center" : "Right"),
                    vertAlignment: imageForm.vertAlignTop.isSelected ? "Top" : (imageForm.vertAlignMiddle.isSelected ? "Center" : "Bottom"),
                    stretch: imageForm.stretch.isChecked,
                    aspectRatio: imageForm.aspectRatio.isChecked
                }
                imageForm.changeVisibleState(false);
                drawContainer.update();
            }
        });
    }

    insertText.action = function () {
        jsObject.InitializeSignatureTextForm(function (textForm) {
            textForm.show(drawContainer.textProps);

            textForm.action = function () {
                var font = {
                    "name": textForm.fontName.key,
                    "size": textForm.fontSize.key,
                    "bold": textForm.fontBold.isSelected ? "1" : "0",
                    "italic": textForm.fontItalic.isSelected ? "1" : "0",
                    "underline": textForm.fontUnderline.isSelected ? "1" : "0",
                    "strikeout": "0"
                }
                drawContainer.textProps = {
                    text: StiBase64.encode(textForm.textContainer.value),
                    font: jsObject.FontObjectToStr(font),
                    color: textForm.textColor.key,
                    horAlign: textForm.horAlignLeft.isSelected ? "Left" : (textForm.horAlignRight.isSelected ? "Right" : "Center")
                }
                textForm.changeVisibleState(false);
                drawContainer.update();
            }
        });
    }

    return panel;
}

StiMobileDesigner.prototype.SignatureFormDrawContainer = function (form) {
    var jsObject = this;
    var panel = document.createElement("div");
    var width = "325px";
    var height = this.options.isTouchDevice ? "183px" : "188px"
    panel.setAttribute("style", "margin: 0 12px 0 12px; position: relative; line-height: 0; width: " + width + "; height: " + height + ";");
    form.controls.drawContainer = panel;

    //canvas
    var canvas = document.createElement("canvas");
    canvas.className = "stiSignatureCanvas";
    canvas.width = parseInt(width);
    canvas.height = parseInt(height);
    canvas.style.position = "absolute";
    canvas.style.zIndex = "100";
    canvas.style.cursor = "url('" + jsObject.options.cursorPenBase64 + "'), crosshair";
    panel.appendChild(canvas);

    var context = canvas.getContext("2d");
    var mouse = { x: 0, y: 0 };
    var draw = false;
    var isTouchDevice = jsObject.options.isTouchDevice;

    jsObject.addEvent(canvas, isTouchDevice ? 'touchstart' : 'mousedown', function (e) {
        if (e && e.button == 2) return;
        if (isTouchDevice) {
            mouse.fingerStartX = e.touches[0].pageX;
            mouse.fingerStartY = e.touches[0].pageY;

            mouse.posXCanvas = jsObject.FindPosX(canvas);
            mouse.posYCanvas = jsObject.FindPosY(canvas);

            mouse.x = mouse.fingerStartX - mouse.posXCanvas;
            mouse.y = mouse.fingerStartY - mouse.posYCanvas;
        }
        else {
            mouse.x = e.offsetX;
            mouse.y = e.offsetY;
        }
        draw = true;
        context.strokeStyle = jsObject.RgbColorStrToHexColor(form.controls.useBrush.key);
        context.beginPath();
        context.moveTo(mouse.x, mouse.y);
    });

    jsObject.addEvent(canvas, isTouchDevice ? 'touchmove' : 'mousemove', function (e) {
        if (draw) {
            if (isTouchDevice) {
                e.preventDefault();
                mouse.x = e.touches[0].pageX - mouse.posXCanvas;
                mouse.y = e.touches[0].pageY - mouse.posYCanvas;
            }
            else {
                mouse.x = e.offsetX;
                mouse.y = e.offsetY;
            }
            context.lineTo(mouse.x, mouse.y);
            context.stroke();
            canvas.isEmpty = false;
        }
    });

    jsObject.addEvent(canvas, isTouchDevice ? 'touchend' : 'mouseup', function (e) {
        if (e && e.button == 2) return;
        if (draw) panel.finishCanvasDraw(e);
        panel.canvasMouseUp = true;
    });

    jsObject.addEvent(document, isTouchDevice ? 'touchend' : 'mouseup', function (e) {
        if (e && e.button == 2) return;
        if (!panel.canvasMouseUp && draw) {
            panel.finishCanvasDraw(e, true);
        }
        panel.canvasMouseUp = false;
    });

    panel.finishCanvasDraw = function (e, isOutsides) {
        mouse.x = e.offsetX;
        mouse.y = e.offsetY;
        if (!isOutsides) {
            context.lineTo(mouse.x, mouse.y);
            context.stroke();
        }
        context.closePath();
        draw = false;
    }

    panel.getCanvasContent = function () {
        return !canvas.isEmpty ? canvas.toDataURL() : "";
    }

    panel.setCanvasContent = function (content) {
        var img = new window.Image();
        panel.clearCanvasContent();

        if (content) {
            img.onload = function () {
                var scale_factor = Math.min(canvas.width / img.width, canvas.height / img.height);

                var newWidth = img.width * scale_factor;
                var newHeight = img.height * scale_factor;

                var x = (canvas.width / 2) - (newWidth / 2);
                var y = (canvas.height / 2) - (newHeight / 2);

                context.drawImage(img, x, y, newWidth, newHeight);
                canvas.isEmpty = false;
            };

            img.src = content;
        }
    }

    panel.clearCanvasContent = function () {
        canvas.isEmpty = true;
        context.clearRect(0, 0, canvas.width, canvas.height);
    }

    //image & text
    var imgTable = this.CreateHTMLTable();
    panel.appendChild(imgTable);
    var img = document.createElement("img");
    img.style.maxWidth = width;
    img.style.maxHeight = height;
    var imgCell = imgTable.addCell(img);
    imgCell.style.width = width;
    imgCell.style.height = height;

    var textCont = document.createElement("div");
    textCont.className = "stiSignatureFormDrawContainer";
    textCont.style.display = "flex";
    textCont.style.alignItems = "center";
    panel.appendChild(textCont);

    panel.update = function () {
        textCont.innerText = StiBase64.decode(this.textProps.text);

        var font = jsObject.FontStrToObject(this.textProps.font);
        textCont.style.fontFamily = font.name;
        textCont.style.fontSize = font.size + "px";
        textCont.style.fontWeight = font.bold == "1" ? "bold" : "normal";
        textCont.style.fontStyle = font.italic == "1" ? "italic" : "normal";
        textCont.style.textDecoration = font.underline == "1" ? "underline" : "";
        textCont.style.color = jsObject.GetHTMLColor(this.textProps.color);
        textCont.style.justifyContent = textCont.style.textAlign = this.textProps.horAlign.toLowerCase();

        img.style.display = this.imageProps.image ? "" : "none";
        if (this.imageProps.image) img.src = this.imageProps.image;

        img.onload = function () {
            img.style.width = panel.imageProps.stretch ? width : "auto";
            img.style.height = panel.imageProps.stretch ? height : "auto";

            if (panel.imageProps.stretch && panel.imageProps.aspectRatio) {
                img.style.height = img.offsetHeight > 0 && img.offsetHeight > img.offsetWidth ? width : "auto";
                img.style.width = img.offsetHeight > 0 && img.offsetHeight > img.offsetWidth ? "auto" : height;
            }

            imgCell.style.textAlign = panel.imageProps.horAlignment.toLowerCase();
            imgCell.style.verticalAlign = panel.imageProps.vertAlignment == "Top" ? "top" : (panel.imageProps.vertAlignment == "Bottom" ? "bottom" : "middle");
        }
    }

    return panel
}