﻿
StiMobileDesigner.prototype.InitializeBlocklyEditorForm_ = function () {
    var jsObject = this;
    var form = this.BaseFormPanel("blocklyEditor", "Blockly", 3);
    form.container.style.border = "0";
    form.container.style.color = "#444444";

    var switchButton = this.FormButton(null, null, this.loc.Buttons.SwitchTo.replace("{0}", this.loc.FormDesigner.Code), null);
    switchButton.style.display = "inline-block";
    switchButton.style.margin = "12px";

    switchButton.action = function () {
        var showEventEditor = function () {
            var blocklyXmlText = form.getBlockCount() > 0 ? form.getXmlFromBlockly() : "";
            var control = form.resultControl.textBox || form.resultControl;
            control.value = control.hiddenValue = "";
            form.changeVisibleState(false);

            jsObject.InitializeEventEditorForm(function (eventForm) {
                var propertiesPanel = jsObject.options.propertiesPanel;
                eventForm.propertiesPanelZIndex = propertiesPanel.style.zIndex;
                eventForm.propertiesPanelIsEnabled = propertiesPanel.isEnabled;
                eventForm.resultControl = form.resultControl;                
                eventForm.show(blocklyXmlText);
            });
        }

        var messageFormEventMode = jsObject.MessageFormForSwitchingEventMode();
        messageFormEventMode.changeVisibleState(true);

        messageFormEventMode.action = function (state) {
            if (state) {
                if (jsObject.options.jsMode || (jsObject.options.report && jsObject.options.report.properties.calculationMode == "Compilation")) {
                    showEventEditor();
                }
                else if (jsObject.options.compilationAccess == "Ask" || jsObject.options.compilationAccess == "Allow") {
                    var messageFormCompilation = jsObject.MessageFormForSwitchToCompilation();
                    messageFormCompilation.changeVisibleState(true);

                    messageFormCompilation.action = function (state) {
                        if (state) {
                            jsObject.options.report.properties.calculationMode = "Compilation";
                            jsObject.SendCommandSetReportProperties(["calculationMode"]);

                            if (messageFormCompilation.doNotAskMe.isChecked) {
                                jsObject.options.compilationAccess = "Allow";
                                StiMobileDesigner.SetCookie("StimulsoftMobileDesignerCompilationAccess", "Allow");
                            }

                            showEventEditor();
                            messageFormCompilation.changeVisibleState(false);
                        }
                    }
                    messageFormCompilation.cancelAction = function (state) {
                        messageFormCompilation.changeVisibleState(false);
                    }
                }
                else {
                    showEventEditor();
                }
            }
            else {
                messageFormEventMode.changeVisibleState(false);
            }
        }
    }
        
    var footerTable = this.CreateHTMLTable();
    footerTable.style.width = "100%";
    var buttonsPanel = form.buttonsPanel;
    form.removeChild(buttonsPanel);
    form.appendChild(footerTable);
    footerTable.addCell(switchButton).style.textAlign = "left";
    footerTable.addCell();
    footerTable.addCell(form.buttonOk).style.width = "1px";
    footerTable.addCell(form.buttonCancel).style.width = "1px";

    var mainTable = this.CreateHTMLTable();
    form.container.appendChild(mainTable);

    var container = document.createElement("div");
    container.className = "stiBlocklyContainer";
    mainTable.addCell(container);

    var host = document.createElement("div");
    host.className = host.id = "stiBlocklyHost";
    container.appendChild(host);

    var emptyBlock = document.createElement("div");
    emptyBlock.className = "stiBlocklyDivEmpty";
    form.container.appendChild(emptyBlock);

    var emptyImg = document.createElement("img");
    emptyImg.className = "stiBlocklyImageEmpty";
    StiMobileDesigner.setImageSource(emptyImg, this.options, "Blockly.BlocklyEmpty.png", false);
    emptyBlock.appendChild(emptyImg);

    var emptyText = document.createElement("div");
    emptyText.className = "stiBlocklyTextEmpty";
    emptyText.innerText = this.loc.Dashboard.DragDropBlocks;
    emptyBlock.appendChild(emptyText);

    var rightToolbar = this.CreateHTMLTable();
    rightToolbar.style.margin = "30px 0 0 -55px";
    rightToolbar.style.position = "absolute";
    mainTable.addCell(rightToolbar).style.verticalAlign = "top";

    var openButton = this.FormImageButton(null, "Open.png", this.loc.Buttons.Open);
    var saveButton = this.FormImageButton(null, "Save.png", this.loc.Buttons.Save);
    var sampleButton = this.FormImageButton(null, "ConnectionString.Info.png", this.loc.FormFormatEditor.Sample);

    saveButton.style.marginTop = sampleButton.style.marginTop = "6px";
    sampleButton.style.display = "none" //Temporarily

    rightToolbar.addCell(openButton);
    rightToolbar.addCellInNextRow(saveButton);
    rightToolbar.addCellInNextRow(sampleButton);

    //AI Converter
    var convertingPanel = document.createElement("div");
    convertingPanel.className = "stiSimpleContainerWithBorder";
    convertingPanel.style.margin = "12px";
    var convertingTable = this.CreateHTMLTable();
    convertingPanel.appendChild(convertingTable);
    convertingTable.style.width = "100%";

    var textCell = convertingTable.addTextCell(this.loc.StimulAI.TryConvertScriptToBlockly.replace("{0}", "C#").replace("{1}", "Blockly"));
    textCell.className = "stiDataTransformHintBlock";
    textCell.style.padding = "12px";

    var tryStimulAIButton = this.FormButton(null, null, this.loc.StimulAI.Try, null);
    tryStimulAIButton.style.margin = "12px";
    tryStimulAIButton.style.display = "inline-block";
    convertingTable.addCell(tryStimulAIButton).style.width = "1px";
    form.container.appendChild(convertingPanel);

    tryStimulAIButton.action = function () {
        convertingPanel.style.display = "none";

        jsObject.InitializeStimulAIForm(function (stimulAIForm) {
            stimulAIForm.show(form, null, function () {
                stimulAIForm.sendButtonAction("ConvertToBlockly");
            });
        });
    }

    openButton.action = function () {
        if (jsObject.options.canOpenFiles) {
            jsObject.InitializeOpenDialog("loadBlocksFromFile", function (evt) {
                var files = evt.target.files;

                for (var i = 0; i < files.length; i++) {
                    var f = files[i];
                    var reader = new FileReader();

                    reader.onload = (function () {
                        return function (e) {
                            jsObject.ResetOpenDialogs();
                            form.insertXmlToBlockly(jsObject.GetDecodedFileContent(e.target.result));
                            jsObject.ReturnFocusToDesigner();

                        };
                    })(f);

                    reader.readAsDataURL(f);
                }
            }, ".blockly");
            jsObject.options.openDialogs.loadBlocksFromFile.action();
        }
    }

    saveButton.action = function () {
        jsObject.SendCommandSaveBlockly(form.getXmlFromBlockly(), form.eventName);
    }

    form.blocklyInitialized = function () {
        return (typeof Blockly != "undefined" && Blockly.mainWorkspace);
    }

    form.clearBlockly = function () {
        if (form.blocklyInitialized()) {
            Blockly.mainWorkspace.clear();
        }
        while (host.childNodes[0]) {
            host.removeChild(host.childNodes[0]);
        }
        this.horScroll = null;
        this.vertScroll = null;
    }

    form.getXmlFromBlockly = function () {
        if (form.blocklyInitialized()) {
            var dom = Blockly.Xml.workspaceToDom(Blockly.mainWorkspace);
            return Blockly.Xml.domToText(dom);
        }
        return "";
    }

    form.insertXmlToBlockly = function (xml) {
        if (form.blocklyInitialized()) {
            try {
                var dom = Blockly.Xml.textToDom(xml);
                Blockly.mainWorkspace.clear();
                Blockly.Xml.domToWorkspace(dom, Blockly.mainWorkspace);
            }
            catch (e) { }
        }
    }

    form.getBlockCount = function () {
        return Blockly.mainWorkspace.getAllBlocks().length;
    }

    form.checkState = function () {
        var countBlocks = form.getBlockCount();
        emptyBlock.style.display = countBlocks > 0 ? "none" : "block";

        form.findScrolls();
        if (form.horScroll && form.vertScroll) {
            form.horScroll.style.display = form.vertScroll.style.display = countBlocks > 0 ? "" : "none";
        }
    }

    form.findScrolls = function () {
        if (!this.horScroll && !this.horScroll) {
            var hScrolls = host.getElementsByClassName("blocklyScrollbarHorizontal");
            if (hScrolls && hScrolls.length > 0) this.horScroll = hScrolls[0];
            var vScrolls = host.getElementsByClassName("blocklyScrollbarVertical");
            if (vScrolls && vScrolls.length > 0) this.vertScroll = vScrolls[0];
        }
    }

    form.initBlockly = function (eventValue, showCurrentValue, userFunction) {
        var params = { eventValue: StiBase64.encode(eventValue), showCurrentValue: showCurrentValue };

        if (userFunction) {
            params.userFunction = userFunction;
        }

        jsObject.SendCommandToDesignerServer("GetBlocklyInitParameters", params, function (answer) {
            var toolboxXML = StiBase64.decode(answer.params.toolboxXML);
            var workspaceXML = StiBase64.decode(answer.params.workspaceXML);
            var initBlocksJsCode = StiBase64.decode(answer.params.initBlocksJsCode);

            if (form.initBlocksScript)
                form.initBlocksScript.parentElement.removeChild(form.initBlocksScript);

            form.initBlocksScript = jsObject.InitializeScriptText(initBlocksJsCode);
            // eslint-disable-next-line no-undef
            initBlocklyBlocks();

            var blocklyOptions = {
                toolbox: toolboxXML,
                zoom: {
                    controls: true,
                    wheel: true,
                    startScale: 1,
                    maxScale: 3,
                    minScale: 0.3,
                    scaleSpeed: 1.2
                }
            }

            Blockly.inject('stiBlocklyHost', blocklyOptions);
            Blockly.mainWorkspace.addChangeListener(form.checkState);

            form.insertXmlToBlockly(workspaceXML);
        });
    }

    form.getDataForAI = function () {
        var params = {
            commandName: "blockly"
        }
        if (form.eventScript) {
            params.eventScript = StiBase64.encode(form.eventScript);
        }
        return params;
    }

    form.onhide = function () {
        form.clearBlockly();
    }

    form.show = function (eventValue, eventName, userFunction, eventScript) {
        this.changeVisibleState(true);
        this.eventName = eventName;
        this.eventScript = eventScript;

        var showCurrentValue = eventName == "StiGetDataUrlEvent" || eventName == "StiGetExcelSheetEvent" || eventName == "StiGetExcelValueEvent" || eventName == "StiGetValueEvent" || eventName == "StiGetTextEvent";
        var allowEvents = jsObject.options.jsMode || jsObject.options.report.properties.calculationMode == "Compilation" ||
            (jsObject.options.report.properties.calculationMode == "Interpretation" && jsObject.options.compilationAccess != "Deny" && jsObject.options.compilationAccess != "ForceInterpretation");

        switchButton.setEnabled(allowEvents);
        switchButton.setAttribute("title", !switchButton.isEnabled ? jsObject.loc.HelpDesigner.NotPossibleEnableCompilationMode : "");
        switchButton.style.visibility = userFunction ? "hidden" : "visible";

        convertingPanel.style.display = jsObject.options.showStimulAI && eventScript ? "" : "none";

        form.clearBlockly();
        form.initBlockly(eventValue, showCurrentValue, userFunction);
    }

    form.action = function () {
        if (this.resultControl) {
            var countBlocks = form.getBlockCount() > 0;
            var resultTextBox = this.resultControl.textBox || this.resultControl;
            resultTextBox.value = countBlocks ? "[" + jsObject.loc.PropertyMain.Blocks + "]" : "";
            resultTextBox.hiddenValue = countBlocks > 0 ? form.getXmlFromBlockly() : "";
            if (this.resultControl.action) this.resultControl.action();
        }
        this.changeVisibleState(false);
    }

    return form;
}