﻿
StiMobileDesigner.prototype.ProcessDesignerFormsEvents = function (data) {
    var jsObject = this;
    if (data) {
        switch (data.action) {
            case "InterfaceEvent": {
                if (data.event == "RibbonFileClick") {
                    jsObject.options.formsDesignerFrame.hide();
                    jsObject.ExecuteAction("fileButton");
                }
                else if (data.event == "ShareButtonClick") {
                    jsObject.InitializeShareForm(function (shareForm) {
                        shareForm.show();
                    });
                }
                else if (data.event == "CloudButtonClick") {
                    var url = "https://cloud.stimulsoft.com/main.aspx";
                    var cloudParameters = jsObject.options.cloudParameters;
                    if (cloudParameters && cloudParameters.sessionKey && cloudParameters.userKey) {
                        url += ("?_loc=" + (jsObject.localizationControl.locName || "en") + "&_sessionkey=" + cloudParameters.sessionKey + "&_userkey=" + cloudParameters.userKey);
                    }
                    jsObject.openNewWindow(url);
                }
                else if (data.event == "AccountButtonClick") {
                    jsObject.options.formsDesignerFrame.hide();
                    var fileMenu = jsObject.options.menus.fileMenu || jsObject.InitializeFileMenu();
                    fileMenu.changeVisibleState(true);
                    setTimeout(function () { fileMenu.items.account.action(); }, 200);
                }
                else if (data.event == "LogoutButtonClick") {
                    jsObject.FinishSession();
                }
                else if (data.event == "LoginButtonClick") {
                    jsObject.options.forms.authForm.show();
                }
                else if (data.event == "SignUpButtonClick") {
                    jsObject.options.forms.authForm.changeMode("signUp");
                    jsObject.options.forms.authForm.show(true);
                }
                else if (data.event == "LocalizationButtonClick") {
                    if (jsObject.localizationControl && data.localization) {
                        jsObject.localizationControl.setLoc(data.localization.substring(0, data.localization.indexOf(".")), data.localization);
                        jsObject.localizationControl.action();
                    }
                }
                else if (data.event == "PublishButtonClick") {
                    jsObject.InitializeFormsDesignerFrame(function (frame) {
                        frame.sendCommand({ action: "publishForm" });
                    });
                }
                else if (data.event == "SaveToCloudButtonClick") {
                    var saveAsForm = jsObject.InitializeOnlineSaveAsForm();
                    saveAsForm.show(true);
                }
                else if (data.event == "SaveButtonClick") {
                    if (jsObject.options.cloudParameters && jsObject.options.cloudParameters.reportTemplateItemKey) {
                        jsObject.ExecuteAction("saveReport");
                    }
                    else {
                        jsObject.options.formsDesignerFrame.hide();
                        var fileMenu = jsObject.options.menus.fileMenu || jsObject.InitializeFileMenu();
                        fileMenu.changeVisibleState(true);
                        fileMenu.items.saveReport.action();
                    }
                }
                break;
            }
            case "CheckIsFormChanged": {
                switch (data.nextAction) {
                    case "openReport": {
                        jsObject.ActionOpenReport(data.isFormChanged);
                        break;
                    }
                    case "newReport": {
                        jsObject.ActionNewReport(data.isFormChanged);
                        break;
                    }
                    case "newDashboard": {
                        jsObject.ActionNewDashboard(data.isFormChanged);
                        break;
                    }
                    case "newForm": {
                        jsObject.ActionNewForm(data.isFormChanged);
                        break;
                    }
                    case "openReportFromCloudItem": {
                        if (jsObject.options.openPanel) {
                            jsObject.options.openPanel.openReportFromCloudItem(data.params.itemObject, data.params.notSaveToRecent, data.isFormChanged);
                        }
                        break;
                    }
                }
                break;
            }
            case "ItemResourceSave": {
                jsObject.SendCommandItemResourceSave(data.params.itemKey, data.params.customMessage, data.formContent);
                break;
            }
            case "PublishForm": {
                if (!jsObject.options.cloudParameters || !jsObject.options.cloudParameters.sessionKey) {
                    var messageForm = jsObject.options.forms.errorMessageForm || jsObject.InitializeErrorMessageForm();
                    messageForm.show(jsObject.loc.Notices.PleaseLogin, "Warning");
                    return;
                }
                if (data.formContent) {
                    var win = jsObject.openNewWindow();

                    jsObject.InitializePublishForm(function (publishForm) {
                        publishForm.show(StiBase64.encode(data.formContent), win);
                    });
                }
                break;
            }
        }
    }
}