﻿
StiMobileDesigner.prototype.TextAreaWithEditButton = function (name, width, height, readOnly, addEditorForm, buttonInside, samples, samplesHeight) {
    var jsObject = this;
    var mainControl = this.CreateHTMLTable();
    mainControl.isEnabled = true;

    var textArea = mainControl.textArea = this.TextArea(name, width && buttonInside ? width - 35 : null, height);
    textArea.style.lineHeight = "1";
    if (buttonInside) textArea.style.paddingRight = "35px";
    mainControl.addCell(mainControl.textArea).style.lineHeight = "0";

    var button = mainControl.button = this.SmallButton(name + "Button", null, null, "EditButton.png", this.loc.QueryBuilder.Edit, null, "stiDesignerFormButton", true);
    var buttonCell = mainControl.buttonCell = mainControl.addCell(button);
    buttonCell.style.verticalAlign = "top";

    //Override
    button.imageCell.style.padding = "0";
    button.style.width = button.style.height = this.options.isTouchDevice ? "28px" : "24px";
    button.style.marginLeft = "4px";
    button.innerTable.style.width = "100%";
    button.textArea = mainControl.textArea;

    if (buttonInside) {
        buttonCell.style.position = "relative";
        button.style.position = "absolute";
        button.style.top = button.style.right = "4px";
    }

    if (readOnly) {
        textArea.readOnly = readOnly;
        textArea.style.cursor = "default";
        textArea.mainControl = mainControl;

        textArea.onclick = function () {
            if (!this.isTouchEndFlag && !jsObject.options.isTouchClick)
                button.onclick();
        }

        textArea.ontouchend = function () {
            this.isTouchEndFlag = true;
            clearTimeout(this.isTouchEndTimer);
            button.ontouchend();
            this.isTouchEndTimer = setTimeout(function () {
                textArea.isTouchEndFlag = false;
            }, 1000);
        }
    }

    if (addEditorForm) {
        button.action = function () {
            jsObject.InitializeTextEditorFormOnlyText(function (form) {
                form.showFunction = function () {
                    if (samples) {
                        jsObject.AddHintHelperToControl(this.textArea, samplesHeight, false, true, samples, null);
                    }
                    this.textArea.value = textArea.value;
                }
                form.actionFunction = function () {
                    textArea.value = this.textArea.value;
                    mainControl.action();
                }
                form.changeVisibleState(true);
            });
        }
    }

    mainControl.setEnabled = function (state) {
        this.isEnabled = state;
        textArea.setEnabled(state);
        button.setEnabled(state);
    }

    mainControl.setValue = function (value) {
        textArea.value = value;
    }

    mainControl.getValue = function () {
        return textArea.value;
    }

    textArea.action = function () {
        mainControl.action();
    }

    mainControl.action = function () { }

    return mainControl;
}

StiMobileDesigner.prototype.ExpressionTextArea = function (name, width, height, withBorder, cutBrackets, showCheckButton, horLayout, samples, sampleLabelText, samplesHeight, hidePlaceholder) {
    var textAreaParent = document.createElement("div");
    var jsObject = textAreaParent.jsObject = this;
    if (name) this.options.controls[name] = textAreaParent;

    var textArea = this.TextArea(null, width, height);
    textArea.samples = samples;
    textArea.sampleLabelText = sampleLabelText;
    textArea.showCheckButton = showCheckButton;
    textArea.samplesHeight = samplesHeight;

    if (samples && samples.length > 0 && !hidePlaceholder) {
        textArea.setAttribute("placeholder", samples[0]);
    }

    textAreaParent.appendChild(textArea);
    textAreaParent.textArea = textArea;
    textAreaParent.controlType == "ExpressionTextArea";

    textArea.style.borderStyle = withBorder ? "solid" : "dashed";
    textArea.style.overflowY = "hidden";
    textArea.addInsertButton();
    textArea.insertButton.style.display = "";
    StiMobileDesigner.setImageSource(textArea.insertButton.image, this.options, "EditButton.png");
    textArea.insertButton.style.margin = "4px 0 0 " + (width - (this.options.isTouchDevice ? 30 : 24)) + "px";
    textArea.cutBrackets = cutBrackets;
    textArea.style.paddingRight = "35px";
    if (width) textArea.style.width = textArea.style.minWidth = (width - 35) + "px";

    if (this.options.isTouchDevice && height && height < 35) {
        textArea.insertButton.style.height = textArea.insertButton.style.width = "23px";
        textArea.insertButton.imageCell.style.padding = "0 4px 0 4px";
        textArea.insertButton.style.margin = "4px 0 0 " + (width - 24) + "px";
    }

    if (showCheckButton) {
        textArea.getDataForAI = function () {
            return {
                commandName: "onlyExpression",
                expression: StiBase64.encode(textArea.value)
            }
        }

        textArea.checkButtonAction = function () {
            textArea.checkButton.setEnabled(false);

            var params = {
                expression: StiBase64.encode(textArea.value),
                useAliases: jsObject.options.useAliases
            }

            jsObject.SendCommandToDesignerServer("CheckExpression", params, function (answer) {
                textArea.checkButton.setEnabled(true);

                if (answer.checkResult) {
                    var message = StiBase64.decode(answer.checkResult);

                    var messageForm = jsObject.MessageFormWithFixAI(jsObject.loc.Buttons.Check);
                    messageForm.show(message == "OK" ? jsObject.loc.StimulAI.CheckExpressionSuccess : message, message == "OK" ? "Information" : "Warning");
                    messageForm.buttonYes.style.display = jsObject.options.showStimulAI && message != "OK" ? "" : "none";

                    messageForm.action = function (state) {
                        messageForm.changeVisibleState(false);

                        if (state) {
                            jsObject.InitializeStimulAIForm(function (stimulAIForm) {
                                stimulAIForm.show(null, textArea, function () {
                                    stimulAIForm.sendButtonAction("FixExpression");
                                });
                            });
                        }
                    }
                }
            });
        }
    }

    textArea.insertButton.action = function () {
        jsObject.InitializeExpressionEditorForm(function (form) {
            form.resultControl = textArea;
            form.changeVisibleState(true);
        });
    }

    textAreaParent.setValue = function (value) {
        textArea.value = value;
    }

    textAreaParent.getValue = function () {
        return textArea.value;
    }

    textAreaParent.setEnabled = function (state) {
        textArea.setEnabled(state);
        textArea.insertButton.setEnabled(state);
    }

    textAreaParent.action = function () { }

    textArea.action = function () {
        textAreaParent.action();
    }

    return textAreaParent;
}