﻿
StiMobileDesigner.prototype.InitializeDrawControl = function (name, width, height) {
    var jsObject = this;
    var control = document.createElement("div");
    control.isEnabled = true;
    control.className = "stiDrawControlWithBorder";
    control.style.position = "relative";

    if (name != null) this.options.controls[name] = control;
    if (!width) width = 250;
    if (!height) height = 100;
    control.style.width = width + "px";
    control.style.height = height + "px";

    var innerTable = this.CreateHTMLTable();
    innerTable.style.width = "100%";
    control.appendChild(innerTable);

    //canvas
    var canvas = document.createElement("canvas");
    canvas.className = "stiSignatureCanvas";
    canvas.width = width;
    canvas.height = height;
    canvas.style.position = "absolute";
    canvas.style.top = "0";
    canvas.style.zIndex = "100";
    canvas.style.cursor = "url('" + jsObject.options.cursorPenBase64 + "'), crosshair";
    control.appendChild(canvas);

    var imageCell = innerTable.addCell(canvas);
    imageCell.style.width = width + "px";
    imageCell.style.height = height + "px";

    var removeButton = this.SmallButton(null, null, null, "Remove.png", this.loc.MainMenu.menuEditDelete.replace("&", ""), null, "stiDesignerFormButton");
    removeButton.style.position = "absolute";
    removeButton.style.zIndex = "101";
    removeButton.style.right = removeButton.style.top = "4px";

    var buttonsCell = innerTable.addCell(removeButton);
    buttonsCell.style.width = "1px";
    buttonsCell.style.position = "relative";

    removeButton.action = function () {
        control.clearCanvasContent();
        control.action();
    }

    var context = canvas.getContext("2d");
    var mouse = { x: 0, y: 0 };
    var draw = false;

    jsObject.addEvent(canvas, 'mousedown', function (e) {
        if (e && e.button == 2) return;
        mouse.x = e.offsetX;
        mouse.y = e.offsetY;
        draw = true;
        context.strokeStyle = "#000000";
        context.beginPath();
        context.moveTo(mouse.x, mouse.y);
    });

    jsObject.addEvent(canvas, 'mousemove', function (e) {
        if (draw) {
            mouse.x = e.offsetX;
            mouse.y = e.offsetY;
            context.lineTo(mouse.x, mouse.y);
            context.stroke();
            canvas.isEmpty = false;
        }
    });

    jsObject.addEvent(canvas, 'mouseup', function (e) {
        if (e && e.button == 2) return;
        if (draw) control.finishCanvasDraw(e);
        control.canvasMouseUp = true;
    });

    jsObject.addEvent(document, 'mouseup', function (e) {
        if (e && e.button == 2) return;
        if (!control.canvasMouseUp && draw) {
            control.finishCanvasDraw(e, true);
        }
        control.canvasMouseUp = false;
    });

    control.finishCanvasDraw = function (e, isOutsides) {
        mouse.x = e.offsetX;
        mouse.y = e.offsetY;
        if (!isOutsides) {
            context.lineTo(mouse.x, mouse.y);
            context.stroke();
        }
        context.closePath();
        draw = false;
        control.action();
    }

    control.getCanvasContent = function () {
        return !canvas.isEmpty ? canvas.toDataURL() : "";
    }

    control.setCanvasContent = function (content) {
        var img = new Image();
        control.clearCanvasContent();

        if (content) {
            img.onload = function () {
                var scale_factor = Math.min(canvas.width / img.width, canvas.height / img.height);

                var newWidth = img.width * scale_factor;
                var newHeight = img.height * scale_factor;

                var x = (canvas.width / 2) - (newWidth / 2);
                var y = (canvas.height / 2) - (newHeight / 2);

                context.drawImage(img, x, y, newWidth, newHeight);
                canvas.isEmpty = false;
            };

            img.src = content;
        }
    }

    control.clearCanvasContent = function () {
        canvas.isEmpty = true;
        context.clearRect(0, 0, canvas.width, canvas.height);
    }

    control.action = function () {}

    return control;
}