﻿
StiMobileDesigner.prototype.ColorControlWithImage = function (name, imageName, toolTip, topMarginIcon, forSingleLineRibbon) {
    var colorControl = this.ColorControl(name, toolTip, null, null, null, true);

    //Override image
    var icon = colorControl.icon = document.createElement("img");
    icon.style.width = "16px";
    icon.style.height = "12px";
    icon.style.pointerEvents = "none";
    StiMobileDesigner.setImageSource(icon, this.options, imageName);

    if (forSingleLineRibbon) {
        if (colorControl.button.imageCell) colorControl.button.imageCell.style.padding = this.options.isTouchDevice ? "0 5px 0 5px" : "0 2px 0 4px";
        if (colorControl.button.arrowCell) colorControl.button.arrowCell.style.padding = this.options.isTouchDevice ? "0 7px 0 2px" : "0px 4px 0px 2px";
    }

    var button = colorControl.button;
    var colorBar = button.image;
    var colorBarParent = colorBar.parentElement;
    var imageCell = colorBarParent.parentElement;

    colorBarParent.className = "stiColorControlWithImage_ColorBar";
    colorBarParent.style.height = "2px";

    if (topMarginIcon) {
        colorBarParent.parentElement.style.paddingTop = "4px";
    }

    imageCell.removeChild(colorBarParent);
    imageCell.appendChild(icon);
    imageCell.appendChild(colorBarParent);

    button.image = colorBar;
    button.icon = icon;

    //Override methods
    colorControl.setEnabled = function (state) {
        if (button.image) button.image.style.opacity = state ? "1" : "0.3";
        if (button.icon) button.icon.style.opacity = state ? "1" : "0.3";
        if (button.arrow) button.arrow.style.opacity = state ? "1" : "0.3";
        this.isEnabled = state;
        button.isEnabled = state;
        button.className = state ? button.defaultClass : button.disabledClass;
    }

    return colorControl;
}