﻿
StiMobileDesigner.prototype.InitializeEditTextElementForm_ = function () {
    var form = this.DashboardBaseForm("editTextElementForm", this.loc.Components.StiText, 1, this.GetHelpLink("textElement"));
    var jsObject = this;
    form.controls = {};
    form.isDockableToComponent = false;
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    form.hideButtonsPanel();

    var controlsTable = this.CreateHTMLTable();
    var textElemEditor = this.TextElementEditor("editTextElementFormEditor", 700, 350);
    textElemEditor.richText.style.margin = "0px";
    textElemEditor.richText.style.border = "0px";
    textElemEditor.style.margin = "12px";
    form.container.appendChild(controlsTable);
    controlsTable.addCell(textElemEditor).style.verticalAlign = "top";

    var measureTable = form.controls.measureTable = this.CreateHTMLTable();
    measureTable.style.display = "none";
    controlsTable.addCell(measureTable);

    var dataContainer = form.controls.dataContainer = this.TextElementDataContainer(200, 300, true, form);
    dataContainer.style.margin = "0 12px 0 0";
    var measureText = measureTable.addTextCell(this.loc.Dashboard.Measures);
    measureText.className = "stiDesignerCaptionControls";
    measureText.style.padding = "25px 0px 6px 0px";
    measureTable.addCellInNextRow(dataContainer);

    var expressionControl = form.controls.expressionControl = this.ExpressionControlWithMenu(null, 200, null, null, null, true, true, false, ["Sum(Field)"], null, 40);
    expressionControl.style.marginBottom = "12px";
    var expText = measureTable.addTextCellInNextRow(this.loc.PropertyMain.Expression);
    expText.className = "stiDesignerCaptionControls";
    expText.style.padding = "6px 0 6px 0";
    measureTable.addCellInNextRow(expressionControl);

    var expressionMenu = form.expressionMenu = this.options.menus.textElementExpressionMenu || this.InitializeDataContainerExpressionMenu("textElementExpressionMenu", expressionControl, dataContainer, form);
    expressionControl.menu = expressionMenu;
    expressionMenu.parentButton = expressionControl.button;

    expressionControl.action = function () {
        form.setPropertyMeasure("Expression", StiBase64.encode(this.textBox.value));
    }

    var expMenu = this.VerticalMenu("textElementExpMenu", textElemEditor.controls.buttonExpression, "Down", []);

    textElemEditor.controls.buttonExpression.action = function () {
        expMenu.changeVisibleState(!expMenu.visible);
    }

    expMenu.onshow = function () {
        this.clear();

        var items = [];
        var dataSources = jsObject.GetDataSourcesFromDictionary(jsObject.options.report.dictionary);

        if (dataSources.length > 0) {
            items.push(jsObject.Item("dataSources", jsObject.loc.PropertyMain.DataSources, "DataSource.png", "dataSources", null, true));
            items.push("separator1");
        }

        var meters = form.currentTextElement.properties.meters;
        if (meters && meters.length > 0) {
            for (var i = 0; i < meters.length; i++) {
                var text = meters[i].currentFunction ? meters[i].label + " (" + meters[i].currentFunction + ")" : meters[i].label; 
                var image = "Meters." + meters[i].typeIcon + ".png";
                items.push(jsObject.Item("measureItem" + i, text, image, "Measure_" + meters[i].labelCorrect));                
            }
            items.push("separator2");
        }
        
        items.push(jsObject.Item("newMeasure", jsObject.loc.Dashboard.NewMeasure, "Empty16.png", "newMeasure"));

        expMenu.addItems(items);

        if (expMenu.items.dataSources) {
            var dataSourcesMenu = jsObject.DataSourcesSubMenu("textElementDataSources", expMenu.items.dataSources, expMenu);

            dataSourcesMenu.action = function (menuItem) {
                textElemEditor.insertText("{" + menuItem.key.corrected + "}");
                textElemEditor.onchange();
            }
        }
    }

    expMenu.action = function (menuItem) {
        if (menuItem.key.indexOf("Measure_") == 0) {
            textElemEditor.richText.onblur();
            textElemEditor.insertText("{" + menuItem.key.substring("Measure_".length) + "}");
            textElemEditor.onchange();
        }
        else if (menuItem.key == "newMeasure") {
            form.sendCommand({ command: "NewMeter" },
                function (answer) {
                    dataContainer.updateMeters(answer.elementProperties.meters, answer.elementProperties.meters.length - 1);
                    form.updateElementProperties(answer.elementProperties);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                }
            );
        }
        expMenu.changeVisibleState(false);
    }

    textElemEditor.controls.fontList.action = function () {
        form.setPropertyTextElement("fontName", this.key);
    }

    textElemEditor.controls.sizeList.action = function () {
        form.setPropertyTextElement("fontSize", this.key);
    }

    textElemEditor.controls.buttonAlignLeft.action = function () {
        if (!textElemEditor.writingInProgress)
            form.setPropertyTextElement("horAlignment", "Left");
    }

    textElemEditor.controls.buttonAlignCenter.action = function () {
        if (!textElemEditor.writingInProgress)
            form.setPropertyTextElement("horAlignment", "Center");
    }

    textElemEditor.controls.buttonAlignRight.action = function () {
        if (!textElemEditor.writingInProgress)
            form.setPropertyTextElement("horAlignment", "Right");
    }

    textElemEditor.controls.buttonAlignWidth.action = function () {
        if (!textElemEditor.writingInProgress)
            form.setPropertyTextElement("horAlignment", "Width");
    }

    textElemEditor.getFontProperties = function () {
        var controls = textElemEditor.controls;
        var align = "Center";
        if (controls.buttonAlignLeft.isSelected) align = "Left";
        else if (controls.buttonAlignCenter.isSelected) align = "Center";
        else if (controls.buttonAlignRight.isSelected) align = "Right";
        else if (controls.buttonAlignWidth.isSelected) align = "Width";
        return {
            fontName: controls.fontList.key,
            fontSize: controls.sizeList.key,
            horAlignment: align
        };
    }

    textElemEditor.controls.buttonClearFormatting.action = function () {
        textElemEditor.richText.selectAllText();
        form.setPropertyTextElement("clearAllFormatting");
        if (form.currentTextElement) {
            form.currentTextElement.properties.vertAlignment = "Center";
            jsObject.SendCommandSendProperties([form.currentTextElement], ["vertAlignment"]);
        }
    }

    textElemEditor.checkCurrentText = function () {
        this.needToRewrite = false;
        var text = textElemEditor.getText();
        if (text.indexOf("<") > 0) {
            this.needToRewrite = true;
        }
        return StiBase64.encode(text);
    }

    textElemEditor.setPropertyText = function () {
        form.setPropertyTextElement("text", textElemEditor.checkCurrentText(), true);
        if (this.needToRewrite) {
            this.needToRewrite = false;
            form.setPropertyTextElement("fontSize", textElemEditor.controls.sizeList.key);
        }
    }

    textElemEditor.onchange = function () {
        textElemEditor.setPropertyText();
    };

    textElemEditor.onchangetext = function () {
        textElemEditor.setPropertyText();
    };

    form.updateControls = function () {
        var controls = textElemEditor.controls;
        var font = form.currentTextElement.properties.font ? jsObject.FontStrToObject(form.currentTextElement.properties.font) : null;
        if (form.currentTextElement.properties.text != null) {
            textElemEditor.setText(StiBase64.decode(form.currentTextElement.properties.text));
        }
        if (font) {
            controls.fontList.setKey(font.name);
            controls.sizeList.setKey(font.size);
            controls.buttonStyleBold.setSelected(font.bold == "1");
            controls.buttonStyleItalic.setSelected(font.italic == "1");
            controls.buttonStyleUnderline.setSelected(font.underline == "1");
        }
        var horAlignment = form.currentTextElement.properties.horAlignment;
        if (horAlignment) {
            controls.buttonAlignLeft.setSelected(horAlignment == "Left");
            controls.buttonAlignCenter.setSelected(horAlignment == "Center");
            controls.buttonAlignRight.setSelected(horAlignment == "Right");
            controls.buttonAlignWidth.setSelected(horAlignment == "Width");
        }
    }

    form.onshow = function () {
        textElemEditor.onLoadComplete = function () {
            var body = textElemEditor.richText.doc.getElementsByTagName("body")[0];
            if (body) {
                body.style.color = jsObject.GetHTMLColor(form.currentTextElement.properties.realForeColor);

                var horAlignment = form.currentTextElement.properties.horAlignment;
                horAlignment = horAlignment == "Width" ? "left" : horAlignment.toLowerCase();
                body.style.textAlign = horAlignment;

                var font = form.currentTextElement.properties.font ? jsObject.FontStrToObject(form.currentTextElement.properties.font) : null;
                if (font) {
                    body.style.fontFamily = font.name;
                    body.style.fontSize = font.size;
                }
            }
        }
        form.updateControls();
        dataContainer.updateMeters(form.currentTextElement.properties.meters, 0);
        textElemEditor.richText.style.background = jsObject.GetHTMLColor(form.currentTextElement.properties.realBackColor);
    }

    form.setPropertyTextElement = function (propertyName, propertyValue, notUpdateControls) {
        if (propertyName == "fontName" || propertyName == "fontSize" || propertyName == "horAlignment") {
            var fontProps = textElemEditor.getFontProperties();
            fontProps[propertyName] = propertyValue;
            propertyName = "fontProperties";
            propertyValue = fontProps;
        }
        form.sendCommand(
            {
                command: "SetProperty",
                propertyName: propertyName,
                propertyValue: propertyValue
            },
            function (answer) {
                for (var propName in answer.elementProperties) {
                    form.currentTextElement.properties[propName] = answer.elementProperties[propName];
                }
                form.currentTextElement.repaint();
                form.jsObject.options.homePanel.updateControls();
                if (!notUpdateControls) form.updateControls();
            }
        );
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        form.jsObject.SendCommandToDesignerServer("UpdateTextElement",
            {
                componentName: form.currentTextElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    form.setPropertyMeasure = function (propertyName, propertyValue) {
        form.sendCommand(
            {
                command: "SetPropertyMeasure",
                propertyName: propertyName,
                propertyValue: propertyValue,
                itemIndex: dataContainer.getSelectedItemIndex()
            },
            function (answer) {
                dataContainer.updateMeters(answer.elementProperties.meters, dataContainer.getSelectedItemIndex());
                form.updateElementProperties(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
            }
        );
    }
        
    form.updateSvgContent = function (svgContent) {
        this.currentTextElement.properties.svgContent = svgContent;
        this.currentTextElement.repaint();
    }

    form.updateElementProperties = function (properties) {
        for (var propertyName in properties) {
            this.currentTextElement.properties[propertyName] = properties[propertyName];
        }
    }

    return form;
}

StiMobileDesigner.prototype.TextElementDataContainer = function (width, height, showItemImage, form) {
    var jsObject = this;
    var dataContainer = this.DataContainer(width, height, showItemImage);
    this.AddDroppedContainerToCollection(dataContainer);

    dataContainer.updateMeters = function (meters, selectedIndex) {
        var oldScrollTop = this.scrollTop;
        this.clear();
        if (meters) {
            for (var i = 0; i < meters.length; i++) {
                this.addItem(meters[i].currentFunction ? meters[i].label + " (" + meters[i].currentFunction + ")" : meters[i].label, "Meters." + meters[i].typeIcon + ".png", meters[i]);
            }
            if (selectedIndex != null && selectedIndex >= 0 && selectedIndex < meters.length) {
                this.childNodes[selectedIndex].select();
            }
            else if (selectedIndex == -1 && this.childNodes.length > 0) {
                this.childNodes[this.childNodes.length - 1].select();
            }
        }
        this.scrollTop = oldScrollTop;
        form.controls.measureTable.style.display = this.getCountItems() > 0 ? "" : "none";
    }

    dataContainer.onmouseup = function (event) {
        if (event.button == 2) {
            event.stopPropagation();
            var point = jsObject.FindMousePosOnMainPanel(event);
            form.expressionMenu.show(point.xPixels + 3, point.yPixels + 3, "Down", "Right");
        }
        else if (jsObject.options.itemInDrag) {
            var itemObject = jsObject.CopyObject(jsObject.options.itemInDrag.originalItem.itemObject);
            if (!itemObject) return;
            var typeItem = itemObject.typeItem;
            var commandName = jsObject.options.CTRL_pressed ? "MoveAndDuplicateMeter" : "MoveMeter";

            if (typeItem == "Meter") {
                var toIndex = this.getOverItemIndex();
                var fromIndex = this.getItemIndex(jsObject.options.itemInDrag.originalItem);

                if (toIndex != null && fromIndex != null && fromIndex != toIndex) {
                    form.sendCommand({ command: commandName, toIndex: toIndex, fromIndex: fromIndex },
                        function (answer) {
                            dataContainer.updateMeters(answer.elementProperties.meters, toIndex);
                            form.updateElementProperties(answer.elementProperties);
                            form.updateSvgContent(answer.elementProperties.svgContent);
                        }
                    );
                    var fromIndex = this.getItemIndex(jsObject.options.itemInDrag.originalItem);
                }
            }
            else if (typeItem == "Column" || typeItem == "DataSource" || typeItem == "BusinessObject" || typeItem == "Variable") {
                var draggedItem = {
                    itemObject: itemObject
                };

                if (typeItem == "Column") {
                    var columnParent = jsObject.options.dictionaryTree.getCurrentColumnParent();
                    if (columnParent) {
                        draggedItem.currentParentType = columnParent.type;
                        draggedItem.currentParentName = (columnParent.type == "BusinessObject") ? jsObject.options.itemInDrag.originalItem.getBusinessObjectFullName() : columnParent.name;
                    }
                }
                else if (typeItem == "DataSource" || typeItem == "BusinessObject") {
                    draggedItem.currentParentType = typeItem;
                    draggedItem.currentParentName = itemObject.name;
                }

                var params = {
                    command: "InsertMeters",
                    draggedItem: draggedItem
                }

                if (typeItem == "Column" || typeItem == "Variable") {
                    params.insertIndex = dataContainer.getOverItemIndex();
                }

                form.sendCommand(params,
                    function (answer) {
                        dataContainer.updateMeters(answer.elementProperties.meters, params.insertIndex != null ? params.insertIndex : answer.elementProperties.meters.length - 1);
                        form.updateElementProperties(answer.elementProperties);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                    }
                );
            }
        }

        return false;
    }

    dataContainer.oncontextmenu = function (event) {
        return false;
    }

    dataContainer.onRemove = function (itemIndex) {
        form.sendCommand({ command: "RemoveMeter", itemIndex: itemIndex },
            function (answer) {
                dataContainer.updateMeters(answer.elementProperties.meters, dataContainer.getSelectedItemIndex());
                form.updateElementProperties(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
            }
        );
    }

    dataContainer.onAction = function (actionName) {
        var controls = form.controls;
        var itemObject = this.selectedItem ? this.selectedItem.itemObject : null;

        if (itemObject) {
            if (actionName == "rename") {
                var itemIndex = dataContainer.getSelectedItemIndex();

                form.sendCommand({ command: "RenameMeter", itemIndex: itemIndex, newLabel: itemObject.label },
                    function (answer) {
                        dataContainer.updateMeters(answer.elementProperties.meters, itemIndex);
                        form.updateElementProperties(answer.elementProperties);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                    }
                );
                return;
            }
            controls.expressionControl.textBox.value = StiBase64.decode(itemObject.expression);
        }
    }

    return dataContainer;
}
