
StiMobileDesigner.prototype.GetCloudPermissions = function () {
    var currentPlan = this.ConvertCloudPlanNumberValueToEnumValue(this.GetCloudPlanNumberValue());
    return {
        rAvailable: (currentPlan.indexOf("RBase") >= 0 || currentPlan.indexOf("RSingle") >= 0 || currentPlan.indexOf("RTeam") >= 0 || currentPlan.indexOf("REnterprise") >= 0),
        dAvailable: (currentPlan.indexOf("DBase") >= 0 || currentPlan.indexOf("DSingle") >= 0 || currentPlan.indexOf("DTeam") >= 0 || currentPlan.indexOf("DEnterprise") >= 0)
    }
}

StiMobileDesigner.prototype.GetCloudPlanNumberValue = function () {
    var workspace = this.options.cloudParameters ? this.options.cloudParameters.workspace : null;
    if (!workspace && this.options.workspace) workspace = this.options.workspace;
    return (workspace ? (workspace.ResultPlanIdent || 0) : 0);
}

StiMobileDesigner.prototype.ConvertCloudPlanEnumValueToNumberValue = function (strValue) {
    var value = 0;
    if (strValue.indexOf("RBase") >= 0) value += 1;
    if (strValue.indexOf("RSingle") >= 0) value += 2;
    if (strValue.indexOf("RTeam") >= 0) value += 4;
    if (strValue.indexOf("REnterprise") >= 0) value += 8;
    if (strValue.indexOf("DBase") >= 0) value += 32;
    if (strValue.indexOf("DSingle") >= 0) value += 64;
    if (strValue.indexOf("DTeam") >= 0) value += 128;
    if (strValue.indexOf("DEnterprise") >= 0) value += 256;
    if (strValue.indexOf("Expiried") >= 0) value += 512;

    return value;
}

StiMobileDesigner.prototype.ConvertCloudPlanNumberValueToEnumValue = function (value) {
    var tText = this.getBackText(true);
    var enumValues = {
        0: tText,
        1: "RBase",
        2: "RSingle",
        4: "RTeam",
        8: "REnterprise",
        32: "DBase",
        64: "DSingle",
        128: "DTeam",
        256: "DEnterprise",
        512: "Expiried"
    }
    if (!enumValues[value]) {
        var values = "";
        for (var enumValue in enumValues) {
            var enumValueNumber = parseInt(enumValue);
            if (enumValueNumber != 0 && (value & enumValueNumber) == enumValueNumber) {
                value -= enumValueNumber;
                values += (values.length > 0 ? ", " : "") + enumValues[enumValueNumber];
            }
        }
        if (values.length == 0) values = tText;
        return values;
    }
    else {
        return enumValues[value]
    }
}

StiMobileDesigner.prototype.GetCurrentPlanLimitValue = function (limitName) {
    var limitValue = null;
    var tText = this.getBackText(true);
    var currentPlan = this.ConvertCloudPlanNumberValueToEnumValue(this.GetCloudPlanNumberValue());
    var plansLimits = this.options.plansLimits;
    if (plansLimits) {
        if (currentPlan.indexOf(tText) >= 0) {
            var tLimits = plansLimits[tText.toLowerCase()];
            limitValue = tLimits[limitName];
        }
        if (currentPlan.indexOf("Base") >= 0)
            limitValue = plansLimits.base[limitName];
        if (currentPlan.indexOf("Single") >= 0)
            limitValue = plansLimits.single[limitName];
        if (currentPlan.indexOf("Team") >= 0)
            limitValue = plansLimits.team[limitName];
        if (currentPlan.indexOf("Enterprise") >= 0)
            limitValue = plansLimits.enterprise[limitName];
    }
    return limitValue;
}

StiMobileDesigner.prototype.UpdateWindowTitle = function () {
    if (document.title) {
        document.title = document.title.replace(" " + this.getBackText(), "");
        if (this.options.currentPage && !this.options.currentPage.valid) {
            document.title += " " + this.getBackText();
        }
    }
}

StiMobileDesigner.prototype.UpdateWatermarksOnPages = function () {
    var report = this.options.report;
    var isOwnerDeveloperRole = this.options.cloudParameters && this.options.cloudParameters.user && this.options.cloudParameters.user.DeveloperRole == "Owner";

    if (report) {
        var permissions = this.GetCloudPermissions();
        for (var pageName in this.options.report.pages) {
            var page = this.options.report.pages[pageName];
            if (page.controls.waterMarkBackParent) {
                page.removeChild(page.controls.waterMarkBackParent);
                page.controls.waterMarkBackParent = null;
                page.valid = true;
            }
            if ((page.isDashboard && !permissions.dAvailable) || (!page.isDashboard && !permissions.rAvailable) || isOwnerDeveloperRole) {
                this.CreatePageWaterMarkBack(page);
                this.RepaintWaterMarkBack(page);
                page.valid = false;
            }
        }
    }
    if (this.options.cloudMode) {
        var permissions = this.GetCloudPermissions();
        if ((!permissions.dAvailable && !permissions.rAvailable) || isOwnerDeveloperRole) {
            this.options.infoPanel.show();
        }
        else {
            this.options.infoPanel.hide();
        }
        if (isOwnerDeveloperRole) {
            this.FinishSession();
        }
    }
}

StiMobileDesigner.prototype.UpdateResourcesLimits = function () {
    var maxResourceSize = this.GetCurrentPlanLimitValue("MaxResourceSize");
    if (maxResourceSize) this.options.reportResourcesMaximumSize = maxResourceSize;
    var maxResourcesCount = this.GetCurrentPlanLimitValue("MaxResources");
    if (maxResourcesCount) this.options.reportResourcesMaximumCount = maxResourcesCount;
    var maxFileSize = this.GetCurrentPlanLimitValue("MaxFileSize");
    if (maxFileSize) this.options.reportMaxFileSize = maxFileSize;
}

StiMobileDesigner.prototype.CheckSubscription = function () {
    if (this.GetCloudPlanNumberValue() == 512)
        this.BlockDesigner();
    else if (this.CheckUserTrExpired())
        this.CheckTrDays();
}

StiMobileDesigner.prototype.CheckTrDays = function () {
    var jsObject = this;
    var user = jsObject.options.cloudParameters.user;
    if (user && user.Days > 0 && user.Created) {
        try {
            var userCreated = jsObject.JSONDateFormatToDate(user.Created);
            var userTotalDays = Math.round((new Date().getTime() - userCreated.getTime()) / 1000 / 60 / 60 / 24);
            var daysLeft = user.Days - userTotalDays;
            if (daysLeft > 0) {
                setTimeout(function () {
                    jsObject.InitializeNotificationCheckTrDaysForm(function (form) {
                        form.show(daysLeft);
                    });
                }, 2000);
            }
        }
        catch (e) { console.log(e); }
    }
}

StiMobileDesigner.prototype.CheckGracePeriod = function (products) {
    var jsObject = this;

    var showNotification = function (days, product) {
        var cookieKey = "StimulsoftMobileDesignerSubscriptionsOut" + days + "_" + jsObject.options.shortProductVersion;

        if (StiMobileDesigner.GetCookie(cookieKey) != null) return;

        jsObject.InitializeNotificationForm(function (form) {
            var description = jsObject.loc.Notices.GracePeriod.replace("{0}", days);
            var imageName = "Notifications.SubscriptionsOut" + days + ".png";

            form.show(jsObject.loc.Notices.Warning, description, imageName);

            form.upgradeButton.caption.innerHTML = jsObject.loc.Cloud.ButtonRenew;

            form.upgradeButton.action = function () {
                var language = jsObject.options.standaloneJsMode ? (Stimulsoft.Base.Localization.StiLocalization.cultureName == "Russian" ? "ru" : "en") : (jsObject.IsRusCulture(jsObject.options.cultureName) ? "ru" : "en");
                var type = "?type=renewal";
                var sessionKey = jsObject.options.standaloneJsMode ? jsObject.options.SessionKey : (jsObject.options.cloudParameters ? jsObject.options.cloudParameters.sessionKey : null);
                var sessionKeyParam = sessionKey ? "&sessionKey=" + sessionKey : "";
                var license = product.License ? product.License.toLowerCase() : "";
                if (license == "site") license = "enterprise";

                var url = "https://www.stimulsoft.com/" + language + "/online-store/purchase/" + jsObject.GetUrlProductName(product.Ident) + type + sessionKeyParam;
                if (license) url += "&license=" + license;

                jsObject.openNewWindow(url);
                form.changeVisibleState(false);
            }

            StiMobileDesigner.SetCookie(cookieKey, "true");
        });
    }

    if (products) {
        try {
            var gracePeriod = 90;
            var firstMessageDays = 30;
            var secondMessageDays = 10;
            var nowTicks = new Date().getTime();

            for (var i = 0; i < products.length; i++) {
                var product = products[i];
                var expirationDate = jsObject.JSONDateFormatToDate(product.ExpirationDate);
                var deltaDays = Math.round((nowTicks - expirationDate.getTime()) / 1000 / 60 / 60 / 24);

                if (deltaDays > 0) {
                    var daysUntilEnd = gracePeriod - deltaDays;

                    if (daysUntilEnd <= firstMessageDays && daysUntilEnd >= firstMessageDays - 1 && daysUntilEnd > secondMessageDays) {
                        //30 days
                        showNotification(firstMessageDays, product);
                        return;
                    }
                    else if (daysUntilEnd <= secondMessageDays && daysUntilEnd >= secondMessageDays - 1 && daysUntilEnd > 0) {
                        //10 days
                        showNotification(secondMessageDays, product);
                        return;
                    }
                }
            }
        }
        catch (e) { console.log(e); }
    }
}

StiMobileDesigner.prototype.BlockDesigner = function () {
    var jsObject = this;
    jsObject.InitializeNotificationForm(function (form) {
        form.show(jsObject.NotificationMessages("cloudSubscriptionExpired"), jsObject.NotificationMessages("updateYourCloudSubscription"), "Notifications.Blocked.png", null, null, true);
        form.upgradeButton.caption.innerHTML = jsObject.loc.Cloud.ButtonRenew;

        var locLang = "en";
        var lang = jsObject.options.cultureName;
        if (lang == "ru" || lang == "be" || lang == "uk" || lang == "kz") locLang = "ru";
        if (lang == "de") locLang = "de";

        jsObject.options.designerIsBlocked = true;
        jsObject.HideAllDesignerControls(form);

        form.upgradeButton.action = function () {
            form.changeVisibleState(false);
            window.location.href = "https://www.stimulsoft.com/" + locLang + "/online-store#cloud/cloud";
        }

        form.cancelAction = function () {
            window.location.href = "https://www.stimulsoft.com/" + locLang + "/online-store#cloud/cloud";
        }
    });
}

StiMobileDesigner.prototype.CheckUserTrExpired = function () {
    var jsObject = this;
    var user = jsObject.options.cloudParameters ? jsObject.options.cloudParameters.user : null;

    if (user) {
        if (user.Expired) {
            jsObject.InitializeNotificationForm(function (form) {
                form.show(jsObject.NotificationMessages("trSubscriptionExpired"), jsObject.NotificationMessages("continueToUse"),
                    "Notifications.Time.png", null, jsObject.NotificationMessages("trSubscriptionExpiredDescription"));

                jsObject.options.designerIsBlocked = true;
                jsObject.HideAllDesignerControls(form);

                var link = jsObject.options.cloudMode ? "https://www.stimulsoft.com/en/online-store#cloud/cloud" : "https://www.stimulsoft.com/en/online-store";

                form.upgradeButton.action = function () {
                    form.changeVisibleState(false);
                    window.location.href = link;
                }

                form.cancelAction = function () {
                    window.location.href = link;
                }
            });
            return false;
        }
        else if (user.Enabled === false) {
            jsObject.InitializeNotificationForm(function (form) {
                form.show(jsObject.NotificationMessages("accountLocked"), jsObject.NotificationMessages("accountLockedDescription"), "Notifications.Blocked.png");

                form.upgradeButton.caption.innerHTML = jsObject.loc.Buttons.Ok.replace("&", "");

                form.upgradeButton.action = function () {
                    form.changeVisibleState(false);
                    jsObject.FinishSession();
                    jsObject.options.forms.authForm.show();
                }

                form.cancelAction = function () {
                    jsObject.FinishSession();
                    jsObject.options.forms.authForm.show();
                }
            });
            return false;
        }
    }

    return true;
}

StiMobileDesigner.prototype.CheckUserActivated = function () {
    var user = this.options.cloudParameters ? this.options.cloudParameters.user : null;

    if (user && user.Activated === false) {
        this.InitializeNotificationCheckActivatedForm(function (form) {
            form.show(user.UserName);
        });
        return false;
    }

    return true;
}

StiMobileDesigner.prototype.HideAllDesignerControls = function (currentForm) {
    for (var i = 0; i < this.options.mainPanel.childNodes.length; i++) {
        var child = this.options.mainPanel.childNodes[i];
        if (child != currentForm && child.style) child.style.display = "none";
    }
}

StiMobileDesigner.prototype.RunLicenseActivate = function (networkData) {
    var jsObject = this;

    var licenseActivate = function (machineName) {
        if (jsObject.options.cloudParameters && jsObject.options.cloudParameters.user) {
            var params = {
                UserName: jsObject.options.cloudParameters.user.UserName,
                Type: "Developer",
                Format: "Base64",
                ResultSvr: false,
                MachineName: machineName,
                Version: jsObject.options.shortProductVersion
            };
            jsObject.SendCloudCommand("LicenseActivate", params, function (data) {
                if (data.ResultLicenseKey && data.ResultLicenseKey.Products) {
                    jsObject.CheckGracePeriod(data.ResultLicenseKey.Products);
                }
            });
        }
    }

    if (networkData && networkData.ipAddress) {
        jsObject.SendCommandToDesignerServer("EncryptMachineName", { ipAddress: networkData.ipAddress, countryName: networkData.countryName }, function (answer) {
            licenseActivate(answer.machineName)
        });
    }
    else {
        licenseActivate();
    }
}

StiMobileDesigner.prototype.ConvertProductsToJSFormat = function (products) {
    var jsProducts = [];

    for (var i = 0; i < products.length; i++) {
        jsProducts.push({
            ident: this.options.productsIdents[products[i].Ident],
            expirationDate: this.JSONDateFormatToDate(products[i].ExpirationDate).getTime()
        });
    }

    return jsProducts;
}

StiMobileDesigner.prototype.showTrLog = function () {
    if (!this.options.cloudMode && !this.options.serverMode && !this.options.standaloneJsMode && this.options.alternateValid == false) {
        console.warn("You are using a trial version of the Stimulsoft product!");
    }
}

StiMobileDesigner.prototype.isGracePeriodOver = function (expirationDate) {
    if (expirationDate) {
        var gracePeriodTime = new Date(expirationDate.getTime()).setDate(expirationDate.getDate() + 91);
        var nowTime = new Date().getTime();

        return gracePeriodTime < nowTime;
    }
    return false;
}

StiMobileDesigner.prototype.sha256 = (function () {

    // Eratosthenes seive to find primes up to 311 for magic constants. This is why SHA256 is better than SHA1
    var i = 1,
        j,
        K = [],
        H = [];

    while (++i < 18) {
        for (j = i * i; j < 312; j += i) {
            K[j] = 1;
        }
    }

    function x(num, root) {
        return (Math.pow(num, 1 / root) % 1) * 4294967296 | 0;
    }

    for (i = 1, j = 0; i < 313;) {
        if (!K[++i]) {
            H[j] = x(i, 2);
            K[j++] = x(i, 3);
        }
    }

    function S(X, n) { return (X >>> n) | (X << (32 - n)); }

    function SHA256(b) {
        var HASH = H.slice(i = 0),
            s = unescape(encodeURI(b)), /* encode as utf8 */
            W = [],
            l = s.length,
            m = [],
            a, y, z;
        for (; i < l;) m[i >> 2] |= (s.charCodeAt(i) & 0xff) << 8 * (3 - i++ % 4);

        l *= 8;

        m[l >> 5] |= 0x80 << (24 - l % 32);
        m[z = (l + 64 >> 5) | 15] = l;

        for (i = 0; i < z; i += 16) {
            a = HASH.slice(j = 0, 8);

            for (; j < 64; a[4] += y) {
                if (j < 16) {
                    W[j] = m[j + i];
                } else {
                    W[j] =
                        (S(y = W[j - 2], 17) ^ S(y, 19) ^ (y >>> 10)) +
                        (W[j - 7] | 0) +
                        (S(y = W[j - 15], 7) ^ S(y, 18) ^ (y >>> 3)) +
                        (W[j - 16] | 0);
                }

                a.unshift(
                    (
                        y = (
                            a.pop() +
                            (S(b = a[4], 6) ^ S(b, 11) ^ S(b, 25)) +
                            (((b & a[5]) ^ ((~b) & a[6])) + K[j]) | 0
                        ) +
                        (W[j++] | 0)
                    ) +
                    (S(l = a[0], 2) ^ S(l, 13) ^ S(l, 22)) +
                    ((l & a[1]) ^ (a[1] & a[2]) ^ (a[2] & l))
                );
            }

            for (j = 8; j--;) HASH[j] = a[j] + HASH[j];

        }

        for (s = ''; j < 63;) s += ((HASH[++j >> 3] >> 4 * (7 - j % 8)) & 15).toString(16);

        return s;
    }

    return SHA256;
})();

StiMobileDesigner.prototype.getDeviceID = function () {
    var jsObject = this;

    var canvasID = function () {
        var canvas, ctx, width = 256, height = 128;
        canvas = document.createElement("canvas");
        canvas.width = width;
        canvas.height = height;
        ctx = canvas.getContext("webgl2") || canvas.getContext("experimental-webgl2") || canvas.getContext("webgl") || canvas.getContext("experimental-webgl") || canvas.getContext("moz-webgl");

        try {
            var f = "attribute vec2 attrVertex;varying vec2 varyinTexCoordinate;uniform vec2 uniformOffset;void main(){varyinTexCoordinate=attrVertex+uniformOffset;gl_Position=vec4(attrVertex,0,1);}";
            var g = "precision mediump float;varying vec2 varyinTexCoordinate;void main() {gl_FragColor=vec4(varyinTexCoordinate,0,1);}";
            var h = ctx.createBuffer();

            ctx.bindBuffer(ctx.ARRAY_BUFFER, h);

            var i = new Float32Array([-.2, -.9, 0, .4, -.26, 0, 0, .7321, 0]);

            ctx.bufferData(ctx.ARRAY_BUFFER, i, ctx.STATIC_DRAW), h.itemSize = 3, h.numItems = 3;

            var j = ctx.createProgram();
            var k = ctx.createShader(ctx.VERTEX_SHADER);

            ctx.shaderSource(k, f);
            ctx.compileShader(k);

            var l = ctx.createShader(ctx.FRAGMENT_SHADER);

            ctx.shaderSource(l, g);
            ctx.compileShader(l);
            ctx.attachShader(j, k);
            ctx.attachShader(j, l);
            ctx.linkProgram(j);
            ctx.useProgram(j);

            j.vertexPosAttrib = ctx.getAttribLocation(j, "attrVertex");
            j.offsetUniform = ctx.getUniformLocation(j, "uniformOffset");

            ctx.enableVertexAttribArray(j.vertexPosArray);
            ctx.vertexAttribPointer(j.vertexPosAttrib, h.itemSize, ctx.FLOAT, !1, 0, 0);
            ctx.uniform2f(j.offsetUniform, 1, 1);
            ctx.drawArrays(ctx.TRIANGLE_STRIP, 0, h.numItems);

        } catch (e) { }

        var m = "";

        var n = new Uint8Array(width * height * 4);
        ctx.readPixels(0, 0, width, height, ctx.RGBA, ctx.UNSIGNED_BYTE, n);
        m = JSON.stringify(n).replace(/,?"[0-9]+":/g, "");

        return jsObject.sha256(m);
    }

    var getWebGLContext = function () {
        var canvas = document.createElement('canvas');
        var context = canvas.getContext("webgl2") || canvas.getContext("experimental-webgl2") || canvas.getContext("webgl") || canvas.getContext("experimental-webgl") || canvas.getContext("moz-webgl");
        return context;
    }

    var deviceID = '';

    //Get info about video card
    var gl = getWebGLContext();
    if (gl) {
        var extension = gl.getExtension('WEBGL_debug_renderer_info');

        if (extension) {
            var vendor = gl.getParameter(extension.UNMASKED_VENDOR_WEBGL);
            var renderer = gl.getParameter(extension.UNMASKED_RENDERER_WEBGL);

            deviceID += vendor;
            deviceID += renderer;
        }

        var cID = canvasID();
        deviceID += cID;
    }

    //Get info about memory
    var availableMemory = navigator.deviceMemory;
    deviceID += availableMemory;

    ////Get info about CPU
    var cpuCores = navigator.hardwareConcurrency;
    deviceID += cpuCores;

    ////Get info about current platform
    var platform = navigator.platform;
    deviceID += platform;

    //Get info about timezone
    var d = new Date();
    var offset = d.getTimezoneOffset();
    deviceID += offset;

    return jsObject.sha256(deviceID);
}