import { MenuItem } from '../menu/meni-item.component';
import { ElementRef } from '@angular/core';
import { Observable } from 'rxjs';
import { PageService } from './page.service';
export declare class ComponentDescription {
    type: string;
    caption?: string;
    img?: string;
    action?: string;
    tooltip?: boolean;
    arrow?: string;
    menuItems?: MenuItem[];
    margin?: string;
    selected?: boolean;
    constructor(type: string, caption?: string, img?: string, action?: string, tooltip?: boolean, arrow?: string, menuItems?: MenuItem[], margin?: string, selected?: boolean);
}
export declare class ViewerEvent {
    name: string;
    value?: any;
    bookmarkPage?: number;
    bookmarkAnchor?: string;
    componentGuid?: string;
    constructor(name: string, value?: any, bookmarkPage?: number, bookmarkAnchor?: string, componentGuid?: string);
}
export declare class ControlClass {
    toolbar: ControlProps;
    reportPanel: ControlProps;
    drillDownPanel: ControlProps;
    findPanel: ControlProps;
    resourcesPanel: ControlProps;
    bookmarksPanel: ControlProps;
    navigatePanel: ControlProps;
    parametersPanel: ControlProps;
    dashboardsPanel: ControlProps;
    viewer: ControlProps;
    tooltip: ControlProps;
    aboutPanel: ControlProps;
    bookmarksLabel: any;
    constructor();
    get head(): HTMLHeadElement;
}
export declare class ControlProps {
    pageService?: PageService;
    el?: ElementRef;
    private _visible;
    private subject;
    enabled: boolean;
    layout: Rectangle;
    constructor(pageService?: PageService, el?: ElementRef);
    get offsetHeight(): number;
    get offsetWidth(): number;
    set visible(value: boolean);
    get visible(): boolean;
    getVisibility(): Observable<any>;
    get exists(): boolean;
}
export declare class Rectangle {
    width: number;
    height: number;
    left: number;
    bottom: number;
    right: number;
    private _top;
    set top(value: number);
    get top(): number;
    constructor(width?: number, height?: number, left?: number, bottom?: number, right?: number);
}
export declare class BookmarkNode {
    name?: string;
    url?: string;
    page?: number;
    compunentGuid?: string;
    nodes?: BookmarkNode[];
    open?: boolean;
    selected?: boolean;
    constructor(name?: string, url?: string, page?: number, compunentGuid?: string, nodes?: BookmarkNode[], open?: boolean, selected?: boolean);
}
export declare class InteractionParams {
    action?: string;
    drillDownParameters?: any;
    drillDownGuid?: string;
    dashboardDrillDownGuid?: string;
    variables?: any;
    sortingParameters?: any;
    collapsingParameters?: any;
    isBindingVariable?: true;
    constructor(action?: string, drillDownParameters?: any, drillDownGuid?: string, dashboardDrillDownGuid?: string, variables?: any, sortingParameters?: any, collapsingParameters?: any, isBindingVariable?: true);
}
export declare class InteractionObject {
    paramsVariables: any[];
    countColumns: any[];
    countInColumn: any[];
    constructor(paramsVariables: any[], countColumns: any[], countInColumn: any[]);
}
export declare class Variable {
    name?: string;
    alias?: string;
    description?: string;
    basicType?: string;
    type?: string;
    allowUserValues?: boolean;
    dateTimeType?: string;
    items?: Variable[];
    key?: any;
    value?: any;
    keyTo?: any;
    isChecked: boolean;
    focusOnCreate?: boolean;
    visible: boolean;
    binding?: boolean;
    isNull?: boolean;
    isFirstInitialization?: boolean;
    checkedStates?: boolean[];
    isChanged?: boolean;
    allowNullableString?: boolean;
    constructor(name?: string, alias?: string, description?: string, basicType?: string, type?: string, allowUserValues?: boolean, dateTimeType?: string, items?: Variable[], key?: any, value?: any, keyTo?: any, isChecked?: boolean, focusOnCreate?: boolean, visible?: boolean, binding?: boolean, isNull?: boolean, isFirstInitialization?: boolean, checkedStates?: boolean[], isChanged?: boolean, allowNullableString?: boolean);
}
export declare class DateTimeObject {
    year?: number;
    month?: number;
    day?: number;
    hours?: number;
    minutes?: number;
    seconds?: number;
    constructor(year?: number, month?: number, day?: number, hours?: number, minutes?: number, seconds?: number);
}
export declare class Item {
    name?: string;
    caption?: string;
    imageName?: string;
    key?: any;
    haveSubMenu?: boolean;
    imageSizes?: any;
    selected?: boolean;
    type?: string;
    constructor(name?: string, caption?: string, imageName?: string, key?: any, haveSubMenu?: boolean, imageSizes?: any, selected?: boolean, type?: string);
}
export declare class Message {
    action: string;
    data?: any;
    subAction?: string;
    constructor(action: string, data?: any, subAction?: string);
}
export declare class Form {
    name: string;
    left: number;
    top: number;
    isMooving: boolean;
    level?: number;
    formData?: any;
    constructor(name: string, left: number, top: number, isMooving?: boolean, level?: number, formData?: any);
}
export declare class ExportFormSettings {
    components: ExportComponent[];
    cSettings?: any;
    openAfterExport?: boolean;
    groups?: any;
    update?: boolean;
    constructor(components: ExportComponent[], cSettings?: any, openAfterExport?: boolean, groups?: any, update?: boolean);
}
export declare class ExportGroup {
    opened: boolean;
    constructor(opened: boolean);
}
export declare class ExportComponent {
    name: string;
    type: string;
    margin: string;
    label?: string;
    tooltip?: string;
    caption?: string;
    checked?: boolean;
    width?: number;
    disabled?: boolean;
    items?: Item[];
    key?: any;
    constructor(name: string, type: string, margin: string, label?: string, tooltip?: string, caption?: string, checked?: boolean, width?: number, disabled?: boolean, items?: Item[], key?: any);
}
export declare class DrillDown {
    caption: string;
    selected: boolean;
    reportParams: any;
    visible: boolean;
    constructor(caption: string, selected: boolean, reportParams: any, visible: boolean);
}
export declare class ErrorMessage {
    error: string;
    type: any;
    constructor(error: string, type: any);
}
export declare class Resource {
    name: string;
    type: string;
    alias: string;
    id?: string;
    constructor(name: string, type: string, alias: string, id?: string);
}
export declare class NotificationFormOptions {
    image?: string;
    message?: string;
    description?: string;
    buttonCaption?: string;
    cancelAction?: any;
    action?: any;
    constructor(image?: string, message?: string, description?: string, buttonCaption?: string, cancelAction?: any, action?: any);
}
