import { ModelService } from './model.service';
import { ControllerService } from './controller.service';
import { ExportService } from './export.service';
import { HelperService } from './helper.service';
import { MailService } from './mail.service';
import { FindService } from './find.service';
import { ApiInterface } from './api.service';
import { DashboardProxyService } from './dashboard-proxy.service';
import * as i0 from "@angular/core";
export declare class ApiDashboardService implements ApiInterface {
    private model;
    private controller;
    private exportService;
    private helper;
    private mailService;
    private findService;
    private proxy;
    EXPORT_FORMATS: string[];
    constructor(model: ModelService, controller: ControllerService, exportService: ExportService, helper: HelperService, mailService: MailService, findService: FindService, proxy: DashboardProxyService);
    /**
     * The current page number
     */
    get currentPage(): number;
    set currentPage(value: number);
    /**
     * The total pages count
     */
    get pagesCount(): any;
    /**
     * The view mode, can be 'SinglePage', 'Continuous' & 'MultiplePages'
     */
    get viewMode(): string;
    set viewMode(value: string);
    /**
     * The page zoom in percent
     * From 1 to 200
     */
    get zoom(): number;
    set zoom(value: number);
    /**
     * Zoom page in height
     */
    zoomPageHeight(): void;
    /**
     * Zoom page in width
     */
    zoomPageWidth(): void;
    /**
     * Print to PDF
     */
    printPdf(): void;
    /**
     * Print with preview
     */
    printWithPreview(): void;
    /**
     * Print without preview
     */
    printWithoutPreview(): void;
    get reportType(): string;
    /**
     * Show export form
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportForm(format: string): void;
    /**
     * Show export form & email
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportEmailForm(format: string): void;
    /**
     * Export report to selected format
     * Use default settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     */
    export(format: string, settings?: any): void;
    /**
     * Export dashboard to selected format
     * Use default settings if not specified
     *
     * @param format The format to export, can be 'Pdf', 'Html', 'Excel', 'Image'
     *
     * @param settings The export settings
     */
    dashboardExport(format: string, settings?: any): void;
    /**
     * Export report to seleted format & email
     * Use default settings if not specified
     * Use default email settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     *
     * @param email The email
     *
     * @param message The email message
     *
     * @param subject The email subject
     */
    exportEmail(format: string, settings?: any, email?: string, subject?: string, message?: string): void;
    /**
     * Search text in report
     *
     * @param text text to search
     *
     * @param matchCase
     *
     * @param matchWholeWord
     */
    search(text: string, matchCase: boolean, matchWholeWord: boolean): void;
    /**
     * Select next or previous search
     *
     * @param direction 'Next' or 'Previous'
     *
     */
    selectSearchLabel(direction: string): void;
    /**
     * Hide search
     */
    hideSearchLabels(): void;
    /**
     * Refresh dashboard
     */
    dashboardRefresh(): void;
    dashboardResetAllFilters(): void;
    private getExportSettings;
    private getDefaultDashboardSettings;
    static ɵfac: i0.ɵɵFactoryDeclaration<ApiDashboardService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ApiDashboardService>;
}
