import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./controller.service";
import * as i3 from "./editable-fields.service";
import * as i4 from "./interactions.service";
import * as i5 from "./helper.service";
import * as i6 from "./export.service";
export class ToolbarService {
    constructor(model, controller, editableFieldsService, interactionService, helper, exportService) {
        this.model = model;
        this.controller = controller;
        this.editableFieldsService = editableFieldsService;
        this.interactionService = interactionService;
        this.helper = helper;
        this.exportService = exportService;
        this.comps = [];
        this.dopComps = [];
        this.controller.getMessage().subscribe((message) => {
            if (message.action !== 'viewer_loaded') {
                this.updateButtons();
            }
        });
    }
    updateButtons() {
        this.comps.filter(i => i.action === 'ViewMode').forEach(m => m.caption = this.model.loc(this.model.reportParams.viewMode));
        this.comps.filter(i => i.action === 'Zoom').forEach((m) => {
            m.menuItems.forEach(n => n.selected = n.name === ('Zoom' + this.model.reportParams.zoom));
            m.caption = this.model.reportParams.zoom ? Math.round(this.model.reportParams.zoom) + '%' : '';
        });
        this.comps.filter(i => i.action === 'ShowFind').forEach((m) => {
            m.selected = this.model.controls.findPanel.visible;
        });
    }
    initButtons() {
        const comps = [];
        const dopComps = [];
        let isFirst = false;
        if (this.model.options.toolbar.showAboutButton) {
            dopComps.push({ type: 'button', action: 'About', img: 'Help.png' });
        }
        if (this.model.options.toolbar.showAboutButton && this.model.options.toolbar.showDesignButton) {
            dopComps.push({ type: 'separator' });
        }
        if (this.model.options.toolbar.showDesignButton) {
            dopComps.push({ type: 'button', action: 'Design', caption: this.model.loc('Design'), img: 'Design.png' });
        }
        if (this.model.options.toolbar.showPinToolbarButton && this.model.options.toolbar.showDesignButton) {
            dopComps.push({ type: 'separator' });
        }
        if (this.model.options.toolbar.showPinToolbarButton) {
            dopComps.push({ type: 'button', action: 'Pin', img: 'Pin.png' });
        }
        if (this.model.options.toolbar.showPrintButton) {
            comps.push({
                type: 'button', action: 'Print', caption: this.model.loc('Print'), img: 'Print.png', tooltip: true,
                arrow: this.model.options.toolbar.printDestination === 'Default' ? 'Down' : null,
                menuItems: this.model.options.toolbar.printDestination === 'Default' ?
                    [{ name: 'PrintPdf', caption: this.model.loc('PrintPdf'), img: 'Save.Small.Pdf.png' },
                        { name: 'PrintWithPreview', caption: this.model.loc('PrintWithPreview'), img: 'ViewMode.png' },
                        { name: 'PrintWithoutPreview', caption: this.model.loc('PrintWithoutPreview'), img: 'Print.png' }] :
                    null
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showOpenButton) {
            comps.push({ type: 'button', action: 'Open', caption: this.model.loc('Open'), img: 'Open.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showSaveButton) {
            comps.push({
                type: 'button', action: 'Save', caption: this.model.loc('Save'), img: 'Save.png', tooltip: true, arrow: 'Down',
                menuItems: this.getSaveMenuItems('saveMenu')
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showSendEmailButton) {
            comps.push({
                type: 'button', action: 'SendEmail', caption: this.model.loc('SendEmail'), img: 'SendEmail.png', tooltip: true, arrow: 'Down',
                menuItems: this.getSaveMenuItems('sendEmailMenu')
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showBookmarksButton || this.model.options.toolbar.showParametersButton) {
            if (!isFirst) {
                comps.push({ type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.toolbar.showBookmarksButton) {
            comps.push({ type: 'button', action: 'Bookmarks', caption: this.model.options.toolbar.displayMode === 'Separated' ? this.model.loc('Bookmarks') : null, img: 'Bookmarks.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showParametersButton) {
            comps.push({ type: 'button', action: 'Parameters', caption: this.model.options.toolbar.displayMode === 'Separated' ? this.model.loc('Parameters') : null, img: 'Parameters.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showResourcesButton) {
            comps.push({ type: 'button', action: 'Resources', caption: this.model.options.toolbar.displayMode === 'Separated' ? this.model.loc('Resources') : null, img: 'Resources.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showFindButton || this.model.options.toolbar.showEditorButton) {
            if (!isFirst) {
                comps.push({ type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.toolbar.showFindButton) {
            comps.push({ type: 'button', action: 'Find', img: 'Find.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showEditorButton) {
            comps.push({ type: 'button', action: 'Editor', img: 'Editor.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.displayMode !== 'Separated') {
            if (this.model.options.toolbar.showFirstPageButton || this.model.options.toolbar.showPreviousPageButton || this.model.options.toolbar.showNextPageButton ||
                this.model.options.toolbar.showLastPageButton || this.model.options.toolbar.showCurrentPageControl) {
                if (!isFirst) {
                    comps.push({ type: 'separator' });
                }
                isFirst = false;
            }
            if (this.model.options.toolbar.showFirstPageButton) {
                comps.push({ type: 'button', action: 'FirstPage', img: this.model.options.appearance.rightToLeft ? 'LastPage.png' : 'FirstPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showPreviousPageButton) {
                comps.push({ type: 'button', action: 'PrevPage', img: this.model.options.appearance.rightToLeft ? 'NextPage.png' : 'PrevPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showCurrentPageControl) {
                comps.push({ type: 'pageControl' });
                isFirst = false;
            }
            if (this.model.options.toolbar.showNextPageButton) {
                comps.push({ type: 'button', action: 'NextPage', img: this.model.options.appearance.rightToLeft ? 'PrevPage.png' : 'NextPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showLastPageButton) {
                comps.push({ type: 'button', action: 'LastPage', img: this.model.options.appearance.rightToLeft ? 'FirstPage.png' : 'LastPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showViewModeButton || this.model.options.toolbar.showZoomButton) {
                if (!isFirst) {
                    comps.push({ type: 'separator' });
                }
                isFirst = false;
            }
        }
        if (this.model.options.toolbar.showFullScreenButton) {
            comps.push({ type: 'button', action: 'FullScreen', img: 'FullScreen.png', tooltip: true });
            comps.push({ type: 'separator' });
            isFirst = false;
        }
        if (this.model.options.toolbar.showZoomButton && this.model.options.toolbar.displayMode !== 'Separated') {
            comps.push({
                type: 'button', action: 'Zoom', caption: '100%', img: 'Zoom.png', tooltip: true, arrow: 'Down',
                menuItems: this.helper.getZoomMenuItems()
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showViewModeButton) {
            comps.push({
                type: 'button', action: 'ViewMode', caption: this.model.loc('SinglePage'), img: 'SinglePage.png', tooltip: true, arrow: 'Down',
                menuItems: [{ name: 'ViewModeSinglePage', caption: this.model.loc('SinglePage'), img: 'SinglePage.png' },
                    { name: 'ViewModeContinuous', caption: this.model.loc('Continuous'), img: 'Continuous.png' },
                    { name: 'ViewModeMultiplePages', caption: this.model.loc('MultiplePages'), img: 'MultiplePages.png' }]
            });
            isFirst = false;
        }
        if (typeof (this.model.options.toolbar.multiPageWidthCount) !== 'undefined') {
            this.model.reportParams.multiPageWidthCount = this.model.options.toolbar.multiPageWidthCount;
        }
        if (typeof (this.model.options.toolbar.multiPageHeightCount) !== 'undefined') {
            this.model.reportParams.multiPageHeightCount = this.model.options.toolbar.multiPageHeightCount;
        }
        if (!this.model.options.appearance.rightToLeft && this.model.options.toolbar.alignment === 'right' &&
            (this.model.options.toolbar.showPinToolbarButton || this.model.options.toolbar.showAboutButton || this.model.options.toolbar.showDesignButton)) {
            comps.push({ type: 'separator6' });
        }
        this.comps = this.model.options.appearance.rightToLeft ? comps.reverse() : comps;
        this.dopComps = this.model.options.appearance.rightToLeft ? dopComps.reverse() : dopComps;
    }
    disableNaviButtons() {
        return this.model.reportParams.viewMode === 'MultiplePages' || this.model.reportParams.viewMode === 'WholeReport' ||
            (this.model.reportParams.viewMode === 'Continuous' && !this.model.options.appearance.scrollbarsMode && !this.model.options.appearance.fullScreenMode);
    }
    getImage(imageName) {
        switch (this.model.options.appearance.saveMenuImageSize) {
            case 'Big':
                return `Save.Big.${imageName}.png`;
            case 'None':
                return null;
            default:
                return `Save.Small.${imageName}.png`;
        }
    }
    getSaveMenuItems(menuName) {
        let isFirst = true;
        const items = [];
        const imageSize = this.model.options.appearance.saveMenuImageSize;
        if (this.model.options.exports.showExportToDocument && menuName === 'saveMenu') {
            items.push({ name: menuName + 'Document', caption: this.model.loc('ReportSnapshot'), imageSize, img: this.getImage('Document') });
            isFirst = false;
        }
        if (menuName === 'saveMenu' && this.model.options.exports.showExportToPdf || this.model.options.exports.showExportToXps || this.model.options.exports.showExportToPowerPoint) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.exports.showExportToPdf) {
            items.push({ name: menuName + 'Pdf', caption: 'Adobe PDF', imageSize, img: this.getImage('Pdf') });
        }
        if (this.model.options.exports.showExportToXps) {
            items.push({ name: menuName + 'Xps', caption: 'Microsoft XPS', imageSize, img: this.getImage('Xps') });
        }
        if (this.model.options.exports.showExportToPowerPoint) {
            items.push({ name: menuName + 'PowerPoint', caption: 'Microsoft PowerPoint', imageSize, img: this.getImage('Ppt') });
        }
        if (this.model.options.exports.showExportToHtml || this.model.options.exports.showExportToHtml5 || this.model.options.exports.showExportToMht) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
            let htmlType = this.model.options.exports.defaultSettings['StiHtmlExportSettings'].HtmlType;
            if (!this.model.options.exports['showExportTo' + htmlType]) {
                if (this.model.options.exports.showExportToHtml) {
                    htmlType = 'Html';
                }
                else if (this.model.options.exports.showExportToHtml5) {
                    htmlType = 'Html5';
                }
                else if (this.model.options.exports.showExportToMht) {
                    htmlType = 'Mht';
                }
            }
            items.push({ name: menuName + htmlType, caption: 'HTML', imageSize, img: this.getImage('Html') });
        }
        if (this.model.options.exports.showExportToText || this.model.options.exports.showExportToRtf || this.model.options.exports.showExportToWord || this.model.options.exports.showExportToOdt) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.exports.showExportToText) {
            items.push({ name: menuName + 'Text', caption: this.model.loc('Text'), imageSize, img: this.getImage('Text') });
        }
        if (this.model.options.exports.showExportToRtf) {
            items.push({ name: menuName + 'Rtf', caption: 'RTF', imageSize, img: this.getImage('Rtf') });
        }
        if (this.model.options.exports.showExportToWord) {
            items.push({ name: menuName + 'Word', caption: 'Microsoft Word', imageSize, img: this.getImage('Word') });
        }
        if (this.model.options.exports.showExportToOpenDocumentWriter) {
            items.push({ name: menuName + 'Odt', caption: 'OpenDocument Writer', imageSize, img: this.getImage('Odt') });
        }
        if (this.model.options.exports.showExportToExcelBiff || this.model.options.exports.showExportToExcel || this.model.options.exports.showExportToExcelXml || this.model.options.exports.showExportToOpenDocumentWriter) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.exports.showExportToExcelBiff || this.model.options.exports.showExportToExcelXml || this.model.options.exports.showExportToExcel) {
            let excelType = this.exportService.getStoredSettings('Excel')?.ExcelType ?? this.model.options.exports.defaultSettings['StiExcelExportSettings'].ExcelType;
            if (!this.model.options.exports['showExportTo' + excelType]) {
                if (this.model.options.exports.showExportToExcel) {
                    excelType = 'Excel';
                }
                else if (this.model.options.exports.showExportToExcelBiff) {
                    excelType = 'ExcelBiff';
                }
                else if (this.model.options.exports.showExportToExcelXml) {
                    excelType = 'ExcelXml';
                }
            }
            items.push({ name: menuName + excelType, caption: 'Microsoft Excel', imageSize, img: this.getImage('Excel') });
        }
        if (this.model.options.exports.showExportToOpenDocumentCalc) {
            items.push({ name: menuName + 'Ods', caption: 'OpenDocument Calc', imageSize, img: this.getImage('Ods') });
        }
        if (this.model.options.exports.showExportToCsv || this.model.options.exports.showExportToDbf || this.model.options.exports.showExportToXml ||
            this.model.options.exports.showExportToDif || this.model.options.exports.showExportToSylk || this.model.options.exports.showExportToJson) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
            let dataType = this.model.options.exports.defaultSettings['StiDataExportSettings'].DataType;
            if (!this.model.options.exports['showExportTo' + dataType]) {
                if (this.model.options.exports.showExportToCsv) {
                    dataType = 'Csv';
                }
                else if (this.model.options.exports.showExportToDbf) {
                    dataType = 'Dbf';
                }
                else if (this.model.options.exports.showExportToXml) {
                    dataType = 'Xml';
                }
                else if (this.model.options.exports.showExportToDif) {
                    dataType = 'Dif';
                }
                else if (this.model.options.exports.showExportToSylk) {
                    dataType = 'Sylk';
                }
                else if (this.model.options.exports.showExportToJson) {
                    dataType = 'Json';
                }
            }
            items.push({ name: menuName + dataType, caption: this.model.loc('Data'), imageSize, img: this.getImage('Data') });
        }
        if (this.model.options.exports.showExportToImageBmp || this.model.options.exports.showExportToImageGif || this.model.options.exports.showExportToImageJpeg || this.model.options.exports.showExportToImagePcx ||
            this.model.options.exports.showExportToImagePng || this.model.options.exports.showExportToImageTiff || this.model.options.exports.showExportToImageMetafile || this.model.options.exports.showExportToImageSvg || this.model.options.exports.showExportToImageSvgz) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
            let imageType = this.model.options.exports.defaultSettings['StiImageExportSettings'].ImageType;
            let imageType_ = imageType === 'Emf' ? 'Metafile' : imageType;
            if (!this.model.options.exports['showExportToImage' + imageType_]) {
                if (this.model.options.exports.showExportToImageBmp) {
                    imageType = 'Bmp';
                }
                else if (this.model.options.exports.showExportToImageGif) {
                    imageType = 'Gif';
                }
                else if (this.model.options.exports.showExportToImageJpeg) {
                    imageType = 'Jpeg';
                }
                else if (this.model.options.exports.showExportToImagePcx) {
                    imageType = 'Pcx';
                }
                else if (this.model.options.exports.showExportToImagePng) {
                    imageType = 'Png';
                }
                else if (this.model.options.exports.showExportToImageTiff) {
                    imageType = 'Tiff';
                }
                else if (this.model.options.exports.showExportToImageMetafile) {
                    imageType = 'Emf';
                }
                else if (this.model.options.exports.showExportToImageSvg) {
                    imageType = 'Svg';
                }
                else if (this.model.options.exports.showExportToImageSvgz) {
                    imageType = 'Svgz';
                }
            }
            items.push({ name: menuName + 'Image' + imageType, caption: this.model.loc('Image'), imageSize, img: this.getImage('Image') });
        }
        return items;
    }
    enabled(desc) {
        const disableNaviButtons = this.disableNaviButtons();
        switch (desc.action) {
            case 'FirstPage':
            case 'PrevPage':
                return this.model.reportParams.pageNumber > 0 && !disableNaviButtons;
            case 'NextPage':
            case 'LastPage':
                return this.model.reportParams.pageNumber < this.model.reportParams.pagesCount - 1 && !disableNaviButtons;
            case 'Bookmarks':
                return this.model.reportParams.bookmarksContent != null;
            case 'Parameters':
                return this.model.interactions?.paramsVariables != null;
            case 'Resources':
                return this.model.reportParams.resources?.length > 0;
        }
        return true;
    }
    selected(desc) {
        switch (desc.action) {
            case 'Find':
                return this.model.controls.findPanel.visible;
            case 'Bookmarks':
                return this.model.controls.bookmarksPanel.visible;
            case 'Parameters':
                return this.model.controls.parametersPanel.visible;
            case 'Editor':
                return this.editableFieldsService.visible;
            case 'Resources':
                return this.model.controls.resourcesPanel.visible;
            case 'FullScreen':
                return this.model.options.appearance.fullScreenMode;
            case 'Pin':
                return !this.model.options.toolbar.autoHide;
        }
        return false;
    }
    display(desc) {
        switch (desc.action) {
            case 'Editor':
                return this.model.reportParams.isEditableReport ? '' : 'none';
        }
        return '';
    }
    getButonWidth(comp) {
        if (this.model.options.toolbar.displayMode === 'Separated') {
            if (comp.action === 'Find' || comp.action === 'Editor' || comp.action === 'FullScreen' || comp.action === 'About') {
                return '28px';
            }
            if (this.model.options.isMobileDevice) {
                return '0.4in';
            }
        }
        return null;
    }
    getInnerTableWidth(comp) {
        if (this.model.options.toolbar.displayMode === 'Separated' &&
            (this.model.options.isMobileDevice || comp.action === 'Find' || comp.action === 'Editor' || comp.action === 'FullScreen' || comp.action === 'About')) {
            return '100%';
        }
        return null;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ToolbarService, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.EditableFieldsService }, { token: i4.InteractionsService }, { token: i5.HelperService }, { token: i6.ExportService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ToolbarService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ToolbarService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.EditableFieldsService }, { type: i4.InteractionsService }, { type: i5.HelperService }, { type: i6.ExportService }] });
//# sourceMappingURL=data:application/json;base64,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