import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StylesService {
    constructor(model) {
        this.model = model;
        this.pagesCss = {};
    }
    setupStyle(style, id) {
        if (this.pagesCss[id] == null) {
            this.pagesCss[id] = document.createElement('STYLE');
            this.pagesCss[id].id = this.model.options?.viewerId + 'Styles';
            this.pagesCss[id].setAttribute('type', 'text/css');
            if (this.model?.options?.cSPNonce) {
                this.pagesCss[id].setAttribute('nonce', this.model.options.cSPNonce);
            }
            this.model.controls.head.appendChild(this.pagesCss[id]);
        }
        if (this.pagesCss[id].styleSheet) {
            this.pagesCss[id].styleSheet.cssText = style;
        }
        else {
            this.pagesCss[id].innerHTML = style;
        }
    }
    addCustomFontStyles(customFonts) {
        if (!customFonts) {
            return;
        }
        let existsStyles = [];
        try {
            existsStyles = document.getElementsByTagName('head')[0].getElementsByTagName('style');
        }
        catch (e) { }
        customFonts.forEach((customFont) => {
            if (customFont.contentForCss && customFont.originalFontFamily) {
                const style = document.createElement('style');
                style.innerHTML = `@font-face {\r\nfont-family: '${customFont.originalFontFamily}';\r\n src: url(${customFont.contentForCss});\r\n }`;
                let existsThisStyle = false;
                for (const estyle of existsStyles) {
                    if (estyle.innerHTML.indexOf(`font-family: '${customFont.originalFontFamily}'`) > 0) {
                        existsThisStyle = true;
                        break;
                    }
                }
                if (!existsThisStyle) {
                    document.getElementsByTagName('head')[0].appendChild(style);
                }
            }
        });
    }
    addChartScript(script) {
        const currChartScripts = document.getElementById(this.model.options.viewerId + 'chartScriptJsViewer');
        if (currChartScripts) {
            this.model.controls.head.removeChild(currChartScripts);
        }
        if (script) {
            const chartScripts = document.createElement('Script');
            chartScripts.setAttribute('type', 'text/javascript');
            chartScripts.setAttribute('nonce', 'stichartanimation'); //used for Content-Security-Policy
            chartScripts.id = this.model.options.viewerId + 'chartScriptJsViewer';
            chartScripts.textContent = script;
            this.model.controls.head.appendChild(chartScripts);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StylesService, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StylesService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StylesService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }] });
//# sourceMappingURL=data:application/json;base64,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