import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./export.service";
import * as i3 from "./helper.service";
import * as i4 from "./http-client.service";
import * as i5 from "./controller.service";
export class PrintService {
    constructor(model, exportService, helper, httpClient, controller) {
        this.model = model;
        this.exportService = exportService;
        this.helper = helper;
        this.httpClient = httpClient;
        this.controller = controller;
        controller.getActionMessage().subscribe((message) => {
            if (message.action === 'Print' && !this.model.showDashboard) {
                this.postPrint(message.data.format);
            }
        });
        controller.getMessage().subscribe((message) => {
            if (message.action === 'PrintReport') {
                switch (message.subAction) {
                    case 'PrintWithPreview':
                        this.printAsPopup(message.data);
                        break;
                    case 'PrintWithoutPreview':
                        this.printAsHtml(message.data);
                        break;
                }
            }
        });
    }
    postPrint(printAction) {
        if (printAction === 'PrintPdf' && /iPhone|iPad|iPod|Macintosh/i.test(navigator.userAgent) && this.helper.isTouchDevice() && !this.model.options.replaceHtmlFormWithRequest) {
            const settings = this.exportService.getDefaultExportSettings('Pdf');
            settings.OpenAfterExport = true;
            this.postExport('Pdf', settings);
            return;
        }
        const data = {
            action: 'PrintReport',
            printAction,
            bookmarksPrint: this.model.options.appearance.bookmarksPrint
        };
        const url = ''; // this.model.options.requestUrl.replace('{action}', this.model.options.actions.printReport);
        switch (printAction) {
            case 'PrintPdf':
                if (this.model.options.appearance.printToPdfMode === 'Popup' || this.helper.getNavigatorName() == 'Safari' || this.helper.getNavigatorName() == 'iPad') {
                    this.printAsPdfPopup(data);
                }
                else {
                    this.printAsPdf(url, data);
                }
                break;
            default:
                this.controller.post('PrintReport', this.model.options.actions.printReport, data, 'text', printAction);
                break;
        }
    }
    postExport(format, settings, elementName, isDashboardExport) {
        const data = {
            action: isDashboardExport ? 'ExportDashboard' : 'ExportReport',
            exportFormat: format,
            exportSettings: settings,
            elementName
        };
        const doc = settings && settings.OpenAfterExport && this.model.options.appearance.openExportedReportWindow === '_blank' ? (!this.model.options.replaceHtmlFormWithRequest ? this.helper.openNewWindow('about:blank', '_blank').document : document) : null;
        const url = this.model.requestUrl;
        this.httpClient.postForm(url.replace('{action}', this.model.options.actions.exportReport), data, doc);
    }
    printAsPdfPopup(data) {
        const url = this.model.requestUrl.replace('{action}', this.model.options.actions.printReport);
        const win = !this.model.options.replaceHtmlFormWithRequest ? this.helper.openNewWindow('about:blank', '_blank') : window;
        if (win != null) {
            this.httpClient.postForm(url, data, win.document, false, false);
        }
    }
    printAsPdf(url, data) {
        data.responseType = 'blob';
        const viewer = this.model.controls.viewer.el.nativeElement;
        const printFrameId = this.model.options.viewerId + '_PdfPrintFrame';
        let printFrame = document.getElementById(printFrameId);
        if (printFrame) {
            viewer.removeChild(printFrame);
        }
        printFrame = document.createElement('iframe');
        printFrame.id = printFrameId;
        printFrame.name = printFrameId;
        printFrame.width = '0';
        printFrame.height = '0';
        printFrame.style.position = 'absolute';
        printFrame.style.border = 'none';
        // Firefox does not load the invisible content of the iframe
        if (this.helper.getNavigatorName() === 'Mozilla') {
            printFrame.width = '100px';
            printFrame.height = '100px';
            printFrame.style.visibility = 'hidden';
            printFrame.style.zIndex = '-100';
            printFrame.style.pointerEvents = 'none';
        }
        viewer.insertBefore(printFrame, viewer.firstChild);
        const params = this.model.createPostParameters(data, true);
        // Manual printing in browsers that do not support automatic PDF printing
        if (this.helper.getNavigatorName() !== 'Mozilla') {
            printFrame.onload = () => {
                printFrame.contentWindow.focus();
                printFrame.contentWindow.print();
            };
        }
        if (!this.model.options.replaceHtmlFormWithRequest) {
            const form = document.createElement('FORM');
            form.setAttribute('id', 'printForm');
            form.setAttribute('method', 'POST');
            form.setAttribute('action', this.model.requestUrl.replace('{action}', this.model.options.actions.printReport));
            form.setAttribute('target', this.model.options.viewerId + '_PdfPrintFrame');
            Object.keys(params).forEach(key => {
                const paramsField = document.createElement('INPUT');
                paramsField.setAttribute('type', 'hidden');
                paramsField.setAttribute('name', key);
                paramsField.setAttribute('value', params[key]);
                form.appendChild(paramsField);
            });
            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        }
        else {
            this.httpClient.getData(this.model.requestUrl.replace('{action}', this.model.options.actions.printReport), params).subscribe((data) => {
                printFrame.src = URL.createObjectURL(data);
            });
        }
    }
    blobToBase64(blob) {
        return new Promise((resolve, _) => {
            const reader = new FileReader();
            reader.onloadend = () => resolve(reader.result);
            reader.readAsDataURL(blob);
        });
    }
    printAsPopup(text) {
        const width = this.model.reportParams.pagesWidth || 790;
        const win = this.helper.openNewWindow('about:blank', 'PrintReport', 'height=900,width=' + width + ',toolbar=no,menubar=yes,scrollbars=yes,resizable=yes,location=no,directories=no,status=no');
        if (win != null) {
            win.document.open();
            win.document.write(text);
            win.document.close();
        }
    }
    printAsHtml(text) {
        if (this.controller.showError(text)) {
            return;
        }
        const viewer = this.model.controls.viewer.el.nativeElement;
        // Remove '_PdfPrintFrame', this should fix IE strange error
        let printFrameId = this.model.options.viewerId + '_PdfPrintFrame';
        let printFrame = document.getElementById(printFrameId);
        if (printFrame) {
            viewer.removeChild(printFrame);
        }
        printFrameId = this.model.options.viewerId + '_HtmlPrintFrame';
        printFrame = document.getElementById(printFrameId);
        if (printFrame) {
            viewer.removeChild(printFrame);
        }
        printFrame = document.createElement('iframe');
        printFrame.id = printFrameId;
        printFrame.name = printFrameId;
        printFrame.width = '0';
        printFrame.height = '0';
        printFrame.style.position = 'absolute';
        printFrame.style.border = 'none';
        viewer.insertBefore(printFrame, viewer.firstChild);
        printFrame.contentWindow.document.open();
        printFrame.contentWindow.document.write(text);
        printFrame.contentWindow.document.close();
        setTimeout(() => {
            printFrame.contentWindow.focus();
            printFrame.contentWindow.print();
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PrintService, deps: [{ token: i1.ModelService }, { token: i2.ExportService }, { token: i3.HelperService }, { token: i4.StiHttpClientService }, { token: i5.ControllerService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PrintService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PrintService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ExportService }, { type: i3.HelperService }, { type: i4.StiHttpClientService }, { type: i5.ControllerService }] });
//# sourceMappingURL=data:application/json;base64,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