import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./controller.service";
import * as i2 from "./model.service";
import * as i3 from "./helper.service";
export class EditableFieldsService {
    constructor(controller, model, helper) {
        this.controller = controller;
        this.model = model;
        this.helper = helper;
        this.visible = false;
        this.editableFields = [];
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Editor':
                    this.visible = !this.visible;
                    if (this.visible) {
                        this.showAllEditableFields();
                    }
                    else {
                        this.hideAllEditableFields();
                    }
                    break;
            }
        });
        controller.getMessage().subscribe((message) => {
            if (message.action === 'GetPages' && this.visible) {
                setTimeout(() => this.showAllEditableFields());
            }
            else {
                this.visible = false;
            }
        });
    }
    showAllEditableFields() {
        this.editableFields = [];
        this.model.pages.forEach((page, pageIndex) => {
            const pageElements = page.page.getElementsByTagName('*');
            for (const pageElement of pageElements) {
                const editableStrAttr = pageElement.getAttribute('editable');
                if (editableStrAttr) {
                    const attrArray = editableStrAttr.split(';');
                    const params = {};
                    params.compIndex = attrArray[0];
                    params.pageIndex = this.model.reportParams.viewMode === 'SinglePage' ? this.model.reportParams.pageNumber : pageIndex.toString();
                    params.type = attrArray[1];
                    if (params.type === 'CheckBox') {
                        this.showCheckBoxEditableField(pageElement, params, attrArray);
                    }
                    else if (params.type === 'Text') {
                        this.showTextEditableField(pageElement, params);
                    }
                    else if (params.type === 'RichText') {
                        this.showRichTextEditableField(pageElement, params);
                    }
                }
            }
        });
    }
    hideAllEditableFields() {
        if (this.currentEditableTextArea) {
            this.currentEditableTextArea.onblur();
        }
        this.editableFields.forEach((eField) => {
            eField.className = eField.className.replace(' stiEditableField stiEditableFieldSelected', '');
            eField.onclick = null;
            eField.style.outline = '';
        });
    }
    showCheckBoxEditableField(editableCell, params, attrArray) {
        if (!editableCell.sizes) {
            let imgElements = editableCell.getElementsByTagName('IMG');
            if (imgElements.length === 0) {
                imgElements = editableCell.getElementsByTagName('SVG');
            }
            if (imgElements.length === 0) {
                imgElements = editableCell.getElementsByTagName('svg');
            }
            const imgElement = (imgElements.length > 0) ? imgElements[0] : null;
            if (!imgElement) {
                return;
            }
            if (imgElement.offsetWidth) {
                editableCell.sizes = {
                    inPixels: imgElement.offsetWidth > imgElement.offsetHeight ? imgElement.offsetHeight : imgElement.offsetWidth,
                    widthStyle: imgElement.style.width,
                    heightStyle: imgElement.style.height
                };
            }
            else {
                editableCell.sizes = {
                    inPixels: imgElement.clientWidth > imgElement.clientHeight ? imgElement.clientHeight : imgElement.clientWidth,
                    widthStyle: imgElement.clientWidth + 'px',
                    heightStyle: imgElement.clientHeight + 'px'
                };
            }
        }
        if (this.helper.getNavigatorName() !== 'Google Chrome') {
            editableCell.style.outline = '1px solid gray';
        }
        editableCell.style.textAlign = 'center';
        editableCell.className += ' stiEditableField stiEditableFieldSelected';
        const trueSvgImage = this.getSvgCheckBox(attrArray[3], attrArray[5], this.helper.strToInt(attrArray[6]), attrArray[7], editableCell.sizes.inPixels);
        const falseSvgImage = this.getSvgCheckBox(attrArray[4], attrArray[5], this.helper.strToInt(attrArray[6]), attrArray[7], editableCell.sizes.inPixels);
        params.falseImage = `<div style="width: ${editableCell.sizes.widthStyle}; height: ${editableCell.sizes.heightStyle}; "> ${trueSvgImage}  </div>`;
        params.trueImage = `<div style="width: ${editableCell.sizes.widthStyle}; height: ${editableCell.sizes.heightStyle}; "> ${falseSvgImage} </div>`;
        params.checked = attrArray[2] === 'true' || attrArray[2] === 'True';
        editableCell.params = params;
        if (!editableCell.hasChanged) {
            editableCell.checked = params.checked;
            editableCell.innerHTML = params.checked ? params.trueImage : params.falseImage;
        }
        editableCell.onclick = () => {
            editableCell.checked = !editableCell.checked;
            editableCell.innerHTML = editableCell.checked ? params.trueImage : params.falseImage;
            editableCell.hasChanged = true;
            this.addEditableParameters(editableCell);
        };
        this.editableFields.push(editableCell);
    }
    showTextEditableField(editableCell, params) {
        editableCell.className += ' stiEditableField stiEditableFieldSelected';
        if (this.helper.getNavigatorName() !== 'Google Chrome') {
            editableCell.style.outline = '1px solid gray';
        }
        editableCell.params = params;
        editableCell.jsObject = this;
        editableCell.onclick = () => {
            if (editableCell.editMode) {
                return;
            }
            if (this.currentEditableTextArea) {
                this.currentEditableTextArea.onblur();
            }
            editableCell.editMode = true;
            const textArea = document.createElement('textarea');
            textArea.style.width = (editableCell.offsetWidth - 5) + 'px';
            textArea.style.height = (editableCell.offsetHeight - 5) + 'px';
            textArea.style.maxWidth = (editableCell.offsetWidth - 5) + 'px';
            textArea.style.maxHeight = (editableCell.offsetHeight - 5) + 'px';
            textArea.className = editableCell.className.replace(' stiEditableField stiEditableFieldSelected', '') + ' stiEditableTextArea';
            textArea.style.border = '0px';
            let textContainer = editableCell;
            var includedInnerDiv = function (el) {
                return (el.firstChild && el.firstChild.nodeName && el.firstChild.nodeName.toLowerCase() == "div");
            };
            while (includedInnerDiv(textContainer)) {
                textContainer = textContainer.childNodes[0];
            }
            textArea.value = textContainer.innerHTML.replace(/<br>/g, '\n');
            editableCell.appendChild(textArea);
            textArea.focus();
            this.currentEditableTextArea = textArea;
            textArea.onblur = () => {
                editableCell.editMode = false;
                const newText = textArea.value;
                textContainer.innerHTML = newText.replace(/\n/g, '<br>');
                if (this && textArea.parentNode) {
                    textArea.parentNode.removeChild(textArea);
                }
                this.currentEditableTextArea = null;
                this.addEditableParameters(editableCell, newText);
            };
            let this_ = this;
            let textArea_ = textArea;
            textArea_.getPrevTextField = (index) => {
                if (index > 0) {
                    for (var i = index - 1; i >= 0; i--) {
                        var field = this_.editableFields[i];
                        if (field.params.type == "Text") {
                            return field;
                        }
                    }
                }
                return null;
            };
            textArea_.getNextTextField = (index) => {
                if (index < this_.editableFields.length - 1) {
                    for (var i = index + 1; i < this_.editableFields.length; i++) {
                        var field = this_.editableFields[i];
                        if (field.params.type == "Text") {
                            return field;
                        }
                    }
                }
                return null;
            };
            textArea_.onkeydown = function (e) {
                if (e && e.keyCode == 9) {
                    if (this_.editableFields) {
                        var index = this_.editableFields.indexOf(editableCell);
                        var field = /*this_.SHIFT_pressed ? textArea_.getPrevTextField(index) : */ textArea_.getNextTextField(index);
                        if (field) {
                            e.preventDefault();
                            field.onclick();
                        }
                    }
                }
            };
        };
        this.editableFields.push(editableCell);
    }
    showRichTextEditableField(editableCell, params) {
    }
    addEditableParameters(editableCell, newText) {
        if (!this.model.reportParams.editableParameters) {
            this.model.reportParams.editableParameters = {};
        }
        const params = {};
        params.type = editableCell.params.type;
        if (params.type === 'CheckBox') {
            params.checked = editableCell.checked;
        }
        if (params.type === 'Text') {
            params.text = newText != null ? newText : editableCell.innerHTML;
        }
        if (!this.model.reportParams.editableParameters[editableCell.params.pageIndex]) {
            this.model.reportParams.editableParameters[editableCell.params.pageIndex] = {};
        }
        this.model.reportParams.editableParameters[editableCell.params.pageIndex][editableCell.params.compIndex] = params;
    }
    getSvgCheckBox(style, contourColor, size, backColor, width) {
        const head = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" width="${width}px" height="${width}px">`;
        const path = `<path stroke="${contourColor}" stroke-width="${size}" fill="${backColor}" stroke-linecap="round" stroke-linejoin="round" transform="scale(${(1 / (200 / width))})" d="`;
        let shape = '';
        switch (style) {
            case 'Cross':
                shape = 'm 62.567796,147.97593 c -0.55,-0.14223 -2.162828,-0.5128 -3.584062,-0.82348 -3.647667,-0.79738 -9.670499,-5.83775 -14.242817,-11.91949 l ' +
                    '-3.902341,-5.19058 5.080199,-1.13481 c 7.353071,-1.64253 13.640456,-5.71752 21.826811,-14.14646 l 7.208128,-7.42171 ' +
                    '-6.410736,-7.513354 c -11.773129,-13.79803 -14.346726,-23.01954 -8.627769,-30.91434 2.894109,-3.9952 11.818482,-12.369333 ' +
                    '13.182086,-12.369333 0.411356,0 1.063049,1.6875 1.448207,3.750003 0.980474,5.25038 6.456187,16.76587 10.936694,23 2.075266,2.8875 ' +
                    '3.991125,5.25 4.257464,5.25 0.266339,0 3.775242,-3.4875 7.797566,-7.75 16.397034,-17.37615 29.674184,-19.76481 38.280564,-6.88699 ' +
                    '4.15523,6.21753 4.18631,8.07093 0.14012,8.3552 -5.84833,0.41088 -17.16241,8.5342 -25.51465,18.319104 l -4.63153,5.42599 ' +
                    '4.87803,4.31529 c 6.55108,5.79533 18.8991,11.89272 25.84076,12.76002 3.0455,0.38051 5.53727,1.10582 5.53727,1.6118 0,2.7809 ' +
                    '-9.26611,14.41872 -13.03,16.36511 -7.96116,4.11687 -16.36991,0.71207 -32.764584,-13.26677 l -4.985957,-4.25125 -7.086791,8.97188 c ' +
                    '-3.897736,4.93454 -8.82141,10.1198 -10.9415,11.52281 -3.906121,2.58495 -8.86588,4.41339 -10.691162,3.94136 z';
                break;
            case 'Check':
                shape = 'M 60.972125,162.49704 C 51.172676,136.72254 43.561975,123.37669 35.370344,117.6027 l -4.45827,-3.14248 2.75159,-2.89559 c 3.875121,-4.07793 ' +
                    '10.034743,-7.49924 14.902472,-8.27747 3.859874,-0.61709 4.458306,-0.38024 8.535897,3.37835 2.660692,2.45254 6.265525,7.60856 9.167226,13.11196 ' +
                    '2.630218,4.98849 4.910542,9.06999 5.067388,9.06999 0.156846,0 2.31372,-3.0375 4.793052,-6.75 C 96.259164,91.956015 129.68299,58.786374 157.56485,41.281603 l ' +
                    '8.84913,-5.555656 2.2633,2.631238 2.26329,2.631237 -7.76266,6.294183 C 139.859,66.19023 108.01682,105.51363 89.042715,138.83563 c -6.680477,11.73214 ' +
                    '-7.172359,12.31296 -15.090788,17.81963 -4.501873,3.13071 -9.044031,6.30443 -10.093684,7.05271 -1.708923,1.21826 -2.010678,1.09165 -2.886118,-1.21093 z';
                break;
            case 'CrossRectangle':
                shape = 'm 24.152542,102.04237 0,-72.499996 74.5,0 74.499998,0 0,72.499996 0,72.5 -74.499998,0 -74.5,0 0,-72.5 z m 133.758188,0.25 -0.25819,-57.249996 ' +
                    '-58.999998,0 -59,0 -0.259695,55.999996 c -0.142833,30.8 -0.04446,56.5625 0.218615,57.25 0.375181,0.98048 13.207991,1.25 59.517885,1.25 l ' +
                    '59.039573,0 -0.25819,-57.25 z m -90.574091,43.18692 c -1.823747,-0.3912 -4.926397,-1.85716 -6.894778,-3.25768 -3.319254,-2.36169 -12.289319,-12.40741 ' +
                    '-12.289319,-13.76302 0,-0.32888 2.417494,-1.13897 5.372209,-1.80021 7.185193,-1.60797 13.747505,-5.93496 21.803114,-14.3763 l 6.675323,-6.99496 ' +
                    '-6.379078,-7.31436 C 64.931387,85.71231 61.643682,76.29465 65.471903,68.89169 67.054097,65.83207 78.56175,54.542374 80.098251,54.542374 c 0.45744,0 ' +
                    '1.146839,1.6875 1.531997,3.75 0.980474,5.250386 6.456187,16.765876 10.936694,22.999996 2.075266,2.8875 3.991125,5.25 4.257464,5.25 0.266339,0 ' +
                    '3.775244,-3.4875 7.797564,-7.75 16.39704,-17.376139 29.67419,-19.764806 38.28057,-6.88698 4.15523,6.21752 4.18631,8.07092 0.14012,8.35519 -5.82996,0.40959 ' +
                    '-18.23707,9.34942 -25.91566,18.67328 -3.90068,4.73647 -3.97203,4.95414 -2.2514,6.86861 3.19054,3.54997 13.7039,10.54321 18.97191,12.61967 2.83427,1.11716 ' +
                    '7.43737,2.33421 10.22912,2.70455 2.79175,0.37034 5.07591,0.9956 5.07591,1.38947 0,2.11419 -8.37504,13.20895 -11.6517,15.4355 -8.39423,5.70403 ' +
                    '-16.63203,2.77 -34.14289,-12.16054 l -4.985955,-4.25125 -7.086791,8.97188 c -9.722344,12.3085 -16.524852,16.55998 -23.948565,14.96754 z';
                break;
            case 'CheckRectangle':
                shape = 'm 19.915254,103.5 0,-72.5 71.942245,0 71.942241,0 6.55727,-4.11139 6.55726,-4.11139 1.96722,2.36139 c 1.08197,1.298765 1.98219,2.644166 2.00049,2.98978 ' +
                    '0.0183,0.345615 -2.44173,2.53784 -5.46673,4.87161 l -5.5,4.243219 0,69.378391 0,69.37839 -74.999991,0 -75.000005,0 0,-72.5 z m 133.999996,3.87756 c ' +
                    '0,-49.33933 -0.12953,-53.514947 -1.62169,-52.276568 -2.78014,2.307312 -15.68408,17.90053 -24.32871,29.399008 -10.4919,13.955575 -23.47926,33.53736 ' +
                    '-29.514025,44.5 -4.457326,8.09707 -5.134776,8.80812 -14.291256,15 -5.28667,3.575 -9.903486,6.62471 -10.259592,6.77712 -0.356107,0.15242 -1.912439,-2.99758 ' +
                    '-3.458515,-7 -1.546077,-4.00241 -5.258394,-12.41205 -8.249593,-18.68809 -4.285436,-8.99155 -6.676569,-12.64898 -11.27758,-17.25 C 47.70282,104.62757 ' +
                    '44.364254,102 43.495254,102 c -2.798369,0 -1.704872,-1.66044 3.983717,-6.049158 5.593548,-4.31539 13.183139,-7.091307 16.801313,-6.145133 3.559412,0.930807 ' +
                    '9.408491,8.154973 13.919775,17.192241 l 4.46286,8.94025 4.54378,-6.83321 C 95.518219,96.605618 108.21371,81.688517 125.80695,63.75 L 143.21531,46 l ' +
                    '-53.650021,0 -53.650035,0 0,57.5 0,57.5 59.000005,0 58.999991,0 0,-53.62244 z';
                break;
            case 'CrossCircle':
                shape = 'M 83.347458,173.13597 C 61.069754,168.04956 42.193415,152.8724 32.202285,132.01368 23.4014,113.63986 23.679644,89.965903 32.91889,71.042373 ' +
                    '41.881579,52.685283 60.867647,37.139882 80.847458,31.799452 c 10.235111,-2.735756 31.264662,-2.427393 40.964762,0.600679 26.18668,8.174684 ' +
                    '46.06876,28.926852 51.62012,53.879155 2.43666,10.952327 1.56754,28.058524 -1.98036,38.977594 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 ' +
                    '-6.3909,2.08202 -10.18566,2.59644 -21.27805,2.88446 -9.033911,0.23456 -15.484931,-0.10267 -19.500002,-1.01939 z M 112.4138,158.45825 c 17.13137,-3.13002 ' +
                    '33.71724,-15.96081 41.41353,-32.03742 14.8975,-31.119027 -1.10807,-67.659584 -34.40232,-78.540141 -6.71328,-2.193899 -9.93541,-2.643501 ' +
                    '-19.07755,-2.661999 -9.354252,-0.01893 -12.16228,0.37753 -18.768532,2.649866 -17.155451,5.900919 -29.669426,17.531424 -36.438658,33.866137 ' +
                    '-2.152301,5.193678 -2.694658,8.35455 -3.070923,17.89744 -0.518057,13.139047 0.741843,19.201887 6.111644,29.410237 4.106815,7.80733 15.431893,19.09359 ' +
                    '23.36818,23.28808 12.061362,6.37467 27.138828,8.6356 40.864629,6.1278 z M 69.097458,133.41654 c -2.8875,-2.75881 -5.25,-5.35869 -5.25,-5.77751 ' +
                    '0,-0.41882 5.658529,-6.30954 12.57451,-13.0905 l 12.57451,-12.329 L 76.198053,89.392633 63.399628,76.565738 68.335951,71.554056 c 2.714978,-2.756426 ' +
                    '5.304859,-5.011683 5.75529,-5.011683 0.450432,0 6.574351,5.611554 13.608709,12.470121 l 12.78974,12.470119 4.42889,-4.553471 c 2.43588,-2.50441 ' +
                    '8.39186,-8.187924 13.23551,-12.630032 l 8.80663,-8.076559 5.34744,5.281006 5.34743,5.281007 -12.96155,12.557899 -12.96154,12.557897 13.13318,13.16027 ' +
                    '13.13319,13.16027 -5.18386,4.66074 c -2.85112,2.5634 -5.70472,4.66073 -6.34134,4.66073 -0.63661,0 -6.5434,-5.4 -13.12621,-12 -6.58281,-6.6 -12.3871,-12 ' +
                    '-12.89844,-12 -0.511329,0 -6.593363,5.60029 -13.515627,12.44509 l -12.585935,12.44508 -5.25,-5.016 z';
                break;
            case 'DotCircle':
                shape = 'M 81.652542,170.5936 C 59.374838,165.50719 40.498499,150.33003 30.507369,129.47131 21.706484,111.09749 21.984728,87.42353 31.223974,68.5 ' +
                    '40.186663,50.14291 59.172731,34.597509 79.152542,29.257079 89.387653,26.521323 110.4172,26.829686 120.1173,29.857758 c 26.18668,8.174684 ' +
                    '46.06876,28.926852 51.62012,53.879152 2.43666,10.95233 1.56754,28.05853 -1.98036,38.9776 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 ' +
                    '-6.3909,2.08202 -10.18566,2.59644 -21.27805,2.88446 -9.033907,0.23456 -15.484927,-0.10267 -19.499998,-1.01939 z m 29.999998,-15.098 c 20.68862,-4.34363 ' +
                    '38.01874,-20.45437 44.09844,-40.9956 2.36228,-7.9813 2.36228,-22.0187 0,-30 C 150.08927,65.371023 134.63549,50.297336 114.65254,44.412396 ' +
                    '106.5531,42.027127 90.741304,42.026386 82.695253,44.4109 62.460276,50.407701 46.686742,66.039241 41.6053,85.13096 c -1.948821,7.32201 -1.86506,23.11641 ' +
                    '0.158766,29.93754 8.730326,29.42481 38.97193,46.91812 69.888474,40.4271 z M 90.004747,122.6703 C 76.550209,117.63801 69.825047,101.82445 ' +
                    '75.898143,89.5 c 2.136718,-4.33615 7.147144,-9.356192 11.754399,-11.776953 5.578622,-2.931141 16.413098,-2.927504 22.052908,0.0074 18.03,9.382663 ' +
                    '19.07573,32.784373 1.91442,42.841563 -5.57282,3.26589 -15.830952,4.2617 -21.615123,2.09829 z';
                break;
            case 'DotRectangle':
                shape = 'm 23.847458,101.19491 0,-72.499995 74.5,0 74.499992,0 0,72.499995 0,72.5 -74.499992,0 -74.5,0 0,-72.5 z m 133.999992,-0.008 0,-57.507925 ' +
                    '-59.249992,0.25793 -59.25,0.25793 -0.25819,57.249995 -0.258189,57.25 59.508189,0 59.508182,0 0,-57.50793 z m -94.320573,33.85402 c -0.37368,-0.37368 ' +
                    '-0.679419,-15.67942 -0.679419,-34.01275 l 0,-33.333335 35.513302,0 35.51329,0 -0.2633,33.749995 -0.2633,33.75 -34.570573,0.26275 c -19.013819,0.14452 ' +
                    '-34.876319,-0.043 -35.25,-0.41666 z';
                break;
            case 'NoneCircle':
                shape = 'M 83.5,170.5936 C 61.222296,165.50719 42.345957,150.33003 32.354827,129.47131 23.553942,111.09749 23.832186,87.423523 33.071432,68.5 ' +
                    '42.034121,50.14291 61.020189,34.597509 81,29.257079 c 10.235111,-2.735756 31.26466,-2.427393 40.96476,0.600679 26.18668,8.174684 46.06876,28.926852 ' +
                    '51.62012,53.879155 2.43666,10.95232 1.56754,28.058527 -1.98036,38.977597 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 -6.3909,2.08202 ' +
                    '-10.18566,2.59644 -21.27805,2.88446 -9.033909,0.23456 -15.484929,-0.10267 -19.5,-1.01939 z m 30,-15.098 c 20.68862,-4.34363 38.01874,-20.45437 ' +
                    '44.09844,-40.9956 2.36228,-7.9813 2.36228,-22.018707 0,-29.999997 C 151.93673,65.371023 136.48295,50.297336 116.5,44.412396 108.40056,42.027127 ' +
                    '92.588762,42.026386 84.542711,44.410896 64.307734,50.407697 48.5342,66.039237 43.452758,85.130959 c -1.948821,7.322 -1.86506,23.116411 ' +
                    '0.158766,29.937541 8.730326,29.42481 38.97193,46.91812 69.888476,40.4271 z';
                break;
            case 'NoneRectangle':
                shape = 'm 24.152542,102.04237 0,-72.499997 74.5,0 74.500008,0 0,72.499997 0,72.5 -74.500008,0 -74.5,0 0,-72.5 z m 133.758198,0.25 ' +
                    '-0.25819,-57.249997 -59.000008,0 -59,0 -0.259695,55.999997 c -0.142833,30.8 -0.04446,56.5625 0.218615,57.25 0.375181,0.98048 ' +
                    '13.207991,1.25 59.517885,1.25 l 59.039583,0 -0.25819,-57.25 z';
                break;
        }
        return head + path + shape + '" /></svg>';
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: EditableFieldsService, deps: [{ token: i1.ControllerService }, { token: i2.ModelService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: EditableFieldsService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: EditableFieldsService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ControllerService }, { type: i2.ModelService }, { type: i3.HelperService }] });
//# sourceMappingURL=data:application/json;base64,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