import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./controller.service";
import * as i2 from "./model.service";
import * as i3 from "./dashboard-proxy.service";
export class DashboardService {
    constructor(controller, model, proxy) {
        this.controller = controller;
        this.model = model;
        this.proxy = proxy;
        this.scriptLoaded = false;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'ShowDashboard') {
                this.model.showDashboard = true;
                this.model.proxyData = JSON.stringify(message.data);
                this.proxy.openReport = message.data.action == 'OpenReport';
                this.addScript();
            }
        });
    }
    addScript() {
        if (this.script) {
            this.head.removeChild(this.script);
        }
        let srcBegin = this.model.dashboards.indexOf("src=\"") + 5;
        let srcEnd = this.model.dashboards.indexOf("\"", srcBegin + 1) - 1;
        this.script = document.createElement('Script');
        this.script.setAttribute('type', 'text/javascript');
        var src = this.model.dashboards.substring(srcBegin, srcEnd);
        this.head.appendChild(this.script);
        let this_ = this;
        this.proxy.getText(src).then(function (data) {
            this_.script.innerHTML = data;
            this_.scriptLoaded = true;
            this_.startDashboards();
        });
    }
    startDashboards() {
        if (this.startScript) {
            this.head.removeChild(this.startScript);
        }
        let srcBegin = this.model.dashboards.indexOf("var jsviewer");
        let srcEnd = this.model.dashboards.lastIndexOf("</script>") - 1;
        let script = this.model.dashboards.substring(srcBegin, srcEnd);
        let idBegin = this.model.dashboards.indexOf("viewerId\":\"") + 11;
        let idEnd = this.model.dashboards.indexOf("\"", idBegin);
        let viewerId = this.model.dashboards.substring(idBegin, idEnd);
        script += '; js' + viewerId + '.options.reportDesignerMode = true; js' + viewerId + '.options.clientGuid = "' + this.model.options.clientGuid + '";' +
            'js' + viewerId + '.options.frameworkType += ", Angular";' +
            'js' + viewerId + '.options.replaceHtmlFormWithRequest = ' + this.model.options.replaceHtmlFormWithRequest + ';';
        document["proxy" + viewerId] = this.proxy;
        eval(script);
    }
    get head() {
        return document.getElementsByTagName('head')[0];
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DashboardService, deps: [{ token: i1.ControllerService }, { token: i2.ModelService }, { token: i3.DashboardProxyService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DashboardService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DashboardService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ControllerService }, { type: i2.ModelService }, { type: i3.DashboardProxyService }] });
//# sourceMappingURL=data:application/json;base64,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