import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./controller.service";
import * as i3 from "./export.service";
import * as i4 from "./helper.service";
import * as i5 from "./mail.service";
import * as i6 from "./find.service";
export class ApiAngularService {
    constructor(model, controller, exportService, helper, mailService, findService) {
        this.model = model;
        this.controller = controller;
        this.exportService = exportService;
        this.helper = helper;
        this.mailService = mailService;
        this.findService = findService;
        this.EXPORT_FORMATS = ['Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
            'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
            'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'];
    }
    dashboardExport(format, settings) { }
    dashboardRefresh() { }
    dashboardResetAllFilters() { }
    /**
     * The current page number
     */
    get currentPage() {
        return this.model.reportParams.pageNumber;
    }
    set currentPage(value) {
        if (value >= 0 && value < this.model.reportParams.pagesCount) {
            this.model.reportParams.pageNumber = value;
            this.controller.getPages();
        }
    }
    /**
     * The total pages count
     */
    get pagesCount() {
        return this.model.reportParams.pagesCount;
    }
    /**
     * The view mode, can be 'SinglePage', 'Continuous' & 'MultiplePages'
     */
    get viewMode() {
        return this.model.reportParams.viewMode;
    }
    set viewMode(value) {
        if (value === 'SinglePage' || value === 'Continuous' || value === 'MultiplePages') {
            this.model.reportParams.viewMode = value;
            this.controller.getPages();
        }
    }
    /**
     * The page zoom in percent
     * From 1 to 1000
     */
    get zoom() {
        return this.model.reportParams.zoom;
    }
    set zoom(value) {
        if (value >= 1 && value <= 1000) {
            this.model.reportParams.zoom = value;
            this.controller.getPages();
        }
    }
    /**
     * Zoom page in height
     */
    zoomPageHeight() {
        this.controller.action({ name: 'ZoomOnePage' });
    }
    /**
     * Zoom page in width
     */
    zoomPageWidth() {
        this.controller.action({ name: 'ZoomPageWidth' });
    }
    /**
     * Print to PDF
     */
    printPdf() {
        this.controller.action({ name: 'PrintPdf' });
    }
    /**
     * Print with preview
     */
    printWithPreview() {
        this.controller.action({ name: 'PrintWithPreview' });
    }
    /**
     * Print without preview
     */
    printWithoutPreview() {
        this.controller.action({ name: 'PrintWithoutPreview' });
    }
    /**
     * Show export form
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportForm(format) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            this.controller.actionSubject.next({ action: 'Export', data: { format } });
        }
    }
    /**
     * Show export form & email
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportEmailForm(format) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            this.controller.actionSubject.next({ action: 'SendEmail', data: { format } });
        }
    }
    /**
     * Export report to selected format
     * Use default settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     */
    export(format, settings) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            const exportSettings = this.getExportSettings(format, settings);
            this.controller.postExport(format, exportSettings);
        }
    }
    /**
     * Export report/dashboard to seleted format & email
     * Use default settings if not specified
     * Use default email settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     *
     * @param email The email
     *
     * @param message The email message
     *
     * @param subject The email subject
     */
    exportEmail(format, settings, email, subject, message) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            this.exportService.exportSettings = this.getExportSettings(format, settings);
            this.exportService.format = format;
            this.mailService.fillDefaults();
            if (email) {
                this.exportService.exportSettings.Email = email;
            }
            if (message) {
                this.exportService.exportSettings.Message = message;
            }
            if (subject) {
                this.exportService.exportSettings.Subject = subject;
            }
            this.mailService.sendMail();
        }
    }
    get reportType() {
        return "Report";
    }
    /**
     * Search text in report
     *
     * @param text text to search
     *
     * @param matchCase
     *
     * @param matchWholeWord
     */
    search(text, matchCase, matchWholeWord) {
        this.findService.text = text;
        this.findService.matchCase = matchCase;
        this.findService.matchWholeWord = matchWholeWord;
        this.findService.showFindLabels();
    }
    /**
     * Select next or previous search
     *
     * @param direction 'Next' or 'Previous'
     *
     */
    selectSearchLabel(direction) {
        this.findService.selectFindLabel(direction);
    }
    /**
     * Hide search
     */
    hideSearchLabels() {
        this.findService.hideFindLabels();
    }
    getExportSettings(format, settings) {
        this.exportService.sendMail = false;
        this.exportService.format = format;
        const exportSettings = this.helper.copyObject(this.exportService.getDefaultExportSettings(format));
        if (settings) {
            Object.keys(settings).forEach(key => exportSettings[key] = settings[key]);
        }
        return exportSettings;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ApiAngularService, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.ExportService }, { token: i4.HelperService }, { token: i5.MailService }, { token: i6.FindService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ApiAngularService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ApiAngularService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.ExportService }, { type: i4.HelperService }, { type: i5.MailService }, { type: i6.FindService }] });
//# sourceMappingURL=data:application/json;base64,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