import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "./menu.service";
import * as i3 from "@angular/common";
export class VerticalMenuItemComponent {
    constructor(model, menuService) {
        this.model = model;
        this.menuService = menuService;
        this.styleName = 'stiJsViewerMenuStandartItem';
        this.action = new EventEmitter();
        this.over = false;
        this._enabled = true;
    }
    ngOnInit() { }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    get className() {
        return this.styleName ? this.styleName + ' ' + (this.enabled ? (this.styleName + (this.over ? 'Over' : (this.item?.selected ? 'Selected' : 'Default'))) : this.styleName + 'Disabled') : '';
    }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
    }
    click() {
        if (this._enabled) {
            this.action.emit(this.item);
        }
    }
    get isSmallItem() {
        return this.styleName && this.styleName.indexOf('MenuStandartItem') >= 0;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: VerticalMenuItemComponent, deps: [{ token: i1.ModelService }, { token: i2.MenuService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: VerticalMenuItemComponent, selector: "sti-vertical-menu-item", inputs: { styleName: "styleName", item: "item", imageSizesWidth: "imageSizesWidth", imageSizesHeight: "imageSizesHeight", enabled: "enabled" }, outputs: { action: "action" }, ngImport: i0, template: `
    <div [style.height]="item?.type == 'DigitalSignature' ? 'auto' :(model.options.isMobileDevice ? '0.4in' : (model.options.isTouchDevice ? '30px' : '24px'))"
         [class]="className"
         [style.width]="item?.type == 'DigitalSignature' ? '100%' :  menuService.getVerticalMenu().width + 'px'"
         [style.lineHeight]="item?.type == 'DigitalSignature' ? 1.3 : null"
         (mouseover)="mouseover()"
         (mouseout)="mouseout()"
         (click)="click()">
         <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.height]="'100%'" [style.width]="'100%'">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                 <td *ngIf="item?.imageName != null && !model.options.appearance.rightToLeft"
                     [style.width.px]="22" [style.minWidth.px]="22" [style.padding]="0" [style.textAlign]="'center'" [style.lineHeight]="0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     [style.padding]="'0px 20px 0px 7px'" [style.textAlign]="'left'" [style.whiteSpace]="'nowrap'"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     [style.padding]="'8px 20px 8px 8px'" [style.textAlign]="'left'" [style.whiteSpace]="'nowrap'"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <!-- right-to-left -->
                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     [style.padding]="'8px 20px 8px 8px'" [style.textAlign]="'right'" [style.whiteSpace]="'nowrap'"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     [style.padding]="'0 7px 0 20px'" [style.textAlign]="'right'" [style.whiteSpace]="'nowrap'"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.imageName != null && model.options.appearance.rightToLeft"
                     [style.width.px]="22" [style.minWidth.px]="22" [style.padding]="0" [style.textAlign]="'center'" [style.lineHeight]="0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>
              </tr>
            </tbody>
          </table>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: VerticalMenuItemComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-vertical-menu-item',
                    template: `
    <div [style.height]="item?.type == 'DigitalSignature' ? 'auto' :(model.options.isMobileDevice ? '0.4in' : (model.options.isTouchDevice ? '30px' : '24px'))"
         [class]="className"
         [style.width]="item?.type == 'DigitalSignature' ? '100%' :  menuService.getVerticalMenu().width + 'px'"
         [style.lineHeight]="item?.type == 'DigitalSignature' ? 1.3 : null"
         (mouseover)="mouseover()"
         (mouseout)="mouseout()"
         (click)="click()">
         <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.height]="'100%'" [style.width]="'100%'">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                 <td *ngIf="item?.imageName != null && !model.options.appearance.rightToLeft"
                     [style.width.px]="22" [style.minWidth.px]="22" [style.padding]="0" [style.textAlign]="'center'" [style.lineHeight]="0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     [style.padding]="'0px 20px 0px 7px'" [style.textAlign]="'left'" [style.whiteSpace]="'nowrap'"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     [style.padding]="'8px 20px 8px 8px'" [style.textAlign]="'left'" [style.whiteSpace]="'nowrap'"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <!-- right-to-left -->
                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     [style.padding]="'8px 20px 8px 8px'" [style.textAlign]="'right'" [style.whiteSpace]="'nowrap'"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     [style.padding]="'0 7px 0 20px'" [style.textAlign]="'right'" [style.whiteSpace]="'nowrap'"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.imageName != null && model.options.appearance.rightToLeft"
                     [style.width.px]="22" [style.minWidth.px]="22" [style.padding]="0" [style.textAlign]="'center'" [style.lineHeight]="0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>
              </tr>
            </tbody>
          </table>
    </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.MenuService }], propDecorators: { styleName: [{
                type: Input
            }], item: [{
                type: Input
            }], imageSizesWidth: [{
                type: Input
            }], imageSizesHeight: [{
                type: Input
            }], action: [{
                type: Output
            }], enabled: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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