import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "@angular/common";
import * as i4 from "../controls/checkbox.component";
import * as i5 from "../controls/parameters/parameter-checkbox.component";
import * as i6 from "./parameter-menu-item.component";
import * as i7 from "./parameter-menu-separator.component";
import * as i8 from "../controls/parameters/parameter-find.component";
export class ParameterMenuNotEditListComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    selectAll() {
        const isAllSelected = this.isAllSelected();
        if (this.menu.params.items) {
            this.menu.params.items.forEach(e => e.isChecked = !isAllSelected);
        }
    }
    isAllSelected() {
        return this.menu.params.items.every(e => e.isChecked);
    }
    check(item) {
        item.isChecked = !item.isChecked;
    }
    closeAction() {
        this.menu.state = 'initialDown';
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterMenuNotEditListComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ParameterMenuNotEditListComponent, selector: "sti-parameter-menu-not-edit-list", inputs: { menu: "menu" }, ngImport: i0, template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div [style.max-height.px]="400" [style.overflow]="'hidden auto'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-check-box [captionText]="model.loc('SelectAll')"
                    [margin]="'8px 7px 8px 7px'"
                    [isChecked]="isAllSelected()"
                    (action)="selectAll()" >
                  </sti-check-box>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-checkbox [params]="item"
                                      [captionText]="helper.val(item.value, helper.getStringKey(item.key, menu.params))"
                                      [margin]="'0 5px 0 0'"
                                      [width]="'100%'"
                                      [imageBlockParentWidth]="'1px'"
                                      [isMenuParameter]="true"
                                      (action)="check(item)">
                                  </sti-parameter-checkbox>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                    <sti-parameter-menu-item [padding]="'0px 5px 0px 13px'" (action)="closeAction()">
                      {{model.loc('Close')}}
                    </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }, { kind: "component", type: i5.ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: ["params", "captionText", "margin", "width", "imageBlockParentWidth", "isEnabled", "isMenuParameter", "paramNull", "nullable"], outputs: ["action"] }, { kind: "component", type: i6.ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: i7.ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }, { kind: "component", type: i8.ParameterFindComponent, selector: "sti-parameter-find", inputs: ["variable"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterMenuNotEditListComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-not-edit-list',
                    template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div [style.max-height.px]="400" [style.overflow]="'hidden auto'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-check-box [captionText]="model.loc('SelectAll')"
                    [margin]="'8px 7px 8px 7px'"
                    [isChecked]="isAllSelected()"
                    (action)="selectAll()" >
                  </sti-check-box>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-checkbox [params]="item"
                                      [captionText]="helper.val(item.value, helper.getStringKey(item.key, menu.params))"
                                      [margin]="'0 5px 0 0'"
                                      [width]="'100%'"
                                      [imageBlockParentWidth]="'1px'"
                                      [isMenuParameter]="true"
                                      (action)="check(item)">
                                  </sti-parameter-checkbox>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                    <sti-parameter-menu-item [padding]="'0px 5px 0px 13px'" (action)="closeAction()">
                      {{model.loc('Close')}}
                    </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.HelperService }], propDecorators: { menu: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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