import { Component, Output, EventEmitter, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
export class ParameterMenuItemComponent {
    constructor(model) {
        this.model = model;
        this.action = new EventEmitter();
        this.active = true;
        this.padding = '0px 5px';
        this.isOver = false;
        this.mouseDown = false;
    }
    ngOnInit() { }
    mouseover() {
        this.isOver = true;
    }
    mouseout() {
        this.isOver = false;
        this.mouseDown = false;
    }
    mousedown() {
        this.mouseDown = true;
    }
    mouseup() {
        this.mouseDown = false;
        this.action.emit();
    }
    get className() {
        return this.active ? this.mouseDown ? 'stiJsViewerParametersMenuItemPressed' : (this.isOver ? 'stiJsViewerParametersMenuItemOver' : 'stiJsViewerParametersMenuItem') : 'stiJsViewerParametersMenuItem';
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterMenuItemComponent, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: { active: "active", padding: "padding" }, outputs: { action: "action" }, ngImport: i0, template: `
      <div [class]="className"
        [style.height.px]="model.options.isTouchDevice ? 30 : 24"
        (mouseover)="mouseover()"
        (mouseout)="mouseout()"
        (mousedown)="mousedown()"
        (mouseup)="mouseup()">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuItemInnerTable" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" [style.padding]="padding">
                <ng-content>
                </ng-content>
              </td>
            </tr>
          </tbody>
        </table>

      </div>
  `, isInline: true }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterMenuItemComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-item',
                    template: `
      <div [class]="className"
        [style.height.px]="model.options.isTouchDevice ? 30 : 24"
        (mouseover)="mouseover()"
        (mouseout)="mouseout()"
        (mousedown)="mousedown()"
        (mouseup)="mouseup()">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuItemInnerTable" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" [style.padding]="padding">
                <ng-content>
                </ng-content>
              </td>
            </tr>
          </tbody>
        </table>

      </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }], propDecorators: { action: [{
                type: Output
            }], active: [{
                type: Input
            }], padding: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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