import { Component, Input, ViewChild } from '@angular/core';
import { Variable } from '../services/objects';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "./menu.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/parameters/parameter-text-box.component";
import * as i6 from "../controls/parameters/parameter-button.component";
import * as i7 from "./parameter-menu-item.component";
import * as i8 from "./parameter-menu-separator.component";
export class ParameterMenuEditListComponent {
    constructor(model, helper, menuService) {
        this.model = model;
        this.helper = helper;
        this.menuService = menuService;
    }
    ngOnInit() { }
    newItem(event) {
        const item = new Variable();
        if (this.menu.params.type === 'DateTime') {
            item.key = this.helper.getDateTimeObject();
            item.value = this.helper.dateTimeObjectToString(item.key);
        }
        else if (this.menu.params.type === 'TimeSpan') {
            item.key = '00:00:00';
            item.value = '00:00:00';
        }
        else if (this.menu.params.type === 'Bool') {
            item.key = 'False';
            item.value = 'False';
        }
        else {
            item.key = '';
            item.value = '';
        }
        item.focusOnCreate = true;
        if (!this.menu.params.items) {
            this.menu.params.items = [];
        }
        this.menu.params.items.push(item);
        setTimeout(() => {
            item.focusOnCreate = false;
        });
    }
    dateTimeButtonAction(item) {
        this.menuService.addMenu({
            type: 'datePickerMenu', name: 'datePickerMenu', items: [], parent: this.dateTimeButton,
            params: item,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu('datePickerMenu');
        });
    }
    guidButtonAction(item) {
        item.key = this.helper.newGuid();
    }
    removeButtonAction(item) {
        this.menu.params.items.splice(this.menu.params.items.indexOf(item), 1);
    }
    removeAllAction() {
        this.menu.params.items.splice(0, this.menu.params.items.length);
    }
    closeAction() {
        this.menu.state = 'initialDown';
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterMenuEditListComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.MenuService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ParameterMenuEditListComponent, selector: "sti-parameter-menu-edit-list", inputs: { menu: "menu" }, viewQueries: [{ propertyName: "dateTimeButton", first: true, predicate: ["dateTimeButton"], descendants: true }], ngImport: i0, template: `
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontSize]="'12px'"
        [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <!--New Item Button -->
                <sti-parameter-menu-item (action)="newItem($event)">
                  {{model.loc('NewItem')}}
                </sti-parameter-menu-item>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-parameter-menu-item *ngFor="let item of menu.params.items" [active]="false">
                  <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                    <tbody>
                      <tr class="stiJsViewerClearAllStyles">
                         <td class="stiJsViewerClearAllStyles" [style.padding]="'0px 1px 0px 0px'">
                            <sti-parameter-text-box [item]="item" [isMenu]="true"
                              [variable]="menu.params" [focusOnCreate]="item.focusOnCreate">
                            </sti-parameter-text-box>
                         </td>

                         <td *ngIf="menu.params.type == 'DateTime'" class="stiJsViewerClearAllStyles" [style.padding]="'0 1px 0 1px'" #dateTimeButton>
                           <sti-parameter-button [buttonType]="'DateTimeButton'" (action)="dateTimeButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td *ngIf="menu.params.type == 'Guid'" class="stiJsViewerClearAllStyles" [style.padding]="'0 1px 0 1px'">
                           <sti-parameter-button [buttonType]="'GuidButton'" (action)="guidButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td class="stiJsViewerClearAllStyles" [style.padding]="'0 1px 0 1px'">
                           <sti-parameter-button [buttonType]="'RemoveItemButton'" (action)="removeButtonAction(item)" [params]="item">
                           </sti-parameter-button>
                         </td>
                       </tr>
                     </tbody>
                  </table>
                </sti-parameter-menu-item>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item (action)="removeAllAction()">
                      {{model.loc('RemoveAll')}}
                  </sti-parameter-menu-item>

                  <sti-parameter-menu-separator></sti-parameter-menu-separator>

                  <sti-parameter-menu-item (action)="closeAction()">
                      {{model.loc('Close')}}
                  </sti-parameter-menu-item>
              </td>
            </tr>
          </tbody>
        </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ParameterTextBoxComponent, selector: "sti-parameter-text-box", inputs: ["item", "variable", "readOnly", "focusOnCreate", "isMenu", "value", "secondTextBox"] }, { kind: "component", type: i6.ParameterButtonComponent, selector: "sti-parameter-button", inputs: ["params", "buttonType"], outputs: ["action"] }, { kind: "component", type: i7.ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: i8.ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterMenuEditListComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-edit-list',
                    template: `
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontSize]="'12px'"
        [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <!--New Item Button -->
                <sti-parameter-menu-item (action)="newItem($event)">
                  {{model.loc('NewItem')}}
                </sti-parameter-menu-item>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-parameter-menu-item *ngFor="let item of menu.params.items" [active]="false">
                  <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                    <tbody>
                      <tr class="stiJsViewerClearAllStyles">
                         <td class="stiJsViewerClearAllStyles" [style.padding]="'0px 1px 0px 0px'">
                            <sti-parameter-text-box [item]="item" [isMenu]="true"
                              [variable]="menu.params" [focusOnCreate]="item.focusOnCreate">
                            </sti-parameter-text-box>
                         </td>

                         <td *ngIf="menu.params.type == 'DateTime'" class="stiJsViewerClearAllStyles" [style.padding]="'0 1px 0 1px'" #dateTimeButton>
                           <sti-parameter-button [buttonType]="'DateTimeButton'" (action)="dateTimeButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td *ngIf="menu.params.type == 'Guid'" class="stiJsViewerClearAllStyles" [style.padding]="'0 1px 0 1px'">
                           <sti-parameter-button [buttonType]="'GuidButton'" (action)="guidButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td class="stiJsViewerClearAllStyles" [style.padding]="'0 1px 0 1px'">
                           <sti-parameter-button [buttonType]="'RemoveItemButton'" (action)="removeButtonAction(item)" [params]="item">
                           </sti-parameter-button>
                         </td>
                       </tr>
                     </tbody>
                  </table>
                </sti-parameter-menu-item>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item (action)="removeAllAction()">
                      {{model.loc('RemoveAll')}}
                  </sti-parameter-menu-item>

                  <sti-parameter-menu-separator></sti-parameter-menu-separator>

                  <sti-parameter-menu-item (action)="closeAction()">
                      {{model.loc('Close')}}
                  </sti-parameter-menu-item>
              </td>
            </tr>
          </tbody>
        </table>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.MenuService }], propDecorators: { dateTimeButton: [{
                type: ViewChild,
                args: ['dateTimeButton']
            }], menu: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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