import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "@angular/common";
import * as i4 from "../controls/button.component";
import * as i5 from "./date-picker-menu.component";
export class DoubleDatePickerMenuComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    get showTime() {
        return this.menu?.params?.dateTimeType !== 'Date';
    }
    setTimeInterval(firstDate, secondDate) {
        firstDate.setHours(0);
        firstDate.setMinutes(0);
        firstDate.setSeconds(0);
        secondDate.setHours(23);
        secondDate.setMinutes(59);
        secondDate.setSeconds(59);
    }
    getFirstDayOfWeek() {
        const date = new Date();
        const timeString = date.toLocaleTimeString();
        return (timeString.toLowerCase().indexOf('am') >= 0 || timeString.toLowerCase().indexOf('pm') >= 0 ? 0 : 1);
    }
    getWeekInterval(now) {
        const startDay = this.getFirstDayOfWeek();
        let dayWeek = startDay === 0 ? now.getDay() : now.getDay() - 1;
        if (dayWeek < 0) {
            dayWeek = 6;
        }
        const values = [new Date(now.valueOf() - dayWeek * 86400000)];
        values.push(new Date(values[0].valueOf() + 6 * 86400000));
        this.setTimeInterval(values[0], values[1]);
        return values;
    }
    getValuesByDateRangeName(item) {
        const now = new Date();
        let values = [new Date(), new Date()];
        switch (item) {
            case 'CurrentMonth': {
                values[0].setDate(1);
                values[1].setDate(this.helper.getCountDaysOfMonth(now.getFullYear(), now.getMonth()));
                break;
            }
            case 'CurrentQuarter': {
                const firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3;
                values[0] = new Date(now.getFullYear(), firstMonth, 1);
                values[1] = new Date(now.getFullYear(), firstMonth + 2, this.helper.getCountDaysOfMonth(now.getFullYear(), firstMonth + 2));
                break;
            }
            case 'CurrentWeek': {
                values = this.getWeekInterval(now);
                break;
            }
            case 'CurrentYear': {
                values[0] = new Date(now.getFullYear(), 0, 1);
                values[1] = new Date(now.getFullYear(), 11, 31);
                break;
            }
            case 'NextMonth': {
                let month = now.getMonth() + 1;
                let year = now.getFullYear();
                if (month > 11) {
                    month = 0;
                    year++;
                }
                values[0] = new Date(year, month, 1);
                values[1] = new Date(year, month, this.helper.getCountDaysOfMonth(year, month));
                break;
            }
            case 'NextQuarter': {
                let year = now.getFullYear();
                let firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3 + 3;
                if (firstMonth > 11) {
                    firstMonth = 0;
                    year++;
                }
                values[0] = new Date(year, firstMonth, 1);
                values[1] = new Date(year, firstMonth + 2, this.helper.getCountDaysOfMonth(year, firstMonth + 2));
                break;
            }
            case 'NextWeek': {
                values = this.getWeekInterval(now);
                values[0] = new Date(values[0].valueOf() + 7 * 86400000);
                values[1] = new Date(values[1].valueOf() + 7 * 86400000);
                break;
            }
            case 'NextYear': {
                values[0] = new Date(now.getFullYear() + 1, 0, 1);
                values[1] = new Date(now.getFullYear() + 1, 11, 31);
                break;
            }
            case 'PreviousMonth': {
                let month = now.getMonth() - 1;
                let year = now.getFullYear();
                if (month < 0) {
                    month = 11;
                    year--;
                }
                values[0] = new Date(year, month, 1);
                values[1] = new Date(year, month, this.helper.getCountDaysOfMonth(year, month));
                break;
            }
            case 'PreviousQuarter': {
                let year = now.getFullYear();
                let firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3 - 3;
                if (firstMonth < 0) {
                    firstMonth = 9;
                    year--;
                }
                values[0] = new Date(year, firstMonth, 1);
                values[1] = new Date(year, firstMonth + 2, this.helper.getCountDaysOfMonth(year, firstMonth + 2));
                break;
            }
            case 'PreviousWeek': {
                values = this.getWeekInterval(now);
                values[0] = new Date(values[0].valueOf() - 7 * 86400000);
                values[1] = new Date(values[1].valueOf() - 7 * 86400000);
                break;
            }
            case 'PreviousYear': {
                values[0] = new Date(now.getFullYear() - 1, 0, 1);
                values[1] = new Date(now.getFullYear() - 1, 11, 31);
                break;
            }
            case 'FirstQuarter': {
                values[0] = new Date(now.getFullYear(), 0, 1);
                values[1] = new Date(now.getFullYear(), 2, this.helper.getCountDaysOfMonth(now.getFullYear(), 2));
                break;
            }
            case 'SecondQuarter': {
                values[0] = new Date(now.getFullYear(), 3, 1);
                values[1] = new Date(now.getFullYear(), 5, this.helper.getCountDaysOfMonth(now.getFullYear(), 5));
                break;
            }
            case 'ThirdQuarter': {
                values[0] = new Date(now.getFullYear(), 6, 1);
                values[1] = new Date(now.getFullYear(), 8, this.helper.getCountDaysOfMonth(now.getFullYear(), 8));
                break;
            }
            case 'FourthQuarter': {
                values[0] = new Date(now.getFullYear(), 9, 1);
                values[1] = new Date(now.getFullYear(), 11, this.helper.getCountDaysOfMonth(now.getFullYear(), 11));
                break;
            }
            case 'MonthToDate': {
                values[0].setDate(1);
                break;
            }
            case 'QuarterToDate': {
                const firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3;
                values[0].setDate(1);
                values[0].setMonth(firstMonth);
                break;
            }
            case 'WeekToDate': {
                const weekValues = this.getWeekInterval(now);
                values[0] = weekValues[0];
                break;
            }
            case 'YearToDate': {
                values[0].setDate(1);
                values[0].setMonth(0);
                break;
            }
            case 'Today': {
                break;
            }
            case 'Tomorrow': {
                values[0] = new Date(values[0].valueOf() + 86400000);
                values[1] = new Date(values[1].valueOf() + 86400000);
                break;
            }
            case 'Yesterday': {
                values[0] = new Date(values[0].valueOf() - 86400000);
                values[1] = new Date(values[1].valueOf() - 86400000);
                break;
            }
            case 'Last7Days': {
                if (this.model.options.appearance.datePickerIncludeCurrentDayForRanges) {
                    values[0] = new Date(values[0].valueOf() - 6 * 86400000);
                }
                else {
                    values[0] = new Date(values[0].valueOf() - 7 * 86400000);
                }
                break;
            }
            case 'Last14Days': {
                if (this.model.options.appearance.datePickerIncludeCurrentDayForRanges) {
                    values[0] = new Date(values[0].valueOf() - 13 * 86400000);
                }
                else {
                    values[0] = new Date(values[0].valueOf() - 14 * 86400000);
                }
                break;
            }
            case 'Last30Days': {
                if (this.model.options.appearance.datePickerIncludeCurrentDayForRanges) {
                    values[0] = new Date(values[0].valueOf() - 29 * 86400000);
                }
                else {
                    values[0] = new Date(values[0].valueOf() - 30 * 86400000);
                }
                break;
            }
        }
        this.setTimeInterval(values[0], values[1]);
        this.menu.params.key = this.helper.getDateTimeObject(values[0]);
        this.menu.params.keyTo = this.helper.getDateTimeObject(values[1]);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DoubleDatePickerMenuComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: DoubleDatePickerMenuComponent, selector: "sti-double-date-picker-menu", inputs: { menu: "menu" }, ngImport: i0, template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin.px]="4" [style.border]="'1px dotted rgb(198, 198, 198)'">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" [style.verticalAlign]="'top'">
                  <div [style.margin.px]="4">
                    <sti-date-picker-menu [menu]="menu" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" [style.borderLeft]="'1px dotted rgb(198, 198, 198)'" [style.verticalAlign]="'top'">
                  <div [style.margin.px]="4">
                    <sti-date-picker-menu [menu]="menu" [keyTo]="true" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" [style.borderLeft]="'1px dotted rgb(198, 198, 198)'" [style.verticalAlign]="'top'">
                <div [style.width.px]="150" [style.overflow]="'auto'" [style.margin.px]="4" [style.height.px]="showTime ? 250 : 220">
                    <ng-container *ngFor="let item of model.dateRanges">
                        <sti-button [caption]="model.loc(item)" (action)="getValuesByDateRangeName(item)">
                        </sti-button>

                        <div *ngIf="item=='Yesterday' || item=='PreviousWeek' || item=='PreviousMonth' || item=='PreviousQuarter' || item=='PreviousYear' || item=='FourthQuarter' || item=='Last30Days'"
                            class="stiJsViewerVerticalMenuSeparator" [style.margin.px]="2"></div>
                    </ng-container>
                </div>
              </td>
            </tr>
          </tbody>
      </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i5.DatePickerMenuComponent, selector: "sti-date-picker-menu", inputs: ["menu", "keyTo", "closeOnAction"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DoubleDatePickerMenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-double-date-picker-menu',
                    template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin.px]="4" [style.border]="'1px dotted rgb(198, 198, 198)'">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" [style.verticalAlign]="'top'">
                  <div [style.margin.px]="4">
                    <sti-date-picker-menu [menu]="menu" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" [style.borderLeft]="'1px dotted rgb(198, 198, 198)'" [style.verticalAlign]="'top'">
                  <div [style.margin.px]="4">
                    <sti-date-picker-menu [menu]="menu" [keyTo]="true" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" [style.borderLeft]="'1px dotted rgb(198, 198, 198)'" [style.verticalAlign]="'top'">
                <div [style.width.px]="150" [style.overflow]="'auto'" [style.margin.px]="4" [style.height.px]="showTime ? 250 : 220">
                    <ng-container *ngFor="let item of model.dateRanges">
                        <sti-button [caption]="model.loc(item)" (action)="getValuesByDateRangeName(item)">
                        </sti-button>

                        <div *ngIf="item=='Yesterday' || item=='PreviousWeek' || item=='PreviousMonth' || item=='PreviousQuarter' || item=='PreviousYear' || item=='FourthQuarter' || item=='Last30Days'"
                            class="stiJsViewerVerticalMenuSeparator" [style.margin.px]="2"></div>
                    </ng-container>
                </div>
              </td>
            </tr>
          </tbody>
      </table>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.HelperService }], propDecorators: { menu: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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