import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/export.service";
import * as i3 from "../services/helper.service";
import * as i4 from "./form.service";
import * as i5 from "../menu/menu.service";
import * as i6 from "../services/collections.service";
import * as i7 from "../services/controller.service";
import * as i8 from "@angular/common";
import * as i9 from "../controls/button.component";
import * as i10 from "../controls/text-box.componet";
import * as i11 from "../controls/checkbox.component";
import * as i12 from "./base-form.component";
import * as i13 from "./group-panel.component";
import * as i14 from "../controls/radio-button.components";
import * as i15 from "../controls/drop-down-list-for-export-form.component";
export class ExportFormComponent {
    constructor(model, exportService, helper, formService, menuService, collections, controller) {
        this.model = model;
        this.exportService = exportService;
        this.helper = helper;
        this.formService = formService;
        this.menuService = menuService;
        this.collections = collections;
        this.controller = controller;
        this.PROPERTY_ALIAS = {
            ImageFormatForHtml: 'ImageFormat',
            EncodingTextOrCsvFile: 'Encoding',
            ExportModeRtf: 'ExportMode',
            EncodingDifFile: 'Encoding',
            EncodingDbfFile: 'CodePage'
        };
        this.formVisible = false;
        this.disabledComponents = {};
    }
    ngOnChanges(changes) {
        if (this.baseForm && this.formService?.form?.name === this.baseForm.name) {
            setTimeout(() => this.updateDisabledComponents());
        }
    }
    ngOnInit() { }
    action() {
        this.formService.closeForm(this.baseForm.name);
        if (this.model.options.exports.storeExportSettings) {
            this.helper.setCookie('StimulsoftWebViewerExportSettings' + this.exportService.getCommonExportFormat(), JSON.stringify(this.exportService.exportSettings));
        }
        this.exportService.postExport();
    }
    updateDisabledComponents() {
        ['StandardPdfFonts', 'EmbeddedFonts', 'UseUnicode'].forEach(n => this.disabledComponents[n] = (this.exportService.exportSettings.PdfACompliance === true));
        this.disabledComponents.ImageQuality = this.exportService.exportSettings.ImageCompressionMethod && this.exportService.exportSettings.ImageCompressionMethod !== 'Jpeg';
        this.disabledComponents.ExportObjectFormatting = this.exportService.exportSettings.DataExportMode === 'AllBands';
        this.disabledComponents.UseOnePageHeaderAndFooter = this.exportService.exportSettings.DataExportMode != 'AllBands';
        this.disabledComponents.EncodingDifFile = this.exportService.exportSettings.UseDefaultSystemEncoding;
        this.disabledComponents.TiffCompressionScheme = this.exportService.exportSettings.ImageType !== 'Tiff';
        this.disabledComponents.UseDigitalSignature = !this.exportService.exportSettings.UseDigitalSignature || !(this.model.pdfSecurityCertificates?.length > 0);
        this.disabledComponents.RemoveEmptySpaceAtBottom = this.exportService.exportSettings.UsePageHeadersAndFooters;
        if (this.exportService.exportSettings.ImageType != null) {
            const ifComponent = this.exportService.exportFormSettings.components.find(c => c.name === 'ImageFormat');
            if (ifComponent != null) {
                ifComponent.items = this.collections.getImageFormatItems(this.exportService.exportSettings.ImageType === 'Emf');
            }
        }
        this.disabledComponents.DitheringType = this.exportService.exportSettings.ImageFormat !== 'Monochrome';
        if (this.saveReportMdc) {
            this.saveReportMdc.click();
        }
        if (this.pagesRangeAll && !this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled) {
            this.pagesRangeAll.click();
        }
        if (this.pageRangeCurrentPage && this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled) {
            this.pageRangeCurrentPage.click();
        }
        if (this.exportService.exportSettings.CompressToArchive === true) {
            this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled = false;
        }
        if (this.exportService.exportSettings.CompressToArchive === false) {
            this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled = true;
        }
    }
    componentAction(comp, value) {
        let property = this.PROPERTY_ALIAS[comp.name] || comp.name;
        switch (property) {
            case 'EmbeddedFonts':
            case 'UseUnicode':
                if (value) {
                    this.exportService.exportSettings.StandardPdfFonts = false;
                }
                break;
            case 'StandardPdfFonts':
                if (value) {
                    this.exportService.exportSettings.EmbeddedFonts = false;
                    this.exportService.exportSettings.UseUnicode = false;
                }
                break;
            case 'ImageType':
                this.exportService.export('Image' + value, true);
                break;
            case 'DataType':
            case 'HtmlType':
                this.exportService.export(value, true);
                break;
            case 'ExcelType':
                const exportFormat = value === 'ExcelBinary' ? 'Excel' : value;
                this.exportService.export(exportFormat, true);
                break;
            case 'UseDigitalSignature':
                if (!(value === true || value === false)) {
                    property = 'CertificateThumbprint';
                }
                if (value === true && this.collections.getPdfSecurityCertificatesItems().length == 0) {
                    value = false;
                    this.controller.showError('Warning', 'Certificate Not Found!');
                }
                break;
            case 'UsePageHeadersAndFooters':
                if (value === true) {
                    this.exportService.exportSettings.RemoveEmptySpaceAtBottom = true;
                }
                break;
        }
        this.exportService.exportSettings[property] = value;
        this.updateDisabledComponents();
    }
    getValue(comp, component) {
        const property = this.PROPERTY_ALIAS[comp.name] || comp.name;
        switch (property) {
            case 'Zoom2':
                return this.exportService.exportSettings[property].toString();
            case 'UseDigitalSignature':
                if (component == 'dropDownList') {
                    return this.exportService.exportSettings['CertificateThumbprint'];
                }
            default:
                return this.exportService.exportSettings[property];
        }
    }
    changeVisibility(state) {
        this.formVisible = state === 'visible';
        if (state === 'hidden' && this.exportFormSettings?.groups?.savingReportGroup) {
            this.helper.setCookie('StimulsoftWebViewerExportSettingsOpeningGroups', JSON.stringify({
                SavingReportGroup: this.exportFormSettings.groups.savingReportGroup.opened,
                PageRangeGroup: this.exportFormSettings.groups.pageRangeGroup.opened,
                SettingsGroup: this.exportFormSettings.groups.settingsGroup.opened
            }));
        }
        if (state === 'visible') {
            this.updateDisabledComponents();
        }
    }
    showMenu(comp, button) {
        let menuName = 'documentSecurityMenu';
        if (comp.name === 'DocumentSecurityButton') {
            this.menuService.addMenu({
                type: menuName, name: menuName, items: [], parent: button.button,
                itemStyleName: 'stiJsViewerMenuStandartItem', menuStyleName: 'stiJsViewerDropdownMenu',
                state: ''
            });
        }
        else {
            menuName = this.menuService.VERTICAL_MENU_NAME;
            this.menuService.addMenu({
                type: 'buttonMenu', name: menuName, items: this.collections.getPdfSecurityCertificatesItems(), parent: button.button,
                itemStyleName: 'stiJsViewerMenuStandartItem', menuStyleName: 'stiJsViewerDropdownMenu',
                state: ''
            });
        }
        setTimeout(() => {
            this.menuService.showMenu(menuName);
        });
    }
    getTextBoxType(name) {
        if (name === 'SaveReportPassword' || name === 'PasswordInputUser' || name === 'PasswordInputOwner') {
            return this.formVisible ? 'password' : '';
        }
        return null;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ExportFormComponent, deps: [{ token: i1.ModelService }, { token: i2.ExportService }, { token: i3.HelperService }, { token: i4.FormService }, { token: i5.MenuService }, { token: i6.CollectionsService }, { token: i7.ControllerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ExportFormComponent, selector: "sti-export-form", inputs: { exportFormSettings: "exportFormSettings" }, viewQueries: [{ propertyName: "baseForm", first: true, predicate: ["baseForm"], descendants: true }, { propertyName: "saveReportMdc", first: true, predicate: ["saveReportMdc"], descendants: true }, { propertyName: "pagesRangeAll", first: true, predicate: ["pagesRangeAll"], descendants: true }, { propertyName: "pageRangeCurrentPage", first: true, predicate: ["pageRangeCurrentPage"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
    [color]="model.options.toolbar.fontColor"
    [fontSize]="'12px'"
    [containerPadding]="'3px'"
    [name]="'exportForm'"
    [caption]="model.loc('ExportFormTitle')"
    [defaultTop]="150"
    (changeVisibility)="changeVisibility($event)"
    (action)="action()">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
      <tbody>
          <tr *ngIf="exportFormSettings?.groups.savingReportGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SavingReport')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.savingReportGroup.opened"
               (action)="exportFormSettings.groups.savingReportGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #saveReportMdc
                           [name]="baseForm.name + 'SaveReportMdc'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdc')"
                           [margin]="'6px 8px 3px 8px'"
                           [checked]="true"
                           (action)="exportService.exportSettings.Format = 'Mdc'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdz'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdz')"
                           [margin]="'3px 8px 3px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdz'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdx'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdx')"
                           [margin]="'3px 8px 0px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdx'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" [style.padding]="'0px 8px'" [style.minWidth.px]="150" [attr.title]="model.loc('PasswordSaveReportTooltip')">
                      {{model.loc('PasswordSaveReport')}}
                      </td>
                      <td>
                        <sti-text-box
                           [width]="140"
                           [tooltip]="model.loc('PasswordSaveReportTooltip')"
                           [margin]="'4px 8px 0px 8px'"
                           [type]="getTextBoxType('SaveReportPassword')"
                           [enabled]="exportService.exportSettings.Format == 'Mdx'"
                           (onchange)="exportService.exportSettings.Password = $event.value">
                        </sti-text-box>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

          <tr *ngIf="exportFormSettings?.groups.pageRangeGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('PagesRange')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.pageRangeGroup.opened"
               (action)="exportFormSettings.groups.pageRangeGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pagesRangeAll
                           [name]="baseForm.name + 'PagesRangeAll'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeAll')"
                           [tooltip]="model.loc('PagesRangeAllTooltip')"
                           [margin]="'6px 8px 6px 8px'"
                           [checked]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           [enabled]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = 'All'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pageRangeCurrentPage
                           [name]="baseForm.name + 'PageRangeCurrentPage'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeCurrentPage')"
                           [tooltip]="model.loc('PagesRangeCurrentPageTooltip')"
                           [margin]="'0px 8px 4px 8px'"
                           [checked]="exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = (model.reportParams.pageNumber + 1).toString()">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'PageRangePages'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangePages')"
                           [tooltip]="model.loc('PagesRangePagesTooltip')"
                           [margin]="'0px 8px 0px 8px'"
                           [paddingLeftLastCell]="'60px'"
                           (action)="exportService.exportSettings.PageRange = pagesRange.element.nativeElement.value">
                              <sti-text-box #pagesRange
                                [width]="130"
                                [tooltip]="model.loc('PagesRangePagesTooltip')"
                                [margin]="'0px 0px 0px 30px'"
                                (onchange)="exportService.exportSettings.PageRange = $event.value"
                                (onblur)="exportService.exportSettings.PageRange = $event.value">
                              </sti-text-box>
                        </sti-radio-button>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

        <tr *ngIf="exportFormSettings?.groups.settingsGroup.visible"class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SettingsGroup')"
                [opened]="exportFormSettings.groups.settingsGroup.opened"
                [width]="390"
                [margin]="'4px'"
                [innerPadding]="'4px 0 4px 0'"
                (action)="exportFormSettings.groups.settingsGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
                  <tbody>
                    <tr *ngFor="let comp of exportFormSettings.components">
                      <td *ngIf="comp.label != null" [style.padding]="'0px 8px'" [style.minWidth.px]="150" [attr.title]="comp.tooltip">
                        {{comp.label}}
                      </td>

                      <td *ngIf="comp.name == 'UseDigitalSignature'">
                        <sti-check-box
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>
                      </td>

                      <td [attr.colSpan]="comp.label != null || comp.name == 'DocumentSecurityButton' || comp.name == 'UseDigitalSignature' ? 1 : 2">
                        <sti-drop-down-list-for-export-form *ngIf="comp.type == 'DropDownListForExportForm'"
                           [width]="comp.width"
                           [items]="comp.items"
                           [key]="getValue(comp, 'dropDownList')"
                           [margin]="comp.margin"
                           [verticalAlign]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'middle' : null"
                           [styleDisplay]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'inline-block' : null"
                           [enabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event.key)">
                        </sti-drop-down-list-for-export-form>

                        <div *ngIf="comp.name == 'ImageQuality' || comp.name == 'ImageResolution'"
                           [style.display]="'inline-block'">
                          {{comp.name == 'ImageQuality' ? '%' : 'dpi'}}
                        </div>

                        <sti-text-box *ngIf="comp.type == 'TextBox'"
                           [width]="comp.width"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [type]="getTextBoxType(comp.name)"
                           [enabled]="!comp.disabled"
                           [value]="getValue(comp)"
                           [enabled]="!disabledComponents[comp.name]"
                           (onchange)="componentAction(comp, $event.value)">
                        </sti-text-box>

                        <sti-check-box *ngIf="comp.type == 'CheckBox' || comp.type == 'DigitalSignature'"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           [isEnabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>

                      </td>

                      <td *ngIf="comp.name == 'DocumentSecurityButton'">
                        <sti-button #button
                           [width]="comp.width"
                           [arrow]="'Down'"
                           [minWidth]="'163px'"
                           [captionAlign]="'center'"
                           [display]="'inline-block'"
                           [styleName]="'stiJsViewerFormButton'"
                           [margin]="'2px 8px'"
                           [innerTableWidth]="'100%'"
                           [captionWidth]="'100%'"
                           [caption]="comp.name == 'DocumentSecurityButton' ? comp.caption : ''"
                           [enabled]="!disabledComponents[comp.name + 'Button']"
                           (action)="showMenu(comp, button)">
                        </sti-button>
                      </td>
                    </tr>
                  </tbody>
                </table>

              </sti-group-panel>
            </td>
        </tr>

        <tr *ngIf="model.options.exports.showOpenAfterExport && exportFormSettings?.openAfterExport && !exportService.sendMail" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
                <sti-check-box [captionText]="model.loc('OpenAfterExport')"
                  [tooltip]="model.loc('OpenAfterExportTooltip')"
                  [margin]="'4px 8px 4px 8px'"
                  [isChecked]="exportService.exportSettings.OpenAfterExport"
                  (action)="exportService.exportSettings.OpenAfterExport = $event">
                </sti-check-box>
            </td>
        </tr>
      </tbody>
    </table>

    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "directive", type: i8.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i8.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i10.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "textAlign", "autocomplete", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i11.CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }, { kind: "component", type: i12.BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }, { kind: "component", type: i13.GroupPanelComponent, selector: "sti-group-panel", inputs: ["width", "caption", "innerPadding", "opened", "margin"], outputs: ["action"] }, { kind: "component", type: i14.RadioButtonComponent, selector: "sti-radio-button", inputs: ["groupName", "name", "enabled", "checked", "tooltip", "caption", "margin", "paddingLeftLastCell"], outputs: ["action"] }, { kind: "component", type: i15.DropDownListForExportFormComponent, selector: "sti-drop-down-list-for-export-form", inputs: ["items", "width", "key", "margin", "enabled", "styleDisplay", "verticalAlign"], outputs: ["action"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ExportFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-export-form',
                    template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
    [color]="model.options.toolbar.fontColor"
    [fontSize]="'12px'"
    [containerPadding]="'3px'"
    [name]="'exportForm'"
    [caption]="model.loc('ExportFormTitle')"
    [defaultTop]="150"
    (changeVisibility)="changeVisibility($event)"
    (action)="action()">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
      <tbody>
          <tr *ngIf="exportFormSettings?.groups.savingReportGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SavingReport')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.savingReportGroup.opened"
               (action)="exportFormSettings.groups.savingReportGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #saveReportMdc
                           [name]="baseForm.name + 'SaveReportMdc'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdc')"
                           [margin]="'6px 8px 3px 8px'"
                           [checked]="true"
                           (action)="exportService.exportSettings.Format = 'Mdc'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdz'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdz')"
                           [margin]="'3px 8px 3px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdz'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdx'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdx')"
                           [margin]="'3px 8px 0px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdx'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" [style.padding]="'0px 8px'" [style.minWidth.px]="150" [attr.title]="model.loc('PasswordSaveReportTooltip')">
                      {{model.loc('PasswordSaveReport')}}
                      </td>
                      <td>
                        <sti-text-box
                           [width]="140"
                           [tooltip]="model.loc('PasswordSaveReportTooltip')"
                           [margin]="'4px 8px 0px 8px'"
                           [type]="getTextBoxType('SaveReportPassword')"
                           [enabled]="exportService.exportSettings.Format == 'Mdx'"
                           (onchange)="exportService.exportSettings.Password = $event.value">
                        </sti-text-box>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

          <tr *ngIf="exportFormSettings?.groups.pageRangeGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('PagesRange')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.pageRangeGroup.opened"
               (action)="exportFormSettings.groups.pageRangeGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pagesRangeAll
                           [name]="baseForm.name + 'PagesRangeAll'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeAll')"
                           [tooltip]="model.loc('PagesRangeAllTooltip')"
                           [margin]="'6px 8px 6px 8px'"
                           [checked]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           [enabled]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = 'All'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pageRangeCurrentPage
                           [name]="baseForm.name + 'PageRangeCurrentPage'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeCurrentPage')"
                           [tooltip]="model.loc('PagesRangeCurrentPageTooltip')"
                           [margin]="'0px 8px 4px 8px'"
                           [checked]="exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = (model.reportParams.pageNumber + 1).toString()">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'PageRangePages'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangePages')"
                           [tooltip]="model.loc('PagesRangePagesTooltip')"
                           [margin]="'0px 8px 0px 8px'"
                           [paddingLeftLastCell]="'60px'"
                           (action)="exportService.exportSettings.PageRange = pagesRange.element.nativeElement.value">
                              <sti-text-box #pagesRange
                                [width]="130"
                                [tooltip]="model.loc('PagesRangePagesTooltip')"
                                [margin]="'0px 0px 0px 30px'"
                                (onchange)="exportService.exportSettings.PageRange = $event.value"
                                (onblur)="exportService.exportSettings.PageRange = $event.value">
                              </sti-text-box>
                        </sti-radio-button>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

        <tr *ngIf="exportFormSettings?.groups.settingsGroup.visible"class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SettingsGroup')"
                [opened]="exportFormSettings.groups.settingsGroup.opened"
                [width]="390"
                [margin]="'4px'"
                [innerPadding]="'4px 0 4px 0'"
                (action)="exportFormSettings.groups.settingsGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'">
                  <tbody>
                    <tr *ngFor="let comp of exportFormSettings.components">
                      <td *ngIf="comp.label != null" [style.padding]="'0px 8px'" [style.minWidth.px]="150" [attr.title]="comp.tooltip">
                        {{comp.label}}
                      </td>

                      <td *ngIf="comp.name == 'UseDigitalSignature'">
                        <sti-check-box
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>
                      </td>

                      <td [attr.colSpan]="comp.label != null || comp.name == 'DocumentSecurityButton' || comp.name == 'UseDigitalSignature' ? 1 : 2">
                        <sti-drop-down-list-for-export-form *ngIf="comp.type == 'DropDownListForExportForm'"
                           [width]="comp.width"
                           [items]="comp.items"
                           [key]="getValue(comp, 'dropDownList')"
                           [margin]="comp.margin"
                           [verticalAlign]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'middle' : null"
                           [styleDisplay]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'inline-block' : null"
                           [enabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event.key)">
                        </sti-drop-down-list-for-export-form>

                        <div *ngIf="comp.name == 'ImageQuality' || comp.name == 'ImageResolution'"
                           [style.display]="'inline-block'">
                          {{comp.name == 'ImageQuality' ? '%' : 'dpi'}}
                        </div>

                        <sti-text-box *ngIf="comp.type == 'TextBox'"
                           [width]="comp.width"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [type]="getTextBoxType(comp.name)"
                           [enabled]="!comp.disabled"
                           [value]="getValue(comp)"
                           [enabled]="!disabledComponents[comp.name]"
                           (onchange)="componentAction(comp, $event.value)">
                        </sti-text-box>

                        <sti-check-box *ngIf="comp.type == 'CheckBox' || comp.type == 'DigitalSignature'"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           [isEnabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>

                      </td>

                      <td *ngIf="comp.name == 'DocumentSecurityButton'">
                        <sti-button #button
                           [width]="comp.width"
                           [arrow]="'Down'"
                           [minWidth]="'163px'"
                           [captionAlign]="'center'"
                           [display]="'inline-block'"
                           [styleName]="'stiJsViewerFormButton'"
                           [margin]="'2px 8px'"
                           [innerTableWidth]="'100%'"
                           [captionWidth]="'100%'"
                           [caption]="comp.name == 'DocumentSecurityButton' ? comp.caption : ''"
                           [enabled]="!disabledComponents[comp.name + 'Button']"
                           (action)="showMenu(comp, button)">
                        </sti-button>
                      </td>
                    </tr>
                  </tbody>
                </table>

              </sti-group-panel>
            </td>
        </tr>

        <tr *ngIf="model.options.exports.showOpenAfterExport && exportFormSettings?.openAfterExport && !exportService.sendMail" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
                <sti-check-box [captionText]="model.loc('OpenAfterExport')"
                  [tooltip]="model.loc('OpenAfterExportTooltip')"
                  [margin]="'4px 8px 4px 8px'"
                  [isChecked]="exportService.exportSettings.OpenAfterExport"
                  (action)="exportService.exportSettings.OpenAfterExport = $event">
                </sti-check-box>
            </td>
        </tr>
      </tbody>
    </table>

    </sti-base-form>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ExportService }, { type: i3.HelperService }, { type: i4.FormService }, { type: i5.MenuService }, { type: i6.CollectionsService }, { type: i7.ControllerService }], propDecorators: { baseForm: [{
                type: ViewChild,
                args: ['baseForm']
            }], saveReportMdc: [{
                type: ViewChild,
                args: ['saveReportMdc']
            }], pagesRangeAll: [{
                type: ViewChild,
                args: ['pagesRangeAll']
            }], pageRangeCurrentPage: [{
                type: ViewChild,
                args: ['pageRangeCurrentPage']
            }], exportFormSettings: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhwb3J0LWZvcm0uY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC12aWV3ZXItYW5ndWxhci9zcmMvbGliL2Zvcm1zL2V4cG9ydC1mb3JtLmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFVLEtBQUssRUFBYSxTQUFTLEVBQUUsTUFBTSxlQUFlLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBb1EvRSxNQUFNLE9BQU8sbUJBQW1CO0lBb0I5QixZQUFtQixLQUFtQixFQUFTLGFBQTRCLEVBQVMsTUFBcUIsRUFBUyxXQUF3QixFQUNqSSxXQUF3QixFQUFTLFdBQStCLEVBQVMsVUFBNkI7UUFENUYsVUFBSyxHQUFMLEtBQUssQ0FBYztRQUFTLGtCQUFhLEdBQWIsYUFBYSxDQUFlO1FBQVMsV0FBTSxHQUFOLE1BQU0sQ0FBZTtRQUFTLGdCQUFXLEdBQVgsV0FBVyxDQUFhO1FBQ2pJLGdCQUFXLEdBQVgsV0FBVyxDQUFhO1FBQVMsZ0JBQVcsR0FBWCxXQUFXLENBQW9CO1FBQVMsZUFBVSxHQUFWLFVBQVUsQ0FBbUI7UUFuQnZHLG1CQUFjLEdBQUc7WUFDdkIsa0JBQWtCLEVBQUUsYUFBYTtZQUNqQyxxQkFBcUIsRUFBRSxVQUFVO1lBQ2pDLGFBQWEsRUFBRSxZQUFZO1lBQzNCLGVBQWUsRUFBRSxVQUFVO1lBQzNCLGVBQWUsRUFBRSxVQUFVO1NBQzVCLENBQUM7UUFTRixnQkFBVyxHQUFHLEtBQUssQ0FBQztRQUNwQix1QkFBa0IsR0FBUSxFQUFFLENBQUM7SUFHc0YsQ0FBQztJQUVwSCxXQUFXLENBQUMsT0FBOEM7UUFDeEQsSUFBSSxJQUFJLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUUsSUFBSSxFQUFFLElBQUksS0FBSyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ3pFLFVBQVUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsd0JBQXdCLEVBQUUsQ0FBQyxDQUFDO1FBQ3BELENBQUM7SUFDSCxDQUFDO0lBRUQsUUFBUSxLQUFLLENBQUM7SUFFZCxNQUFNO1FBQ0osSUFBSSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUUvQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO1lBQ25ELElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLG1DQUFtQyxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMscUJBQXFCLEVBQUUsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztRQUM3SixDQUFDO1FBRUQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxVQUFVLEVBQUUsQ0FBQztJQUNsQyxDQUFDO0lBRUQsd0JBQXdCO1FBQ3RCLENBQUMsa0JBQWtCLEVBQUUsZUFBZSxFQUFFLFlBQVksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsY0FBYyxDQUFDLGNBQWMsS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDO1FBRTNKLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsc0JBQXNCLElBQUksSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsc0JBQXNCLEtBQUssTUFBTSxDQUFDO1FBRXZLLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxzQkFBc0IsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxjQUFjLEtBQUssVUFBVSxDQUFDO1FBQ2pILElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx5QkFBeUIsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxjQUFjLElBQUksVUFBVSxDQUFDO1FBRW5ILElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsd0JBQXdCLENBQUM7UUFFckcsSUFBSSxDQUFDLGtCQUFrQixDQUFDLHFCQUFxQixHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsY0FBYyxDQUFDLFNBQVMsS0FBSyxNQUFNLENBQUM7UUFFdkcsSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixHQUFHLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsbUJBQW1CLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsdUJBQXVCLEVBQUUsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBRTFKLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx3QkFBd0IsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyx3QkFBd0IsQ0FBQztRQUU5RyxJQUFJLElBQUksQ0FBQyxhQUFhLENBQUMsY0FBYyxDQUFDLFNBQVMsSUFBSSxJQUFJLEVBQUUsQ0FBQztZQUN4RCxNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxLQUFLLGFBQWEsQ0FBQyxDQUFDO1lBQ3pHLElBQUksV0FBVyxJQUFJLElBQUksRUFBRSxDQUFDO2dCQUN4QixXQUFXLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsU0FBUyxLQUFLLEtBQUssQ0FBQyxDQUFDO1lBQ2xILENBQUM7UUFDSCxDQUFDO1FBRUQsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxXQUFXLEtBQUssWUFBWSxDQUFDO1FBRXZHLElBQUksSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUFDLENBQUM7UUFDdkQsSUFBSSxJQUFJLENBQUMsYUFBYSxJQUFJLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsc0JBQXNCLEVBQUUsQ0FBQztZQUNoRyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQzdCLENBQUM7UUFDRCxJQUFJLElBQUksQ0FBQyxvQkFBb0IsSUFBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO1lBQ3RHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUNwQyxDQUFDO1FBRUQsSUFBSSxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsS0FBSyxJQUFJLEVBQUUsQ0FBQztZQUNqRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7UUFDL0UsQ0FBQztRQUVELElBQUksSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsaUJBQWlCLEtBQUssS0FBSyxFQUFFLENBQUM7WUFDbEUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsc0JBQXNCLEdBQUcsSUFBSSxDQUFDO1FBQzlFLENBQUM7SUFDSCxDQUFDO0lBRUQsZUFBZSxDQUFDLElBQXFCLEVBQUUsS0FBVztRQUNoRCxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDO1FBRTNELFFBQVEsUUFBUSxFQUFFLENBQUM7WUFDakIsS0FBSyxlQUFlLENBQUM7WUFDckIsS0FBSyxZQUFZO2dCQUNmLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQ1YsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO2dCQUM3RCxDQUFDO2dCQUNELE1BQU07WUFFUixLQUFLLGtCQUFrQjtnQkFDckIsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDVixJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO29CQUN4RCxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO2dCQUN2RCxDQUFDO2dCQUNELE1BQU07WUFFUixLQUFLLFdBQVc7Z0JBQ2QsSUFBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsT0FBTyxHQUFHLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztnQkFDakQsTUFBTTtZQUVSLEtBQUssVUFBVSxDQUFDO1lBQ2hCLEtBQUssVUFBVTtnQkFDYixJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUM7Z0JBQ3ZDLE1BQU07WUFFUixLQUFLLFdBQVc7Z0JBQ2QsTUFBTSxZQUFZLEdBQUcsS0FBSyxLQUFLLGFBQWEsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUM7Z0JBQy9ELElBQUksQ0FBQyxhQUFhLENBQUMsTUFBTSxDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsQ0FBQztnQkFDOUMsTUFBTTtZQUVSLEtBQUsscUJBQXFCO2dCQUN4QixJQUFJLENBQUMsQ0FBQyxLQUFLLEtBQUssSUFBSSxJQUFJLEtBQUssS0FBSyxLQUFLLENBQUMsRUFBRSxDQUFDO29CQUN6QyxRQUFRLEdBQUcsdUJBQXVCLENBQUM7Z0JBQ3JDLENBQUM7Z0JBQ0QsSUFBSSxLQUFLLEtBQUssSUFBSSxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsK0JBQStCLEVBQUUsQ0FBQyxNQUFNLElBQUksQ0FBQyxFQUFFLENBQUM7b0JBQ3JGLEtBQUssR0FBRyxLQUFLLENBQUM7b0JBQ2QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsU0FBUyxFQUFFLHdCQUF3QixDQUFDLENBQUM7Z0JBQ2pFLENBQUM7Z0JBQ0QsTUFBTTtZQUVSLEtBQUssMEJBQTBCO2dCQUM3QixJQUFJLEtBQUssS0FBSyxJQUFJLEVBQUUsQ0FBQztvQkFDbkIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsd0JBQXdCLEdBQUcsSUFBSSxDQUFDO2dCQUNwRSxDQUFDO2dCQUNELE1BQU07UUFDVixDQUFDO1FBRUQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsUUFBUSxDQUFDLEdBQUcsS0FBSyxDQUFDO1FBRXBELElBQUksQ0FBQyx3QkFBd0IsRUFBRSxDQUFDO0lBQ2xDLENBQUM7SUFFRCxRQUFRLENBQUMsSUFBcUIsRUFBRSxTQUFrQjtRQUNoRCxNQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDO1FBQzdELFFBQVEsUUFBUSxFQUFFLENBQUM7WUFDakIsS0FBSyxPQUFPO2dCQUNWLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsUUFBUSxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7WUFFaEUsS0FBSyxxQkFBcUI7Z0JBQ3hCLElBQUksU0FBUyxJQUFJLGNBQWMsRUFBRSxDQUFDO29CQUNoQyxPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsY0FBYyxDQUFDLHVCQUF1QixDQUFDLENBQUM7Z0JBQ3BFLENBQUM7WUFDSDtnQkFDRSxPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsY0FBYyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3ZELENBQUM7SUFDSCxDQUFDO0lBRUQsZ0JBQWdCLENBQUMsS0FBYTtRQUM1QixJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssS0FBSyxTQUFTLENBQUM7UUFFdkMsSUFBSSxLQUFLLEtBQUssUUFBUSxJQUFJLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxNQUFNLEVBQUUsaUJBQWlCLEVBQUUsQ0FBQztZQUM3RSxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxnREFBZ0QsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDO2dCQUNyRixpQkFBaUIsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLGlCQUFpQixDQUFDLE1BQU07Z0JBQzFFLGNBQWMsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxNQUFNO2dCQUNwRSxhQUFhLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsTUFBTTthQUNuRSxDQUFDLENBQUMsQ0FBQztRQUNOLENBQUM7UUFDRCxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUUsQ0FBQztZQUN4QixJQUFJLENBQUMsd0JBQXdCLEVBQUUsQ0FBQztRQUNsQyxDQUFDO0lBQ0gsQ0FBQztJQUVELFFBQVEsQ0FBQyxJQUFxQixFQUFFLE1BQXVCO1FBQ3JELElBQUksUUFBUSxHQUFHLHNCQUFzQixDQUFDO1FBQ3RDLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyx3QkFBd0IsRUFBRSxDQUFDO1lBQzNDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDO2dCQUN2QixJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsS0FBSyxFQUFFLEVBQUUsRUFBRSxNQUFNLEVBQUUsTUFBTSxDQUFDLE1BQU07Z0JBQ2hFLGFBQWEsRUFBRSw2QkFBNkIsRUFBRSxhQUFhLEVBQUUseUJBQXlCO2dCQUN0RixLQUFLLEVBQUUsRUFBRTthQUNWLENBQUMsQ0FBQztRQUNMLENBQUM7YUFBTSxDQUFDO1lBQ04sUUFBUSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsa0JBQWtCLENBQUM7WUFDL0MsSUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUM7Z0JBQ3ZCLElBQUksRUFBRSxZQUFZLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQywrQkFBK0IsRUFBRSxFQUFFLE1BQU0sRUFBRSxNQUFNLENBQUMsTUFBTTtnQkFDcEgsYUFBYSxFQUFFLDZCQUE2QixFQUFFLGFBQWEsRUFBRSx5QkFBeUI7Z0JBQ3RGLEtBQUssRUFBRSxFQUFFO2FBQ1YsQ0FBQyxDQUFDO1FBQ0wsQ0FBQztRQUVELFVBQVUsQ0FBQyxHQUFHLEVBQUU7WUFDZCxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUN0QyxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCxjQUFjLENBQUMsSUFBWTtRQUN6QixJQUFJLElBQUksS0FBSyxvQkFBb0IsSUFBSSxJQUFJLEtBQUssbUJBQW1CLElBQUksSUFBSSxLQUFLLG9CQUFvQixFQUFFLENBQUM7WUFDbkcsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUM1QyxDQUFDO1FBQ0QsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOytHQWxNVSxtQkFBbUI7bUdBQW5CLG1CQUFtQix5aEJBclBwQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FrUFQ7OzRGQUdVLG1CQUFtQjtrQkF2UC9CLFNBQVM7bUJBQUM7b0JBQ1QsUUFBUSxFQUFFLGlCQUFpQjtvQkFDM0IsUUFBUSxFQUFFOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQWtQVDtpQkFDRjs4UEFZd0IsUUFBUTtzQkFBOUIsU0FBUzt1QkFBQyxVQUFVO2dCQUNPLGFBQWE7c0JBQXhDLFNBQVM7dUJBQUMsZUFBZTtnQkFDRSxhQUFhO3NCQUF4QyxTQUFTO3VCQUFDLGVBQWU7Z0JBQ1Msb0JBQW9CO3NCQUF0RCxTQUFTO3VCQUFDLHNCQUFzQjtnQkFFeEIsa0JBQWtCO3NCQUExQixLQUFLIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBPbkluaXQsIElucHV0LCBPbkNoYW5nZXMsIFZpZXdDaGlsZCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBNb2RlbFNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlJztcclxuaW1wb3J0IHsgRXhwb3J0Rm9ybVNldHRpbmdzLCBFeHBvcnRDb21wb25lbnQsIEV4cG9ydEdyb3VwIH0gZnJvbSAnLi4vc2VydmljZXMvb2JqZWN0cyc7XHJcbmltcG9ydCB7IEV4cG9ydFNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9leHBvcnQuc2VydmljZSc7XHJcbmltcG9ydCB7IEJhc2VGb3JtQ29tcG9uZW50IH0gZnJvbSAnLi9iYXNlLWZvcm0uY29tcG9uZW50JztcclxuaW1wb3J0IHsgSGVscGVyU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL2hlbHBlci5zZXJ2aWNlJztcclxuaW1wb3J0IHsgRm9ybVNlcnZpY2UgfSBmcm9tICcuL2Zvcm0uc2VydmljZSc7XHJcbmltcG9ydCB7IE1lbnVTZXJ2aWNlIH0gZnJvbSAnLi4vbWVudS9tZW51LnNlcnZpY2UnO1xyXG5pbXBvcnQgeyBCdXR0b25Db21wb25lbnQgfSBmcm9tICcuLi9jb250cm9scy9idXR0b24uY29tcG9uZW50JztcclxuaW1wb3J0IHsgQ29sbGVjdGlvbnNTZXJ2aWNlIH0gZnJvbSAnLi4vc2VydmljZXMvY29sbGVjdGlvbnMuc2VydmljZSc7XHJcbmltcG9ydCB7IFJhZGlvQnV0dG9uQ29tcG9uZW50IH0gZnJvbSAnLi4vY29udHJvbHMvcmFkaW8tYnV0dG9uLmNvbXBvbmVudHMnO1xyXG5pbXBvcnQgeyBDb250cm9sbGVyU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL2NvbnRyb2xsZXIuc2VydmljZSc7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3N0aS1leHBvcnQtZm9ybScsXHJcbiAgdGVtcGxhdGU6IGBcclxuICAgIDxzdGktYmFzZS1mb3JtICNiYXNlRm9ybSBbZm9udEZhbWlseV09XCJtb2RlbC5vcHRpb25zLnRvb2xiYXIuZm9udEZhbWlseVwiXHJcbiAgICBbY29sb3JdPVwibW9kZWwub3B0aW9ucy50b29sYmFyLmZvbnRDb2xvclwiXHJcbiAgICBbZm9udFNpemVdPVwiJzEycHgnXCJcclxuICAgIFtjb250YWluZXJQYWRkaW5nXT1cIiczcHgnXCJcclxuICAgIFtuYW1lXT1cIidleHBvcnRGb3JtJ1wiXHJcbiAgICBbY2FwdGlvbl09XCJtb2RlbC5sb2MoJ0V4cG9ydEZvcm1UaXRsZScpXCJcclxuICAgIFtkZWZhdWx0VG9wXT1cIjE1MFwiXHJcbiAgICAoY2hhbmdlVmlzaWJpbGl0eSk9XCJjaGFuZ2VWaXNpYmlsaXR5KCRldmVudClcIlxyXG4gICAgKGFjdGlvbik9XCJhY3Rpb24oKVwiPlxyXG4gICAgPHRhYmxlIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiIGNlbGxwYWRkaW5nPVwiMFwiIGNlbGxzcGFjaW5nPVwiMFwiIFtzdHlsZS53aWR0aF09XCInMTAwJSdcIj5cclxuICAgICAgPHRib2R5PlxyXG4gICAgICAgICAgPHRyICpuZ0lmPVwiZXhwb3J0Rm9ybVNldHRpbmdzPy5ncm91cHMuc2F2aW5nUmVwb3J0R3JvdXAudmlzaWJsZVwiIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgY29sc3Bhbj1cIjJcIj5cclxuICAgICAgICAgICAgICA8c3RpLWdyb3VwLXBhbmVsIFtjYXB0aW9uXT1cIm1vZGVsLmxvYygnU2F2aW5nUmVwb3J0JylcIlxyXG4gICAgICAgICAgICAgICBbd2lkdGhdPVwiMzkwXCJcclxuICAgICAgICAgICAgICAgW21hcmdpbl09XCInNHB4J1wiXHJcbiAgICAgICAgICAgICAgIFtpbm5lclBhZGRpbmddPVwiJzRweCAwIDRweCAwJ1wiXHJcbiAgICAgICAgICAgICAgIFtvcGVuZWRdPVwiZXhwb3J0Rm9ybVNldHRpbmdzLmdyb3Vwcy5zYXZpbmdSZXBvcnRHcm91cC5vcGVuZWRcIlxyXG4gICAgICAgICAgICAgICAoYWN0aW9uKT1cImV4cG9ydEZvcm1TZXR0aW5ncy5ncm91cHMuc2F2aW5nUmVwb3J0R3JvdXAub3BlbmVkPSRldmVudFwiPlxyXG4gICAgICAgICAgICAgICAgPHRhYmxlIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiIGNlbGxwYWRkaW5nPVwiMFwiIGNlbGxzcGFjaW5nPVwiMFwiIFtzdHlsZS53aWR0aF09XCInMTAwJSdcIj5cclxuICAgICAgICAgICAgICAgICAgPHRib2R5PlxyXG4gICAgICAgICAgICAgICAgICAgIDx0ciBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIiBjb2xzcGFuPVwiMlwiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICA8c3RpLXJhZGlvLWJ1dHRvbiAjc2F2ZVJlcG9ydE1kY1xyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbbmFtZV09XCJiYXNlRm9ybS5uYW1lICsgJ1NhdmVSZXBvcnRNZGMnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2dyb3VwTmFtZV09XCJiYXNlRm9ybS5uYW1lICsgJ1NhdmluZ1JlcG9ydEdyb3VwJ1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtjYXB0aW9uXT1cIm1vZGVsLmxvYygnU2F2ZVJlcG9ydE1kYycpXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW21hcmdpbl09XCInNnB4IDhweCAzcHggOHB4J1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtjaGVja2VkXT1cInRydWVcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAoYWN0aW9uKT1cImV4cG9ydFNlcnZpY2UuZXhwb3J0U2V0dGluZ3MuRm9ybWF0ID0gJ01kYydcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgPC9zdGktcmFkaW8tYnV0dG9uPlxyXG4gICAgICAgICAgICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgICAgICAgICAgICA8L3RyPlxyXG4gICAgICAgICAgICAgICAgICAgIDx0ciBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIiBjb2xzcGFuPVwiMlwiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICA8c3RpLXJhZGlvLWJ1dHRvblxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbbmFtZV09XCJiYXNlRm9ybS5uYW1lICsgJ1NhdmVSZXBvcnRNZHonXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2dyb3VwTmFtZV09XCJiYXNlRm9ybS5uYW1lICsgJ1NhdmluZ1JlcG9ydEdyb3VwJ1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtjYXB0aW9uXT1cIm1vZGVsLmxvYygnU2F2ZVJlcG9ydE1keicpXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW21hcmdpbl09XCInM3B4IDhweCAzcHggOHB4J1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIChhY3Rpb24pPVwiZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5Gb3JtYXQgPSAnTWR6J1wiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICA8L3N0aS1yYWRpby1idXR0b24+XHJcbiAgICAgICAgICAgICAgICAgICAgICA8L3RkPlxyXG4gICAgICAgICAgICAgICAgICAgIDwvdHI+XHJcbiAgICAgICAgICAgICAgICAgICAgPHRyIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgPHRkIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiIGNvbHNwYW49XCIyXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDxzdGktcmFkaW8tYnV0dG9uXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtuYW1lXT1cImJhc2VGb3JtLm5hbWUgKyAnU2F2ZVJlcG9ydE1keCdcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbZ3JvdXBOYW1lXT1cImJhc2VGb3JtLm5hbWUgKyAnU2F2aW5nUmVwb3J0R3JvdXAnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NhcHRpb25dPVwibW9kZWwubG9jKCdTYXZlUmVwb3J0TWR4JylcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbbWFyZ2luXT1cIiczcHggOHB4IDBweCA4cHgnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgKGFjdGlvbik9XCJleHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLkZvcm1hdCA9ICdNZHgnXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDwvc3RpLXJhZGlvLWJ1dHRvbj5cclxuICAgICAgICAgICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgICAgICAgICAgPC90cj5cclxuICAgICAgICAgICAgICAgICAgICA8dHIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgW3N0eWxlLnBhZGRpbmddPVwiJzBweCA4cHgnXCIgW3N0eWxlLm1pbldpZHRoLnB4XT1cIjE1MFwiIFthdHRyLnRpdGxlXT1cIm1vZGVsLmxvYygnUGFzc3dvcmRTYXZlUmVwb3J0VG9vbHRpcCcpXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICB7e21vZGVsLmxvYygnUGFzc3dvcmRTYXZlUmVwb3J0Jyl9fVxyXG4gICAgICAgICAgICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgICAgICAgICAgICAgIDx0ZD5cclxuICAgICAgICAgICAgICAgICAgICAgICAgPHN0aS10ZXh0LWJveFxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbd2lkdGhdPVwiMTQwXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW3Rvb2x0aXBdPVwibW9kZWwubG9jKCdQYXNzd29yZFNhdmVSZXBvcnRUb29sdGlwJylcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbbWFyZ2luXT1cIic0cHggOHB4IDBweCA4cHgnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW3R5cGVdPVwiZ2V0VGV4dEJveFR5cGUoJ1NhdmVSZXBvcnRQYXNzd29yZCcpXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2VuYWJsZWRdPVwiZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5Gb3JtYXQgPT0gJ01keCdcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAob25jaGFuZ2UpPVwiZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5QYXNzd29yZCA9ICRldmVudC52YWx1ZVwiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICA8L3N0aS10ZXh0LWJveD5cclxuICAgICAgICAgICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgICAgICAgICAgPC90cj5cclxuICAgICAgICAgICAgICAgICAgPC90Ym9keT5cclxuICAgICAgICAgICAgICAgIDwvdGFibGU+XHJcbiAgICAgICAgICAgICAgPC9zdGktZ3JvdXAtcGFuZWw+XHJcbiAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICA8L3RyPlxyXG5cclxuICAgICAgICAgIDx0ciAqbmdJZj1cImV4cG9ydEZvcm1TZXR0aW5ncz8uZ3JvdXBzLnBhZ2VSYW5nZUdyb3VwLnZpc2libGVcIiBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgPHRkIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiIGNvbHNwYW49XCIyXCI+XHJcbiAgICAgICAgICAgICAgPHN0aS1ncm91cC1wYW5lbCBbY2FwdGlvbl09XCJtb2RlbC5sb2MoJ1BhZ2VzUmFuZ2UnKVwiXHJcbiAgICAgICAgICAgICAgIFt3aWR0aF09XCIzOTBcIlxyXG4gICAgICAgICAgICAgICBbbWFyZ2luXT1cIic0cHgnXCJcclxuICAgICAgICAgICAgICAgW2lubmVyUGFkZGluZ109XCInNHB4IDAgNHB4IDAnXCJcclxuICAgICAgICAgICAgICAgW29wZW5lZF09XCJleHBvcnRGb3JtU2V0dGluZ3MuZ3JvdXBzLnBhZ2VSYW5nZUdyb3VwLm9wZW5lZFwiXHJcbiAgICAgICAgICAgICAgIChhY3Rpb24pPVwiZXhwb3J0Rm9ybVNldHRpbmdzLmdyb3Vwcy5wYWdlUmFuZ2VHcm91cC5vcGVuZWQ9JGV2ZW50XCI+XHJcbiAgICAgICAgICAgICAgICA8dGFibGUgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgY2VsbHBhZGRpbmc9XCIwXCIgY2VsbHNwYWNpbmc9XCIwXCIgW3N0eWxlLndpZHRoXT1cIicxMDAlJ1wiPlxyXG4gICAgICAgICAgICAgICAgICA8dGJvZHk+XHJcbiAgICAgICAgICAgICAgICAgICAgPHRyIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgPHRkIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiIGNvbHNwYW49XCIyXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDxzdGktcmFkaW8tYnV0dG9uICNwYWdlc1JhbmdlQWxsXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtuYW1lXT1cImJhc2VGb3JtLm5hbWUgKyAnUGFnZXNSYW5nZUFsbCdcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbZ3JvdXBOYW1lXT1cImJhc2VGb3JtLm5hbWUgKyAnUGFnZVJhbmdlR3JvdXAnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NhcHRpb25dPVwibW9kZWwubG9jKCdQYWdlc1JhbmdlQWxsJylcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbdG9vbHRpcF09XCJtb2RlbC5sb2MoJ1BhZ2VzUmFuZ2VBbGxUb29sdGlwJylcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbbWFyZ2luXT1cIic2cHggOHB4IDZweCA4cHgnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NoZWNrZWRdPVwiIWV4cG9ydEZvcm1TZXR0aW5ncy5ncm91cHMucGFnZVJhbmdlR3JvdXAucGFnZVJhbmdlQWxsSXNEaXNhYmxlZFwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtlbmFibGVkXT1cIiFleHBvcnRGb3JtU2V0dGluZ3MuZ3JvdXBzLnBhZ2VSYW5nZUdyb3VwLnBhZ2VSYW5nZUFsbElzRGlzYWJsZWRcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAoYWN0aW9uKT1cImV4cG9ydFNlcnZpY2UuZXhwb3J0U2V0dGluZ3MuUGFnZVJhbmdlID0gJ0FsbCdcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgPC9zdGktcmFkaW8tYnV0dG9uPlxyXG4gICAgICAgICAgICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgICAgICAgICAgICA8L3RyPlxyXG4gICAgICAgICAgICAgICAgICAgIDx0ciBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIiBjb2xzcGFuPVwiMlwiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICA8c3RpLXJhZGlvLWJ1dHRvbiAjcGFnZVJhbmdlQ3VycmVudFBhZ2VcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW25hbWVdPVwiYmFzZUZvcm0ubmFtZSArICdQYWdlUmFuZ2VDdXJyZW50UGFnZSdcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbZ3JvdXBOYW1lXT1cImJhc2VGb3JtLm5hbWUgKyAnUGFnZVJhbmdlR3JvdXAnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NhcHRpb25dPVwibW9kZWwubG9jKCdQYWdlc1JhbmdlQ3VycmVudFBhZ2UnKVwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFt0b29sdGlwXT1cIm1vZGVsLmxvYygnUGFnZXNSYW5nZUN1cnJlbnRQYWdlVG9vbHRpcCcpXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW21hcmdpbl09XCInMHB4IDhweCA0cHggOHB4J1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtjaGVja2VkXT1cImV4cG9ydEZvcm1TZXR0aW5ncy5ncm91cHMucGFnZVJhbmdlR3JvdXAucGFnZVJhbmdlQWxsSXNEaXNhYmxlZFwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIChhY3Rpb24pPVwiZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5QYWdlUmFuZ2UgPSAobW9kZWwucmVwb3J0UGFyYW1zLnBhZ2VOdW1iZXIgKyAxKS50b1N0cmluZygpXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDwvc3RpLXJhZGlvLWJ1dHRvbj5cclxuICAgICAgICAgICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgICAgICAgICAgPC90cj5cclxuICAgICAgICAgICAgICAgICAgICA8dHIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgY29sc3Bhbj1cIjJcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgPHN0aS1yYWRpby1idXR0b25cclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW25hbWVdPVwiYmFzZUZvcm0ubmFtZSArICdQYWdlUmFuZ2VQYWdlcydcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbZ3JvdXBOYW1lXT1cImJhc2VGb3JtLm5hbWUgKyAnUGFnZVJhbmdlR3JvdXAnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NhcHRpb25dPVwibW9kZWwubG9jKCdQYWdlc1JhbmdlUGFnZXMnKVwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFt0b29sdGlwXT1cIm1vZGVsLmxvYygnUGFnZXNSYW5nZVBhZ2VzVG9vbHRpcCcpXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW21hcmdpbl09XCInMHB4IDhweCAwcHggOHB4J1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtwYWRkaW5nTGVmdExhc3RDZWxsXT1cIic2MHB4J1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIChhY3Rpb24pPVwiZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5QYWdlUmFuZ2UgPSBwYWdlc1JhbmdlLmVsZW1lbnQubmF0aXZlRWxlbWVudC52YWx1ZVwiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c3RpLXRleHQtYm94ICNwYWdlc1JhbmdlXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW3dpZHRoXT1cIjEzMFwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW3Rvb2x0aXBdPVwibW9kZWwubG9jKCdQYWdlc1JhbmdlUGFnZXNUb29sdGlwJylcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFttYXJnaW5dPVwiJzBweCAwcHggMHB4IDMwcHgnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAob25jaGFuZ2UpPVwiZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5QYWdlUmFuZ2UgPSAkZXZlbnQudmFsdWVcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIChvbmJsdXIpPVwiZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5QYWdlUmFuZ2UgPSAkZXZlbnQudmFsdWVcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9zdGktdGV4dC1ib3g+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDwvc3RpLXJhZGlvLWJ1dHRvbj5cclxuICAgICAgICAgICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgICAgICAgICAgPC90cj5cclxuICAgICAgICAgICAgICAgICAgPC90Ym9keT5cclxuICAgICAgICAgICAgICAgIDwvdGFibGU+XHJcbiAgICAgICAgICAgICAgPC9zdGktZ3JvdXAtcGFuZWw+XHJcbiAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICA8L3RyPlxyXG5cclxuICAgICAgICA8dHIgKm5nSWY9XCJleHBvcnRGb3JtU2V0dGluZ3M/Lmdyb3Vwcy5zZXR0aW5nc0dyb3VwLnZpc2libGVcImNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgY29sc3Bhbj1cIjJcIj5cclxuICAgICAgICAgICAgICA8c3RpLWdyb3VwLXBhbmVsIFtjYXB0aW9uXT1cIm1vZGVsLmxvYygnU2V0dGluZ3NHcm91cCcpXCJcclxuICAgICAgICAgICAgICAgIFtvcGVuZWRdPVwiZXhwb3J0Rm9ybVNldHRpbmdzLmdyb3Vwcy5zZXR0aW5nc0dyb3VwLm9wZW5lZFwiXHJcbiAgICAgICAgICAgICAgICBbd2lkdGhdPVwiMzkwXCJcclxuICAgICAgICAgICAgICAgIFttYXJnaW5dPVwiJzRweCdcIlxyXG4gICAgICAgICAgICAgICAgW2lubmVyUGFkZGluZ109XCInNHB4IDAgNHB4IDAnXCJcclxuICAgICAgICAgICAgICAgIChhY3Rpb24pPVwiZXhwb3J0Rm9ybVNldHRpbmdzLmdyb3Vwcy5zZXR0aW5nc0dyb3VwLm9wZW5lZD0kZXZlbnRcIj5cclxuICAgICAgICAgICAgICAgIDx0YWJsZSBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIiBjZWxscGFkZGluZz1cIjBcIiBjZWxsc3BhY2luZz1cIjBcIiBbc3R5bGUud2lkdGhdPVwiJzEwMCUnXCI+XHJcbiAgICAgICAgICAgICAgICAgIDx0Ym9keT5cclxuICAgICAgICAgICAgICAgICAgICA8dHIgKm5nRm9yPVwibGV0IGNvbXAgb2YgZXhwb3J0Rm9ybVNldHRpbmdzLmNvbXBvbmVudHNcIj5cclxuICAgICAgICAgICAgICAgICAgICAgIDx0ZCAqbmdJZj1cImNvbXAubGFiZWwgIT0gbnVsbFwiIFtzdHlsZS5wYWRkaW5nXT1cIicwcHggOHB4J1wiIFtzdHlsZS5taW5XaWR0aC5weF09XCIxNTBcIiBbYXR0ci50aXRsZV09XCJjb21wLnRvb2x0aXBcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAge3tjb21wLmxhYmVsfX1cclxuICAgICAgICAgICAgICAgICAgICAgIDwvdGQ+XHJcblxyXG4gICAgICAgICAgICAgICAgICAgICAgPHRkICpuZ0lmPVwiY29tcC5uYW1lID09ICdVc2VEaWdpdGFsU2lnbmF0dXJlJ1wiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICA8c3RpLWNoZWNrLWJveFxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbdG9vbHRpcF09XCJjb21wLnRvb2x0aXBcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbbWFyZ2luXT1cImNvbXAubWFyZ2luXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NhcHRpb25UZXh0XT1cImNvbXAuY2FwdGlvblwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtpc0NoZWNrZWRdPVwiZ2V0VmFsdWUoY29tcClcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAoYWN0aW9uKT1cImNvbXBvbmVudEFjdGlvbihjb21wLCAkZXZlbnQpXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDwvc3RpLWNoZWNrLWJveD5cclxuICAgICAgICAgICAgICAgICAgICAgIDwvdGQ+XHJcblxyXG4gICAgICAgICAgICAgICAgICAgICAgPHRkIFthdHRyLmNvbFNwYW5dPVwiY29tcC5sYWJlbCAhPSBudWxsIHx8IGNvbXAubmFtZSA9PSAnRG9jdW1lbnRTZWN1cml0eUJ1dHRvbicgfHwgY29tcC5uYW1lID09ICdVc2VEaWdpdGFsU2lnbmF0dXJlJyA/IDEgOiAyXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDxzdGktZHJvcC1kb3duLWxpc3QtZm9yLWV4cG9ydC1mb3JtICpuZ0lmPVwiY29tcC50eXBlID09ICdEcm9wRG93bkxpc3RGb3JFeHBvcnRGb3JtJ1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFt3aWR0aF09XCJjb21wLndpZHRoXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2l0ZW1zXT1cImNvbXAuaXRlbXNcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBba2V5XT1cImdldFZhbHVlKGNvbXAsICdkcm9wRG93bkxpc3QnKVwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFttYXJnaW5dPVwiY29tcC5tYXJnaW5cIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbdmVydGljYWxBbGlnbl09XCJjb21wLm5hbWUgPT0gJ0ltYWdlUXVhbGl0eScgfHwgY29tcC5uYW1lID09ICdJbWFnZVJlc29sdXRpb24nID8gJ21pZGRsZScgOiBudWxsXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW3N0eWxlRGlzcGxheV09XCJjb21wLm5hbWUgPT0gJ0ltYWdlUXVhbGl0eScgfHwgY29tcC5uYW1lID09ICdJbWFnZVJlc29sdXRpb24nID8gJ2lubGluZS1ibG9jaycgOiBudWxsXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2VuYWJsZWRdPVwiIWRpc2FibGVkQ29tcG9uZW50c1tjb21wLm5hbWVdXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgKGFjdGlvbik9XCJjb21wb25lbnRBY3Rpb24oY29tcCwgJGV2ZW50LmtleSlcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgPC9zdGktZHJvcC1kb3duLWxpc3QtZm9yLWV4cG9ydC1mb3JtPlxyXG5cclxuICAgICAgICAgICAgICAgICAgICAgICAgPGRpdiAqbmdJZj1cImNvbXAubmFtZSA9PSAnSW1hZ2VRdWFsaXR5JyB8fCBjb21wLm5hbWUgPT0gJ0ltYWdlUmVzb2x1dGlvbidcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbc3R5bGUuZGlzcGxheV09XCInaW5saW5lLWJsb2NrJ1wiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgIHt7Y29tcC5uYW1lID09ICdJbWFnZVF1YWxpdHknID8gJyUnIDogJ2RwaSd9fVxyXG4gICAgICAgICAgICAgICAgICAgICAgICA8L2Rpdj5cclxuXHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDxzdGktdGV4dC1ib3ggKm5nSWY9XCJjb21wLnR5cGUgPT0gJ1RleHRCb3gnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW3dpZHRoXT1cImNvbXAud2lkdGhcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbdG9vbHRpcF09XCJjb21wLnRvb2x0aXBcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbbWFyZ2luXT1cImNvbXAubWFyZ2luXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW3R5cGVdPVwiZ2V0VGV4dEJveFR5cGUoY29tcC5uYW1lKVwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtlbmFibGVkXT1cIiFjb21wLmRpc2FibGVkXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW3ZhbHVlXT1cImdldFZhbHVlKGNvbXApXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2VuYWJsZWRdPVwiIWRpc2FibGVkQ29tcG9uZW50c1tjb21wLm5hbWVdXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgKG9uY2hhbmdlKT1cImNvbXBvbmVudEFjdGlvbihjb21wLCAkZXZlbnQudmFsdWUpXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDwvc3RpLXRleHQtYm94PlxyXG5cclxuICAgICAgICAgICAgICAgICAgICAgICAgPHN0aS1jaGVjay1ib3ggKm5nSWY9XCJjb21wLnR5cGUgPT0gJ0NoZWNrQm94JyB8fCBjb21wLnR5cGUgPT0gJ0RpZ2l0YWxTaWduYXR1cmUnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW3Rvb2x0aXBdPVwiY29tcC50b29sdGlwXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW21hcmdpbl09XCJjb21wLm1hcmdpblwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtjYXB0aW9uVGV4dF09XCJjb21wLmNhcHRpb25cIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbaXNDaGVja2VkXT1cImdldFZhbHVlKGNvbXApXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2lzRW5hYmxlZF09XCIhZGlzYWJsZWRDb21wb25lbnRzW2NvbXAubmFtZV1cIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAoYWN0aW9uKT1cImNvbXBvbmVudEFjdGlvbihjb21wLCAkZXZlbnQpXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgIDwvc3RpLWNoZWNrLWJveD5cclxuXHJcbiAgICAgICAgICAgICAgICAgICAgICA8L3RkPlxyXG5cclxuICAgICAgICAgICAgICAgICAgICAgIDx0ZCAqbmdJZj1cImNvbXAubmFtZSA9PSAnRG9jdW1lbnRTZWN1cml0eUJ1dHRvbidcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgPHN0aS1idXR0b24gI2J1dHRvblxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbd2lkdGhdPVwiY29tcC53aWR0aFwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFthcnJvd109XCInRG93bidcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbbWluV2lkdGhdPVwiJzE2M3B4J1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtjYXB0aW9uQWxpZ25dPVwiJ2NlbnRlcidcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbZGlzcGxheV09XCInaW5saW5lLWJsb2NrJ1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtzdHlsZU5hbWVdPVwiJ3N0aUpzVmlld2VyRm9ybUJ1dHRvbidcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbbWFyZ2luXT1cIicycHggOHB4J1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFtpbm5lclRhYmxlV2lkdGhdPVwiJzEwMCUnXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NhcHRpb25XaWR0aF09XCInMTAwJSdcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbY2FwdGlvbl09XCJjb21wLm5hbWUgPT0gJ0RvY3VtZW50U2VjdXJpdHlCdXR0b24nID8gY29tcC5jYXB0aW9uIDogJydcIlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBbZW5hYmxlZF09XCIhZGlzYWJsZWRDb21wb25lbnRzW2NvbXAubmFtZSArICdCdXR0b24nXVwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIChhY3Rpb24pPVwic2hvd01lbnUoY29tcCwgYnV0dG9uKVwiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICA8L3N0aS1idXR0b24+XHJcbiAgICAgICAgICAgICAgICAgICAgICA8L3RkPlxyXG4gICAgICAgICAgICAgICAgICAgIDwvdHI+XHJcbiAgICAgICAgICAgICAgICAgIDwvdGJvZHk+XHJcbiAgICAgICAgICAgICAgICA8L3RhYmxlPlxyXG5cclxuICAgICAgICAgICAgICA8L3N0aS1ncm91cC1wYW5lbD5cclxuICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICA8L3RyPlxyXG5cclxuICAgICAgICA8dHIgKm5nSWY9XCJtb2RlbC5vcHRpb25zLmV4cG9ydHMuc2hvd09wZW5BZnRlckV4cG9ydCAmJiBleHBvcnRGb3JtU2V0dGluZ3M/Lm9wZW5BZnRlckV4cG9ydCAmJiAhZXhwb3J0U2VydmljZS5zZW5kTWFpbFwiIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgY29sc3Bhbj1cIjJcIj5cclxuICAgICAgICAgICAgICAgIDxzdGktY2hlY2stYm94IFtjYXB0aW9uVGV4dF09XCJtb2RlbC5sb2MoJ09wZW5BZnRlckV4cG9ydCcpXCJcclxuICAgICAgICAgICAgICAgICAgW3Rvb2x0aXBdPVwibW9kZWwubG9jKCdPcGVuQWZ0ZXJFeHBvcnRUb29sdGlwJylcIlxyXG4gICAgICAgICAgICAgICAgICBbbWFyZ2luXT1cIic0cHggOHB4IDRweCA4cHgnXCJcclxuICAgICAgICAgICAgICAgICAgW2lzQ2hlY2tlZF09XCJleHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLk9wZW5BZnRlckV4cG9ydFwiXHJcbiAgICAgICAgICAgICAgICAgIChhY3Rpb24pPVwiZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5PcGVuQWZ0ZXJFeHBvcnQgPSAkZXZlbnRcIj5cclxuICAgICAgICAgICAgICAgIDwvc3RpLWNoZWNrLWJveD5cclxuICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICA8L3RyPlxyXG4gICAgICA8L3Rib2R5PlxyXG4gICAgPC90YWJsZT5cclxuXHJcbiAgICA8L3N0aS1iYXNlLWZvcm0+XHJcbiAgYFxyXG59KVxyXG5cclxuZXhwb3J0IGNsYXNzIEV4cG9ydEZvcm1Db21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIE9uQ2hhbmdlcyB7XHJcblxyXG4gIHByaXZhdGUgUFJPUEVSVFlfQUxJQVMgPSB7XHJcbiAgICBJbWFnZUZvcm1hdEZvckh0bWw6ICdJbWFnZUZvcm1hdCcsXHJcbiAgICBFbmNvZGluZ1RleHRPckNzdkZpbGU6ICdFbmNvZGluZycsXHJcbiAgICBFeHBvcnRNb2RlUnRmOiAnRXhwb3J0TW9kZScsXHJcbiAgICBFbmNvZGluZ0RpZkZpbGU6ICdFbmNvZGluZycsXHJcbiAgICBFbmNvZGluZ0RiZkZpbGU6ICdDb2RlUGFnZSdcclxuICB9O1xyXG5cclxuICBAVmlld0NoaWxkKCdiYXNlRm9ybScpIGJhc2VGb3JtOiBCYXNlRm9ybUNvbXBvbmVudDtcclxuICBAVmlld0NoaWxkKCdzYXZlUmVwb3J0TWRjJykgc2F2ZVJlcG9ydE1kYzogUmFkaW9CdXR0b25Db21wb25lbnQ7XHJcbiAgQFZpZXdDaGlsZCgncGFnZXNSYW5nZUFsbCcpIHBhZ2VzUmFuZ2VBbGw6IFJhZGlvQnV0dG9uQ29tcG9uZW50O1xyXG4gIEBWaWV3Q2hpbGQoJ3BhZ2VSYW5nZUN1cnJlbnRQYWdlJykgcGFnZVJhbmdlQ3VycmVudFBhZ2U6IFJhZGlvQnV0dG9uQ29tcG9uZW50O1xyXG5cclxuICBASW5wdXQoKSBleHBvcnRGb3JtU2V0dGluZ3M6IEV4cG9ydEZvcm1TZXR0aW5ncztcclxuXHJcbiAgZm9ybVZpc2libGUgPSBmYWxzZTtcclxuICBkaXNhYmxlZENvbXBvbmVudHM6IGFueSA9IHt9O1xyXG5cclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgbW9kZWw6IE1vZGVsU2VydmljZSwgcHVibGljIGV4cG9ydFNlcnZpY2U6IEV4cG9ydFNlcnZpY2UsIHB1YmxpYyBoZWxwZXI6IEhlbHBlclNlcnZpY2UsIHB1YmxpYyBmb3JtU2VydmljZTogRm9ybVNlcnZpY2UsXHJcbiAgICBwdWJsaWMgbWVudVNlcnZpY2U6IE1lbnVTZXJ2aWNlLCBwdWJsaWMgY29sbGVjdGlvbnM6IENvbGxlY3Rpb25zU2VydmljZSwgcHVibGljIGNvbnRyb2xsZXI6IENvbnRyb2xsZXJTZXJ2aWNlKSB7IH1cclxuXHJcbiAgbmdPbkNoYW5nZXMoY2hhbmdlczogaW1wb3J0KCdAYW5ndWxhci9jb3JlJykuU2ltcGxlQ2hhbmdlcyk6IHZvaWQge1xyXG4gICAgaWYgKHRoaXMuYmFzZUZvcm0gJiYgdGhpcy5mb3JtU2VydmljZT8uZm9ybT8ubmFtZSA9PT0gdGhpcy5iYXNlRm9ybS5uYW1lKSB7XHJcbiAgICAgIHNldFRpbWVvdXQoKCkgPT4gdGhpcy51cGRhdGVEaXNhYmxlZENvbXBvbmVudHMoKSk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBuZ09uSW5pdCgpIHsgfVxyXG5cclxuICBhY3Rpb24oKSB7XHJcbiAgICB0aGlzLmZvcm1TZXJ2aWNlLmNsb3NlRm9ybSh0aGlzLmJhc2VGb3JtLm5hbWUpO1xyXG5cclxuICAgIGlmICh0aGlzLm1vZGVsLm9wdGlvbnMuZXhwb3J0cy5zdG9yZUV4cG9ydFNldHRpbmdzKSB7XHJcbiAgICAgIHRoaXMuaGVscGVyLnNldENvb2tpZSgnU3RpbXVsc29mdFdlYlZpZXdlckV4cG9ydFNldHRpbmdzJyArIHRoaXMuZXhwb3J0U2VydmljZS5nZXRDb21tb25FeHBvcnRGb3JtYXQoKSwgSlNPTi5zdHJpbmdpZnkodGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzKSk7XHJcbiAgICB9XHJcblxyXG4gICAgdGhpcy5leHBvcnRTZXJ2aWNlLnBvc3RFeHBvcnQoKTtcclxuICB9XHJcblxyXG4gIHVwZGF0ZURpc2FibGVkQ29tcG9uZW50cygpIHtcclxuICAgIFsnU3RhbmRhcmRQZGZGb250cycsICdFbWJlZGRlZEZvbnRzJywgJ1VzZVVuaWNvZGUnXS5mb3JFYWNoKG4gPT4gdGhpcy5kaXNhYmxlZENvbXBvbmVudHNbbl0gPSAodGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLlBkZkFDb21wbGlhbmNlID09PSB0cnVlKSk7XHJcblxyXG4gICAgdGhpcy5kaXNhYmxlZENvbXBvbmVudHMuSW1hZ2VRdWFsaXR5ID0gdGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLkltYWdlQ29tcHJlc3Npb25NZXRob2QgJiYgdGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLkltYWdlQ29tcHJlc3Npb25NZXRob2QgIT09ICdKcGVnJztcclxuXHJcbiAgICB0aGlzLmRpc2FibGVkQ29tcG9uZW50cy5FeHBvcnRPYmplY3RGb3JtYXR0aW5nID0gdGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLkRhdGFFeHBvcnRNb2RlID09PSAnQWxsQmFuZHMnO1xyXG4gICAgdGhpcy5kaXNhYmxlZENvbXBvbmVudHMuVXNlT25lUGFnZUhlYWRlckFuZEZvb3RlciA9IHRoaXMuZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5EYXRhRXhwb3J0TW9kZSAhPSAnQWxsQmFuZHMnO1xyXG5cclxuICAgIHRoaXMuZGlzYWJsZWRDb21wb25lbnRzLkVuY29kaW5nRGlmRmlsZSA9IHRoaXMuZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5Vc2VEZWZhdWx0U3lzdGVtRW5jb2Rpbmc7XHJcblxyXG4gICAgdGhpcy5kaXNhYmxlZENvbXBvbmVudHMuVGlmZkNvbXByZXNzaW9uU2NoZW1lID0gdGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLkltYWdlVHlwZSAhPT0gJ1RpZmYnO1xyXG5cclxuICAgIHRoaXMuZGlzYWJsZWRDb21wb25lbnRzLlVzZURpZ2l0YWxTaWduYXR1cmUgPSAhdGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLlVzZURpZ2l0YWxTaWduYXR1cmUgfHwgISh0aGlzLm1vZGVsLnBkZlNlY3VyaXR5Q2VydGlmaWNhdGVzPy5sZW5ndGggPiAwKTtcclxuXHJcbiAgICB0aGlzLmRpc2FibGVkQ29tcG9uZW50cy5SZW1vdmVFbXB0eVNwYWNlQXRCb3R0b20gPSB0aGlzLmV4cG9ydFNlcnZpY2UuZXhwb3J0U2V0dGluZ3MuVXNlUGFnZUhlYWRlcnNBbmRGb290ZXJzO1xyXG5cclxuICAgIGlmICh0aGlzLmV4cG9ydFNlcnZpY2UuZXhwb3J0U2V0dGluZ3MuSW1hZ2VUeXBlICE9IG51bGwpIHtcclxuICAgICAgY29uc3QgaWZDb21wb25lbnQgPSB0aGlzLmV4cG9ydFNlcnZpY2UuZXhwb3J0Rm9ybVNldHRpbmdzLmNvbXBvbmVudHMuZmluZChjID0+IGMubmFtZSA9PT0gJ0ltYWdlRm9ybWF0Jyk7XHJcbiAgICAgIGlmIChpZkNvbXBvbmVudCAhPSBudWxsKSB7XHJcbiAgICAgICAgaWZDb21wb25lbnQuaXRlbXMgPSB0aGlzLmNvbGxlY3Rpb25zLmdldEltYWdlRm9ybWF0SXRlbXModGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLkltYWdlVHlwZSA9PT0gJ0VtZicpO1xyXG4gICAgICB9XHJcbiAgICB9XHJcblxyXG4gICAgdGhpcy5kaXNhYmxlZENvbXBvbmVudHMuRGl0aGVyaW5nVHlwZSA9IHRoaXMuZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5JbWFnZUZvcm1hdCAhPT0gJ01vbm9jaHJvbWUnO1xyXG5cclxuICAgIGlmICh0aGlzLnNhdmVSZXBvcnRNZGMpIHsgdGhpcy5zYXZlUmVwb3J0TWRjLmNsaWNrKCk7IH1cclxuICAgIGlmICh0aGlzLnBhZ2VzUmFuZ2VBbGwgJiYgIXRoaXMuZXhwb3J0Rm9ybVNldHRpbmdzLmdyb3Vwcy5wYWdlUmFuZ2VHcm91cC5wYWdlUmFuZ2VBbGxJc0Rpc2FibGVkKSB7XHJcbiAgICAgIHRoaXMucGFnZXNSYW5nZUFsbC5jbGljaygpO1xyXG4gICAgfVxyXG4gICAgaWYgKHRoaXMucGFnZVJhbmdlQ3VycmVudFBhZ2UgJiYgdGhpcy5leHBvcnRGb3JtU2V0dGluZ3MuZ3JvdXBzLnBhZ2VSYW5nZUdyb3VwLnBhZ2VSYW5nZUFsbElzRGlzYWJsZWQpIHtcclxuICAgICAgdGhpcy5wYWdlUmFuZ2VDdXJyZW50UGFnZS5jbGljaygpO1xyXG4gICAgfVxyXG5cclxuICAgIGlmICh0aGlzLmV4cG9ydFNlcnZpY2UuZXhwb3J0U2V0dGluZ3MuQ29tcHJlc3NUb0FyY2hpdmUgPT09IHRydWUpIHtcclxuICAgICAgdGhpcy5leHBvcnRGb3JtU2V0dGluZ3MuZ3JvdXBzLnBhZ2VSYW5nZUdyb3VwLnBhZ2VSYW5nZUFsbElzRGlzYWJsZWQgPSBmYWxzZTtcclxuICAgIH1cclxuXHJcbiAgICBpZiAodGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLkNvbXByZXNzVG9BcmNoaXZlID09PSBmYWxzZSkge1xyXG4gICAgICB0aGlzLmV4cG9ydEZvcm1TZXR0aW5ncy5ncm91cHMucGFnZVJhbmdlR3JvdXAucGFnZVJhbmdlQWxsSXNEaXNhYmxlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBjb21wb25lbnRBY3Rpb24oY29tcDogRXhwb3J0Q29tcG9uZW50LCB2YWx1ZT86IGFueSkge1xyXG4gICAgbGV0IHByb3BlcnR5ID0gdGhpcy5QUk9QRVJUWV9BTElBU1tjb21wLm5hbWVdIHx8IGNvbXAubmFtZTtcclxuXHJcbiAgICBzd2l0Y2ggKHByb3BlcnR5KSB7XHJcbiAgICAgIGNhc2UgJ0VtYmVkZGVkRm9udHMnOlxyXG4gICAgICBjYXNlICdVc2VVbmljb2RlJzpcclxuICAgICAgICBpZiAodmFsdWUpIHtcclxuICAgICAgICAgIHRoaXMuZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5ncy5TdGFuZGFyZFBkZkZvbnRzID0gZmFsc2U7XHJcbiAgICAgICAgfVxyXG4gICAgICAgIGJyZWFrO1xyXG5cclxuICAgICAgY2FzZSAnU3RhbmRhcmRQZGZGb250cyc6XHJcbiAgICAgICAgaWYgKHZhbHVlKSB7XHJcbiAgICAgICAgICB0aGlzLmV4cG9ydFNlcnZpY2UuZXhwb3J0U2V0dGluZ3MuRW1iZWRkZWRGb250cyA9IGZhbHNlO1xyXG4gICAgICAgICAgdGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLlVzZVVuaWNvZGUgPSBmYWxzZTtcclxuICAgICAgICB9XHJcbiAgICAgICAgYnJlYWs7XHJcblxyXG4gICAgICBjYXNlICdJbWFnZVR5cGUnOlxyXG4gICAgICAgIHRoaXMuZXhwb3J0U2VydmljZS5leHBvcnQoJ0ltYWdlJyArIHZhbHVlLCB0cnVlKTtcclxuICAgICAgICBicmVhaztcclxuXHJcbiAgICAgIGNhc2UgJ0RhdGFUeXBlJzpcclxuICAgICAgY2FzZSAnSHRtbFR5cGUnOlxyXG4gICAgICAgIHRoaXMuZXhwb3J0U2VydmljZS5leHBvcnQodmFsdWUsIHRydWUpO1xyXG4gICAgICAgIGJyZWFrO1xyXG5cclxuICAgICAgY2FzZSAnRXhjZWxUeXBlJzpcclxuICAgICAgICBjb25zdCBleHBvcnRGb3JtYXQgPSB2YWx1ZSA9PT0gJ0V4Y2VsQmluYXJ5JyA/ICdFeGNlbCcgOiB2YWx1ZTtcclxuICAgICAgICB0aGlzLmV4cG9ydFNlcnZpY2UuZXhwb3J0KGV4cG9ydEZvcm1hdCwgdHJ1ZSk7XHJcbiAgICAgICAgYnJlYWs7XHJcblxyXG4gICAgICBjYXNlICdVc2VEaWdpdGFsU2lnbmF0dXJlJzpcclxuICAgICAgICBpZiAoISh2YWx1ZSA9PT0gdHJ1ZSB8fCB2YWx1ZSA9PT0gZmFsc2UpKSB7XHJcbiAgICAgICAgICBwcm9wZXJ0eSA9ICdDZXJ0aWZpY2F0ZVRodW1icHJpbnQnO1xyXG4gICAgICAgIH1cclxuICAgICAgICBpZiAodmFsdWUgPT09IHRydWUgJiYgdGhpcy5jb2xsZWN0aW9ucy5nZXRQZGZTZWN1cml0eUNlcnRpZmljYXRlc0l0ZW1zKCkubGVuZ3RoID09IDApIHtcclxuICAgICAgICAgIHZhbHVlID0gZmFsc2U7XHJcbiAgICAgICAgICB0aGlzLmNvbnRyb2xsZXIuc2hvd0Vycm9yKCdXYXJuaW5nJywgJ0NlcnRpZmljYXRlIE5vdCBGb3VuZCEnKTtcclxuICAgICAgICB9XHJcbiAgICAgICAgYnJlYWs7XHJcblxyXG4gICAgICBjYXNlICdVc2VQYWdlSGVhZGVyc0FuZEZvb3RlcnMnOlxyXG4gICAgICAgIGlmICh2YWx1ZSA9PT0gdHJ1ZSkge1xyXG4gICAgICAgICAgdGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzLlJlbW92ZUVtcHR5U3BhY2VBdEJvdHRvbSA9IHRydWU7XHJcbiAgICAgICAgfVxyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgfVxyXG5cclxuICAgIHRoaXMuZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5nc1twcm9wZXJ0eV0gPSB2YWx1ZTtcclxuXHJcbiAgICB0aGlzLnVwZGF0ZURpc2FibGVkQ29tcG9uZW50cygpO1xyXG4gIH1cclxuXHJcbiAgZ2V0VmFsdWUoY29tcDogRXhwb3J0Q29tcG9uZW50LCBjb21wb25lbnQ/OiBzdHJpbmcpOiBzdHJpbmcge1xyXG4gICAgY29uc3QgcHJvcGVydHkgPSB0aGlzLlBST1BFUlRZX0FMSUFTW2NvbXAubmFtZV0gfHwgY29tcC5uYW1lO1xyXG4gICAgc3dpdGNoIChwcm9wZXJ0eSkge1xyXG4gICAgICBjYXNlICdab29tMic6XHJcbiAgICAgICAgcmV0dXJuIHRoaXMuZXhwb3J0U2VydmljZS5leHBvcnRTZXR0aW5nc1twcm9wZXJ0eV0udG9TdHJpbmcoKTtcclxuXHJcbiAgICAgIGNhc2UgJ1VzZURpZ2l0YWxTaWduYXR1cmUnOlxyXG4gICAgICAgIGlmIChjb21wb25lbnQgPT0gJ2Ryb3BEb3duTGlzdCcpIHtcclxuICAgICAgICAgIHJldHVybiB0aGlzLmV4cG9ydFNlcnZpY2UuZXhwb3J0U2V0dGluZ3NbJ0NlcnRpZmljYXRlVGh1bWJwcmludCddO1xyXG4gICAgICAgIH1cclxuICAgICAgZGVmYXVsdDpcclxuICAgICAgICByZXR1cm4gdGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFNldHRpbmdzW3Byb3BlcnR5XTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIGNoYW5nZVZpc2liaWxpdHkoc3RhdGU6IHN0cmluZykge1xyXG4gICAgdGhpcy5mb3JtVmlzaWJsZSA9IHN0YXRlID09PSAndmlzaWJsZSc7XHJcblxyXG4gICAgaWYgKHN0YXRlID09PSAnaGlkZGVuJyAmJiB0aGlzLmV4cG9ydEZvcm1TZXR0aW5ncz8uZ3JvdXBzPy5zYXZpbmdSZXBvcnRHcm91cCkge1xyXG4gICAgICB0aGlzLmhlbHBlci5zZXRDb29raWUoJ1N0aW11bHNvZnRXZWJWaWV3ZXJFeHBvcnRTZXR0aW5nc09wZW5pbmdHcm91cHMnLCBKU09OLnN0cmluZ2lmeSh7XHJcbiAgICAgICAgU2F2aW5nUmVwb3J0R3JvdXA6IHRoaXMuZXhwb3J0Rm9ybVNldHRpbmdzLmdyb3Vwcy5zYXZpbmdSZXBvcnRHcm91cC5vcGVuZWQsXHJcbiAgICAgICAgUGFnZVJhbmdlR3JvdXA6IHRoaXMuZXhwb3J0Rm9ybVNldHRpbmdzLmdyb3Vwcy5wYWdlUmFuZ2VHcm91cC5vcGVuZWQsXHJcbiAgICAgICAgU2V0dGluZ3NHcm91cDogdGhpcy5leHBvcnRGb3JtU2V0dGluZ3MuZ3JvdXBzLnNldHRpbmdzR3JvdXAub3BlbmVkXHJcbiAgICAgIH0pKTtcclxuICAgIH1cclxuICAgIGlmIChzdGF0ZSA9PT0gJ3Zpc2libGUnKSB7XHJcbiAgICAgIHRoaXMudXBkYXRlRGlzYWJsZWRDb21wb25lbnRzKCk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBzaG93TWVudShjb21wOiBFeHBvcnRDb21wb25lbnQsIGJ1dHRvbjogQnV0dG9uQ29tcG9uZW50KSB7XHJcbiAgICBsZXQgbWVudU5hbWUgPSAnZG9jdW1lbnRTZWN1cml0eU1lbnUnO1xyXG4gICAgaWYgKGNvbXAubmFtZSA9PT0gJ0RvY3VtZW50U2VjdXJpdHlCdXR0b24nKSB7XHJcbiAgICAgIHRoaXMubWVudVNlcnZpY2UuYWRkTWVudSh7XHJcbiAgICAgICAgdHlwZTogbWVudU5hbWUsIG5hbWU6IG1lbnVOYW1lLCBpdGVtczogW10sIHBhcmVudDogYnV0dG9uLmJ1dHRvbixcclxuICAgICAgICBpdGVtU3R5bGVOYW1lOiAnc3RpSnNWaWV3ZXJNZW51U3RhbmRhcnRJdGVtJywgbWVudVN0eWxlTmFtZTogJ3N0aUpzVmlld2VyRHJvcGRvd25NZW51JyxcclxuICAgICAgICBzdGF0ZTogJydcclxuICAgICAgfSk7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICBtZW51TmFtZSA9IHRoaXMubWVudVNlcnZpY2UuVkVSVElDQUxfTUVOVV9OQU1FO1xyXG4gICAgICB0aGlzLm1lbnVTZXJ2aWNlLmFkZE1lbnUoe1xyXG4gICAgICAgIHR5cGU6ICdidXR0b25NZW51JywgbmFtZTogbWVudU5hbWUsIGl0ZW1zOiB0aGlzLmNvbGxlY3Rpb25zLmdldFBkZlNlY3VyaXR5Q2VydGlmaWNhdGVzSXRlbXMoKSwgcGFyZW50OiBidXR0b24uYnV0dG9uLFxyXG4gICAgICAgIGl0ZW1TdHlsZU5hbWU6ICdzdGlKc1ZpZXdlck1lbnVTdGFuZGFydEl0ZW0nLCBtZW51U3R5bGVOYW1lOiAnc3RpSnNWaWV3ZXJEcm9wZG93bk1lbnUnLFxyXG4gICAgICAgIHN0YXRlOiAnJ1xyXG4gICAgICB9KTtcclxuICAgIH1cclxuXHJcbiAgICBzZXRUaW1lb3V0KCgpID0+IHtcclxuICAgICAgdGhpcy5tZW51U2VydmljZS5zaG93TWVudShtZW51TmFtZSk7XHJcbiAgICB9KTtcclxuICB9XHJcblxyXG4gIGdldFRleHRCb3hUeXBlKG5hbWU6IHN0cmluZykge1xyXG4gICAgaWYgKG5hbWUgPT09ICdTYXZlUmVwb3J0UGFzc3dvcmQnIHx8IG5hbWUgPT09ICdQYXNzd29yZElucHV0VXNlcicgfHwgbmFtZSA9PT0gJ1Bhc3N3b3JkSW5wdXRPd25lcicpIHtcclxuICAgICAgcmV0dXJuIHRoaXMuZm9ybVZpc2libGUgPyAncGFzc3dvcmQnIDogJyc7XHJcbiAgICB9XHJcbiAgICByZXR1cm4gbnVsbDtcclxuICB9XHJcbn1cclxuIl19