import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "./parameters/parameter-checkbox.component";
export class TextBoxComponent {
    constructor(model) {
        this.model = model;
        this.enabled = true;
        this.focusOnCreate = false;
        this.action = new EventEmitter();
        this.onchange = new EventEmitter();
        this.onblur = new EventEmitter();
        this.selected = false;
        this.focused = false;
        this.over = false;
        this._readOnly = false;
        this.styleName = 'stiJsViewerTextBox';
    }
    ngAfterViewInit() {
        if (this.focusOnCreate) {
            setTimeout(() => {
                this.element.nativeElement.focus();
            });
        }
    }
    keypress(event) {
        if (!this.enabled) {
            return false;
        }
        if (event.keyCode === 13) {
            this.action.emit(event.target);
        }
    }
    onchanged(event) {
        this.onchange.emit(event.target);
    }
    get paddingInt() {
        return this.isNullableParam ? "0 0 0 22px" : this.padding;
    }
    focus() {
        this.oldValue = this.element.nativeElement.value;
    }
    get isNullableParam() {
        return this.variable?.basicType == 'NullableValue' || this.variable?.allowNullableString;
    }
    nullableAction(checked) {
        this.variable.isNull = !this.variable.isNull;
    }
    get height() {
        return this.model.options.isTouchDevice ? '26px' : '21px';
    }
    get className() {
        if (this._readOnly) {
            return this.styleName + ' ' + this.styleName + 'Default';
        }
        return this.styleName + ' ' + this.styleName + (this.selected ? 'Over' : (this.enabled ? (this.over ? 'Over' : 'Default') : 'Disabled'));
    }
    set readOnly(value) {
        this._readOnly = value;
        setTimeout(() => {
            try {
                this.element.nativeElement.setAttribute('unselectable', value ? 'on' : 'off');
                this.element.nativeElement.setAttribute('onselectstart', value ? 'return false' : '');
                this.element.nativeElement.readOnly = value;
            }
            catch (e) { }
        });
    }
    get readOnly() {
        return this._readOnly;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TextBoxComponent, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: TextBoxComponent, selector: "sti-text-box", inputs: { width: "width", actionLostFocus: "actionLostFocus", tooltip: "tooltip", enabled: "enabled", value: "value", margin: "margin", focusOnCreate: "focusOnCreate", maxLength: "maxLength", color: "color", type: "type", padding: "padding", border: "border", variable: "variable", textAlign: "textAlign", autocomplete: "autocomplete", readOnly: "readOnly" }, outputs: { action: "action", onchange: "onchange", onblur: "onblur" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <input #element
    [style]="{fontFamily:model.options.toolbar.fontFamily, height: height, lineHeight: height, boxSizing:'content-box'}"
    [style.color]="color ? color : (model.options.toolbar.fontColor != '' ? model.options.toolbar.fontColor : '')"
    [style.width]="width != null ? width + 'px' : ''"
    [style.margin]="margin"
    [style.cursor]="readOnly ? 'default' : ''"
    [style.padding]="paddingInt"
    [style.border]="border"
    [style.textAlign]="textAlign"
    [title]="tooltip || ''"
    [class]="className"
    [value]="value || ''"
    [attr.maxLength]="maxLength"
    [attr.type]="type"
    [autocomplete]="autocomplete"
    (mouseover)="over=true"
    (mouseleave)="over=false"
    (focused)="focused=true; selected=true"
    (blur)="focused=false; selected=false; onblur.emit($event.target)"
    (keypress)="keypress($event)"
    (keyup)="onchanged($event)"
    (focus)="focus()"/>
    <sti-parameter-checkbox *ngIf="isNullableParam"
      [style]="{left: '6px', top: 'calc(50% - 7px)', position: 'absolute'}"
      [params]="variable"
      [isEnabled]="variable.allowUserValues"
      (action)="nullableAction($event)"
      [paramNull]="true" >
    </sti-parameter-checkbox>
  `, isInline: true, dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: ["params", "captionText", "margin", "width", "imageBlockParentWidth", "isEnabled", "isMenuParameter", "paramNull", "nullable"], outputs: ["action"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TextBoxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-text-box',
                    template: `
    <input #element
    [style]="{fontFamily:model.options.toolbar.fontFamily, height: height, lineHeight: height, boxSizing:'content-box'}"
    [style.color]="color ? color : (model.options.toolbar.fontColor != '' ? model.options.toolbar.fontColor : '')"
    [style.width]="width != null ? width + 'px' : ''"
    [style.margin]="margin"
    [style.cursor]="readOnly ? 'default' : ''"
    [style.padding]="paddingInt"
    [style.border]="border"
    [style.textAlign]="textAlign"
    [title]="tooltip || ''"
    [class]="className"
    [value]="value || ''"
    [attr.maxLength]="maxLength"
    [attr.type]="type"
    [autocomplete]="autocomplete"
    (mouseover)="over=true"
    (mouseleave)="over=false"
    (focused)="focused=true; selected=true"
    (blur)="focused=false; selected=false; onblur.emit($event.target)"
    (keypress)="keypress($event)"
    (keyup)="onchanged($event)"
    (focus)="focus()"/>
    <sti-parameter-checkbox *ngIf="isNullableParam"
      [style]="{left: '6px', top: 'calc(50% - 7px)', position: 'absolute'}"
      [params]="variable"
      [isEnabled]="variable.allowUserValues"
      (action)="nullableAction($event)"
      [paramNull]="true" >
    </sti-parameter-checkbox>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], width: [{
                type: Input
            }], actionLostFocus: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], enabled: [{
                type: Input
            }], value: [{
                type: Input
            }], margin: [{
                type: Input
            }], focusOnCreate: [{
                type: Input
            }], maxLength: [{
                type: Input
            }], color: [{
                type: Input
            }], type: [{
                type: Input
            }], padding: [{
                type: Input
            }], border: [{
                type: Input
            }], variable: [{
                type: Input
            }], textAlign: [{
                type: Input
            }], autocomplete: [{
                type: Input
            }], action: [{
                type: Output
            }], onchange: [{
                type: Output
            }], onblur: [{
                type: Output
            }], readOnly: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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