import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../../services/helper.service";
import * as i2 from "../../services/model.service";
import * as i3 from "../text-box.componet";
export class ParameterTextBoxComponent {
    constructor(helper, model) {
        this.helper = helper;
        this.model = model;
        this.focusOnCreate = false;
        this.isMenu = false;
        this.value = '';
        this.secondTextBox = false;
    }
    ngOnInit() { }
    onchange(target) {
        if (this.element.oldValue === target.value) {
            return;
        }
        const value = this.getValue(target);
        if (this.isMenu) {
            if (!this.secondTextBox) {
                this.item.key = value;
            }
            else {
                this.item.keyTo = value;
            }
        }
        else {
            if (!this.secondTextBox) {
                if (this.variable.basicType === 'Range' || this.variable.type === 'DateTime') {
                    this.variable.key = value;
                }
                else {
                    this.variable.value = value;
                    if (this.variable.basicType === 'Value') {
                        this.variable.key = value;
                    }
                }
            }
            else {
                this.variable.keyTo = value;
            }
        }
    }
    getValue(target) {
        if (this.variable.type === 'DateTime') {
            if (this.element.oldValue === target.value) {
                return;
            }
            try {
                const timeString = new Date().toLocaleTimeString();
                const isAmericanFormat = timeString.toLowerCase().indexOf('am') >= 0 || timeString.toLowerCase().indexOf('pm') >= 0;
                const formatDate = isAmericanFormat ? 'MM/dd/yyyy' : 'dd.MM.yyyy';
                let format = formatDate + (isAmericanFormat ? ' h:mm:ss tt' : ' hh:mm:ss');
                if (this.variable.dateTimeType === 'Date') {
                    format = formatDate;
                }
                if (this.variable.dateTimeType === 'Time') {
                    format = 'hh:mm:ss';
                }
                const date = this.helper.getDateTimeFromString(target.value, this.model.options.appearance.parametersPanelDateFormat || format);
                return this.helper.getDateTimeObject(date);
            }
            catch (e) {
                alert(e);
            }
        }
        else {
            return target.value;
        }
    }
    get width() {
        let width = 210;
        if (this.variable.basicType === 'Range') {
            width = 140;
            if (this.variable.type === 'Guid' || this.variable.type === 'String') {
                width = 190;
            }
            if (this.variable.type === 'DateTime') {
                width = 235;
            }
            if (this.variable.type === 'Char') {
                width = 60;
            }
        }
        else {
            if (this.variable.type === 'Guid') {
                width = 265;
            }
            else {
                width = 210;
            }
        }
        return width;
    }
    get color() {
        return !this.variable.isNull
            ? (this.model.options.toolbar.fontColor && this.model.options.toolbar.fontColor !== 'Empty' ? this.model.options.toolbar.fontColor : '#444444')
            : this.variable.type === 'DateTime' ? 'transparent' : '#c6c6c6';
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterTextBoxComponent, deps: [{ token: i1.HelperService }, { token: i2.ModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ParameterTextBoxComponent, selector: "sti-parameter-text-box", inputs: { item: "item", variable: "variable", readOnly: "readOnly", focusOnCreate: "focusOnCreate", isMenu: "isMenu", value: "value", secondTextBox: "secondTextBox" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <sti-text-box #element
      [maxLength]="variable.type === 'Char' ? 1 : ''"
      [value]="isMenu ? helper.getStringKey(item.key, variable): value"
      [width]="width"
      [readOnly]="readOnly"
      [focusOnCreate]="focusOnCreate"
      [enabled]="!variable?.isNull"
      [color]="color"
      [variable]="variable"
      [textAlign]="model.options.currentParameterAlignment?.toLowerCase()"
      (onblur)="onchange($event)">
    </sti-text-box>
  `, isInline: true, dependencies: [{ kind: "component", type: i3.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "textAlign", "autocomplete", "readOnly"], outputs: ["action", "onchange", "onblur"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterTextBoxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-text-box',
                    template: `
    <sti-text-box #element
      [maxLength]="variable.type === 'Char' ? 1 : ''"
      [value]="isMenu ? helper.getStringKey(item.key, variable): value"
      [width]="width"
      [readOnly]="readOnly"
      [focusOnCreate]="focusOnCreate"
      [enabled]="!variable?.isNull"
      [color]="color"
      [variable]="variable"
      [textAlign]="model.options.currentParameterAlignment?.toLowerCase()"
      (onblur)="onchange($event)">
    </sti-text-box>
  `
                }]
        }], ctorParameters: () => [{ type: i1.HelperService }, { type: i2.ModelService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], item: [{
                type: Input
            }], variable: [{
                type: Input
            }], readOnly: [{
                type: Input
            }], focusOnCreate: [{
                type: Input
            }], isMenu: [{
                type: Input
            }], value: [{
                type: Input
            }], secondTextBox: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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