import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../checkbox.component";
export class ParameterCheckboxComponent {
    constructor() {
        this.isEnabled = true;
        this.isMenuParameter = false;
        this.paramNull = false;
        this.nullable = false;
        this.action = new EventEmitter();
    }
    ngOnInit() { }
    onAction(checked) {
        this.action.emit(checked);
    }
    get checked() {
        if (this.paramNull) {
            return this.params.isNull;
        }
        else {
            return this.isMenuParameter ? this.params.isChecked : (typeof (this.params.value) === 'boolean' && this.params.value) || this.params.value === 'true' || this.params.value === 'True';
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterCheckboxComponent, deps: [], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: { params: "params", captionText: "captionText", margin: "margin", width: "width", imageBlockParentWidth: "imageBlockParentWidth", isEnabled: "isEnabled", isMenuParameter: "isMenuParameter", paramNull: "paramNull", nullable: "nullable" }, outputs: { action: "action" }, ngImport: i0, template: `
    <sti-check-box [isEnabled]="isEnabled"
                   [isChecked]="checked"
                   [nullable]="nullable"
                   [captionText]="captionText"
                   [margin]="margin"
                   [width]="width"
                   [imageBlockParentWidth]="imageBlockParentWidth"
                   (action)="onAction($event)">
    </sti-check-box>
    `, isInline: true, dependencies: [{ kind: "component", type: i1.CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ParameterCheckboxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-checkbox',
                    template: `
    <sti-check-box [isEnabled]="isEnabled"
                   [isChecked]="checked"
                   [nullable]="nullable"
                   [captionText]="captionText"
                   [margin]="margin"
                   [width]="width"
                   [imageBlockParentWidth]="imageBlockParentWidth"
                   (action)="onAction($event)">
    </sti-check-box>
    `
                }]
        }], ctorParameters: () => [], propDecorators: { params: [{
                type: Input
            }], captionText: [{
                type: Input
            }], margin: [{
                type: Input
            }], width: [{
                type: Input
            }], imageBlockParentWidth: [{
                type: Input
            }], isEnabled: [{
                type: Input
            }], isMenuParameter: [{
                type: Input
            }], paramNull: [{
                type: Input
            }], nullable: [{
                type: Input
            }], action: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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