import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/toolbar.service";
import * as i4 from "@angular/common";
import * as i5 from "./toolbar-dop.component";
export class ToolbarComponent {
    constructor(model, controller, toolbarService) {
        this.model = model;
        this.controller = controller;
        this.toolbarService = toolbarService;
    }
    ngAfterViewInit() {
        this.model.controls.toolbar.el = this.element;
    }
    ngOnInit() {
        this.toolbarService.initButtons();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ToolbarComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.ToolbarService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ToolbarComponent, selector: "sti-toolbar", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode === 'Separated' ? '  stiJsViewerToolBarSeparated' : '')"
         [style.display]="'block'"
         [style.width.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.height.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.display]="!model.options.isMobileDevice ? (this.model.controls.toolbar.visible ? '' : 'none') : ''"
         [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
         [style.zIndex]="model.options.toolbar.autoHide ? 5 : 2"
         [style.position]="model.options.toolbar.autoHide ? 'absolute' : 'relative'"
         [style.opacity]="model.options.isMobileDevice ? (model.controls.toolbar.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
         [style.marginTop]="model.options.isMobileDevice && !model.controls.toolbar.visible ? '-0.55in' : 0">
      <div [style]="model.options.toolbar.displayMode === 'Simple' ? 'paddingTop: 2px' : ''">
        <table class="stiJsViewerToolBarTable" [style.margin.px]="0" [style.boxSizing]="'border-box'"
               cellpadding="0" cellspacing="0"
               [style.background]="model.options.toolbar.backgroundColor !== '' ? model.options.toolbar.backgroundColor : ''"
               [style.border]="model.options.toolbar.displayMode === 'Separated' ? '0px' : (model.options.toolbar.borderColor !== '' ?  '1px solid ' + model.options.toolbar.borderColor : '')"
               [style.color]="model.options.toolbar.fontColor !== '' ? model.options.toolbar.fontColor : ''"
               [style.fontFamily]="model.options.toolbar.fontFamily">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngIf="model.options.appearance.rightToLeft">
              <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>

              <td class="stiJsViewerClearAllStyles" [style.width]="'100%'">
                <sti-toolbar-dop
                  [align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment === 'default' ? 'left' : model.options.toolbar.alignment)"
                  [comps]="toolbarService.comps">
                </sti-toolbar-dop>
              </td>

              <td *ngIf="!model.options.appearance.rightToLeft">
                <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
      <div class="stiJsViewerDisabledPanel" [style.display]="this.model.controls.toolbar.enabled ? 'none' : 'block'"></div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ToolbarDopComponent, selector: "sti-toolbar-dop", inputs: ["comps", "align"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ToolbarComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-toolbar',
                    template: `
    <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode === 'Separated' ? '  stiJsViewerToolBarSeparated' : '')"
         [style.display]="'block'"
         [style.width.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.height.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.display]="!model.options.isMobileDevice ? (this.model.controls.toolbar.visible ? '' : 'none') : ''"
         [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
         [style.zIndex]="model.options.toolbar.autoHide ? 5 : 2"
         [style.position]="model.options.toolbar.autoHide ? 'absolute' : 'relative'"
         [style.opacity]="model.options.isMobileDevice ? (model.controls.toolbar.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
         [style.marginTop]="model.options.isMobileDevice && !model.controls.toolbar.visible ? '-0.55in' : 0">
      <div [style]="model.options.toolbar.displayMode === 'Simple' ? 'paddingTop: 2px' : ''">
        <table class="stiJsViewerToolBarTable" [style.margin.px]="0" [style.boxSizing]="'border-box'"
               cellpadding="0" cellspacing="0"
               [style.background]="model.options.toolbar.backgroundColor !== '' ? model.options.toolbar.backgroundColor : ''"
               [style.border]="model.options.toolbar.displayMode === 'Separated' ? '0px' : (model.options.toolbar.borderColor !== '' ?  '1px solid ' + model.options.toolbar.borderColor : '')"
               [style.color]="model.options.toolbar.fontColor !== '' ? model.options.toolbar.fontColor : ''"
               [style.fontFamily]="model.options.toolbar.fontFamily">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngIf="model.options.appearance.rightToLeft">
              <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>

              <td class="stiJsViewerClearAllStyles" [style.width]="'100%'">
                <sti-toolbar-dop
                  [align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment === 'default' ? 'left' : model.options.toolbar.alignment)"
                  [comps]="toolbarService.comps">
                </sti-toolbar-dop>
              </td>

              <td *ngIf="!model.options.appearance.rightToLeft">
                <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
      <div class="stiJsViewerDisabledPanel" [style.display]="this.model.controls.toolbar.enabled ? 'none' : 'block'"></div>
    </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.ToolbarService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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