import { Component, ViewChild } from '@angular/core';
import { trigger, state, transition, style, keyframes, animate } from '@angular/animations';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "../services/interactions.service";
import * as i4 from "../menu/menu.service";
import * as i5 from "../services/controller.service";
import * as i6 from "@angular/common";
import * as i7 from "../controls/form-button.component";
import * as i8 from "../controls/parameters/parameter.component";
export class InteractionsPanelComponent {
    constructor(model, helper, interactionService, menuService, controller) {
        this.model = model;
        this.helper = helper;
        this.interactionService = interactionService;
        this.menuService = menuService;
        this.controller = controller;
        this.currentOpeningParameter = null;
        this.dropDownButtonWasClicked = false;
        this.dateTimeButtonWasClicked = false;
    }
    ngAfterViewInit() {
        this.model.controls.parametersPanel.el = this.element;
    }
    ngOnInit() { }
    getNameAlign(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        if (index < this.length() &&
            this.model.interactions.paramsVariables[index].basicType === 'Range' &&
            this.model.options.appearance.currentParametersPanelPosition === 'Left') {
            return 'top';
        }
        return '';
    }
    getNamePadding(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        if (index < this.length() &&
            this.model.interactions.paramsVariables[index].basicType === 'Range' &&
            this.model.options.appearance.currentParametersPanelPosition === 'Left') {
            return this.model.options.isTouchDevice ? '11px' : '9px';
        }
        return '';
    }
    getCaption(indexRow, indexColumn, checkLeft = true) {
        const index = this.index(indexRow, indexColumn);
        if (checkLeft && this.ifLeftRange(indexRow, indexColumn)) {
            return '';
        }
        return index < this.length() ? this.model.interactions.paramsVariables[index].alias : '';
    }
    ifLeftRange(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        return this.model.interactions.paramsVariables[index].basicType === 'Range' && this.model.options.appearance.currentParametersPanelPosition === 'Left';
    }
    getTitle(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        return index < this.length() ? this.model.interactions.paramsVariables[index].description : '';
    }
    index(indexRow, indexColumn) {
        return indexColumn * this.model.interactions.countInColumn.length + indexRow;
    }
    length() {
        return this.model.interactions?.paramsVariables != null ? Object.keys(this.model.interactions?.paramsVariables).length : 0;
    }
    get className() {
        let className = 'stiJsViewerParametersPanel';
        if (this.model.options.appearance.currentParametersPanelPosition === 'Top') {
            className += ' stiJsViewerParametersPanelTop';
            if (this.model.options.toolbar.displayMode === 'Separated') {
                className += ' stiJsViewerParametersPanelSeparatedTop';
            }
        }
        return className;
    }
    get top() {
        let styleTop = this.model.options.toolbar.visible ? this.model.controls.toolbar.offsetHeight : 0;
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            styleTop = 0;
        }
        styleTop += this.model.controls.drillDownPanel.exists ? this.model.controls.drillDownPanel.offsetHeight : 0;
        styleTop += this.model.controls.findPanel.exists ? this.model.controls.findPanel.offsetHeight : 0;
        styleTop += this.model.controls.resourcesPanel.exists ? this.model.controls.resourcesPanel.offsetHeight : 0;
        return styleTop;
    }
    get bottom() {
        if (this.model.options.appearance.currentParametersPanelPosition === 'Left') {
            if (this.model.options.isMobileDevice) {
                return this.model.options.toolbar.autoHide ? '0' : '0.5in';
            }
            else {
                return this.model.options.toolbar.displayMode === 'Separated' && this.model.options.toolbar.visible ? '35px' : '0';
            }
        }
        return '';
    }
    get innerClassName() {
        let className = this.model.options.toolbar.displayMode === 'Simple' ? 'stiJsViewerInnerParametersPanelSimple' : '';
        if (this.model.options.appearance.currentParametersPanelPosition === 'Left') {
            className += ' stiJsViewerInnerParametersPanelLeft';
            if (this.model.options.toolbar.displayMode === 'Separated') {
                className += ' stiJsViewerInnerParametersPanelSeparatedLeft';
            }
        }
        return className;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: InteractionsPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.InteractionsService }, { token: i4.MenuService }, { token: i5.ControllerService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: InteractionsPanelComponent, selector: "sti-interactions-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element [class]="className"
       [style.display]="!this.model.options.isMobileDevice ? (model.controls.parametersPanel.visible ? '' : 'none') : null"
       [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbar.fontColor"
       [style.top.px]="top"
       [style.left.px]="model.controls.parametersPanel.layout.left"
       [style.bottom]="bottom"
       [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
       [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.parametersPanel.visible ? 'visible' : 'hidden')">
       <div [class]="innerClassName" [style.marginTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''" (scroll)="menuService.closeAllMenus()">
         <div class="stiJsViewerInnerContainerParametersPanel"
              [style.background]="helper.val(model.options.toolbar.backgroundColor, '')"
              [style.border]="helper.val(model.options.toolbar.backgroundColor, '') != '' ? '1px solid ' + helper.val(model.options.toolbar.backgroundColor, '') : ''"
              [style.maxHeight]="model.options.appearance.currentParametersPanelPosition == 'Top' ? model.options.appearance.parametersPanelMaxHeight + 'px' : ''"
              (scroll)="menuService.closeAllMenus()">
            <table *ngIf="model.interactions" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.border.px]="0">
              <tbody>
                <tr *ngFor="let item of model.interactions.countInColumn; let indexRow=index" >
                  <ng-container *ngFor="let item2 of model.interactions.countColumns; let indexColumn=index">
                    <ng-container *ngIf="index(indexRow, indexColumn) < length()">
                        <td [style.padding]="'0 10px 0 ' + (indexColumn > 0 ? '30px' : '0')"
                            [style.whiteSpace]="'nowrap'"
                            [style.verticalAlign]='getNameAlign(indexRow, indexColumn)'
                            [style.paddingTop]='getNamePadding(indexRow, indexColumn)'
                            [attr.title]='getTitle(indexRow, indexColumn)'>
                            {{getCaption(indexRow, indexColumn)}}
                              <table *ngIf="ifLeftRange(indexRow, indexColumn)" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.height.px]="60">
                                <tbody>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" rowspan="2" [style.verticalAlign]="'top'" [style.paddingTop.px]="9">
                                      {{getCaption(indexRow, indexColumn, false)}}
                                    </td>
                                    <td class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="12">
                                      {{model.loc('RangeFrom')}}
                                    </td>
                                  </tr>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="12">
                                      {{model.loc('RangeTo')}}
                                    </td>
                                  </tr>
                                </tbody>
                              </table>
                            </td>
                        <td [style.padding]="'0px'">
                          <sti-parameter *ngIf="index(indexRow, indexColumn) != length()"  [params]="model.interactions.paramsVariables[index(indexRow, indexColumn)]"></sti-parameter>

                          <!--table *ngIf="index(indexRow, indexColumn) == length()" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                            align="right" [style.margin]="'5px 2px 10px 0px'">
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                              </td>
                              <td class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="10">
                                <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                              </td>
                            </tr>
                          </table-->
                        </td>
                    </ng-container>
                  </ng-container>
                </tr>
                <tr><!--*ngIf="length() == model.interactions.countInColumn.length * model.interactions.countColumns.length"-->
                  <td></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td [style.padding]="'0px'">
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                         align="right" [style.margin]="'5px 2px 10px 0px'">
                         <tr class="stiJsViewerClearAllStyles">
                           <td class="stiJsViewerClearAllStyles">
                             <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                           </td>
                           <td class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="10">
                              <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                           </td>
                         </tr>
                       </table>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i6.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.FormButtonComponent, selector: "sti-form-button", inputs: ["caption", "actionName", "imageName", "imageCellWidth", "captionPadding", "margin", "captionAlign"], outputs: ["action"] }, { kind: "component", type: i8.ParameterComponent, selector: "sti-parameter", inputs: ["params"] }], animations: [
            trigger('visibility', [
                state('visible', style({ opacity: 1, display: 'block' })),
                state('hidden', style({ opacity: 0, display: 'none' })),
                transition('hidden => visible', [
                    animate('300ms ease-in-out', keyframes([
                        style({ display: 'block', opacity: 0, offset: 0 }),
                        style({ display: 'block', opacity: 1, offset: 1 }),
                    ]))
                ]),
                transition('visible => hidden', [
                    animate('300ms ease-in-out', keyframes([
                        style({ display: 'block', opacity: 1, offset: 0 }),
                        style({ display: 'none', opacity: 0, offset: 1 }),
                    ]))
                ])
            ])
        ] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: InteractionsPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-interactions-panel',
                    template: `
    <div #element [class]="className"
       [style.display]="!this.model.options.isMobileDevice ? (model.controls.parametersPanel.visible ? '' : 'none') : null"
       [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbar.fontColor"
       [style.top.px]="top"
       [style.left.px]="model.controls.parametersPanel.layout.left"
       [style.bottom]="bottom"
       [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
       [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.parametersPanel.visible ? 'visible' : 'hidden')">
       <div [class]="innerClassName" [style.marginTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''" (scroll)="menuService.closeAllMenus()">
         <div class="stiJsViewerInnerContainerParametersPanel"
              [style.background]="helper.val(model.options.toolbar.backgroundColor, '')"
              [style.border]="helper.val(model.options.toolbar.backgroundColor, '') != '' ? '1px solid ' + helper.val(model.options.toolbar.backgroundColor, '') : ''"
              [style.maxHeight]="model.options.appearance.currentParametersPanelPosition == 'Top' ? model.options.appearance.parametersPanelMaxHeight + 'px' : ''"
              (scroll)="menuService.closeAllMenus()">
            <table *ngIf="model.interactions" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.border.px]="0">
              <tbody>
                <tr *ngFor="let item of model.interactions.countInColumn; let indexRow=index" >
                  <ng-container *ngFor="let item2 of model.interactions.countColumns; let indexColumn=index">
                    <ng-container *ngIf="index(indexRow, indexColumn) < length()">
                        <td [style.padding]="'0 10px 0 ' + (indexColumn > 0 ? '30px' : '0')"
                            [style.whiteSpace]="'nowrap'"
                            [style.verticalAlign]='getNameAlign(indexRow, indexColumn)'
                            [style.paddingTop]='getNamePadding(indexRow, indexColumn)'
                            [attr.title]='getTitle(indexRow, indexColumn)'>
                            {{getCaption(indexRow, indexColumn)}}
                              <table *ngIf="ifLeftRange(indexRow, indexColumn)" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.height.px]="60">
                                <tbody>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" rowspan="2" [style.verticalAlign]="'top'" [style.paddingTop.px]="9">
                                      {{getCaption(indexRow, indexColumn, false)}}
                                    </td>
                                    <td class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="12">
                                      {{model.loc('RangeFrom')}}
                                    </td>
                                  </tr>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="12">
                                      {{model.loc('RangeTo')}}
                                    </td>
                                  </tr>
                                </tbody>
                              </table>
                            </td>
                        <td [style.padding]="'0px'">
                          <sti-parameter *ngIf="index(indexRow, indexColumn) != length()"  [params]="model.interactions.paramsVariables[index(indexRow, indexColumn)]"></sti-parameter>

                          <!--table *ngIf="index(indexRow, indexColumn) == length()" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                            align="right" [style.margin]="'5px 2px 10px 0px'">
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                              </td>
                              <td class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="10">
                                <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                              </td>
                            </tr>
                          </table-->
                        </td>
                    </ng-container>
                  </ng-container>
                </tr>
                <tr><!--*ngIf="length() == model.interactions.countInColumn.length * model.interactions.countColumns.length"-->
                  <td></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td [style.padding]="'0px'">
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                         align="right" [style.margin]="'5px 2px 10px 0px'">
                         <tr class="stiJsViewerClearAllStyles">
                           <td class="stiJsViewerClearAllStyles">
                             <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                           </td>
                           <td class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="10">
                              <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                           </td>
                         </tr>
                       </table>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
      </div>
    </div>
  `,
                    animations: [
                        trigger('visibility', [
                            state('visible', style({ opacity: 1, display: 'block' })),
                            state('hidden', style({ opacity: 0, display: 'none' })),
                            transition('hidden => visible', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 0, offset: 0 }),
                                    style({ display: 'block', opacity: 1, offset: 1 }),
                                ]))
                            ]),
                            transition('visible => hidden', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 1, offset: 0 }),
                                    style({ display: 'none', opacity: 0, offset: 1 }),
                                ]))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.InteractionsService }, { type: i4.MenuService }, { type: i5.ControllerService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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