import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "../services/dashboard.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
import * as i6 from "../controls/dashboard-panel-button.component";
export class DashboardsPanelComponent {
    constructor(model, helper, dashboardService) {
        this.model = model;
        this.helper = helper;
        this.dashboardService = dashboardService;
        this.imagesPath = 'Dashboards.Actions.Light.';
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.navigatePanel.el = this.element;
    }
    get dbsMode() {
        return this.dashboardsCount > 0 && this.reportsCount === 0;
    }
    get dashboardsCount() {
        let count = 0;
        if (this.model?.reportParams?.dashboards) {
            this.model.reportParams.dashboards.forEach(i => {
                if (i['type'] === 'Dashboard') {
                    count++;
                }
            });
        }
        return count;
    }
    get reportsCount() {
        if (this.model?.reportParams?.dashboards) {
            return this.model.reportParams.dashboards.length - this.dashboardsCount;
        }
        return 0;
    }
    get previewSettings() {
        return this.model.reportParams.previewSettings || {};
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DashboardsPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.DashboardService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: DashboardsPanelComponent, selector: "sti-dashboards-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="helper.val(model.options.toolbar.fontColor)"
      [style.display]="model.controls.dashboardsPanel.visible ? '' : 'none'"
      [style.background]="dbsMode ? 'transparent' : ''"
      [style.borderColor]="dbsMode ? 'transparent' : ''">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" [style.margin.px]="0" [style.boxSizing]="'border-box'"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
          [style.background]="dbsMode ? 'transparent' : ''"
          [style.borderColor]="dbsMode ? 'transparent' : ''">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" [style.width]="'100%'">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0"
                  [style.align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment == 'default' ? 'left' : model.options.toolbar.alignment)">
                  <tbody>
                      <tr>
                         <td *ngFor="let info of model.reportParams.dashboards; let i=index">
                            <sti-dashboard-button
                              [info]="info"
                              [dbsMode]="dbsMode"
                              [display]="dashboardsCount == 1 && reportsCount == 0 ? 'none': null">
                            </sti-dashboard-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>

              <!-- actions table -->
              <td class="stiJsViewerClearAllStyles">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" [style.marginRight.px]="2">
                  <tbody>
                      <tr>
                        <td *ngIf="model.options.toolbar.showRefreshButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Refresh.png'"
                            [tooltip]="model.loc('Refresh')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Refresh'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardRefreshButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showParametersButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Parameters.png'"
                            [tooltip]="model.loc('Parameters')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Parameters'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showOpenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Open.png'"
                            [tooltip]="model.loc('Open')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'OpenDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardOpenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showDesignButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Edit.png'"
                            [tooltip]="model.loc('Edit')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postDesign'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardEditButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showFullScreenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'CloseFullScreen.png'"
                            [caption]="model.loc('Close')"
                            [tooltip]="model.loc('FullScreen')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postFullScreen'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardFullScreenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showSaveButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Menu.png'"
                            [tooltip]="model.loc('Save')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'ExportDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardMenuButton && ((previewSettings.dashboardShowReportSnapshots && !model.options.jsMode) || previewSettings.dashboardShowExports) ? '' :'none'">
                          </sti-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i6.DashboardButtonComponent, selector: "sti-dashboard-button", inputs: ["showCloseButton", "info", "dbsMode", "display"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DashboardsPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-dashboards-panel',
                    template: `
    <div #element
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="helper.val(model.options.toolbar.fontColor)"
      [style.display]="model.controls.dashboardsPanel.visible ? '' : 'none'"
      [style.background]="dbsMode ? 'transparent' : ''"
      [style.borderColor]="dbsMode ? 'transparent' : ''">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" [style.margin.px]="0" [style.boxSizing]="'border-box'"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
          [style.background]="dbsMode ? 'transparent' : ''"
          [style.borderColor]="dbsMode ? 'transparent' : ''">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" [style.width]="'100%'">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0"
                  [style.align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment == 'default' ? 'left' : model.options.toolbar.alignment)">
                  <tbody>
                      <tr>
                         <td *ngFor="let info of model.reportParams.dashboards; let i=index">
                            <sti-dashboard-button
                              [info]="info"
                              [dbsMode]="dbsMode"
                              [display]="dashboardsCount == 1 && reportsCount == 0 ? 'none': null">
                            </sti-dashboard-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>

              <!-- actions table -->
              <td class="stiJsViewerClearAllStyles">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" [style.marginRight.px]="2">
                  <tbody>
                      <tr>
                        <td *ngIf="model.options.toolbar.showRefreshButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Refresh.png'"
                            [tooltip]="model.loc('Refresh')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Refresh'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardRefreshButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showParametersButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Parameters.png'"
                            [tooltip]="model.loc('Parameters')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Parameters'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showOpenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Open.png'"
                            [tooltip]="model.loc('Open')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'OpenDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardOpenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showDesignButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Edit.png'"
                            [tooltip]="model.loc('Edit')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postDesign'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardEditButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showFullScreenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'CloseFullScreen.png'"
                            [caption]="model.loc('Close')"
                            [tooltip]="model.loc('FullScreen')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postFullScreen'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardFullScreenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showSaveButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Menu.png'"
                            [tooltip]="model.loc('Save')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'ExportDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardMenuButton && ((previewSettings.dashboardShowReportSnapshots && !model.options.jsMode) || previewSettings.dashboardShowExports) ? '' :'none'">
                          </sti-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.DashboardService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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