import { StiFormElement } from "../elements/base/StiFormElement";
import { StiLabelItem } from "../elements/text/StiLabelItem";
import { StiTextItem } from "../elements/text/StiTextItem";
import Color from "./Color";
import { StiDisplayCurrencyAs, StiHorizontalAlignment, StiNumberType, StiThousandSeparator, StiUnitAlignment, StiVerticalAlignment } from "./enums";
import { Font } from "./Font";
import { StiImageEditorResult } from "../elements/signature/StiImageEditorResult";
export interface StiLabel {
    label: StiLabelItem;
}
export interface StiContainer {
    elements: StiFormElement[];
    allElements: StiFormElement[];
    getColumnWidth(columnsCount: number): number;
    contentAreaWidth: number;
}
export interface StiDescription {
    description: StiTextItem;
}
export interface StiHtmlStyle {
    htmlStyle(): string;
}
export interface StiEditableContent extends StiHtmlStyle {
    eValue: string;
    eFont: Font;
    eColor: Color;
    eBackgroundColor?: Color;
    eContentAlignment?: StiHorizontalAlignment;
    eVerticalAlignment?: StiVerticalAlignment;
    haveContentAlignment(): boolean;
    haveVerticalAlignment(): boolean;
    haveBackgoundColor(): boolean;
    eParent?: any;
}
export interface StiOptionsElement {
    options: string[];
}
export interface StiSignatureDrawTemplate {
    type: string;
    image: StiImageEditorResult;
    text: StiTextItem;
    drawedImage: any;
}
export interface StiSignatureTypeTemplate {
    type: string;
    fullName: string;
    initials: string;
    specialFont: string;
}
export interface StiBackgroundElement {
    backgroundColor: Color;
}
export interface StiDraggableExpressionObject {
    previewString: string;
    startObject: any;
    lastCaretOffset: number;
}
export interface StiImageEditorResultObject {
    loadedImage: any;
    verticalAlignment: StiVerticalAlignment;
    horizontalAlignment: StiHorizontalAlignment;
    aspectRatio: boolean;
    stretch: boolean;
}
export interface StiFormCheckerItem {
    type: string;
    label: string;
    content: string;
}
export interface StiExpressionSample {
    functionName: string;
    samples: string[];
    title: string;
}
export interface StiBorderElement {
    borderColor: Color;
}
export interface StiChangesInterceptor {
    propertyChanged(propName: string, value: any, oldObject: any): any;
}
export interface StiSetProperty {
    setProperty(propName: string, value: any, oldObject: any): any;
}
export interface StiValueElement {
    value: any;
}
export interface StiFormattedElement {
    decimalDigits: number;
    thousandSeparator: StiThousandSeparator;
}
export interface StiNumberElement {
    type: string;
    decimalDigits: number;
    unitLabel: string;
    thousandSeparator: StiThousandSeparator;
    numberType: StiNumberType;
    unitAlignment: StiUnitAlignment;
    currencyLabelFormat: StiDisplayCurrencyAs;
    currency: string;
}
export interface StiTabIndex {
    setTabIndex(value: number): number;
}
export interface UpdateToViewerMode {
    updateToViewerMode(): any;
}
