import Hashtable from './Hashtable';
import Dictionary from './Dictionary';
export default class List<T> extends Array<T> {
    constructor(items?: T[] | number);
    get countItems(): number;
    addRange(items: List<T> | T[]): void;
    removeRange(index: number, count: number): void;
    getRange(index: number, count: number): List<T>;
    add(item: T): void;
    insert(index: number, item: T): void;
    getKeys(): string[];
    getByIndex(index: number, keys?: string[]): T;
    setByIndex(index: number, item: T): void;
    removeByIndex(index: number): List<T>;
    copyTo(array: any[], index?: number): void;
    /** Removes all elements from the List. */
    clear(): void;
    peek(): T;
    remove(item: T): void;
    /** Removes the element at the specified index of the Lis.
     * @param index The zero-based index of the element to remove.
     * @throw index is less than 0. -or- index is equal to or greater than Count.
     */
    removeAt(index: number): void;
    exists(predicate: (value: T) => boolean): boolean;
    fullOuterJoin<K>(inner: List<T>, outerKeySelector: (value: T) => K, innerKeySelector: (value: T) => K, resultSelector: (value1: T, value2: T) => T, __this?: any): List<T>;
    toList(): List<T>;
    findIndex2(match: (value: T) => boolean): number;
    findLastIndex2(match: (value: T) => boolean): number;
    zip<S, R>(second: List<S>, resultSelector: (first: T, second: S) => R): List<R>;
    static repeat<T>(element: T, count: number): List<T>;
    /** Filters a sequence of values based on a predicate.
     * @param predicate A function to test each element for a condition.
     * @returns An List that contains elements from the input sequence that satisfy the condition.
     */
    where(predicate: (value: T, index: number) => boolean, __this?: any): List<T>;
    /** Correlates the elements of two sequences based on matching keys. The default
     * equality comparer is used to compare keys.
     * @param inner The sequence to join to the first sequence.
     * @param outerKeySelector A function to extract the join key from each element of the first sequence.
     * @param innerKeySelector A function to extract the join key from each element of the second sequence.
     * @param resultSelector A function to create a result element from two matching elements.
     * @returns An List that has elements of type V
     * that are obtained by performing an inner join on two sequences.
     */
    join2<U, K, V>(inner: List<U>, outerKeySelector: (value: T) => K, innerKeySelector: (value: U) => K, resultSelector: (value1: T, value2: U) => V, __this?: any): List<V>;
    /** Correlates the elements of two sequences based on equality of keys and groups
     * the results. The default equality comparer is used to compare keys.
     * @param inner The sequence to join to the first sequence.
     * @param outerKeySelector A function to extract the join key from each element of the first sequence.
     * @param innerKeySelector A function to extract the join key from each element of the second sequence.
     * @param resultSelector A function to create a result element from an element from the first sequence
     * and a collection of matching elements from the second sequence.
     * @returns An List that contains elements of type V
     * that are obtained by performing a grouped join on two sequences.
     */
    groupJoin<U, K, V>(inner: List<U>, outerKeySelector: (value: T) => K, innerKeySelector: (value: U) => K, resultSelector: (value1: T, value2: List<U>) => V, __this?: any): List<V>;
    /**
     * Projects each element of a sequence into a new form.
     * @param selector A transform function to apply to each element.
     * @returns An List whose elements are the result of invoking the transform function on each element of source.
     */
    select<S>(selector: (value: T) => S, __this?: any): List<S>;
    selectMany<S>(selector: (value: T) => List<S>, __this?: any): List<S>;
    selectMany2<C>(collectionSelector: (value: T) => List<C>, resultSelector: (value1: T, value2: C) => C, __this?: any): List<C>;
    /** Sorts the elements of a sequence in ascending order according to a key or by using a specified comparer.
     * @param keySelector A function to extract a key from an element.
     * @param comparer An System.Collections.Generic.IComparer`1 to compare keys.
     * @returns An System.Linq.IOrderedEnumerable`1 whose elements are sorted according to a key.
     */
    /** Groups the elements of a sequence according to a specified key selector function
     * and compares the keys by using a specified comparer.
     * @param keySelector A function to extract the key for each element.
     * @param comparer An System.Collections.Generic.IEqualityComparer`1 to compare keys.
     * @returns An IEnumerable<IGrouping<TKey, TSource>> in C# or IEnumerable(Of IGrouping(Of
     * TKey, TSource)) in Visual Basic where each System.Linq.IGrouping`2 object contains
     * a collection of objects and a key.
     */
    /** Converts the elements of an List to the specified type.
     * @returns An List that contains each element of the source sequence converted to the specified type.
     */
    cast<S>(): List<S>;
    toDictionary<K, V>(keySelector: (item: T) => K, elementSelector: (item: T) => V): Dictionary<K, V>;
    /** Creates a Lookup from an List
     * according to a specified key selector function.
     * @param keySelector A function to extract a key from each element.
     * @returns A Lookup that contains keys and values.
     */
    toLookup<K>(keySelector: (value: T) => K, __this?: any): Hashtable;
    /** Concatenates two sequences.
     * @param second The sequence to concatenate to the first sequence.
     * @returns An List that contains the concatenated elements
     * of the two input sequences.
     */
    concat(second: List<T>): List<T>;
    /**
     * Applies an accumulator function over a sequence.
     * @param func An accumulator function to be invoked on each element.
     * @returns The final accumulator value.
     */
    aggregate(func: (av: T, e: T) => T): T;
    aggregate2(seed: T, func: (av: T, e: T) => T): T;
    count2(selector?: (value: T) => boolean, __this?: any): number;
    /** Invokes a transform function on each element of a sequence and returns the maximum value.
     * @param selector A transform function to apply to each element.
     * @returns The maximum value in the sequence.
     */
    /** Invokes a transform function on each element of a sequence and returns the minimum value.
     * @parm selector A transform function to apply to each element.
     * @returns The minimum value in the sequence.
     */
    /** Computes the sum of the sequence of System.Decimal values that are obtained by
     * invoking a transform function on each element of the input sequence.
     * @param selector A transform function to apply to each element.
     * @returns The sum of the projected values.
     */
    all(predicate?: (value: T) => boolean, __this?: any): boolean;
    /** Determines whether any element of a sequence satisfies a condition.
     * @param predicate A function to test each element for a condition.
     * @returns true if any elements in the source sequence pass the test in the specified predicate; otherwise, false.
     */
    any(predicate?: (value: T) => boolean, __this?: any): boolean;
    /** Determines whether an element is in the List.
     * @param item The object to locate in the List. The value can be null for reference types.
     * @returns true if item is found in the List otherwise, false.
     */
    contains(item: T): boolean;
    skip(count: number): List<T>;
    take(count: number): List<T>;
    defaultIfEmpty(): List<T>;
    /** Returns distinct elements from a sequence by using the default equality comparer to compare values.
     * @returns An List that contains distinct elements from the source sequence.
     */
    distinct(): List<T>;
    except(second: List<T>): List<T>;
    union(second: List<T>): List<T>;
    sequenceEqual(second: List<T>): boolean;
    first(selector?: (value: T) => boolean, __this?: any): T;
    /** Returns the first element of the sequence that satisfies a condition or a default value if no such element is found.
     * @param predicate A function to test each element for a condition.
     * @returns if source is empty or if no element passes the test specified by predicate;
     * otherwise, the first element in source that passes the test specified by predicate.
     */
    firstOrDefault(predicate?: (value: T) => boolean): T;
    lastOrDefault(): T;
}
