import List from "./List";
export default class Hashtable<K = any, V = any> {
    private ignoreCase;
    private isSimpleKeys;
    keys: List<K>;
    values: List<V>;
    private indexObject;
    constructor(options?: {
        ignoreCase: boolean;
    });
    get(key: K): V;
    set(key: K, value: V): void;
    /** Adds an element with the specified key and value into the Hashtable. */
    add(key: K, value: V): void;
    /** Determines whether the Hashtable contains a specific key. */
    contains(key: K): boolean;
    /** Determines whether the Hashtable contains a specific key. */
    containsKey(key: K): boolean;
    /** Determines whether the Hashtable contains a specific value. */
    containsValue(value: V): boolean;
    /** Removes the element with the specified key from the Hashtable. */
    remove(key: K): void;
    /** Removes all elements from the Hashtable. */
    clear(): void;
    /** Copies the Hashtable elements to a one-dimensional Array instance at the specified index. */
    copyTo(array: V[], arrayIndex: number): void;
    /** Gets the number of key/value pairs contained in the Hashtable. */
    get count(): number;
    clone(): Hashtable<K, V>;
}
