import { Subject } from "rxjs";
import * as i0 from "@angular/core";
export declare class StimulsoftFormsService {
    serviceEvents: Subject<any>;
    serviceEventsCallbacks: Subject<any>;
    constructor();
    /**
     * Post custom data to controller
     * @param data to send to controller
     * @param func callback function
     * @param options to send to controller
     */
    postData(data: any, func: any, options?: any): void;
    /**
     * Add Element to Form
     * @param elementType
     * Text
     * TextBox
     * Table
     * SingleSelection
     * Signature
     * Panel
     * NumberBox
     * MultipleSelection
     * ListBox
     * Line
     * Label
     * Image
     * DateTimeBox
     * CheckBox
     * ComboBox
     * Button
     * BarCode
     * Address
     */
    addElementToForm(elementType: string): void;
    /**
     * Show form tab
     * @param tabName
     * Home
     * Insert
     * Preview
     * PdfPreview
     */
    showTab(tabName: string): void;
    showFileMenu(): void;
    showSaveMenu(): void;
    exportToPdf(readOnly?: boolean, pdfACompliance?: boolean): void;
    getPdfBytes(readOnly?: boolean, pdfACompliance?: boolean): Promise<any>;
    /**
     * Set form zoom
     * @param zoom
     * PageWidth
     * OnePage
     * from 10%
     * to 400%
     */
    setZoom(zoom: string): void;
    /**
     * Create form element
     * @param elementType
     * Text
     * TextBox
     * Table
     * SingleSelection
     * Signature
     * Panel
     * NumberBox
     * MultipleSelection
     * ListBox
     * Line
     * Label
     * Image
     * DateTimeBox
     * CheckBox
     * ComboBox
     * Button
     * BarCode
     * Address
     * Page
     * Form
     * @returns Element object
     */
    createElement(elementType: string): any;
    /**
     * Get class of form element
     * @param type
     * Text
     * TextBox
     * Table
     * SingleSelection
     * Signature
     * Panel
     * NumberBox
     * MultipleSelection
     * ListBox
     * Line
     * Label
     * Image
     * DateTimeBox
     * CheckBox
     * ComboBox
     * Button
     * BarCode
     * Address
     * Page
     * Form
     * @returns element Class
     */
    getElementClass(type: string): any;
    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    base64Encode(input: any): string;
    base64Decode(input: any): string;
    static ɵfac: i0.ɵɵFactoryDeclaration<StimulsoftFormsService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<StimulsoftFormsService>;
}
