import { AfterViewInit, ElementRef, EventEmitter, OnChanges, OnInit } from "@angular/core";
import StiRectangleGeometryLayout from "./computed/StiRectangleGeometryLayout";
import { StiLocalizationService } from "./services/sti-localization.service";
import { StiModelService } from "./services/model.service";
import { StiMouseService } from "./services/mouse.service";
import { StiEditableContentService } from "./services/sti-editable-content.service";
import { StiHelperService } from "./services/sti-helper.service";
import { StiToolbarResizerService } from "./services/sti-toolbar-resizer.service";
import { StiToolboxService } from "./services/sti-toolbox.service";
import { StiThemeService } from "./services/theme.service";
import { StiControllerService } from "./services/sti-controller.service";
import { StiHttpClientService } from "./services/http-client.service";
import { StiBarcodeService } from "./services/sti-barcode.service";
import { StiForm } from "./elements/StiForm";
import { StiChangesService } from "./services/sti-changes-service";
import { StiUndoService } from "./services/sti-undo-service";
import { StiExportService } from "./services/sti-export.service";
import { StiFontService } from "./services/sti-font.service";
import { StiUserService } from "./services/sti-user-service";
import { StiExpressionService } from "./services/sti-expression.service";
import { StiInterfaceEvent } from "./services/objects";
import { FormEventsService } from "./services/sti-form-events-service";
import { SignatureService } from "./services/sti-signature.service";
import { StiTabIndexService } from "./services/sti-tabindex.service";
import { StiDropdownService } from "./components/sti-dropdown-component/sti-dropdown-service";
import { StiFormCheckerService } from "./services/sti-form-checker.service";
import { StiLocalStorageService } from "./services/sti-local-storage.service";
import { StiTooltipService } from "./components/sti-tooltip/sti-tooltip.service";
import { StiClipboardService } from "./services/sti-clipboard-sevice";
import * as i0 from "@angular/core";
export declare class StimulsoftFormsComponent implements OnInit, AfterViewInit, OnChanges {
    toolbarResizerService: StiToolbarResizerService;
    model: StiModelService;
    theme: StiThemeService;
    controller: StiControllerService;
    barcodeService: StiBarcodeService;
    render: StiRectangleGeometryLayout;
    editableContentService: StiEditableContentService;
    changesService: StiChangesService;
    exportService: StiExportService;
    font: StiFontService;
    toolboxService: StiToolboxService;
    undoService: StiUndoService;
    userService: StiUserService;
    expressionService: StiExpressionService;
    helper: StiHelperService;
    localizationService: StiLocalizationService;
    httpService: StiHttpClientService;
    signatureService: SignatureService;
    tabIndexService: StiTabIndexService;
    mouseService: StiMouseService;
    formEvents: FormEventsService;
    dropdownService: StiDropdownService;
    formCheckerService: StiFormCheckerService;
    stiLocalStorage: StiLocalStorageService;
    tooltipService: StiTooltipService;
    clipboardService: StiClipboardService;
    addTotalMenu: any;
    /**
     * Url to server instance
     * Example: http://server.url:51528/Forms/Action
     */
    requestUrl: string;
    style: string;
    viewerMode: boolean;
    readonlyMode: boolean;
    form: StiForm;
    localization: string;
    formName: string;
    /**
     * Form component settings
     * showSaveToPdfButton - visibility of Save to PDF button
     * showEditButton - visibility of Edit button
     * showSaveButton - visibility of Save button in navigation panel
     * showFileButton - visibility of File button in navigation panel
     * defaultTab - string of default value for displaying a form tab ("Home"/"Insert"/"Preview"/"PDFPreview")
     * showToolbox - visibility of elements panel at left part of designer
     * showProperties - visibility of property grid at right part of designer
     * showSetupToolbox - visibility of button for setup a panel of elements
     * showZoomButtons - visibility of zoom buttons on footer panel.
     * showFooter - visibility of footer panel
     * zoom - set a form zoom ("PageWidth","OnePage","10%" to "400%")
     * visibility of form Elements:
     * showText - visibility of text element.
     * showTextBox - visibility of text box element
     * showTable - visibility of table element
     * showSingleSelection - visibility of single selection element
     * showSignature - visibility of signature element
     * showPanel - visibility of panel element
     * showNumberBox - visibility of number box element
     * showMultipleSelection - visibility of multiple selection element
     * showListBox - visibility of list box element
     * showLine - visibility of line element
     * showLabel- visibility of label element
     * showImage - visibility of image element
     * showDateTimeBox - visibility of date time box element
     * showCheckBox - visibility of check box element
     * showComboBox - visibility of combo box element
     * showButton - visibility of button element
     * showBarCode - visibility of barcode element
     * showAddress - visibility of address element
     * showFormTree - ...
     */
    settings: object;
    interfaceEvent: EventEmitter<StiInterfaceEvent>;
    /**
     * properties that will transfer to controller action as JSON object
     */
    properties: any;
    private init;
    distance: number;
    startZoomValue: any;
    isDoubleTouch: boolean;
    rootFormElementRef: ElementRef;
    constructor(toolbarResizerService: StiToolbarResizerService, model: StiModelService, theme: StiThemeService, controller: StiControllerService, barcodeService: StiBarcodeService, render: StiRectangleGeometryLayout, editableContentService: StiEditableContentService, changesService: StiChangesService, exportService: StiExportService, font: StiFontService, toolboxService: StiToolboxService, undoService: StiUndoService, userService: StiUserService, expressionService: StiExpressionService, helper: StiHelperService, localizationService: StiLocalizationService, httpService: StiHttpClientService, signatureService: SignatureService, tabIndexService: StiTabIndexService, mouseService: StiMouseService, formEvents: FormEventsService, dropdownService: StiDropdownService, formCheckerService: StiFormCheckerService, stiLocalStorage: StiLocalStorageService, tooltipService: StiTooltipService, clipboardService: StiClipboardService);
    get pointerEvents(): string;
    get cursor(): string;
    get toolbarWidth(): number;
    hasParentHeight(): boolean;
    hasParentWidth(): boolean;
    ngOnInit(): void;
    needToScroll(): boolean;
    ngOnChanges(changes: import("@angular/core").SimpleChanges): void;
    startTouch(event: any): void;
    get isMobileViewer(): boolean;
    touchMove(event: any): void;
    touchEnd(event: any): void;
    minimalZoomValue(): number;
    setReadOnlyMode(): void;
    ngAfterViewInit(): void;
    containerHeight(): "calc(100% - 32px)" | "calc(100% - 38px)" | "calc(100% - 70px)" | "calc(100% - 155px)" | "calc(100% - 125px)" | "calc(100% - 123px)" | "calc(100% - 93px)";
    initialize(): void;
    cloudLogin(event: any): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<StimulsoftFormsComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<StimulsoftFormsComponent, "stimulsoft-forms", never, { "requestUrl": { "alias": "requestUrl"; "required": false; }; "style": { "alias": "style"; "required": false; }; "viewerMode": { "alias": "viewerMode"; "required": false; }; "readonlyMode": { "alias": "readonlyMode"; "required": false; }; "form": { "alias": "form"; "required": false; }; "localization": { "alias": "localization"; "required": false; }; "formName": { "alias": "formName"; "required": false; }; "settings": { "alias": "settings"; "required": false; }; "properties": { "alias": "properties"; "required": false; }; }, { "interfaceEvent": "interfaceEvent"; }, never, never, false, never>;
}
