import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { StiHorizontalAlignment, StiTextRangeFormat, StiLineWeight } from "../system/enums";
import { Font } from "../system/Font";
import { StiLabel, StiDescription, StiEditableContent, StiValueElement, StiTabIndex } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiTextItem } from "./text/StiTextItem";
export declare class StiTextBoxElement extends StiFormElement implements StiLabel, StiDescription, StiEditableContent, StiValueElement, StiTabIndex {
    private _linesCount;
    private _maximum;
    type: string;
    tooltip: string;
    required: boolean;
    description: StiTextItem;
    font: Font;
    text: string;
    backgroundColor: Color;
    textColor: Color;
    borderColor: Color;
    contentAlignment: StiHorizontalAlignment;
    isMultiline: boolean;
    password: string;
    isPassword: boolean;
    useRange: boolean;
    minimum: number;
    rangeFormat: StiTextRangeFormat;
    borderWeight: StiLineWeight;
    heightForExport: number;
    tabIndex: number;
    mask: string;
    constructor();
    setDefaultValues(): void;
    setTabIndex(value: number): number;
    getDefaultEditableContent(): StiEditableContent;
    get maximum(): number;
    set maximum(value: number);
    get linesCount(): number;
    set linesCount(value: number);
    get value(): string;
    set value(value: string);
    get eValue(): string;
    set eValue(value: string);
    get eFont(): Font;
    set eFont(value: Font);
    get eColor(): Color;
    set eColor(value: Color);
    get eBackgroundColor(): Color;
    set eBackgroundColor(value: Color);
    get eContentAlignment(): StiHorizontalAlignment;
    set eContentAlignment(value: StiHorizontalAlignment);
    haveContentAlignment(): boolean;
    haveVerticalAlignment(): boolean;
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    haveBackgoundColor(): boolean;
    htmlStyle(): string;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
