import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { StiHorizontalAlignment, StiLineWeight } from "../system/enums";
import { Font } from "../system/Font";
import { StiLabel, StiEditableContent, StiTabIndex } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiAddressLabelItem } from "./text/StiAddressLabelItem";
export declare class StiAddressElement extends StiFormElement implements StiLabel, StiTabIndex {
    type: string;
    font: Font;
    descriptionFont: Font;
    descriptionColor: Color;
    backgroundColor: Color;
    textColor: Color;
    borderColor: Color;
    borderWeight: StiLineWeight;
    contentAlignment: StiHorizontalAlignment;
    streetAddress: string;
    streetAddress2: string;
    city: string;
    state: string;
    zipCode: string;
    country: string;
    streetAddressLabel: string;
    streetAddress2Label: string;
    cityLabel: string;
    stateLabel: string;
    zipCodeLabel: string;
    countryLabel: string;
    streetAddressLabelItem: StiAddressLabelItem;
    streetAddress2LabelItem: StiAddressLabelItem;
    cityLabelItem: StiAddressLabelItem;
    stateLabelItem: StiAddressLabelItem;
    zipCodeLabelItem: StiAddressLabelItem;
    countryLabelItem: StiAddressLabelItem;
    useStreetAddress: boolean;
    useStreetAddress2: boolean;
    useCity: boolean;
    useState: boolean;
    useZipCode: boolean;
    useCountry: boolean;
    maximum: number;
    tabIndex: number;
    constructor();
    setDefaultValues(): void;
    setTabIndex(value: number): number;
    get contentAreaWidth(): number;
    get contentAreaHeight(): number;
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    getDefaultEditableContent(): StiEditableContent;
    setProperty(propName: string, value: any, oldObject: any): void;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
    htmlStyle(): string;
    comboBoxHtmlStyle(): string;
}
