import { AfterViewInit, ElementRef, OnDestroy, OnInit } from "@angular/core";
import { StiModelService } from "../../services/model.service";
import { StiLocalizationService } from "../../services/sti-localization.service";
import { Subscription } from "rxjs";
import { StiMouseService } from "../../services/mouse.service";
import { SignatureService } from "../../services/sti-signature.service";
import { StiDraggableModalWindowService } from "../../services/sti-draggable-modal-window.service";
import Color from "../../system/Color";
import { StiColorDialogService } from "../../services/sti-color-dialog.service";
import { StiTextItem } from "../../elements/text/StiTextItem";
import { StiImageEditorResult } from "../../elements/signature/StiImageEditorResult";
import * as i0 from "@angular/core";
export declare class StiElectronicSignatureEditorComponent implements OnInit, AfterViewInit, OnDestroy {
    model: StiModelService;
    loc: StiLocalizationService;
    mouseService: StiMouseService;
    signatureService: SignatureService;
    modalWindowService: StiDraggableModalWindowService;
    colorService: StiColorDialogService;
    canvas: ElementRef;
    get brushColor(): Color;
    drawingMode: boolean;
    isDrawing: boolean;
    context: any;
    defaultPreviewText: string;
    startX: number;
    startY: number;
    startComponentX: number;
    startComponentY: number;
    isDragging: boolean;
    drawedImage: any;
    canvasWidth: number;
    canvasHeight: number;
    insertedImageLayer: any;
    insertedTextLayer: any;
    drawedLayer: any;
    resultCanvasContext: any;
    mouseUpSubscription: Subscription;
    mouseMoveSubscription: Subscription;
    updateSignatureSubscription: Subscription;
    updateResultCanvasSubscription: Subscription;
    constructor(model: StiModelService, loc: StiLocalizationService, mouseService: StiMouseService, signatureService: SignatureService, modalWindowService: StiDraggableModalWindowService, colorService: StiColorDialogService);
    get hasTemplates(): boolean;
    get insertedText(): StiTextItem;
    get insertedImage(): StiImageEditorResult;
    get fullName(): string;
    set fullName(value: string);
    get initials(): string;
    set initials(value: string);
    isEmptyContent(): boolean;
    saveTemplate(): void;
    showSavedTemplatesPreview(button: any): void;
    ngOnDestroy(): void;
    isCanvasBlank(canvas: any): boolean;
    ngAfterViewInit(): void;
    get image(): string;
    getHorizontalAlignment(): "center" | "start" | "end";
    onMouseDown(event: any, canvasElement: any): void;
    private relativeCoords;
    onCanvasMove(event: any, canvasElement: any): void;
    onMouseUp(): void;
    getBackgroundSize(container: any): string;
    getBackgroundPosition(): string;
    get previewText(): string;
    get alignment(): "center" | "start" | "end";
    clear(): void;
    showEditor(editorType: string): void;
    showColorPicker(element: any, object: any, isRichText?: boolean): void;
    fillDrawingCanvas(): void;
    showFontsPreview(element: any): void;
    acceptChanges(): void;
    createLayer(canvas: any): CanvasRenderingContext2D;
    drawLayer(context: any, layer: any): void;
    fillLayer(layer: CanvasRenderingContext2D, content: StiTextItem | StiImageEditorResult | any): void;
    changeMode(mode: any): void;
    updateResultCanvas(type?: string): void;
    onMouseMove(event: any): void;
    startDrag(event: any): void;
    ngOnInit(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<StiElectronicSignatureEditorComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<StiElectronicSignatureEditorComponent, "sti-electronic-signature-editor", never, {}, {}, never, never, false, never>;
}
